using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SecurityFile;

/// <summary>
/// Summary description for Profile
/// </summary>
public class Profile
{
    private string address;
    private string postalCode;
    private string phoneNumber;
    private string email;

    public string Address
    {
        get
        {
            return address;
        }
        set
        {
            address = value;
        }
    }


    public string PostalCode
    {
        get
        {
            return postalCode;
        }
        set
        {
            postalCode = value;
        }
    }

    public string PhoneNumber
    {
        get
        {
            return phoneNumber;
        }
        set
        {
            phoneNumber = value;
        }
    }

    public string Email
    {
        get
        {
            return email;
        }
        set
        {
            email = value;
        }
    }

    public Profile()
    {
        ProfileCommon profile =
          HttpContext.Current.Profile as ProfileCommon;
        address = profile.Address;
        postalCode = profile.PostalCode;
        phoneNumber = profile.PhoneNumber;
        email = Membership.GetUser(profile.UserName).Email;

    }

    public void UpdateProfile()
    {
        ProfileCommon profile =
           HttpContext.Current.Profile as ProfileCommon;
        profile.Address = address;
        profile.PostalCode = postalCode;
        profile.PhoneNumber = phoneNumber;

        Membership.GetUser(profile.UserName).Email = email;
    }
}

