using System;
using System.Data;
using System.Data.Common;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;


/*A struct is a value type, where class is reference type
 * Inheritance doesn't work with structs
 */
public struct DirectoryDetails
{
    public string Name;
    public string Description;
}

public struct MenuItemsDetails
{
    public int DirectoryId;
    public string Name;
    public string Description;
}

public struct FoodDetalis
{
    public string Name;
    public string Description;
    public decimal Price;
    public string Image1FileName;
}
/// <summary>
///business tier componet
/// </summary>
public class MenuAccess
{
    public MenuAccess()
    {
    }

    //Get the list of directory
    public static DataTable GetDirectory()
    {
        //get a configured DbCommand object
        DbCommand comm = GenericDataAccess.CreateCommand();

        //set the stored procedure name
        comm.CommandText = "GetDirectory";

        //execute the stored procedure and return the results
        return GenericDataAccess.ExecuteSelectCommand(comm);
    }

    //Get directory details
    public static DirectoryDetails GetDirectoryDetail(string directoryId)
    {

        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "GetDirectoryDetail";

        //create a new parameter
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@DirectoryID";
        param.Value = directoryId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        //execute the stored procedure
        DataTable table = GenericDataAccess.ExecuteSelectCommand(comm);

        //wrap retrieved data
        DirectoryDetails details = new DirectoryDetails();

        if (table.Rows.Count > 0)
        {
            details.Name = table.Rows[0]["Name"].ToString();
            details.Description = table.Rows[0]["Description"].ToString();
        }
        //return directory details
        return details;
    }

    //Get MenuItems details
    public static MenuItemsDetails GetMenuItemsDetails(string menuItemsId)
    {

        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "GetMenuItemsDetails";


        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@MenuItemsID";
        param.Value = menuItemsId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        DataTable table = GenericDataAccess.ExecuteSelectCommand(comm);

        MenuItemsDetails details = new MenuItemsDetails();
        if (table.Rows.Count > 0)
        {
            details.DirectoryId = Int32.Parse(table.Rows[0]["DirectoryID"].ToString());
            details.Name = table.Rows[0]["Name"].ToString();
            details.Description = table.Rows[0]["Description"].ToString();
        }

        return details;
    }

    //Get food details
    public static FoodDetalis GetFoodDetails(string foodId)
    {

        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "GetFoodDetail";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@FoodID";
        param.Value = foodId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        DataTable table = GenericDataAccess.ExecuteSelectCommand(comm);

        FoodDetalis details = new FoodDetalis();

        if (table.Rows.Count > 0)
        {

            DataRow dr = table.Rows[0];
            //get food details
            details.Name = dr["Name"].ToString();
            details.Description = dr["Description"].ToString();
            details.Price = Decimal.Parse(dr["Price"].ToString());
            details.Image1FileName = dr["Image1FileName"].ToString();
        }

        return details;
    }

    //Get MenuItems in Directory
    public static DataTable GetMenuItemsInDirectory(string directoryId)
    {

        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "GetMenuItemsInDirectory";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@DirectoryID";
        param.Value = directoryId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        return GenericDataAccess.ExecuteSelectCommand(comm);
    }

    //Get foods in each menu 
    public static DataTable GetFoodInMenuItem(string menuItemId, string pageNumber, out int howManyPages)
    {

        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "GetFoodInMenuItem";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@MenuItemsID";
        param.Value = menuItemId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@DescriptionLength";
        param.Value = LaScalaConfiguration.FoodDescriptionLength;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);


        param = comm.CreateParameter();
        param.ParameterName = "@PageNumber";
        param.Value = pageNumber;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);


        param = comm.CreateParameter();
        param.ParameterName = "@FoodsPerPage";
        param.Value = LaScalaConfiguration.FoodsPerPage;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@HowManyFoods";
        param.Direction = ParameterDirection.Output;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);


        DataTable table = GenericDataAccess.ExecuteSelectCommand(comm);

        //calculate how many food and set the out parameter
        int howManyFood = Int32.Parse(comm.Parameters["@HowManyFoods"].Value.ToString());
        howManyPages = (int)Math.Ceiling((double)howManyFood / (double)LaScalaConfiguration.FoodsPerPage);

        return table;
    }

    //Search the food list
    public static DataTable Search(string searchString, string allWords, string pageNumber, out int howManyPages)
    {

        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "SearchEngine";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@DescriptionLength";
        param.Value = LaScalaConfiguration.FoodDescriptionLength;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);


        param = comm.CreateParameter();
        param.ParameterName = "@AllWords";
        param.Value = allWords.ToUpper() == "TRUE" ? "TRUE" : "FALSE";
        param.DbType = DbType.Boolean;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@PageNumber";
        param.Value = pageNumber;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@FoodsPerPage";
        param.Value = LaScalaConfiguration.FoodsPerPage;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@HowManyResults";
        param.Direction = ParameterDirection.Output;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        //define the maximum number of words 
        int howManyWords = 5;
        //change the search string into arrays of words
        char[] wordSeparators = new char[] { ',', ';', '.', '!', '?', '-', ' ' };
        string[] words = searchString.Split(wordSeparators, StringSplitOptions.RemoveEmptyEntries);
        int index = 1;

        //add the words as stored procedure parameters
        for (int i = 0; i <= words.GetUpperBound(0) && index <= howManyWords; i++)
            //ignore short words, which is ignore words that is less than 3 characters
            if (words[i].Length > 2)
            {
                //create the @Word parameters
                param = comm.CreateParameter();
                param.ParameterName = "@Word" + index.ToString();
                param.Value = words[i];
                param.DbType = DbType.String;
                comm.Parameters.Add(param);
                index++;
            }

        DataTable table = GenericDataAccess.ExecuteSelectCommand(comm);

        int howManyFoods = Int32.Parse(comm.Parameters["@HowManyResults"].Value.ToString());
        howManyPages = (int)Math.Ceiling((double)howManyFoods /
                        (double)LaScalaConfiguration.FoodsPerPage);

        return table;

    }

    //Update directory details
    public static bool UpdateDirectory(string id, string name)//, string description)
    {

        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "UpdateDirectory";


        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@DirectoryID";
        param.Value = id;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@DirectoryName";
        param.Value = name;
        param.DbType = DbType.String;
        param.Size = 50;
        comm.Parameters.Add(param);

        //result will represent the number of changed rows
        int result = -1;
        try
        {
            //execute the stored procedure
            result = GenericDataAccess.ExecuteNonQuery(comm);
        }
        catch
        {
            //Errors are placed in GenericDataAccess.  This is just dummy catch.
        }

        return (result != -1);
    }

    public static bool DeleteDirectory(string id)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "DeleteDirectory";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@DirectoryID";
        param.Value = id;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        int result = -1;
        try
        {
            result = GenericDataAccess.ExecuteNonQuery(comm);
        }
        catch
        {

        }

        return (result != -1);
    }

    //Add new directory
    public static bool AddDirectory(string name)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "AddDirectory";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@DirectoryName";
     //   param.ParameterName = "@Name";
        param.Value = name;
        param.DbType = DbType.String;
        param.Size = 50;
        comm.Parameters.Add(param);

        int result = -1;
        try
        {

            result = GenericDataAccess.ExecuteNonQuery(comm);
        }
        catch
        {
            //Errors are placed in GenericDataAccess.  This is just dummy catch.
        }

        return (result != -1);
    }

    //Create a new menu items
    public static bool CreateMenuItems(string directoryId, string name, string description)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "CreateMenuItems";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@DirectoryID";
        param.Value = directoryId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@MenuItemsName";
        param.Value = name;
        param.DbType = DbType.String;
        param.Size = 50;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@MenuItemsDescription";
        param.Value = description;
        param.DbType = DbType.String;
        param.Size = 1000;
        comm.Parameters.Add(param);

        int result = -1;
        try
        {
            result = GenericDataAccess.ExecuteNonQuery(comm);
        }
        catch
        {
            //Errors are placed in GenericDataAccess.  This is just dummy catch.
        }

        return (result != -1);
    }

    //Update the menu items
    public static bool UpdateMenuItems(string id, string name, string description)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "UpdateMenuItems";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@MenuItemsID";
        param.Value = id;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@MenuItemsName";
        param.Value = name;
        param.DbType = DbType.String;
        param.Size = 50;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@MenuItemsDescription";
        param.Value = description;
        param.DbType = DbType.String;
        param.Size = 1000;
        comm.Parameters.Add(param);
        int result = -1;
        try
        {
            result = GenericDataAccess.ExecuteNonQuery(comm);
        }
        catch
        {
            //Errors are placed in GenericDataAccess.  This is just dummy catch.
        }

        return (result != -1);
    }

    //Delete menu Items
    public static bool DeleteMenuItems(string id)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "DeleteMenuItems";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@MenuItemsID";
        param.Value = id;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        int result = -1;
        try
        {
            result = GenericDataAccess.ExecuteNonQuery(comm);
        }
        catch
        {

        }

        return (result != -1);
    }

    //Get the list of foods in a menu item
    public static DataTable GetAllFoodsInMenuItems(string menuItemsId)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "GetAllFoodsInMenuItems";
        DbParameter param = comm.CreateParameter();
        param.Value = menuItemsId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        DataTable table = GenericDataAccess.ExecuteSelectCommand(comm);
        return table;
    }

    //Create a new food
    public static bool CreateFood(string menuItemsId, string name, string description, string price, string image1FileName)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "CreateFood";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@MenuItemsID";
        param.Value = menuItemsId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@FoodName";
        param.Value = name;
        param.DbType = DbType.String;
        param.Size = 50;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@FoodDescription";
        param.Value = description;
        param.DbType = DbType.AnsiString;
        param.Size = 5000;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@FoodPrice";
        param.Value = price;
        param.DbType = DbType.Decimal;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@Image1FileName";
        param.Value = image1FileName;
        param.DbType = DbType.String;
        comm.Parameters.Add(param);

        int result = -1;
        try
        {
            result = GenericDataAccess.ExecuteNonQuery(comm);
        }
        catch
        {
        }

        return (result >= 1);
    }

    public static bool UpdateFood(string foodId, string name, string description, string price, string image1FileName)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "UpdateFood";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@FoodID";
        param.Value = foodId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@FoodName";
        param.Value = name;
        param.DbType = DbType.String;
        param.Size = 50;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@FoodDescription";
        param.Value = description;
        param.DbType = DbType.AnsiString;
        param.Size = 5000;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@FoodPrice";
        param.Value = price;
        param.DbType = DbType.Decimal;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@Image1FileName";
        param.Value = image1FileName;
        param.DbType = DbType.String;
        comm.Parameters.Add(param);

        int result = -1;
        try
        {
            result = GenericDataAccess.ExecuteNonQuery(comm);
        }
        catch
        {
        }

        return (result != -1);
    }


    public static DataTable GetMenuItemsWithFood(string foodId)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "GetMenuItemsWithFood";
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@FoodID";
        param.Value = foodId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        return GenericDataAccess.ExecuteSelectCommand(comm);
    }

    public static DataTable GetMenuItemsWithoutFood(string foodId)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "GetMenuItemsWithoutFood";
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@FoodID";
        param.Value = foodId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        return GenericDataAccess.ExecuteSelectCommand(comm);
    }
    public static bool AssignFoodToMenuItems(string foodId, string menuItemsId)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "AssignFoodToMenuItems";
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@FoodID";
        param.Value = foodId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "MenuItemsID";
        param.Value = menuItemsId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        int result = -1;
        try
        {
            result = GenericDataAccess.ExecuteNonQuery(comm);
        }
        catch
        {
        }

        return (result != -1);
    }

    public static bool MoveFoodToMenuItems(string foodId, string oldMenuItemsId, string newMenuItemsId)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "MoveFoodToMenuItems";
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@FoodID";
        param.Value = foodId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@OldMenuItemsID";
        param.Value = oldMenuItemsId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@NewMenuItemsID";
        param.Value = newMenuItemsId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        int result = -1;
        try
        {
            result = GenericDataAccess.ExecuteNonQuery(comm);
        }
        catch
        {
        }

        return (result != -1);
    }

    public static bool RemoveFoodFromMenuItems(string foodId, string menuItemsId)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "RemoveFoodToMenuItems";
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@FoodID";
        param.Value = foodId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "MenuItemsID";
        param.Value = menuItemsId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        int result = -1;
        try
        {
            result = GenericDataAccess.ExecuteNonQuery(comm);
        }
        catch
        {
        }

        return (result != -1);
    }

    public static bool DeleteFood(string foodId)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "DeleteFood";
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@FoodID";
        param.Value = foodId;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        int result = -1;
        try
        {
            result = GenericDataAccess.ExecuteNonQuery(comm);
        }
        catch
        {
        }

        return (result != -1);
    }
}


