using System;
using System.Data;
using System.Data.Common;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// <summary>
/// Summary description for GenericDataAccess
/// </summary>
public class GenericDataAccess
{
    public GenericDataAccess()
    {
        //
        // TODO: Add constructor logic here
        //
    }

    public static DataTable ExecuteSelectCommand(DbCommand command)
    {
        //The DataTable to be returned
        DataTable table;

        //execute the command making sure the connection get closed in the end
        try
        {
            //open the data connection
            command.Connection.Open();

            //Execute the command and save the results in a DataTable
            DbDataReader reader = command.ExecuteReader();
            table = new DataTable();
            table.Load(reader);

            //close the reader
            reader.Close();
        }
        catch (Exception ex)
        {
            //  Utilities.LogError(ex);
            //throw ex;
            Utilities.SendErrorLogEmail(ex);
            throw ex;
        }
        finally
        {
            //close the connection
            command.Connection.Close();
        }

        return table;
    }

    //creates and prepares a new DbCommand object on a new connection
    public static DbCommand CreateCommand()
    {
        //obtain the database provider name
        string dataProviderName = LaScalaConfiguration.DbProviderName;

        //obtain the database connection string
        string connectionString = LaScalaConfiguration.DbConnectionString;

        //create a new data provider factory

        DbProviderFactory factory = DbProviderFactories.GetFactory(dataProviderName);

        //obtain a database specific connection object
        DbConnection conn = factory.CreateConnection();

        //Set the connection string
        conn.ConnectionString = connectionString;

        //create a database specific command object
        DbCommand comm = conn.CreateCommand();

        //Set the command type to stored procedure
        comm.CommandType = CommandType.StoredProcedure;

        //return the initialize command object
        return comm;
    }

    //Run an update, delete, or insert command and return the number affected rows
    public static int ExecuteNonQuery(DbCommand command)
    {
        //the number of affected rows
        int affectedRows = -1;

        //run the command making sure the connection gets closed in the end
        try
        {
            command.Connection.Open();
            affectedRows = command.ExecuteNonQuery();
        }
        catch (Exception ex)
        {
            //Log eventual errors and rethrow them
            Utilities.LogError(ex);
            throw ex;
        }
        finally
        {
            command.Connection.Close();
        }
        return affectedRows;
    }

    //Run a select command and return a single result as a string
    public static string ExecuteScalar(DbCommand command)
    {
        //the value to be returned
        string value = "";

        try
        {
            command.Connection.Open();

            value = command.ExecuteScalar().ToString();
        }
        catch (Exception ex)
        {
            Utilities.LogError(ex);
            throw ex;
        }
        finally
        {
            command.Connection.Close();
        }
        return value;
    }
}
