using System;
using System.Data;
using System.Data.Common;
using System.Text;
using System.Collections.Generic;
using System.Configuration;
using System.Web;
using System.Web.Profile;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SecurityFile;



/// <summary>
/// handle order detail data
/// </summary>
public class CommerceLibOrderDetailInfo
{
    private int orderID;
    private int foodID;
    private string foodName;
    private int quantity;
    private double unitCost;
    private string itemAsString;

    public int OrderID
    {
        get
        {
            return orderID;
        }
        set
        {
            orderID = value;
        }
    }
    public int FoodID
    {
        get
        {
            return foodID;
        }
        set
        {
            foodID = value;
        }
    }
    public string FoodName
    {
        get
        {
            return 
                foodName;
        }
        set
        {
            foodName = value;
        }
    }
    public int Quantity
    {
        get
        {
            return quantity;
        }
        set
        {
            quantity = value;
        }
    }
    public double UnitCost
    {
        get
        {
            return unitCost;
        }
        set
        {
            unitCost = value;
        }
    }
    public string ItemAsString
    {
        get
        {
            return itemAsString;
        }
        set
        {
            itemAsString = value;
        }
    }
    public double Subtotal
    {
        get
        {
            return Quantity * UnitCost;
        }
    }

    public CommerceLibOrderDetailInfo(DataRow orderDetailRow)
    {
        OrderID = Int32.Parse(orderDetailRow["OrderID"].ToString());
        FoodID = Int32.Parse(orderDetailRow["FoodId"].ToString());
        FoodName = orderDetailRow["FoodName"].ToString();
        Quantity = Int32.Parse(orderDetailRow["Quantity"].ToString());
        UnitCost = Double.Parse(orderDetailRow["UnitCost"].ToString());
        // set info property
        Refresh();
    }

    public void Refresh()
    {
        StringBuilder sb = new StringBuilder();
        sb.Append(Quantity.ToString());
        sb.Append(" ");
        sb.Append(FoodName);
        sb.Append(", $");
        sb.Append(UnitCost.ToString());
        sb.Append(" each, total cost $");
        sb.Append(Subtotal.ToString());
        ItemAsString = sb.ToString();
    }
}

/// <summary>
/// Wraps order data
/// </summary>
public class CommerceLibOrderInfo
{
    //public int OrderID;
    public int orderID;
    public string dateCreated;
    public string comments;
    public int status;

    public MembershipUser customer;
    public ProfileCommon customerProfile;
    private List<CommerceLibAuditInfo> auditTrail;
    public List<CommerceLibOrderDetailInfo> orderDetails;

    public double totalCost;
    public string orderAsString;
    public string customerAddressAsString;


    // public List<CommerceLibOrderDetailInfo> OrderDetails;

    public int OrderID
    {
        get
        {
            return orderID;
        }
        set
        {
            orderID = value;
        }
    }
    public string DateCreated
    {
        get
        {
            return dateCreated;
        }
        set
        {
            dateCreated = value;
        }
    }

    public string Comments
    {
        get
        {
            return comments;
        }
        set
        {
            comments = value;
        }
    }
    public int Status
    {
        get
        {
            return status;
        }
        set
        {
            status = value;
        }
    }

    public MembershipUser Customer
    {
        get
        {
            return customer;
        }
        set
        {
            customer = value;
        }
    }
    public ProfileCommon CustomerProfile
    {
        get
        {
            return customerProfile;
        }
        set
        {
            customerProfile = value;
        }
    }
    public double TotalCost
    {
        get
        {
            return totalCost;
        }
        set
        {
            totalCost = value;
        }
    }
    public string OrderAsString
    {
        get
        {
            return orderAsString;
        }
        set
        {
            orderAsString = value;
        }
    }
    public string CustomerAddressAsString
    {
        get
        {
            return customerAddressAsString;
        }
        set
        {
            customerAddressAsString = value;
        }
    }
    public List<CommerceLibOrderDetailInfo> OrderDetails
    {
        get
        {
            return orderDetails;
        }
        set
        {
            orderDetails = value;
        }
    }
    public List<CommerceLibAuditInfo> AuditTrail
    {
        get
        {
            if (auditTrail == null)
            {
                auditTrail = CommerceLibAccess.GetOrderAuditTrail(
                  OrderID.ToString());
            }
            return auditTrail;
        }
    }

    public string StatusAsString
    {
        get
        {
            try
            {
                return CommerceLibAccess.OrderStatuses[Status];
            }
            catch
            {
                return "Status unknown";
            }
        }
    }

    public string CustomerName
    {
        get
        {
            return customer.UserName;
        }
    }

    public CommerceLibOrderInfo(DataRow orderRow)
    {
        OrderID = Int32.Parse(orderRow["OrderID"].ToString());
        DateCreated = orderRow["DateCreated"].ToString();
        Comments = orderRow["Comments"].ToString();
        Status = Int32.Parse(orderRow["Status"].ToString());
        Customer = Membership.GetUser(
          new Guid(orderRow["CustomerID"].ToString()));
        CustomerProfile =
          (HttpContext.Current.Profile as ProfileCommon)
            .GetProfile(Customer.UserName);
        OrderDetails =
          CommerceLibAccess.GetOrderDetails(
          orderRow["OrderID"].ToString());

        // set info properties
        Refresh();
    }

    public void Refresh()
    {
        // calculate total cost and set data
        StringBuilder sb = new StringBuilder();
        TotalCost = 0.0;
        foreach (CommerceLibOrderDetailInfo item in OrderDetails)
        {
            sb.AppendLine(item.ItemAsString);
            TotalCost += item.Subtotal;
        }

        
        sb.AppendLine();
        sb.Append("Total order cost: $");
        sb.Append(TotalCost.ToString());
        OrderAsString = sb.ToString();

        // get customer address string
        sb = new StringBuilder();
        sb.AppendLine(Customer.UserName);
        sb.AppendLine(CustomerProfile.Address);
        sb.AppendLine(CustomerProfile.PostalCode);
        CustomerAddressAsString = sb.ToString();
    }

    public void UpdateStatus(int status)
    {
        CommerceLibAccess.UpdateOrderStatus(OrderID, status);

        Status = status;
    }
}

/// <summary>
/// it handles order detail data
/// </summary>
public class CommerceLibAccess
{
    public static readonly string[] OrderStatuses = { "Order placed, notifying customer", "Order Cancelled" };

    public CommerceLibAccess()
    {
        //
        // TODO: Add constructor logic here
        //
    }

    public static List<CommerceLibOrderDetailInfo> GetOrderDetails(string orderId)
    {
        // use existing method for DataTable
        DataTable orderDetailsData = OrdersAccess.GetDetails(orderId);
        // create List<>
        List<CommerceLibOrderDetailInfo> orderDetails =
           new List<CommerceLibOrderDetailInfo>(
           orderDetailsData.Rows.Count);
        foreach (DataRow orderDetail in orderDetailsData.Rows)
        {
            orderDetails.Add(
              new CommerceLibOrderDetailInfo(orderDetail));
        }
        return orderDetails;
    }

    public static CommerceLibOrderInfo GetOrder(string orderID)
    {
        // get a configured DbCommand object
        DbCommand comm = GenericDataAccess.CreateCommand();
        // set the stored procedure name
        comm.CommandText = "CommerceLibOrderGetInfo";
        // create a new parameter
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@OrderID";
        param.Value = orderID;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);
        // obtain the results
        DataTable table = GenericDataAccess.ExecuteSelectCommand(comm);
        DataRow orderRow = table.Rows[0];
        // save the results into an CommerceLibOrderInfo object
        CommerceLibOrderInfo orderInfo =
          new CommerceLibOrderInfo(orderRow);
        return orderInfo;
    }

    public static void CreateAudit(int orderID, string message, int messageNumber)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "CreateAudit";
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@OrderID";
        param.Value = orderID;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@Message";
        param.Value = message;
        param.DbType = DbType.String;
        param.Size = 512;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@MessageNumber";
        param.Value = messageNumber;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        GenericDataAccess.ExecuteNonQuery(comm);

    }

    public static void UpdateOrderStatus(int orderID, int status)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "CommerceLibOrderUpdateStatus";
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@OrderID";
        param.Value = orderID;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        param = comm.CreateParameter();
        param.ParameterName = "@Status";
        param.Value = status;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        GenericDataAccess.ExecuteNonQuery(comm);
    }

    public static List<CommerceLibAuditInfo> GetOrderAuditTrail(string orderID)
    {
        DbCommand comm = GenericDataAccess.CreateCommand();
        comm.CommandText = "CommerceLibOrderGetAuditTrail";

        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@OrderID";
        param.Value = orderID;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        DataTable orderAuditTrailData = GenericDataAccess.ExecuteSelectCommand(comm);

        List<CommerceLibAuditInfo> orderAuditTrail = new List<CommerceLibAuditInfo>(orderAuditTrailData.Rows.Count);
        foreach (DataRow orderAudit in orderAuditTrailData.Rows)
        {
            orderAuditTrail.Add(new CommerceLibAuditInfo(orderAudit));
        }

        return orderAuditTrail;
    }

    public static List<CommerceLibOrderInfo> ConvertDataTableToOrders(DataTable table)
    {
        List<CommerceLibOrderInfo> orders =
          new List<CommerceLibOrderInfo>(table.Rows.Count);
        foreach (DataRow orderRow in table.Rows)
        {
            try
            {
                // try to add order
                orders.Add(new CommerceLibOrderInfo(orderRow));
            }
            catch
            {
                // can't add this order
            }
        }
        return orders;
    }

    public static List<CommerceLibOrderInfo> GetOrdersByCustomer(string customerID)
    {
        // get a configured DbCommand object
        DbCommand comm = GenericDataAccess.CreateCommand();
        // set the stored procedure name
        comm.CommandText = "CommerceLibOrdersGetByCustomer";
        // create a new parameter
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@CustomerID";
        param.Value = new Guid(customerID);
        param.DbType = DbType.Guid;
        comm.Parameters.Add(param);
        // obtain the results
        return ConvertDataTableToOrders(GenericDataAccess.ExecuteSelectCommand(comm));
    }

    public static List<CommerceLibOrderInfo> GetOrdersByDate(string startDate, string endDate)
    {
        // get a configured DbCommand object
        DbCommand comm = GenericDataAccess.CreateCommand();
        // set the stored procedure name
        comm.CommandText = "CommerceLibOrdersGetByDate";
        // create a new parameter
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@StartDate";
        param.Value = startDate;
        param.DbType = DbType.Date;
        comm.Parameters.Add(param);
        // create a new parameter
        param = comm.CreateParameter();
        param.ParameterName = "@EndDate";
        param.Value = endDate;
        param.DbType = DbType.Date;
        comm.Parameters.Add(param);
        // obtain the results
        return ConvertDataTableToOrders(
          GenericDataAccess.ExecuteSelectCommand(comm));
    }

    public static List<CommerceLibOrderInfo> GetOrdersByRecent(
    int count)
    {
        // get a configured DbCommand object
        DbCommand comm = GenericDataAccess.CreateCommand();
        // set the stored procedure name
        comm.CommandText = "CommerceLibOrdersGetByRecent";
        // create a new parameter
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@Count";
        param.Value = count;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);
        // obtain the results
        return ConvertDataTableToOrders(
          GenericDataAccess.ExecuteSelectCommand(comm));
    }

    public static List<CommerceLibOrderInfo> GetOrdersByStatus(
    int status)
    {
        // get a configured DbCommand object
        DbCommand comm = GenericDataAccess.CreateCommand();
        // set the stored procedure name
        comm.CommandText = "CommerceLibOrdersGetByStatus";
        // create a new parameter
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@Status";
        param.Value = status;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);
        // obtain the results
        return ConvertDataTableToOrders(
          GenericDataAccess.ExecuteSelectCommand(comm));
    }

    public static void UpdateOrder(int orderID, string newDateCreated, int newStatus, string newComments)
    {
        // get a configured DbCommand object
        DbCommand comm = GenericDataAccess.CreateCommand();
        // set the stored procedure name
        comm.CommandText = "CommerceLibOrderUpdate";
        // create a new parameter
        DbParameter param = comm.CreateParameter();
        param.ParameterName = "@OrderID";
        param.Value = orderID;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);
        // create a new parameter
        param = comm.CreateParameter();
        param.ParameterName = "@DateCreated";
        param.Value = DateTime.Parse(newDateCreated);
        param.DbType = DbType.DateTime;
        comm.Parameters.Add(param);

        // create a new parameter
        param = comm.CreateParameter();
        param.ParameterName = "@Status";
        param.Value = newStatus;
        param.DbType = DbType.Int32;
        comm.Parameters.Add(param);

        // create a new parameter
        param = comm.CreateParameter();
        param.ParameterName = "@Comments";
        param.Value = newComments;
        param.DbType = DbType.String;
        comm.Parameters.Add(param);
        // update the order
        GenericDataAccess.ExecuteNonQuery(comm);
    }

}

//audit trail data
public class CommerceLibAuditInfo
{
    #region Private Fields
    private int auditID;
    private int orderID;
    private DateTime dateStamp;
    private string message;
    private int messageNumber;
    #endregion

    #region Public Properties
    public int AuditID
    {
        get
        {
            return auditID;
        }
    }
    public int OrderID
    {
        get
        {
            return orderID;
        }
    }
    public DateTime DateStamp
    {
        get
        {
            return dateStamp;
        }
    }
    public string Message
    {
        get
        {
            return message;
        }
    }

    public int MessageNumber
    {
        get
        {
            return messageNumber;
        }
    }
    #endregion

    #region Constructor
    public CommerceLibAuditInfo(DataRow auditRow)
    {
        auditID = (int)auditRow["AuditID"];
        orderID = (int)auditRow["OrderID"];
        dateStamp = (DateTime)auditRow["DateStamp"];
        message = auditRow["Message"] as string;
        messageNumber = (int)auditRow["messageNumber"];


    }
    #endregion
}


