using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// <summary>
/// Summary description for OrderProcessor
/// </summary>
/// 
namespace CommerceLib
{
    public class OrderProcessor
    {
        internal IPipelineSection CurrentPipelineSection;
        internal bool ContinueNow;
        internal CommerceLibOrderInfo Order;

        public OrderProcessor(string orderID)
        {
            Order = CommerceLibAccess.GetOrder(orderID);
        }

        public OrderProcessor(CommerceLibOrderInfo orderToProcess)
        {
            Order = orderToProcess;
        }

        public void Process()
        {
            ContinueNow = true;

            //log start of execution
            CreateAudit("Order Processor started.", 10000);
        
            //process pipeline section
            try
            {
                while (ContinueNow)
                {
                    ContinueNow = false;
                    GeCurrentPipelineSection();
                    CurrentPipelineSection.Process(this);
                }
            }
            catch (OrderProcessorException ex)
            {
                //MailAdmin("Order Processing error occurred.", ex.Message, ex.SourceStage);
                CreateAudit("Order Processing error occurred.", 10002);
                throw new OrderProcessorException("Error occurred, order aborted." + "Details mailed to administrator.", 100);
            }
            catch (Exception ex)
            {
               // MailAdmin("Order Processing error occurred.", ex.Message, 100);
                CreateAudit("Order Processing error occurred.", 10002);
                throw new OrderProcessorException("Unknown error, order aborted." + "Details mailed to administrator.", 100);
            }
            finally
            {
                CommerceLibAccess.CreateAudit(Order.OrderID, "Order Processor finished.", 10001);
            }
        }

        public void CreateAudit(string message, int messageNumber)
        {
            CommerceLibAccess.CreateAudit(Order.OrderID, message, messageNumber);
        }
        /*
        public void MailAdmin(string subject, string message, int sourceStage)
        {
            OrderProcessorMailer.MailAdmin(Order.OrderID, subject, message, sourceStage);
        }
        */
        private void GeCurrentPipelineSection()
        {
            //select pipeline section to execute based on order status

            CurrentPipelineSection = new PSDummy();

                if (Order.Status == 0)
                    CurrentPipelineSection = new PSInitialNotification();
                 else
                  throw new OrderProcessorException("Unknown pipeline section requested.", 100);
        }
        /*
        public void MailCustomer(string subject, string message)
        {
            OrderProcessorMailer.MailCustomer(Order.Customer, subject, message);
        }*/
        
    }
}