/*
FILE: WorldMap.java
AUTHOR: Trevor Evans
CREATED: 2-19-06
MODIFIED: 4-24-06
*/

import javax.imageio.*;
import java.awt.*;
import java.io.*;

/*
CLASS: WorldMap
PURPOSE: Creates the world map. This class has been tailored to a specific pre-made map.
The constructor sets the boolean passable to false for each impassable tile. Any changes
made to the image associated with this map would require a change to this constructor, and
visa-versa.
*/
public class WorldMap extends Map
{
	public WorldMap(int heroColumnIn, int heroRowIn)
	{
		super();
		//set hero's position
		heroColumn = heroColumnIn;
		heroRow = heroRowIn;
		//load pre-made map image
		try
		{
			image = ImageIO.read(new File("image_files/world_map.gif"));
		}
		catch (IOException exception)
		{
			System.out.println("Caught exception: " + exception) ;
		}
		//set map width and height, in tiles
		width = image.getWidth(null) / Tile.TILE_SIZE;
		height = image.getHeight(null) / Tile.TILE_SIZE;
		//construct array of tiles and initialize it
		tile = new Tile[width][height];
		for(int i = 0; i < width; i++)
		{
			for(int j = 0; j < height; j++)
			{
				tile[i][j] = new Tile();
			}
		}
		//for each impassable tile on the pre-made map, set passable to false
		for(int i = 10; i < 16; i++)
			tile[i][3].setPassable(false);
		for(int i = 6; i < 10; i++)
			tile[i][4].setPassable(false);
		for(int i = 6; i < 9; i++)
			tile[i][14].setPassable(false);
		for(int i = 9; i < 14; i++)
			tile[i][15].setPassable(false);
		for(int j = 8; j < 15; j++)
			tile[4][j].setPassable(false);
		for(int j = 5; j < 8; j++)
			tile[5][j].setPassable(false);
		for(int j = 13; j < 15; j++)
			tile[14][j].setPassable(false);
		for(int j = 6; j < 13; j++)
			tile[15][j].setPassable(false);
		for(int j = 4; j < 6; j++)
			tile[16][j].setPassable(false);
	}
}