/*
FILE: TreasureChest.java
AUTHOR: Trevor Evans
CREATED: 4-12-06
MODIFIED: 4-24-06
*/

/*
CLASS: TreasureChest
PURPOSE: Creates a new treasure chest. Treasure chests appear randomly in the dungeon and
contain random items. The value of items increase the deeper the hero is in the dungeon.
*/
public class TreasureChest
{
	private int column; //the column position of the chest on the map
	private int row; //the row position of the chest on the map
	private Item contents; //the item contained by the chest

	public TreasureChest(int dungeonLevel, int columnIn, int rowIn)
	{
		column = columnIn;
		row = rowIn;
		contents = new ItemLookUpTable().getRandomItem(dungeonLevel);
	}

	/*
	METHOD: getColumn
	PURPOSE: Returns the column position of this chest.
	*/
	public int getColumn()
	{
		return column;
	}

	/*
	METHOD: getRow
	PURPOSE: Returns the row position of this chest.
	*/
	public int getRow()
	{
		return row;
	}

	/*
	METHOD: getContents
	PURPOSE: Returns the item contained inside this chest.
	*/
	public Item getContents()
	{
		return contents;
	}
}