/*
FILE: TownMap.java
AUTHOR: Trevor Evans
CREATED: 2-20-06
MODIFIED: 4-24-06
*/

import javax.imageio.*;
import java.awt.*;
import java.io.*;

/*
CLASS: TownMap
PURPOSE: Creates the town map. This class has been tailored to a specific pre-made map.
The constructor sets the boolean passable to false for each impassable tile. Any changes
made to the image associated with this map would require a change to this constructor, and
visa-versa.
*/
public class TownMap extends Map
{
	public TownMap(int heroColumnIn, int heroRowIn)
	{
		super();
		//set hero's position
		heroColumn = heroColumnIn;
		heroRow = heroRowIn;
		//load pre-made map image
		try
		{
			image = ImageIO.read(new File("image_files/town_map.gif"));
		}
		catch (IOException exception)
		{
			System.out.println("Caught exception: " + exception) ;
		}
		//set map width and height, in tiles
		width = image.getWidth(null) / Tile.TILE_SIZE;
		height = image.getHeight(null) / Tile.TILE_SIZE;
		//construct array of tiles and initialize it
		tile = new Tile[width][height];
		for(int i = 0; i < width; i++)
		{
			for(int j = 0; j < height; j++)
			{
				tile[i][j] = new Tile();
			}
		}
		//for each impassable tile on the pre-made map, set passable to false
		for(int i = 5; i < 17; i++)
			tile[i][4].setPassable(false);
		for(int i = 21; i < 35; i++)
			tile[i][4].setPassable(false);
		for(int i = 12; i < 16; i++)
			tile[i][5].setPassable(false);
		for(int i = 22; i < 25; i++)
			tile[i][5].setPassable(false);
		for(int i = 25; i < 33; i++)
			tile[i][6].setPassable(false);
		for(int i = 7; i < 12; i++)
			tile[i][7].setPassable(false);
		for(int i = 28; i < 33; i++)
			tile[i][7].setPassable(false);
		for(int i = 28; i < 33; i++)
			tile[i][8].setPassable(false);
		for(int i = 8; i < 11; i++)
			tile[i][9].setPassable(false);
		for(int i = 28; i < 33; i++)
			tile[i][9].setPassable(false);
		for(int i = 27; i < 33; i++)
			tile[i][10].setPassable(false);
		for(int i = 23; i < 32; i++)
			tile[i][12].setPassable(false);
		for(int i = 24; i < 27; i++)
			tile[i][13].setPassable(false);
		for(int i = 31; i < 34; i++)
			tile[i][20].setPassable(false);
		for(int i = 22; i < 26; i++)
			tile[i][21].setPassable(false);
		for(int i = 29; i < 34; i++)
			tile[i][21].setPassable(false);
		for(int i = 21; i < 34; i++)
			tile[i][22].setPassable(false);
		for(int i = 25; i < 34; i++)
			tile[i][23].setPassable(false);
		for(int i = 7; i < 13; i++)
			tile[i][24].setPassable(false);
		for(int i = 14; i < 18; i++)
			tile[i][24].setPassable(false);
		for(int i = 24; i < 28; i++)
			tile[i][24].setPassable(false);
		for(int i = 30; i < 34; i++)
			tile[i][24].setPassable(false);
		for(int i = 14; i < 18; i++)
			tile[i][25].setPassable(false);
		for(int i = 12; i < 18; i++)
			tile[i][26].setPassable(false);
		for(int i = 26; i < 34; i++)
			tile[i][27].setPassable(false);
		for(int i = 8; i < 12; i++)
			tile[i][28].setPassable(false);
		for(int i = 13; i < 16; i++)
			tile[i][28].setPassable(false);
		for(int i = 29; i < 34; i++)
			tile[i][28].setPassable(false);
		for(int i = 8; i < 11; i++)
			tile[i][31].setPassable(false);
		for(int i = 15; i < 24; i++)
			tile[i][31].setPassable(false);
		for(int i = 26; i < 34; i++)
			tile[i][31].setPassable(false);
		for(int i = 6; i < 18; i++)
			tile[i][32].setPassable(false);
		for(int i = 19; i < 25; i++)
			tile[i][32].setPassable(false);
		for(int i = 30; i < 34; i++)
			tile[i][32].setPassable(false);
		for(int i = 19; i < 34; i++)
			tile[i][33].setPassable(false);
		for(int i = 5; i < 34; i++)
			tile[i][34].setPassable(false);
		for(int j = 4; j < 35; j++)
			tile[4][j].setPassable(false);
		for(int j = 5; j < 15; j++)
			tile[5][j].setPassable(false);
		for(int j = 20; j < 24; j++)
			tile[5][j].setPassable(false);
		for(int j = 8; j < 12; j++)
			tile[7][j].setPassable(false);
		for(int j = 24; j < 32; j++)
			tile[6][j].setPassable(false);
		for(int j = 8; j < 12; j++)
			tile[11][j].setPassable(false);
		for(int j = 29; j < 32; j++)
			tile[13][j].setPassable(false);
		for(int j = 27; j < 31; j++)
			tile[17][j].setPassable(false);
		for(int j = 10; j < 17; j++)
			tile[22][j].setPassable(false);
		for(int j = 28; j < 31; j++)
			tile[22][j].setPassable(false);
		for(int j = 7; j < 11; j++)
			tile[25][j].setPassable(false);
		for(int j = 13; j < 17; j++)
			tile[26][j].setPassable(false);
		for(int j = 13; j < 17; j++)
			tile[31][j].setPassable(false);
		for(int j = 4; j < 35; j++)
			tile[34][j].setPassable(false);
		tile[13][6].setPassable(false);
		tile[15][6].setPassable(false);
		tile[23][6].setPassable(false);
		tile[23][7].setPassable(false);
		tile[8][11].setPassable(false);
		tile[10][11].setPassable(false);
		tile[21][11].setPassable(false);
		tile[6][12].setPassable(false);
		tile[10][12].setPassable(false);
		tile[21][12].setPassable(false);
		tile[6][13].setPassable(false);
		tile[14][14].setPassable(false);
		tile[29][14].setPassable(false);
		tile[5][16].setPassable(false);
		tile[6][16].setPassable(false);
		tile[23][16].setPassable(false);
		tile[25][16].setPassable(false);
		tile[27][16].setPassable(false);
		tile[29][16].setPassable(false);
		tile[30][16].setPassable(false);
		tile[33][16].setPassable(false);
		tile[5][17].setPassable(false);
		tile[33][17].setPassable(false);
		tile[18][20].setPassable(false);
		tile[24][20].setPassable(false);
		tile[6][21].setPassable(false);
		tile[17][21].setPassable(false);
		tile[18][21].setPassable(false);
		tile[16][22].setPassable(false);
		tile[17][22].setPassable(false);
		tile[11][23].setPassable(false);
		tile[12][23].setPassable(false);
		tile[14][23].setPassable(false);
		tile[22][23].setPassable(false);
		tile[10][25].setPassable(false);
		tile[23][25].setPassable(false);
		tile[24][25].setPassable(false);
		tile[32][25].setPassable(false);
		tile[33][25].setPassable(false);
		tile[10][26].setPassable(false);
		tile[33][26].setPassable(false);
		tile[23][27].setPassable(false);
		tile[23][28].setPassable(false);
		tile[26][28].setPassable(false);
		tile[10][29].setPassable(false);
		tile[18][29].setPassable(false);
		tile[29][29].setPassable(false);
		tile[9][30].setPassable(false);
		tile[10][30].setPassable(false);
		tile[19][30].setPassable(false);
		tile[21][30].setPassable(false);
		tile[25][30].setPassable(false);
		tile[26][30].setPassable(false);
		tile[29][30].setPassable(false);
	}
}