/*
FILE: SpellLookUpTable.java
AUTHOR: Trevor Evans
CREATED: 3-14-06
MODIFIED: 4-24-06
*/

import java.io.*;
import java.util.*;

/*
CLASS: SpellLookUpTable
PURPOSE: A look-up table containing all spells. Implemented using a hash table to ensure no
duplication and quick accessibility. All spells are created here and added to the hash table,
using their names as keys.
*/
public class SpellLookUpTable implements Serializable
{
	private Hashtable spellTable; //stores all items using their names as keys

	public SpellLookUpTable()
	{
		spellTable = new Hashtable();

		Spell empty = new Spell("", 0);
		spellTable.put(empty.getName(), empty);

		MonsterMelee meleeAttack = new MonsterMelee();
		spellTable.put(meleeAttack.getName(), meleeAttack);

		HealingSpell minorHeal = new HealingSpell("minor heal", 5, 2);
		minorHeal.setDescription("Recovers a small amount of HP.");
		spellTable.put(minorHeal.getName(), minorHeal);

		HealingSpell midHeal = new HealingSpell("mid heal", 10, 3);
		midHeal.setDescription("Recovers a moderate amount of HP.");
		spellTable.put(midHeal.getName(), midHeal);

		HealingSpell majorHeal = new HealingSpell("major heal", 15, 4);
		majorHeal.setDescription("Recovers a large amount of HP.");
		spellTable.put(majorHeal.getName(), majorHeal);

		HealingSpell fullHeal = new HealingSpell("full heal", 20, 540);
		fullHeal.setDescription("Fully recovers HP.");
		spellTable.put(fullHeal.getName(), fullHeal);

		OffensiveSpell minorBlast = new OffensiveSpell("minor blast", 5, 1);
		minorBlast.setDescription("Deals out a small amount of damage.");
		spellTable.put(minorBlast.getName(), minorBlast);

		OffensiveSpell midBlast = new OffensiveSpell("mid blast", 10, 1.5);
		midBlast.setDescription("Deals out a moderate amount of damage.");
		spellTable.put(midBlast.getName(), midBlast);

		OffensiveSpell majorBlast = new OffensiveSpell("major blast", 15, 2);
		majorBlast.setDescription("Deals out a large amount of damage.");
		spellTable.put(majorBlast.getName(), majorBlast);

		OffensiveSpell fullBlast = new OffensiveSpell("full blast", 20, 3);
		fullBlast.setDescription("Deals out a critical amount of damage.");
		spellTable.put(fullBlast.getName(), fullBlast);

		BuffingSpell minorStrength = new BuffingSpell("minor strength", 2, 1, GameCharacter.ATK);
		minorStrength.setDescription("Slightly increases ATK.");
		spellTable.put(minorStrength.getName(), minorStrength);

		BuffingSpell midStrength = new BuffingSpell("mid strength", 3, 1.5, GameCharacter.ATK);
		midStrength.setDescription("Moderately increases ATK.");
		spellTable.put(midStrength.getName(), midStrength);

		BuffingSpell majorStrength = new BuffingSpell("major strength", 15, 2, GameCharacter.ATK);
		majorStrength.setDescription("Greatly increases ATK.");
		spellTable.put(majorStrength.getName(), majorStrength);

		BuffingSpell fullStrength = new BuffingSpell("full strength", 20, 3, GameCharacter.ATK);
		fullStrength.setDescription("Fully increases ATK.");
		spellTable.put(fullStrength.getName(), fullStrength);

		BuffingSpell minorShield = new BuffingSpell("minor shield", 2, 1, GameCharacter.DEF);
		minorShield.setDescription("Slightly increases DEF.");
		spellTable.put(minorShield.getName(), minorShield);

		BuffingSpell midShield = new BuffingSpell("mid shield", 3, 1.5, GameCharacter.DEF);
		midShield.setDescription("Moderately increases DEF.");
		spellTable.put(midShield.getName(), midShield);

		BuffingSpell majorShield = new BuffingSpell("major shield", 15, 2, GameCharacter.DEF);
		majorShield.setDescription("Greatly increases DEF.");
		spellTable.put(majorShield.getName(), majorShield);

		BuffingSpell fullShield = new BuffingSpell("full shield", 20, 3, GameCharacter.DEF);
		fullShield.setDescription("Fully increases DEF.");
		spellTable.put(fullShield.getName(), fullShield);

		BuffingSpell minorSight = new BuffingSpell("minor sight", 2, 1, GameCharacter.ACC);
		minorSight.setDescription("Slightly increases ACC.");
		spellTable.put(minorSight.getName(), minorSight);

		BuffingSpell midSight = new BuffingSpell("mid sight", 3, 1.5, GameCharacter.ACC);
		midSight.setDescription("Moderately increases ACC.");
		spellTable.put(midSight.getName(), midSight);

		BuffingSpell majorSight = new BuffingSpell("major sight", 15, 2, GameCharacter.ACC);
		majorSight.setDescription("Greatly increases ACC.");
		spellTable.put(majorSight.getName(), majorSight);

		BuffingSpell fullSight = new BuffingSpell("full sight", 20, 3, GameCharacter.ACC);
		fullSight.setDescription("Fully increases ACC.");
		spellTable.put(fullSight.getName(), fullSight);

		BuffingSpell minorAgility = new BuffingSpell("minor agility", 2, 1, GameCharacter.EVA);
		minorAgility.setDescription("Slightly increases EVA.");
		spellTable.put(minorAgility.getName(), minorAgility);

		BuffingSpell midAgility = new BuffingSpell("mid agility", 3, 1.5, GameCharacter.EVA);
		midAgility.setDescription("Moderately increases EVA.");
		spellTable.put(midAgility.getName(), midAgility);

		BuffingSpell majorAgility = new BuffingSpell("major agility", 15, 2, GameCharacter.EVA);
		majorAgility.setDescription("Greatly increases EVA.");
		spellTable.put(majorAgility.getName(), majorAgility);

		BuffingSpell fullAgility = new BuffingSpell("full agility", 20, 3, GameCharacter.EVA);
		fullAgility.setDescription("Fully increases EVA.");
		spellTable.put(fullAgility.getName(), fullAgility);

		BuffingSpell minorBarrier = new BuffingSpell("minor barrier", 2, 1, GameCharacter.MDEF);
		minorBarrier.setDescription("Slightly increases MDEF.");
		spellTable.put(minorBarrier.getName(), minorBarrier);

		BuffingSpell midBarrier = new BuffingSpell("mid barrier", 3, 1.5, GameCharacter.MDEF);
		midBarrier.setDescription("Moderately increases MDEF.");
		spellTable.put(midBarrier.getName(), midBarrier);

		BuffingSpell majorBarrier = new BuffingSpell("major barrier", 15, 2, GameCharacter.MDEF);
		majorBarrier.setDescription("Greatly increases MDEF.");
		spellTable.put(majorBarrier.getName(), majorBarrier);

		BuffingSpell fullBarrier = new BuffingSpell("full barrier", 20, 3, GameCharacter.MDEF);
		fullBarrier.setDescription("Fully increases MDEF.");
		spellTable.put(fullBarrier.getName(), fullBarrier);

		BuffingSpell minorAccelerate = new BuffingSpell("minor accelerate", 2, 1, GameCharacter.SPD);
		minorAccelerate.setDescription("Slightly increases SPD.");
		spellTable.put(minorAccelerate.getName(), minorAccelerate);

		BuffingSpell midAccelerate = new BuffingSpell("mid accelerate", 3, 1.5, GameCharacter.SPD);
		midAccelerate.setDescription("Moderately increases SPD.");
		spellTable.put(midAccelerate.getName(), midAccelerate);

		BuffingSpell majorAccelerate = new BuffingSpell("major accelerate", 15, 2, GameCharacter.SPD);
		majorAccelerate.setDescription("Greatly increases SPD.");
		spellTable.put(majorAccelerate.getName(), majorAccelerate);

		BuffingSpell fullAccelerate = new BuffingSpell("full accelerate", 20, 3, GameCharacter.SPD);
		fullAccelerate.setDescription("Fully increases SPD.");
		spellTable.put(fullAccelerate.getName(), fullAccelerate);

		DebuffingSpell minorWeakness = new DebuffingSpell("minor weakness", 2, 1, GameCharacter.ATK);
		minorWeakness.setDescription("Slightly reduces ATK.");
		spellTable.put(minorWeakness.getName(), minorWeakness);

		DebuffingSpell midWeakness = new DebuffingSpell("mid weakness", 3, 1.5, GameCharacter.ATK);
		midWeakness.setDescription("Moderately reduces ATK.");
		spellTable.put(midWeakness.getName(), midWeakness);

		DebuffingSpell majorWeakness = new DebuffingSpell("major weakness", 15, 2, GameCharacter.ATK);
		majorWeakness.setDescription("Greatly reduces ATK.");
		spellTable.put(majorWeakness.getName(), majorWeakness);

		DebuffingSpell fullWeakness = new DebuffingSpell("full weakness", 20, 3, GameCharacter.ATK);
		fullWeakness.setDescription("Fully reduces ATK.");
		spellTable.put(fullWeakness.getName(), fullWeakness);

		DebuffingSpell minorOpening = new DebuffingSpell("minor opening", 2, 1, GameCharacter.DEF);
		minorOpening.setDescription("Slightly reduces DEF.");
		spellTable.put(minorOpening.getName(), minorOpening);

		DebuffingSpell midOpening = new DebuffingSpell("mid opening", 3, 1.5, GameCharacter.DEF);
		midOpening.setDescription("Moderately reduces DEF.");
		spellTable.put(midOpening.getName(), midOpening);

		DebuffingSpell majorOpening = new DebuffingSpell("major opening", 15, 2, GameCharacter.DEF);
		majorOpening.setDescription("Greatly reduces DEF.");
		spellTable.put(majorOpening.getName(), majorOpening);

		DebuffingSpell fullOpening = new DebuffingSpell("full opening", 20, 3, GameCharacter.DEF);
		fullOpening.setDescription("Fully reduces DEF.");
		spellTable.put(fullOpening.getName(), fullOpening);

		DebuffingSpell minorBlind = new DebuffingSpell("minor blind", 2, 1, GameCharacter.ACC);
		minorBlind.setDescription("Slightly reduces ACC.");
		spellTable.put(minorBlind.getName(), minorBlind);

		DebuffingSpell midBlind = new DebuffingSpell("mid blind", 3, 1.5, GameCharacter.ACC);
		midBlind.setDescription("Moderately reduces ACC.");
		spellTable.put(midBlind.getName(), midBlind);

		DebuffingSpell majorBlind = new DebuffingSpell("major blind", 15, 2, GameCharacter.ACC);
		majorBlind.setDescription("Greatly reduces ACC.");
		spellTable.put(majorBlind.getName(), majorBlind);

		DebuffingSpell fullBlind = new DebuffingSpell("full blind", 20, 3, GameCharacter.ACC);
		fullBlind.setDescription("Fully reduces ACC.");
		spellTable.put(fullBlind.getName(), fullBlind);

		DebuffingSpell minorParalysis = new DebuffingSpell("minor paralysis", 2, 1, GameCharacter.EVA);
		minorParalysis.setDescription("Slightly reduces EVA.");
		spellTable.put(minorParalysis.getName(), minorParalysis);

		DebuffingSpell midParalysis = new DebuffingSpell("mid paralysis", 3, 1.5, GameCharacter.EVA);
		midParalysis.setDescription("Moderately reduces EVA.");
		spellTable.put(midParalysis.getName(), midParalysis);

		DebuffingSpell majorParalysis = new DebuffingSpell("major paralysis", 15, 2, GameCharacter.EVA);
		majorParalysis.setDescription("Greatly reduces EVA.");
		spellTable.put(majorParalysis.getName(), majorParalysis);

		DebuffingSpell fullParalysis = new DebuffingSpell("full paralysis", 20, 3, GameCharacter.EVA);
		fullParalysis.setDescription("Fully reduces EVA.");
		spellTable.put(fullParalysis.getName(), fullParalysis);

		DebuffingSpell minorStupidity = new DebuffingSpell("minor stupidity", 2, 1, GameCharacter.WIS);
		minorStupidity.setDescription("Slightly reduces WIS.");
		spellTable.put(minorStupidity.getName(), minorStupidity);

		DebuffingSpell midStupidity = new DebuffingSpell("mid stupidity", 3, 1.5, GameCharacter.WIS);
		midStupidity.setDescription("Moderately reduces WIS.");
		spellTable.put(midStupidity.getName(), midStupidity);

		DebuffingSpell majorStupidity = new DebuffingSpell("major stupidity", 15, 2, GameCharacter.WIS);
		majorStupidity.setDescription("Greatly reduces WIS.");
		spellTable.put(majorStupidity.getName(), majorStupidity);

		DebuffingSpell fullStupidity = new DebuffingSpell("full stupidity", 20, 3, GameCharacter.WIS);
		fullStupidity.setDescription("Fully reduces WIS.");
		spellTable.put(fullStupidity.getName(), fullStupidity);

		DebuffingSpell minorExposure = new DebuffingSpell("minor exposure", 2, 1, GameCharacter.MDEF);
		minorExposure.setDescription("Slightly reduces MDEF.");
		spellTable.put(minorExposure.getName(), minorExposure);

		DebuffingSpell midExposure = new DebuffingSpell("mid exposure", 3, 1.5, GameCharacter.MDEF);
		midExposure.setDescription("Moderately reduces MDEF.");
		spellTable.put(midExposure.getName(), midExposure);

		DebuffingSpell majorExposure = new DebuffingSpell("major exposure", 15, 2, GameCharacter.MDEF);
		majorExposure.setDescription("Greatly reduces MDEF.");
		spellTable.put(majorExposure.getName(), majorExposure);

		DebuffingSpell fullExposure = new DebuffingSpell("full exposure", 20, 3, GameCharacter.MDEF);
		fullExposure.setDescription("Fully reduces MDEF.");
		spellTable.put(fullExposure.getName(), fullExposure);

		DebuffingSpell minorBrakes = new DebuffingSpell("minor brakes", 2, 1, GameCharacter.SPD);
		minorBrakes.setDescription("Slightly reduces SPD.");
		spellTable.put(minorBrakes.getName(), minorBrakes);

		DebuffingSpell midBrakes = new DebuffingSpell("mid brakes", 3, 1.5, GameCharacter.SPD);
		midBrakes.setDescription("Moderately reduces SPD.");
		spellTable.put(midBrakes.getName(), midBrakes);

		DebuffingSpell majorBrakes = new DebuffingSpell("major brakes", 15, 2, GameCharacter.SPD);
		majorBrakes.setDescription("Greatly reduces SPD.");
		spellTable.put(majorBrakes.getName(), majorBrakes);

		DebuffingSpell fullBrakes = new DebuffingSpell("full brakes", 20, 3, GameCharacter.SPD);
		fullBrakes.setDescription("Fully reduces SPD.");
		spellTable.put(fullBrakes.getName(), fullBrakes);
	}

	/*
	METHOD: getSpell(String)
	PURPOSE: Uses the specified string to look up a spell in the hash table and then
	returns the appropriate spell.
	*/
	public Spell getSpell(String spellName)
	{
		return (Spell) spellTable.get(spellName);
	}
}