/*
FILE: Monster.java
AUTHOR: Trevor Evans
CREATED: 12-19-05
MODIFIED: 4-24-06
*/

import java.io.*;
import javax.imageio.*;
import java.awt.*;

/*
CLASS: Monster
PURPOSE: Creates a new monster. Monsters are the player's adversaries and are controlled by
the system.
*/
public class Monster extends GameCharacter
{
	private String imageFileName; //the name of the image file associated with this monster
	private Spell[] spellList; //the monster's list of spells and attacks
	private SpellLookUpTable spellTable; //a look-up table containing all spells

	public Monster()
	{
		super();
	}

	public Monster(String nameIn, String imageFileNameIn, int lvlIn)
	{
		super();

		spellTable = new SpellLookUpTable();
		spellList = new Spell[5];
		for(int i = 0; i < 5; i++)
		{
			spellList[i] = new Spell("", 0);
		}
		name = nameIn;
		imageFileName = imageFileNameIn;
		LVL = lvlIn;
	}

	/*
	METHOD: getImageFileName
	PURPOSE: Returns the file name of the image associated with this monster.
	*/
	public String getImageFileName()
	{
		return imageFileName;
	}

	/*
	METHOD: setImageFileName
	PURPOSE: Sets the file name of the image associated with this monster to the specified
	string.
	*/
	public void setImageFileName(String fileNameIn)
	{
		imageFileName = fileNameIn;
	}

	/*
	METHOD: getSpell(int)
	PURPOSE: Returns the item at the specified index of the monster's spell list.
	*/
	public Spell getSpell(int index)
	{
		return spellList[index];
	}

	/*
	METHOD: setSpell(String, int)
	PURPOSE: Adds a spell, specified by its name, to the specified slot in the monster's
	spell list.
	*/
	public void setSpell(String spellNameIn, int index)
	{
		spellList[index] = spellTable.getSpell(spellNameIn);
	}

	/*
	METHOD: chooseRandomAction
	PURPOSE: Randomly selects an action for the monster to execute. The monster is more
	likely to select some actions than others. Typically, less powerful actions should be
	executed more often than more powerful actions.
	*/
	public Spell chooseRandomAction()
	{
		int random;
		Spell action = null;

		while(true)
		{
			random = (int) (Math.random() * 100);

			if(random >= 0 && random < 50)
			{
				action = spellList[0];
			}
			else if(random >= 50 && random < 70)
			{
				action = spellList[1];
			}
			else if(random >= 70 && random < 85)
			{
				action = spellList[2];
			}
			else if(random >= 85 && random < 95)
			{
				action = spellList[3];
			}
			else
			{
				action = spellList[4];
			}

			if(this.MP >= action.getMPcost())
			{
				return action;
			}
		}
	}
}