/*
FILE: MagicScroll.java
AUTHOR: Trevor Evans
CREATED: 3-15-06
MODIFIED: 4-24-06
*/

import java.io.*;

/*
CLASS: MagicScroll
PURPOSE: Creates a new item of type MAGIC_SCROLL. Magic scrolls are used to add new spells
to the hero's spell list.
*/
public class MagicScroll extends Item implements Serializable
{
	private Spell spell; //the spell learned from this scroll

	public MagicScroll(String nameIn, int valueIn)
	{
		super(nameIn, valueIn);
		type = MAGIC_SCROLL;
		spell = new SpellLookUpTable().getSpell(nameIn);
	}

	/*
	METHOD: use(Hero)
	PURPOSE: Uses this scroll on the specified hero. Returns the appropriate message to be
	displayed.
	*/
	public String use(Hero hero)
	{
		if(!hero.hasInSpellList(spell.getName()) && hero.firstEmptySlotInSpellList() != -1)
		{
			hero.setSpell(spell, hero.firstEmptySlotInSpellList());
			return (hero.getName() + " reads the scroll. He learns the spell " + spell.getName() + ".");
		}

		return null;
	}

	/*
	METHOD: getSpell
	PURPOSE: Returns the spell learned from this scroll.
	*/
	public Spell getSpell()
	{
		return spell;
	}
}