/*
FILE: ItemLookUpTable.java
AUTHOR: Trevor Evans
CREATED: 3-6-06
MODIFIED: 4-24-06
*/

import java.io.*;
import java.util.*;

/*
CLASS: ItemLookUpTable
PURPOSE: A look-up table containing all items. Implemented using a hash table to ensure no
duplication and quick accessibility. All items are created here and added to the hash table,
using their names as keys.
*/
public class ItemLookUpTable implements Serializable
{
	private Hashtable itemTable; //stores all items using their names as keys

	public ItemLookUpTable()
	{
		itemTable = new Hashtable();

		Equipment empty = new Equipment("", 0);
		itemTable.put(empty.getName(), empty);

		HealingItem herb = new HealingItem("herb", 10, 25, 0);
		herb.setDescription("Restores 25 HP when used.");
		itemTable.put(herb.getName(), herb);

		HealingItem strongHerb = new HealingItem("strong herb", 100, 50, 0);
		strongHerb.setDescription("Restores 50 HP when used.");
		itemTable.put(strongHerb.getName(), strongHerb);

		HealingItem specialHerb = new HealingItem("special herb", 300, 100, 0);
		specialHerb.setDescription("Restores 100 HP when used.");
		itemTable.put(specialHerb.getName(), specialHerb);

		HealingItem potion = new HealingItem("potion", 10, 0, 25);
		potion.setDescription("Restores 25 MP when used.");
		itemTable.put(potion.getName(), potion);

		HealingItem strongPotion = new HealingItem("strong potion", 100, 0, 50);
		strongPotion.setDescription("Restores 50 MP when used.");
		itemTable.put(strongPotion.getName(), strongPotion);

		HealingItem specialPotion = new HealingItem("special potion", 300, 0, 100);
		specialPotion.setDescription("Restores 100 MP when used.");
		itemTable.put(specialPotion.getName(), specialPotion);

		WarpScroll warpScroll = new WarpScroll(50);
		warpScroll.setDescription("Instantly transports user from the dungeon to town or visa-versa.");
		itemTable.put(warpScroll.getName(), warpScroll);

		MagicScroll minorHealScroll = new MagicScroll("minor heal", 15);
		minorHealScroll.setDescription("A magic scroll. Enscribed are the magic words for casting minor heal.");
		itemTable.put(minorHealScroll.getName(), minorHealScroll);

		MagicScroll midHealScroll = new MagicScroll("mid heal", 400);
		midHealScroll.setDescription("A magic scroll. Enscribed are the magic words for casting mid heal.");
		itemTable.put(midHealScroll.getName(), midHealScroll);

		MagicScroll majorHealScroll = new MagicScroll("major heal", 2000);
		majorHealScroll.setDescription("A magic scroll. Enscribed are the magic words for casting major heal.");
		itemTable.put(majorHealScroll.getName(), majorHealScroll);

		MagicScroll fullHealScroll = new MagicScroll("full heal", 0);
		fullHealScroll.setDescription("A magic scroll. Enscribed are the magic words for casting full heal.");
		itemTable.put(fullHealScroll.getName(), fullHealScroll);

		MagicScroll minorBlastScroll = new MagicScroll("minor blast", 15);
		minorBlastScroll.setDescription("A magic scroll. Enscribed are the magic words for casting minor blast.");
		itemTable.put(minorBlastScroll.getName(), minorBlastScroll);

		MagicScroll midBlastScroll = new MagicScroll("mid blast", 400);
		midBlastScroll.setDescription("A magic scroll. Enscribed are the magic words for casting mid blast.");
		itemTable.put(midBlastScroll.getName(), midBlastScroll);

		MagicScroll majorBlastScroll = new MagicScroll("major blast", 2000);
		majorBlastScroll.setDescription("A magic scroll. Enscribed are the magic words for casting major blast.");
		itemTable.put(majorBlastScroll.getName(), majorBlastScroll);

		MagicScroll fullBlastScroll = new MagicScroll("full blast", 0);
		fullBlastScroll.setDescription("A magic scroll. Enscribed are the magic words for casting full blast.");
		itemTable.put(fullBlastScroll.getName(), fullBlastScroll);

		MagicScroll minorStrengthScroll = new MagicScroll("minor strength", 15);
		minorStrengthScroll.setDescription("A magic scroll. Enscribed are the magic words for casting minor strength.");
		itemTable.put(minorStrengthScroll.getName(), minorStrengthScroll);

		MagicScroll midStrengthScroll = new MagicScroll("mid strength", 400);
		midStrengthScroll.setDescription("A magic scroll. Enscribed are the magic words for casting mid strength.");
		itemTable.put(midStrengthScroll.getName(), midStrengthScroll);

		MagicScroll majorStrengthScroll = new MagicScroll("major strength", 2000);
		majorStrengthScroll.setDescription("A magic scroll. Enscribed are the magic words for casting major strength.");
		itemTable.put(majorStrengthScroll.getName(), majorStrengthScroll);

		MagicScroll fullStrengthScroll = new MagicScroll("full strength", 0);
		fullStrengthScroll.setDescription("A magic scroll. Enscribed are the magic words for casting full strength.");
		itemTable.put(fullStrengthScroll.getName(), fullStrengthScroll);

		MagicScroll minorWeaknessScroll = new MagicScroll("minor weakness", 15);
		minorWeaknessScroll.setDescription("A magic scroll. Enscribed are the magic words for casting minor weakness.");
		itemTable.put(minorWeaknessScroll.getName(), minorWeaknessScroll);

		MagicScroll midWeaknessScroll = new MagicScroll("mid weakness", 400);
		midWeaknessScroll.setDescription("A magic scroll. Enscribed are the magic words for casting mid weakness.");
		itemTable.put(midWeaknessScroll.getName(), midWeaknessScroll);

		MagicScroll majorWeaknessScroll = new MagicScroll("major weakness", 2000);
		majorWeaknessScroll.setDescription("A magic scroll. Enscribed are the magic words for casting major weakness.");
		itemTable.put(majorWeaknessScroll.getName(), majorWeaknessScroll);

		MagicScroll fullWeaknessScroll = new MagicScroll("full weakness", 0);
		fullWeaknessScroll.setDescription("A magic scroll. Enscribed are the magic words for casting full weakness.");
		itemTable.put(fullWeaknessScroll.getName(), fullWeaknessScroll);

		MagicScroll minorShieldScroll = new MagicScroll("minor shield", 15);
		minorShieldScroll.setDescription("A magic scroll. Enscribed are the magic words for casting minor shield.");
		itemTable.put(minorShieldScroll.getName(), minorShieldScroll);

		MagicScroll midShieldScroll = new MagicScroll("mid shield", 400);
		midShieldScroll.setDescription("A magic scroll. Enscribed are the magic words for casting mid shield.");
		itemTable.put(midShieldScroll.getName(), midShieldScroll);

		MagicScroll majorShieldScroll = new MagicScroll("major shield", 2000);
		majorShieldScroll.setDescription("A magic scroll. Enscribed are the magic words for casting major shield.");
		itemTable.put(majorShieldScroll.getName(), majorShieldScroll);

		MagicScroll fullShieldScroll = new MagicScroll("full shield", 0);
		fullShieldScroll.setDescription("A magic scroll. Enscribed are the magic words for casting full shield.");
		itemTable.put(fullShieldScroll.getName(), fullShieldScroll);

		MagicScroll minorExposureScroll = new MagicScroll("minor exposure", 15);
		minorExposureScroll.setDescription("A magic scroll. Enscribed are the magic words for casting minor exposure.");
		itemTable.put(minorExposureScroll.getName(), minorExposureScroll);

		MagicScroll midExposureScroll = new MagicScroll("mid exposure", 400);
		midExposureScroll.setDescription("A magic scroll. Enscribed are the magic words for casting mid exposure.");
		itemTable.put(midExposureScroll.getName(), midExposureScroll);

		MagicScroll majorExposureScroll = new MagicScroll("major exposure", 2000);
		majorExposureScroll.setDescription("A magic scroll. Enscribed are the magic words for casting major exposure.");
		itemTable.put(majorExposureScroll.getName(), majorExposureScroll);

		MagicScroll fullExposureScroll = new MagicScroll("full exposure", 0);
		fullExposureScroll.setDescription("A magic scroll. Enscribed are the magic words for casting full exposure.");
		itemTable.put(fullExposureScroll.getName(), fullExposureScroll);

		MagicScroll minorSightScroll = new MagicScroll("minor sight", 15);
		minorSightScroll.setDescription("A magic scroll. Enscribed are the magic words for casting minor sight.");
		itemTable.put(minorSightScroll.getName(), minorSightScroll);

		MagicScroll midSightScroll = new MagicScroll("mid sight", 400);
		midSightScroll.setDescription("A magic scroll. Enscribed are the magic words for casting mid sight.");
		itemTable.put(midSightScroll.getName(), midSightScroll);

		MagicScroll majorSightScroll = new MagicScroll("major sight", 2000);
		majorSightScroll.setDescription("A magic scroll. Enscribed are the magic words for casting major sight.");
		itemTable.put(majorSightScroll.getName(), majorSightScroll);

		MagicScroll fullSightScroll = new MagicScroll("full sight", 0);
		fullSightScroll.setDescription("A magic scroll. Enscribed are the magic words for casting full sight.");
		itemTable.put(fullSightScroll.getName(), fullSightScroll);

		MagicScroll minorBlindScroll = new MagicScroll("minor blind", 15);
		minorBlindScroll.setDescription("A magic scroll. Enscribed are the magic words for casting minor blind.");
		itemTable.put(minorBlindScroll.getName(), minorBlindScroll);

		MagicScroll midBlindScroll = new MagicScroll("mid blind", 400);
		midBlindScroll.setDescription("A magic scroll. Enscribed are the magic words for casting mid blind.");
		itemTable.put(midBlindScroll.getName(), midBlindScroll);

		MagicScroll majorBlindScroll = new MagicScroll("major blind", 2000);
		majorBlindScroll.setDescription("A magic scroll. Enscribed are the magic words for casting major blind.");
		itemTable.put(majorBlindScroll.getName(), majorBlindScroll);

		MagicScroll fullBlindScroll = new MagicScroll("full blind", 0);
		fullBlindScroll.setDescription("A magic scroll. Enscribed are the magic words for casting full blind.");
		itemTable.put(fullBlindScroll.getName(), fullBlindScroll);

		MagicScroll minorAgilityScroll = new MagicScroll("minor agility", 15);
		minorAgilityScroll.setDescription("A magic scroll. Enscribed are the magic words for casting minor agility.");
		itemTable.put(minorAgilityScroll.getName(), minorAgilityScroll);

		MagicScroll midAgilityScroll = new MagicScroll("mid agility", 400);
		midAgilityScroll.setDescription("A magic scroll. Enscribed are the magic words for casting mid agility.");
		itemTable.put(midAgilityScroll.getName(), midAgilityScroll);

		MagicScroll majorAgilityScroll = new MagicScroll("major agility", 2000);
		majorAgilityScroll.setDescription("A magic scroll. Enscribed are the magic words for casting major agility.");
		itemTable.put(majorAgilityScroll.getName(), majorAgilityScroll);

		MagicScroll fullAgilityScroll = new MagicScroll("full agility", 0);
		fullAgilityScroll.setDescription("A magic scroll. Enscribed are the magic words for casting full agility.");
		itemTable.put(fullAgilityScroll.getName(), fullAgilityScroll);

		MagicScroll minorClumsinessScroll = new MagicScroll("minor paralysis", 15);
		minorClumsinessScroll.setDescription("A magic scroll. Enscribed are the magic words for casting minor paralysis.");
		itemTable.put(minorClumsinessScroll.getName(), minorClumsinessScroll);

		MagicScroll midClumsinessScroll = new MagicScroll("mid paralysis", 400);
		midClumsinessScroll.setDescription("A magic scroll. Enscribed are the magic words for casting mid paralysis.");
		itemTable.put(midClumsinessScroll.getName(), midClumsinessScroll);

		MagicScroll majorClumsinessScroll = new MagicScroll("major paralysis", 2000);
		majorClumsinessScroll.setDescription("A magic scroll. Enscribed are the magic words for casting major paralysis.");
		itemTable.put(majorClumsinessScroll.getName(), majorClumsinessScroll);

		MagicScroll fullClumsinessScroll = new MagicScroll("full paralysis", 0);
		fullClumsinessScroll.setDescription("A magic scroll. Enscribed are the magic words for casting full paralysis.");
		itemTable.put(fullClumsinessScroll.getName(), fullClumsinessScroll);

		MagicScroll minorOpeningScroll = new MagicScroll("minor opening", 15);
		minorOpeningScroll.setDescription("A magic scroll. Enscribed are the magic words for casting minor opening.");
		itemTable.put(minorOpeningScroll.getName(), minorOpeningScroll);

		MagicScroll midOpeningScroll = new MagicScroll("mid opening", 400);
		midOpeningScroll.setDescription("A magic scroll. Enscribed are the magic words for casting mid opening.");
		itemTable.put(midOpeningScroll.getName(), midOpeningScroll);

		MagicScroll majorOpeningScroll = new MagicScroll("major opening", 2000);
		majorOpeningScroll.setDescription("A magic scroll. Enscribed are the magic words for casting major opening.");
		itemTable.put(majorOpeningScroll.getName(), majorOpeningScroll);

		MagicScroll fullOpeningScroll = new MagicScroll("full opening", 0);
		fullOpeningScroll.setDescription("A magic scroll. Enscribed are the magic words for casting full opening.");
		itemTable.put(fullOpeningScroll.getName(), fullOpeningScroll);

		MagicScroll minorAccelerateScroll = new MagicScroll("minor accelerate", 15);
		minorAccelerateScroll.setDescription("A magic scroll. Enscribed are the magic words for casting minor accelerate.");
		itemTable.put(minorAccelerateScroll.getName(), minorAccelerateScroll);

		MagicScroll midAccelerateScroll = new MagicScroll("mid accelerate", 400);
		midAccelerateScroll.setDescription("A magic scroll. Enscribed are the magic words for casting mid accelerate.");
		itemTable.put(midAccelerateScroll.getName(), midAccelerateScroll);

		MagicScroll majorAccelerateScroll = new MagicScroll("major accelerate", 2000);
		majorAccelerateScroll.setDescription("A magic scroll. Enscribed are the magic words for casting major accelerate.");
		itemTable.put(majorAccelerateScroll.getName(), majorAccelerateScroll);

		MagicScroll fullAccelerateScroll = new MagicScroll("full accelerate", 0);
		fullAccelerateScroll.setDescription("A magic scroll. Enscribed are the magic words for casting full accelerate.");
		itemTable.put(fullAccelerateScroll.getName(), fullAccelerateScroll);

		MagicScroll minorBrakesScroll = new MagicScroll("minor brakes", 15);
		minorBrakesScroll.setDescription("A magic scroll. Enscribed are the magic words for casting minor brakes.");
		itemTable.put(minorBrakesScroll.getName(), minorBrakesScroll);

		MagicScroll midBrakesScroll = new MagicScroll("mid brakes", 400);
		midBrakesScroll.setDescription("A magic scroll. Enscribed are the magic words for casting mid brakes.");
		itemTable.put(midBrakesScroll.getName(), midBrakesScroll);

		MagicScroll majorBrakesScroll = new MagicScroll("major brakes", 2000);
		majorBrakesScroll.setDescription("A magic scroll. Enscribed are the magic words for casting major brakes.");
		itemTable.put(majorBrakesScroll.getName(), majorBrakesScroll);

		MagicScroll fullBrakesScroll = new MagicScroll("full brakes", 0);
		fullBrakesScroll.setDescription("A magic scroll. Enscribed are the magic words for casting full brakes.");
		itemTable.put(fullBrakesScroll.getName(), fullBrakesScroll);

		MagicScroll minorBarrierScroll = new MagicScroll("minor barrier", 15);
		minorBarrierScroll.setDescription("A magic scroll. Enscribed are the magic words for casting minor barrier.");
		itemTable.put(minorBarrierScroll.getName(), minorBarrierScroll);

		MagicScroll midBarrierScroll = new MagicScroll("mid barrier", 400);
		midBarrierScroll.setDescription("A magic scroll. Enscribed are the magic words for casting mid barrier.");
		itemTable.put(midBarrierScroll.getName(), midBarrierScroll);

		MagicScroll majorBarrierScroll = new MagicScroll("major barrier", 2000);
		majorBarrierScroll.setDescription("A magic scroll. Enscribed are the magic words for casting major barrier.");
		itemTable.put(majorBarrierScroll.getName(), majorBarrierScroll);

		MagicScroll fullBarrierScroll = new MagicScroll("full barrier", 0);
		fullBarrierScroll.setDescription("A magic scroll. Enscribed are the magic words for casting full barrier.");
		itemTable.put(fullBarrierScroll.getName(), fullBarrierScroll);

		MagicScroll minorStupidityScroll = new MagicScroll("minor stupidity", 15);
		minorStupidityScroll.setDescription("A magic scroll. Enscribed are the magic words for casting minor stupidity.");
		itemTable.put(minorStupidityScroll.getName(), minorStupidityScroll);

		MagicScroll midStupidityScroll = new MagicScroll("mid stupidity", 400);
		midStupidityScroll.setDescription("A magic scroll. Enscribed are the magic words for casting mid stupidity.");
		itemTable.put(midStupidityScroll.getName(), midStupidityScroll);

		MagicScroll majorStupidityScroll = new MagicScroll("major stupidity", 2000);
		majorStupidityScroll.setDescription("A magic scroll. Enscribed are the magic words for casting major stupidity.");
		itemTable.put(majorStupidityScroll.getName(), majorStupidityScroll);

		MagicScroll fullStupidityScroll = new MagicScroll("full stupidity", 0);
		fullStupidityScroll.setDescription("A magic scroll. Enscribed are the magic words for casting full stupidity.");
		itemTable.put(fullStupidityScroll.getName(), fullStupidityScroll);

		Weapon woodenSword = new Weapon("wooden sword", 10);
		woodenSword.setStatBonus(3, GameCharacter.ATK);
		woodenSword.setDescription("A carved sword used mainly for practice. Inflicts minimal damage.");
		itemTable.put(woodenSword.getName(), woodenSword);

		Shield woodenShield = new Shield("wooden shield", 5);
		woodenShield.setStatBonus(1, GameCharacter.DEF);
		woodenShield.setDescription("A carved shield used mainly for practice. Provides minimal guard.");
		itemTable.put(woodenShield.getName(), woodenShield);

		HeadGear bandana = new HeadGear("bandana", 5);
		bandana.setStatBonus(1, GameCharacter.DEF);
		bandana.setDescription("A plain old bandana. Provides minimal protection.");
		itemTable.put(bandana.getName(), bandana);

		BodyGear clothShirt = new BodyGear("cloth shirt", 5);
		clothShirt.setStatBonus(1, GameCharacter.DEF);
		clothShirt.setDescription("A plain old shirt. Provides minimal protection.");
		itemTable.put(clothShirt.getName(), clothShirt);

		Weapon copperSword = new Weapon("copper sword", 50);
		copperSword.setStatBonus(10, GameCharacter.ATK);
		copperSword.setDescription("A dull, crudely made sword. Inflicts a fair amount of damage.");
		itemTable.put(copperSword.getName(), copperSword);

		Shield leatherShield = new Shield("leather shield", 30);
		leatherShield.setStatBonus(2, GameCharacter.DEF);
		leatherShield.setStatBonus(-3, GameCharacter.EVA);
		leatherShield.setStatBonus(-3, GameCharacter.SPD);
		leatherShield.setDescription("A wooden shield covered with a thick monster hide. Provides a fair guard.");
		itemTable.put(leatherShield.getName(), leatherShield);

		HeadGear leatherHelmet = new HeadGear("leather helmet", 40);
		leatherHelmet.setStatBonus(4, GameCharacter.DEF);
		leatherHelmet.setStatBonus(-1, GameCharacter.EVA);
		leatherHelmet.setStatBonus(-1, GameCharacter.SPD);
		leatherHelmet.setDescription("A helmet made from a thick monster hide. Provides fair protection.");
		itemTable.put(leatherHelmet.getName(), leatherHelmet);

		BodyGear leatherArmor = new BodyGear("leather armor", 40);
		leatherArmor.setStatBonus(4, GameCharacter.DEF);
		leatherArmor.setStatBonus(-1, GameCharacter.EVA);
		leatherArmor.setStatBonus(-1, GameCharacter.SPD);
		leatherArmor.setDescription("Armor made from a thick monster hide. Provides fair protection.");
		itemTable.put(leatherArmor.getName(), leatherArmor);

		Accessory copperBracers = new Accessory("copper bracers", 40);
		copperBracers.setStatBonus(20, GameCharacter.MAX_HP);
		copperBracers.setDescription("Enchanted bracers made from copper. Provides a fair stamina boost.");
		itemTable.put(copperBracers.getName(), copperBracers);

		Weapon bronzeSword = new Weapon("bronze sword", 200);
		bronzeSword.setStatBonus(20, GameCharacter.ATK);
		bronzeSword.setDescription("A sword crafted from bronze. Inflicts a nice amount of damage.");
		itemTable.put(bronzeSword.getName(), bronzeSword);

		Shield bronzeShield = new Shield("bronze shield", 100);
		bronzeShield.setStatBonus(4, GameCharacter.DEF);
		bronzeShield.setStatBonus(-4, GameCharacter.EVA);
		bronzeShield.setStatBonus(-4, GameCharacter.SPD);
		bronzeShield.setDescription("A shield crafted from bronze. Provides a nice guard.");
		itemTable.put(bronzeShield.getName(), bronzeShield);

		HeadGear bronzeHelmet = new HeadGear("bronze helmet", 150);
		bronzeHelmet.setStatBonus(8, GameCharacter.DEF);
		bronzeHelmet.setStatBonus(-3, GameCharacter.EVA);
		bronzeHelmet.setStatBonus(-3, GameCharacter.SPD);
		bronzeHelmet.setDescription("A helmet crafted from bronze. Provides nice protection.");
		itemTable.put(bronzeHelmet.getName(), bronzeHelmet);

		BodyGear bronzeArmor = new BodyGear("bronze armor", 150);
		bronzeArmor.setStatBonus(8, GameCharacter.DEF);
		bronzeArmor.setStatBonus(-3, GameCharacter.EVA);
		bronzeArmor.setStatBonus(-3, GameCharacter.SPD);
		bronzeArmor.setDescription("Armor crafted from bronze. Provides nice protection.");
		itemTable.put(bronzeArmor.getName(), bronzeArmor);

		Accessory bronzeBracers = new Accessory("bronze bracers", 150);
		bronzeBracers.setStatBonus(40, GameCharacter.MAX_HP);
		bronzeBracers.setDescription("Enchanted bracers made of bronze. Provides a nice stamina boost.");
		itemTable.put(bronzeBracers.getName(), bronzeBracers);

		Weapon ironSword = new Weapon("iron sword", 600);
		ironSword.setStatBonus(30, GameCharacter.ATK);
		ironSword.setDescription("A sword crafted from iron. Inflicts a good amount of damage.");
		itemTable.put(ironSword.getName(), ironSword);

		Shield ironShield = new Shield("iron shield", 400);
		ironShield.setStatBonus(5, GameCharacter.DEF);
		ironShield.setStatBonus(-5, GameCharacter.EVA);
		ironShield.setStatBonus(-5, GameCharacter.SPD);
		ironShield.setDescription("A shield crafted from iron. Provides a good guard.");
		itemTable.put(ironShield.getName(), ironShield);

		HeadGear ironHelmet = new HeadGear("iron helmet", 500);
		ironHelmet.setStatBonus(12, GameCharacter.DEF);
		ironHelmet.setStatBonus(-5, GameCharacter.EVA);
		ironHelmet.setStatBonus(-5, GameCharacter.SPD);
		ironHelmet.setDescription("A helmet crafted from iron. Provides good protection.");
		itemTable.put(ironHelmet.getName(), ironHelmet);

		BodyGear ironArmor = new BodyGear("iron armor", 500);
		ironArmor.setStatBonus(13, GameCharacter.DEF);
		ironArmor.setStatBonus(-5, GameCharacter.EVA);
		ironArmor.setStatBonus(-5, GameCharacter.SPD);
		ironArmor.setDescription("Armor crafted from iron. Provides good protection.");
		itemTable.put(ironArmor.getName(), ironArmor);

		Accessory ironGauntlets = new Accessory("iron gauntlets", 500);
		ironGauntlets.setStatBonus(60, GameCharacter.MAX_HP);
		ironGauntlets.setDescription("Enchanted gauntlets made of iron. Provides a good stamina boost.");
		itemTable.put(ironGauntlets.getName(), ironGauntlets);

		Weapon steelSword = new Weapon("steel sword", 1200);
		steelSword.setStatBonus(40, GameCharacter.ATK);
		steelSword.setDescription("A sword crafted from steel. Inflicts a very good amount of damage.");
		itemTable.put(steelSword.getName(), steelSword);

		Shield steelShield = new Shield("steel shield", 800);
		steelShield.setStatBonus(8, GameCharacter.DEF);
		steelShield.setStatBonus(-8, GameCharacter.EVA);
		steelShield.setStatBonus(-8, GameCharacter.SPD);
		steelShield.setDescription("A shield crafted from steel. Provides a very good guard.");
		itemTable.put(steelShield.getName(), steelShield);

		HeadGear steelHelmet = new HeadGear("steel helmet", 1000);
		steelHelmet.setStatBonus(16, GameCharacter.DEF);
		steelHelmet.setStatBonus(-6, GameCharacter.EVA);
		steelHelmet.setStatBonus(-6, GameCharacter.SPD);
		steelHelmet.setDescription("A helmet crafted from steel. Provides very good protection.");
		itemTable.put(steelHelmet.getName(), steelHelmet);

		BodyGear steelArmor = new BodyGear("steel armor", 1000);
		steelArmor.setStatBonus(16, GameCharacter.DEF);
		steelArmor.setStatBonus(-6, GameCharacter.EVA);
		steelArmor.setStatBonus(-6, GameCharacter.SPD);
		steelArmor.setDescription("Armor crafted from steel. Provides very good protection.");
		itemTable.put(steelArmor.getName(), steelArmor);

		Accessory steelGauntlets = new Accessory("steel gauntlets", 1000);
		steelGauntlets.setStatBonus(80, GameCharacter.MAX_HP);
		steelGauntlets.setDescription("Enchanted gauntlets made of steel. Provides a very good stamina boost.");
		itemTable.put(steelGauntlets.getName(), steelGauntlets);

		Weapon silverSword = new Weapon("silver sword", 2500);
		silverSword.setStatBonus(50, GameCharacter.ATK);
		silverSword.setDescription("A silver plated, steel sword. Inflicts a great amount of damage.");
		itemTable.put(silverSword.getName(), silverSword);

		Shield silverShield = new Shield("silver shield", 1500);
		silverShield.setStatBonus(10, GameCharacter.DEF);
		silverShield.setStatBonus(-9, GameCharacter.EVA);
		silverShield.setStatBonus(-9, GameCharacter.SPD);
		silverShield.setDescription("A silver plated, steel shield. Provides a great guard.");
		itemTable.put(silverShield.getName(), silverShield);

		HeadGear silverHelmet = new HeadGear("silver helmet", 2000);
		silverHelmet.setStatBonus(20, GameCharacter.DEF);
		silverHelmet.setStatBonus(-8, GameCharacter.EVA);
		silverHelmet.setStatBonus(-8, GameCharacter.SPD);
		silverHelmet.setDescription("A silver plated, steel helmet. Provides great protection.");
		itemTable.put(silverHelmet.getName(), silverHelmet);

		BodyGear silverArmor = new BodyGear("silver armor", 2000);
		silverArmor.setStatBonus(20, GameCharacter.DEF);
		silverArmor.setStatBonus(-8, GameCharacter.EVA);
		silverArmor.setStatBonus(-8, GameCharacter.SPD);
		silverArmor.setDescription("Silver plated, steel armor. Provides great protection.");
		itemTable.put(silverArmor.getName(), silverArmor);

		Accessory silverBracers = new Accessory("silver bracers", 2000);
		silverBracers.setStatBonus(100, GameCharacter.MAX_HP);
		silverBracers.setDescription("Enchanted bracers made of silver. Provides a great stamina boost.");
		itemTable.put(silverBracers.getName(), silverBracers);

		Weapon platinumSword = new Weapon("platinum sword", 4000);
		platinumSword.setStatBonus(60, GameCharacter.ATK);
		platinumSword.setDescription("A platinum plated, steel sword. Inflicts a superb amount of damage.");
		itemTable.put(platinumSword.getName(), platinumSword);

		Shield platinumShield = new Shield("platinum shield", 2000);
		platinumShield.setStatBonus(15, GameCharacter.DEF);
		platinumShield.setStatBonus(-10, GameCharacter.EVA);
		platinumShield.setStatBonus(-10, GameCharacter.SPD);
		platinumShield.setDescription("A platinum plated, steel shield. Provides a superb guard.");
		itemTable.put(platinumShield.getName(), platinumShield);

		HeadGear platinumHelmet = new HeadGear("platinum helmet", 3000);
		platinumHelmet.setStatBonus(22, GameCharacter.DEF);
		platinumHelmet.setStatBonus(-10, GameCharacter.EVA);
		platinumHelmet.setStatBonus(-10, GameCharacter.SPD);
		platinumHelmet.setDescription("A platinum plated, steel helmet. Provides superb protection.");
		itemTable.put(platinumHelmet.getName(), platinumHelmet);

		BodyGear platinumArmor = new BodyGear("platinum armor", 3000);
		platinumArmor.setStatBonus(23, GameCharacter.DEF);
		platinumArmor.setStatBonus(-10, GameCharacter.EVA);
		platinumArmor.setStatBonus(-10, GameCharacter.SPD);
		platinumArmor.setDescription("Platinum plated, steel armor. Provides superb protection.");
		itemTable.put(platinumArmor.getName(), platinumArmor);

		Accessory platinumBracers = new Accessory("platinum bracers", 3000);
		platinumBracers.setStatBonus(120, GameCharacter.MAX_HP);
		platinumBracers.setDescription("Enchanted bracers made of platinum. Provides a superb stamina boost.");
		itemTable.put(platinumBracers.getName(), platinumBracers);

		Weapon mythrilSword = new Weapon("mythril sword", 5000);
		mythrilSword.setStatBonus(70, GameCharacter.ATK);
		mythrilSword.setDescription("A sword crafted from mythril. Inflicts a supreme amount of damage.");
		itemTable.put(mythrilSword.getName(), mythrilSword);

		Shield mythrilShield = new Shield("mythril shield", 3000);
		mythrilShield.setStatBonus(20, GameCharacter.DEF);
		mythrilShield.setStatBonus(-13, GameCharacter.EVA);
		mythrilShield.setStatBonus(-13, GameCharacter.SPD);
		mythrilShield.setDescription("A shield crafted from mythril. Provides a supreme guard.");
		itemTable.put(mythrilShield.getName(), mythrilShield);

		HeadGear mythrilHelmet = new HeadGear("mythril helmet", 4000);
		mythrilHelmet.setStatBonus(25, GameCharacter.DEF);
		mythrilHelmet.setStatBonus(-11, GameCharacter.EVA);
		mythrilHelmet.setStatBonus(-11, GameCharacter.SPD);
		mythrilHelmet.setDescription("A helmet crafted from mythril. Provides supreme protection.");
		itemTable.put(mythrilHelmet.getName(), mythrilHelmet);

		BodyGear mythrilArmor = new BodyGear("mythril armor", 4000);
		mythrilArmor.setStatBonus(25, GameCharacter.DEF);
		mythrilArmor.setStatBonus(-11, GameCharacter.EVA);
		mythrilArmor.setStatBonus(-11, GameCharacter.SPD);
		mythrilArmor.setDescription("Armor crafted from mythril. Provides supreme protection.");
		itemTable.put(mythrilArmor.getName(), mythrilArmor);

		Accessory mythrilGauntlets = new Accessory("mythril gauntlets", 4000);
		mythrilGauntlets.setStatBonus(140, GameCharacter.MAX_HP);
		mythrilGauntlets.setDescription("Enchanted gauntlets made of mythril. Provides a supreme stamina boost.");
		itemTable.put(mythrilGauntlets.getName(), mythrilGauntlets);

		Weapon dragonSlayer = new Weapon("dragon slayer", 7500);
		dragonSlayer.setStatBonus(80, GameCharacter.ATK);
		dragonSlayer.setDescription("Carved from a dragon's fang. Inflicts a maximum amount of damage.");
		itemTable.put(dragonSlayer.getName(), dragonSlayer);

		Shield dragonShield = new Shield("dragon shield", 5500);
		dragonShield.setStatBonus(23, GameCharacter.DEF);
		dragonShield.setStatBonus(-14, GameCharacter.EVA);
		dragonShield.setStatBonus(-14, GameCharacter.SPD);
		dragonShield.setDescription("A shield crafted from dragon scales. Provides a maximum guard.");
		itemTable.put(dragonShield.getName(), dragonShield);

		HeadGear dragonHelmet = new HeadGear("dragon helmet", 6500);
		dragonHelmet.setStatBonus(28, GameCharacter.DEF);
		dragonHelmet.setStatBonus(-13, GameCharacter.EVA);
		dragonHelmet.setStatBonus(-13, GameCharacter.SPD);
		dragonHelmet.setDescription("A helmet crafted from a dragon head. Provides maximum protection.");
		itemTable.put(dragonHelmet.getName(), dragonHelmet);

		BodyGear dragonArmor = new BodyGear("dragon armor", 6500);
		dragonArmor.setStatBonus(29, GameCharacter.DEF);
		dragonArmor.setStatBonus(-13, GameCharacter.EVA);
		dragonArmor.setStatBonus(-13, GameCharacter.SPD);
		dragonArmor.setDescription("Armor crafted from dragon scales. Provides maximum protection.");
		itemTable.put(dragonArmor.getName(), dragonArmor);

		Accessory dragonGauntlets = new Accessory("dragon gauntlets", 6500);
		dragonGauntlets.setStatBonus(160, GameCharacter.MAX_HP);
		dragonGauntlets.setDescription("Enchanted gauntlets made of dragon scales. Provides a maximum stamina boost.");
		itemTable.put(dragonGauntlets.getName(), dragonGauntlets);

		Weapon excalibur = new Weapon("Excalibur", 0);
		excalibur.setStatBonus(100, GameCharacter.ATK);
		excalibur.setDescription("The legendary sword itself. Inflicts a legendary amount of damage.");
		itemTable.put(excalibur.getName(), excalibur);

		Shield arthurShield = new Shield("Arthur's shield", 0);
		arthurShield.setStatBonus(30, GameCharacter.DEF);
		arthurShield.setStatBonus(-18, GameCharacter.EVA);
		arthurShield.setStatBonus(-18, GameCharacter.SPD);
		arthurShield.setDescription("A shield fit for a king. Provides a legendary guard.");
		itemTable.put(arthurShield.getName(), arthurShield);

		HeadGear arthurHelmet = new HeadGear("Arthur's helmet", 0);
		arthurHelmet.setStatBonus(35, GameCharacter.DEF);
		arthurHelmet.setStatBonus(-16, GameCharacter.EVA);
		arthurHelmet.setStatBonus(-16, GameCharacter.SPD);
		arthurHelmet.setDescription("A helmet fit for a king. Provides legendary protection.");
		itemTable.put(arthurHelmet.getName(), arthurHelmet);

		BodyGear arthurArmor = new BodyGear("Arthur's armor", 0);
		arthurArmor.setStatBonus(35, GameCharacter.DEF);
		arthurArmor.setStatBonus(-16, GameCharacter.EVA);
		arthurArmor.setStatBonus(-16, GameCharacter.SPD);
		arthurArmor.setDescription("Armor fit for a king. Provides legendary protection.");
		itemTable.put(arthurArmor.getName(), arthurArmor);

		Accessory arthurGauntlets = new Accessory("Arthur's gauntlets", 0);
		arthurGauntlets.setStatBonus(200, GameCharacter.MAX_HP);
		arthurGauntlets.setDescription("Enchanted gauntlets fit for a king. Provides a legendary stamina boost.");
		itemTable.put(arthurGauntlets.getName(), arthurGauntlets);

		Weapon walkingStick = new Weapon("walking stick", 15);
		walkingStick.setStatBonus(5, GameCharacter.ATK);
		walkingStick.setStatBonus(5, GameCharacter.WIS);
		walkingStick.setDescription("A common walking stick. Provides a fair wisdom boost");
		itemTable.put(walkingStick.getName(), walkingStick);

		HeadGear furHood = new HeadGear("fur hood", 10);
		furHood.setStatBonus(2, GameCharacter.DEF);
		furHood.setStatBonus(3, GameCharacter.MDEF);
		furHood.setDescription("A hood made from monster fur. Provides a fair magic barrier");
		itemTable.put(furHood.getName(), furHood);

		BodyGear furRobe = new BodyGear("fur robe", 10);
		furRobe.setStatBonus(3, GameCharacter.DEF);
		furRobe.setStatBonus(2, GameCharacter.MDEF);
		furRobe.setDescription("A robe made from monster fur. Provides a fair magic barrier");
		itemTable.put(furRobe.getName(), furRobe);

		Accessory magicRing = new Accessory("magic ring", 15);
		magicRing.setStatBonus(10, GameCharacter.MAX_MP);
		magicRing.setDescription("A simple enchanted ring. Provides a fair mana boost");
		itemTable.put(magicRing.getName(), magicRing);

		Weapon noviceStaff = new Weapon("novice staff", 125);
		noviceStaff.setStatBonus(10, GameCharacter.ATK);
		noviceStaff.setStatBonus(10, GameCharacter.WIS);
		noviceStaff.setDescription("The staff of a novice mage. Provides a nice wisdom boost");
		itemTable.put(noviceStaff.getName(), noviceStaff);

		HeadGear noviceHood = new HeadGear("novice hood", 90);
		noviceHood.setStatBonus(5, GameCharacter.DEF);
		noviceHood.setStatBonus(5, GameCharacter.MDEF);
		noviceHood.setDescription("The hood of a novice mage. Provides a nice magic barrier");
		itemTable.put(noviceHood.getName(), noviceHood);

		BodyGear noviceRobe = new BodyGear("novice robe", 90);
		noviceRobe.setStatBonus(5, GameCharacter.DEF);
		noviceRobe.setStatBonus(5, GameCharacter.MDEF);
		noviceRobe.setDescription("The robe of a novice mage. Provides a nice magic barrier");
		itemTable.put(noviceRobe.getName(), noviceRobe);

		Accessory noviceRing = new Accessory("novice ring", 120);
		noviceRing.setStatBonus(20, GameCharacter.MAX_MP);
		noviceRing.setDescription("The ring of a novice mage. Provides a nice mana boost");
		itemTable.put(noviceRing.getName(), noviceRing);

		Weapon apprenticeStaff = new Weapon("apprentice staff", 375);
		apprenticeStaff.setStatBonus(15, GameCharacter.ATK);
		apprenticeStaff.setStatBonus(15, GameCharacter.WIS);
		apprenticeStaff.setDescription("The staff of an apprentice mage. Provides a good wisdom boost");
		itemTable.put(apprenticeStaff.getName(), apprenticeStaff);

		HeadGear apprenticeHood = new HeadGear("apprentice hood", 275);
		apprenticeHood.setStatBonus(7, GameCharacter.DEF);
		apprenticeHood.setStatBonus(8, GameCharacter.MDEF);
		apprenticeHood.setDescription("The hood of an apprentice mage. Provides a good magic barrier");
		itemTable.put(apprenticeHood.getName(), apprenticeHood);

		BodyGear apprenticeRobe = new BodyGear("apprentice robe", 275);
		apprenticeRobe.setStatBonus(8, GameCharacter.DEF);
		apprenticeRobe.setStatBonus(7, GameCharacter.MDEF);
		apprenticeRobe.setDescription("The robe of an apprentice mage. Provides a good magic barrier");
		itemTable.put(apprenticeRobe.getName(), apprenticeRobe);

		Accessory apprenticeRing = new Accessory("apprentice ring", 350);
		apprenticeRing.setStatBonus(30, GameCharacter.MAX_MP);
		apprenticeRing.setDescription("The ring of an apprentice mage. Provides a good mana boost");
		itemTable.put(apprenticeRing.getName(), apprenticeRing);

		Weapon journeymanStaff = new Weapon("journeyman staff", 750);
		journeymanStaff.setStatBonus(20, GameCharacter.ATK);
		journeymanStaff.setStatBonus(20, GameCharacter.WIS);
		journeymanStaff.setDescription("The staff of a journeyman mage. Provides a very good wisdom boost");
		itemTable.put(journeymanStaff.getName(), journeymanStaff);

		HeadGear journeymanHat = new HeadGear("journeyman hat", 550);
		journeymanHat.setStatBonus(10, GameCharacter.DEF);
		journeymanHat.setStatBonus(10, GameCharacter.MDEF);
		journeymanHat.setDescription("The hat of a journeyman mage. Provides a very good magic barrier");
		itemTable.put(journeymanHat.getName(), journeymanHat);

		BodyGear journeymanRobe = new BodyGear("journeyman robe", 550);
		journeymanRobe.setStatBonus(10, GameCharacter.DEF);
		journeymanRobe.setStatBonus(10, GameCharacter.MDEF);
		journeymanRobe.setDescription("The robe of a journeyman mage. Provides a very good magic barrier");
		itemTable.put(journeymanRobe.getName(), journeymanRobe);

		Accessory journeymanRing = new Accessory("journeyman ring", 700);
		journeymanRing.setStatBonus(40, GameCharacter.MAX_MP);
		journeymanRing.setDescription("The ring of a journeyman mage. Provides a very good mana boost");
		itemTable.put(journeymanRing.getName(), journeymanRing);

		Weapon masterStaff = new Weapon("master staff", 1050);
		masterStaff.setStatBonus(25, GameCharacter.ATK);
		masterStaff.setStatBonus(25, GameCharacter.WIS);
		masterStaff.setDescription("The staff of a master mage. Provides a great wisdom boost");
		itemTable.put(masterStaff.getName(), masterStaff);

		HeadGear masterHat = new HeadGear("master hat", 850);
		masterHat.setStatBonus(12, GameCharacter.DEF);
		masterHat.setStatBonus(13, GameCharacter.MDEF);
		masterHat.setDescription("The hat of a master mage. Provides a great magic barrier");
		itemTable.put(masterHat.getName(), masterHat);

		BodyGear masterRobe = new BodyGear("master robe", 850);
		masterRobe.setStatBonus(13, GameCharacter.DEF);
		masterRobe.setStatBonus(12, GameCharacter.MDEF);
		masterRobe.setDescription("The robe of a master mage. Provides a great magic barrier");
		itemTable.put(masterRobe.getName(), masterRobe);

		Accessory masterRing = new Accessory("master ring", 1000);
		masterRing.setStatBonus(50, GameCharacter.MAX_MP);
		masterRing.setDescription("The ring of a master mage. Provides a great mana boost");
		itemTable.put(masterRing.getName(), masterRing);

		Weapon hermitStaff = new Weapon("hermit staff", 2100);
		hermitStaff.setStatBonus(30, GameCharacter.ATK);
		hermitStaff.setStatBonus(30, GameCharacter.WIS);
		hermitStaff.setDescription("The staff of a hermit mage. Provides a superb wisdom boost");
		itemTable.put(hermitStaff.getName(), hermitStaff);

		HeadGear hermitHood = new HeadGear("hermit hood", 1700);
		hermitHood.setStatBonus(15, GameCharacter.DEF);
		hermitHood.setStatBonus(15, GameCharacter.MDEF);
		hermitHood.setDescription("The hood of a hermit mage. Provides a superb magic barrier");
		itemTable.put(hermitHood.getName(), hermitHood);

		BodyGear hermitRobe = new BodyGear("hermit robe", 1700);
		hermitRobe.setStatBonus(15, GameCharacter.DEF);
		hermitRobe.setStatBonus(15, GameCharacter.MDEF);
		hermitRobe.setDescription("The robe of a hermit mage. Provides a superb magic barrier");
		itemTable.put(hermitRobe.getName(), hermitRobe);

		Accessory hermitRing = new Accessory("hermit ring", 2000);
		hermitRing.setStatBonus(60, GameCharacter.MAX_MP);
		hermitRing.setDescription("The ring of a hermit mage. Provides a superb mana boost");
		itemTable.put(hermitRing.getName(), hermitRing);

		Weapon wizardStaff = new Weapon("wizard staff", 3650);
		wizardStaff.setStatBonus(35, GameCharacter.ATK);
		wizardStaff.setStatBonus(35, GameCharacter.WIS);
		wizardStaff.setDescription("The staff of a powerful wizard. Provides a supreme wisdom boost");
		itemTable.put(wizardStaff.getName(), wizardStaff);

		HeadGear wizardHat = new HeadGear("wizard hat", 3300);
		wizardHat.setStatBonus(17, GameCharacter.DEF);
		wizardHat.setStatBonus(18, GameCharacter.MDEF);
		wizardHat.setDescription("The hat of a powerful wizard. Provides a supreme magic barrier");
		itemTable.put(wizardHat.getName(), wizardHat);

		BodyGear wizardRobe = new BodyGear("wizard robe", 3300);
		wizardRobe.setStatBonus(18, GameCharacter.DEF);
		wizardRobe.setStatBonus(17, GameCharacter.MDEF);
		wizardRobe.setDescription("The robe of a powerful wizard. Provides a supreme magic barrier");
		itemTable.put(wizardRobe.getName(), wizardRobe);

		Accessory wizardRing = new Accessory("wizard ring", 3500);
		wizardRing.setStatBonus(70, GameCharacter.MAX_MP);
		wizardRing.setDescription("The ring of a powerful wizard. Provides a supreme mana boost");
		itemTable.put(wizardRing.getName(), wizardRing);

		Weapon dragonStaff = new Weapon("dragon staff", 7000);
		dragonStaff.setStatBonus(40, GameCharacter.ATK);
		dragonStaff.setStatBonus(40, GameCharacter.WIS);
		dragonStaff.setDescription("A staff carved from dragon bone. Provides a maximum wisdom boost");
		itemTable.put(dragonStaff.getName(), dragonStaff);

		HeadGear dragonHood = new HeadGear("dragon hood", 6500);
		dragonHood.setStatBonus(20, GameCharacter.DEF);
		dragonHood.setStatBonus(20, GameCharacter.MDEF);
		dragonHood.setDescription("A hood made of dragon scales. Provides a maximum magic barrier");
		itemTable.put(dragonHood.getName(), dragonHood);

		BodyGear dragonRobe = new BodyGear("dragon robe", 6500);
		dragonRobe.setStatBonus(20, GameCharacter.DEF);
		dragonRobe.setStatBonus(20, GameCharacter.MDEF);
		dragonRobe.setDescription("A robe made of dragon scales. Provides a maximum magic barrier");
		itemTable.put(dragonRobe.getName(), dragonRobe);

		Accessory dragonRing = new Accessory("dragon ring", 6750);
		dragonRing.setStatBonus(80, GameCharacter.MAX_MP);
		dragonRing.setDescription("A ring carved from dragon bone. Provides a maximum mana boost");
		itemTable.put(dragonRing.getName(), dragonRing);

		Weapon merlinStaff = new Weapon("Merlin's staff", 0);
		merlinStaff.setStatBonus(50, GameCharacter.ATK);
		merlinStaff.setStatBonus(50, GameCharacter.WIS);
		merlinStaff.setDescription("The staff of the legendary sorcerer himself. Provides a legendary wisdom boost");
		itemTable.put(merlinStaff.getName(), merlinStaff);

		HeadGear merlinHat = new HeadGear("Merlin's hat", 0);
		merlinHat.setStatBonus(25, GameCharacter.DEF);
		merlinHat.setStatBonus(25, GameCharacter.MDEF);
		merlinHat.setDescription("The hat of the legendary sorcerer himself. Provides a legendary magic barrier");
		itemTable.put(merlinHat.getName(), merlinHat);

		BodyGear merlinRobe = new BodyGear("Merlin's robe", 0);
		merlinRobe.setStatBonus(25, GameCharacter.DEF);
		merlinRobe.setStatBonus(25, GameCharacter.MDEF);
		merlinRobe.setDescription("The robe of the legendary sorcerer himself. Provides a legendary magic barrier");
		itemTable.put(merlinRobe.getName(), merlinRobe);

		Accessory merlinRing = new Accessory("Merlin's ring", 0);
		merlinRing.setStatBonus(100, GameCharacter.MAX_MP);
		merlinRing.setDescription("The ring of the legendary sorcerer himself. Provides a legendary mana boost");
		itemTable.put(merlinRing.getName(), merlinRing);

		Weapon copperDagger = new Weapon("copper dagger", 40);
		copperDagger.setStatBonus(5, GameCharacter.ATK);
		copperDagger.setStatBonus(5, GameCharacter.ACC);
		copperDagger.setDescription("A dull, crudely made dagger. It's fairly accurate.");
		itemTable.put(copperDagger.getName(), copperDagger);

		HeadGear leatherCap = new HeadGear("leather cap", 35);
		leatherCap.setStatBonus(2, GameCharacter.DEF);
		leatherCap.setStatBonus(3, GameCharacter.EVA);
		leatherCap.setDescription("A cap made from a thick monster hide. Provides fair mobility.");
		itemTable.put(leatherCap.getName(), leatherCap);

		BodyGear leatherTunic = new BodyGear("leather tunic", 35);
		leatherTunic.setStatBonus(3, GameCharacter.DEF);
		leatherTunic.setStatBonus(2, GameCharacter.EVA);
		leatherTunic.setDescription("A tunic made from a thick monster hide. Provides fair mobility.");
		itemTable.put(leatherTunic.getName(), leatherTunic);

		Accessory leatherBoots = new Accessory("leather boots", 40);
		leatherBoots.setStatBonus(5, GameCharacter.SPD);
		leatherBoots.setDescription("Boots made from a thick monster hide. Provides fair speed.");
		itemTable.put(leatherBoots.getName(), leatherBoots);

		Weapon bronzeKnife = new Weapon("bronze knife", 150);
		bronzeKnife.setStatBonus(10, GameCharacter.ATK);
		bronzeKnife.setStatBonus(10, GameCharacter.ACC);
		bronzeKnife.setDescription("A knife crafted from bronze. It has nice accuracy.");
		itemTable.put(bronzeKnife.getName(), bronzeKnife);

		HeadGear banditBandana = new HeadGear("bandit bandana", 150);
		banditBandana.setStatBonus(5, GameCharacter.DEF);
		banditBandana.setStatBonus(5, GameCharacter.EVA);
		banditBandana.setDescription("A bandana worn by a common bandit. Provides nice mobility.");
		itemTable.put(banditBandana.getName(), banditBandana);

		BodyGear banditTunic = new BodyGear("bandit tunic", 150);
		banditTunic.setStatBonus(5, GameCharacter.DEF);
		banditTunic.setStatBonus(5, GameCharacter.EVA);
		banditTunic.setDescription("A tunic worn by a common bandit. Provides nice mobility.");
		itemTable.put(banditTunic.getName(), banditTunic);

		Accessory banditShoes = new Accessory("bandit shoes", 150);
		banditShoes.setStatBonus(10, GameCharacter.SPD);
		banditShoes.setDescription("Shoes worn by a common bandit. Provides nice speed.");
		itemTable.put(banditShoes.getName(), banditShoes);

		Weapon ironDagger = new Weapon("iron dagger", 475);
		ironDagger.setStatBonus(15, GameCharacter.ATK);
		ironDagger.setStatBonus(15, GameCharacter.ACC);
		ironDagger.setDescription("A dagger crafted from iron. It's pretty accurate.");
		itemTable.put(ironDagger.getName(), ironDagger);

		HeadGear robberMask = new HeadGear("robber mask", 475);
		robberMask.setStatBonus(7, GameCharacter.DEF);
		robberMask.setStatBonus(8, GameCharacter.EVA);
		robberMask.setDescription("A mask worn by a masked robber. Provides good mobility.");
		itemTable.put(robberMask.getName(), robberMask);

		BodyGear robberTunic = new BodyGear("robber tunic", 475);
		robberTunic.setStatBonus(8, GameCharacter.DEF);
		robberTunic.setStatBonus(7, GameCharacter.EVA);
		robberTunic.setDescription("A tunic worn by a masked robber. Provides good mobility.");
		itemTable.put(robberTunic.getName(), robberTunic);

		Accessory robberBoots = new Accessory("robber boots", 475);
		robberBoots.setStatBonus(15, GameCharacter.SPD);
		robberBoots.setDescription("Boots worn by a masked robber. Provides good speed.");
		itemTable.put(robberBoots.getName(), robberBoots);

		Weapon steelDagger = new Weapon("steel dagger", 950);
		steelDagger.setStatBonus(20, GameCharacter.ATK);
		steelDagger.setStatBonus(20, GameCharacter.ACC);
		steelDagger.setDescription("A dagger crafted from steel. It's very accurate.");
		itemTable.put(steelDagger.getName(), steelDagger);

		HeadGear burglarMask = new HeadGear("burglar mask", 950);
		burglarMask.setStatBonus(10, GameCharacter.DEF);
		burglarMask.setStatBonus(10, GameCharacter.EVA);
		burglarMask.setDescription("A mask worn by a cat burglar. Provides very good mobility.");
		itemTable.put(burglarMask.getName(), burglarMask);

		BodyGear burglarTunic = new BodyGear("burglar tunic", 950);
		burglarTunic.setStatBonus(10, GameCharacter.DEF);
		burglarTunic.setStatBonus(10, GameCharacter.EVA);
		burglarTunic.setDescription("A tunic worn by a cat burglar. Provides very good mobility.");
		itemTable.put(burglarTunic.getName(), burglarTunic);

		Accessory burglarShoes = new Accessory("burglar shoes", 950);
		burglarShoes.setStatBonus(20, GameCharacter.SPD);
		burglarShoes.setDescription("Shoes worn by a cat burglar. Provides very good speed.");
		itemTable.put(burglarShoes.getName(), burglarShoes);

		Weapon thiefDagger = new Weapon("thief dagger", 1725);
		thiefDagger.setStatBonus(25, GameCharacter.ATK);
		thiefDagger.setStatBonus(25, GameCharacter.ACC);
		thiefDagger.setDescription("The dagger of a master thief. It's greatly accurate.");
		itemTable.put(thiefDagger.getName(), thiefDagger);

		HeadGear thiefCap = new HeadGear("thief cap", 1750);
		thiefCap.setStatBonus(12, GameCharacter.DEF);
		thiefCap.setStatBonus(13, GameCharacter.EVA);
		thiefCap.setDescription("A cap worn by a master thief. Provides great mobility.");
		itemTable.put(thiefCap.getName(), thiefCap);

		BodyGear thiefTunic = new BodyGear("thief tunic", 1750);
		thiefTunic.setStatBonus(13, GameCharacter.DEF);
		thiefTunic.setStatBonus(12, GameCharacter.EVA);
		thiefTunic.setDescription("A tunic worn by a master thief. Provides great mobility.");
		itemTable.put(thiefTunic.getName(), thiefTunic);

		Accessory thiefBoots = new Accessory("thief boots", 1750);
		thiefBoots.setStatBonus(25, GameCharacter.SPD);
		thiefBoots.setDescription("Boots worn by a master thief. Provides great speed.");
		itemTable.put(thiefBoots.getName(), thiefBoots);

		Weapon huntingBow = new Weapon("hunting bow", 2850);
		huntingBow.setStatBonus(30, GameCharacter.ATK);
		huntingBow.setStatBonus(30, GameCharacter.ACC);
		huntingBow.setDescription("The bow of a master hunter. It's superbly accurate.");
		itemTable.put(huntingBow.getName(), huntingBow);

		HeadGear huntingCap = new HeadGear("hunting cap", 2850);
		huntingCap.setStatBonus(15, GameCharacter.DEF);
		huntingCap.setStatBonus(15, GameCharacter.EVA);
		huntingCap.setDescription("A cap worn by a master hunter. Provides superb mobility.");
		itemTable.put(huntingCap.getName(), huntingCap);

		BodyGear huntingVest = new BodyGear("hunting vest", 2850);
		huntingVest.setStatBonus(15, GameCharacter.DEF);
		huntingVest.setStatBonus(15, GameCharacter.EVA);
		huntingVest.setDescription("A vest worn by a master hunter. Provides superb mobility.");
		itemTable.put(huntingVest.getName(), huntingVest);

		Accessory huntingBoots = new Accessory("hunting boots", 2850);
		huntingBoots.setStatBonus(30, GameCharacter.SPD);
		huntingBoots.setDescription("Boots worn by a master hunter. Provides superb speed.");
		itemTable.put(huntingBoots.getName(), huntingBoots);

		Weapon katana = new Weapon("katana", 4000);
		katana.setStatBonus(35, GameCharacter.ATK);
		katana.setStatBonus(35, GameCharacter.ACC);
		katana.setDescription("The katana of a master ninja. It's supremely accurate.");
		itemTable.put(katana.getName(), katana);

		HeadGear ninjaMask = new HeadGear("ninja mask", 4000);
		ninjaMask.setStatBonus(17, GameCharacter.DEF);
		ninjaMask.setStatBonus(18, GameCharacter.EVA);
		ninjaMask.setDescription("A mask worn by a master ninja. Provides supreme mobility.");
		itemTable.put(ninjaMask.getName(), ninjaMask);

		BodyGear ninjaGi = new BodyGear("ninja gi", 4000);
		ninjaGi.setStatBonus(18, GameCharacter.DEF);
		ninjaGi.setStatBonus(17, GameCharacter.EVA);
		ninjaGi.setDescription("A gi worn by a master ninja. Provides supreme mobility.");
		itemTable.put(ninjaGi.getName(), ninjaGi);

		Accessory ninjaSoles = new Accessory("ninja soles", 4000);
		ninjaSoles.setStatBonus(35, GameCharacter.SPD);
		ninjaSoles.setDescription("Soles worn by a master ninja. Provides supreme speed.");
		itemTable.put(ninjaSoles.getName(), ninjaSoles);

		Weapon dragonFang = new Weapon("dragon fang", 6500);
		dragonFang.setStatBonus(40, GameCharacter.ATK);
		dragonFang.setStatBonus(40, GameCharacter.ACC);
		dragonFang.setDescription("A dragon fang used like a dagger. It has maximum accuracy.");
		itemTable.put(dragonFang.getName(), dragonFang);

		HeadGear dragonMask = new HeadGear("dragon mask", 6500);
		dragonMask.setStatBonus(20, GameCharacter.DEF);
		dragonMask.setStatBonus(20, GameCharacter.EVA);
		dragonMask.setDescription("A mask crafted from a dragon head. Provides maximum mobility.");
		itemTable.put(dragonMask.getName(), dragonMask);

		BodyGear dragonGi = new BodyGear("dragon gi", 6500);
		dragonGi.setStatBonus(20, GameCharacter.DEF);
		dragonGi.setStatBonus(20, GameCharacter.EVA);
		dragonGi.setDescription("A ninja gi crafted from dragon skin. Provides maximum mobility.");
		itemTable.put(dragonGi.getName(), dragonGi);

		Accessory dragonSoles = new Accessory("dragon soles", 6500);
		dragonSoles.setStatBonus(40, GameCharacter.SPD);
		dragonSoles.setDescription("Ninja soles fitted with dragon claws. Provides maximum speed.");
		itemTable.put(dragonSoles.getName(), dragonSoles);

		Weapon robinBow = new Weapon("Robin's bow", 0);
		robinBow.setStatBonus(50, GameCharacter.ATK);
		robinBow.setStatBonus(50, GameCharacter.ACC);
		robinBow.setDescription("The bow of the prince of thieves. It has lengendary accuracy.");
		itemTable.put(robinBow.getName(), robinBow);

		HeadGear robinHood = new HeadGear("Robin's hood", 0);
		robinHood.setStatBonus(25, GameCharacter.DEF);
		robinHood.setStatBonus(25, GameCharacter.EVA);
		robinHood.setDescription("The cap of the prince of thieves. Provides lengendary mobility.");
		itemTable.put(robinHood.getName(), robinHood);

		BodyGear robinTunic = new BodyGear("Robin's tunic", 0);
		robinTunic.setStatBonus(25, GameCharacter.DEF);
		robinTunic.setStatBonus(25, GameCharacter.EVA);
		robinTunic.setDescription("The tunic of the prince of thieves. Provides lengendary mobility.");
		itemTable.put(robinTunic.getName(), robinTunic);

		Accessory robinBoots = new Accessory("Robin's boots", 0);
		robinBoots.setStatBonus(50, GameCharacter.SPD);
		robinBoots.setDescription("The boots of the prince of thieves. Provides lengendary speed.");
		itemTable.put(robinBoots.getName(), robinBoots);
	}

	/*
	METHOD: getItem(String)
	PURPOSE: Uses the specified string to look up an item in the hash table and then
	returns the appropriate item.
	*/
	public Item getItem(String itemName)
	{
		return (Item) itemTable.get(itemName);
	}

	/*
	METHOD: getRandomItem(int)
	PURPOSE: Takes a random item from the hash table and returns it. The possibilities of
	items returned are based on the dungeon level specified.
	*/
	public Item getRandomItem(int dungeonLevel)
	{
		Item item = new Item();
		int random = (int) (Math.random() * 100);

		if(dungeonLevel >= 1 && dungeonLevel <= 5)
		{
			if(random >= 0 && random < 15) item = (Item) itemTable.get("herb");
			else if(random >= 15 && random < 30) item = (Item) itemTable.get("potion");
			else if(random >= 30 && random < 44) item = (Item) itemTable.get("warp scroll");
			else if(random >= 44 && random < 46) item = (Item) itemTable.get("minor heal");
			else if(random >= 46 && random < 48) item = (Item) itemTable.get("minor blast");
			else if(random >= 48 && random < 50) item = (Item) itemTable.get("minor strength");
			else if(random >= 50 && random < 52) item = (Item) itemTable.get("minor weakness");
			else if(random >= 52 && random < 54) item = (Item) itemTable.get("minor exposure");
			else if(random >= 54 && random < 56) item = (Item) itemTable.get("minor sight");
			else if(random >= 56 && random < 58) item = (Item) itemTable.get("minor blind");
			else if(random >= 58 && random < 60) item = (Item) itemTable.get("minor agility");
			else if(random >= 60 && random < 62) item = (Item) itemTable.get("minor paralysis");
			else if(random >= 62 && random < 64) item = (Item) itemTable.get("minor opening");
			else if(random >= 64 && random < 66) item = (Item) itemTable.get("minor accelerate");
			else if(random >= 66 && random < 68) item = (Item) itemTable.get("minor brakes");
			else if(random >= 68 && random < 70) item = (Item) itemTable.get("minor shield");
			else if(random >= 70 && random < 72) item = (Item) itemTable.get("minor barrier");
			else if(random >= 72 && random < 74) item = (Item) itemTable.get("minor stupidity");
			else if(random >= 74 && random < 76) item = (Item) itemTable.get("copper sword");
			else if(random >= 76 && random < 78) item = (Item) itemTable.get("leather shield");
			else if(random >= 78 && random < 80) item = (Item) itemTable.get("leather helmet");
			else if(random >= 80 && random < 82) item = (Item) itemTable.get("leather armor");
			else if(random >= 82 && random < 84) item = (Item) itemTable.get("copper bracers");
			else if(random >= 84 && random < 86) item = (Item) itemTable.get("walking stick");
			else if(random >= 86 && random < 88) item = (Item) itemTable.get("fur hood");
			else if(random >= 88 && random < 90) item = (Item) itemTable.get("fur robe");
			else if(random >= 90 && random < 92) item = (Item) itemTable.get("magic ring");
			else if(random >= 92 && random < 94) item = (Item) itemTable.get("copper dagger");
			else if(random >= 94 && random < 96) item = (Item) itemTable.get("leather cap");
			else if(random >= 96 && random < 98) item = (Item) itemTable.get("leather tunic");
			else if(random >= 98 && random < 100) item = (Item) itemTable.get("leather boots");
		}
		else if(dungeonLevel >= 6 && dungeonLevel <= 10)
		{
			if(random >= 0 && random < 22) item = (Item) itemTable.get("herb");
			else if(random >= 22 && random < 44) item = (Item) itemTable.get("potion");
			else if(random >= 44 && random < 46) item = (Item) itemTable.get("minor heal");
			else if(random >= 46 && random < 48) item = (Item) itemTable.get("minor blast");
			else if(random >= 48 && random < 50) item = (Item) itemTable.get("minor strength");
			else if(random >= 50 && random < 52) item = (Item) itemTable.get("minor weakness");
			else if(random >= 52 && random < 54) item = (Item) itemTable.get("minor exposure");
			else if(random >= 54 && random < 56) item = (Item) itemTable.get("minor sight");
			else if(random >= 56 && random < 58) item = (Item) itemTable.get("minor blind");
			else if(random >= 58 && random < 60) item = (Item) itemTable.get("minor agility");
			else if(random >= 60 && random < 62) item = (Item) itemTable.get("minor paralysis");
			else if(random >= 62 && random < 64) item = (Item) itemTable.get("minor opening");
			else if(random >= 64 && random < 66) item = (Item) itemTable.get("minor accelerate");
			else if(random >= 66 && random < 68) item = (Item) itemTable.get("minor brakes");
			else if(random >= 68 && random < 70) item = (Item) itemTable.get("minor shield");
			else if(random >= 70 && random < 72) item = (Item) itemTable.get("minor barrier");
			else if(random >= 72 && random < 74) item = (Item) itemTable.get("minor stupidity");
			else if(random >= 74 && random < 76) item = (Item) itemTable.get("bronze sword");
			else if(random >= 76 && random < 78) item = (Item) itemTable.get("bronze shield");
			else if(random >= 78 && random < 80) item = (Item) itemTable.get("bronze helmet");
			else if(random >= 80 && random < 82) item = (Item) itemTable.get("bronze armor");
			else if(random >= 82 && random < 84) item = (Item) itemTable.get("bronze bracers");
			else if(random >= 84 && random < 86) item = (Item) itemTable.get("novice staff");
			else if(random >= 86 && random < 88) item = (Item) itemTable.get("novice hood");
			else if(random >= 88 && random < 90) item = (Item) itemTable.get("novice robe");
			else if(random >= 90 && random < 92) item = (Item) itemTable.get("novice ring");
			else if(random >= 92 && random < 94) item = (Item) itemTable.get("bronze knife");
			else if(random >= 94 && random < 96) item = (Item) itemTable.get("bandit bandana");
			else if(random >= 96 && random < 98) item = (Item) itemTable.get("bandit tunic");
			else if(random >= 98 && random < 100) item = (Item) itemTable.get("bandit shoes");
		}
		else if(dungeonLevel >= 11 && dungeonLevel <= 15)
		{
			if(random >= 0 && random < 15) item = (Item) itemTable.get("herb");
			else if(random >= 15 && random < 30) item = (Item) itemTable.get("potion");
			else if(random >= 30 && random < 44) item = (Item) itemTable.get("warp scroll");
			else if(random >= 44 && random < 46) item = (Item) itemTable.get("mid heal");
			else if(random >= 46 && random < 48) item = (Item) itemTable.get("mid blast");
			else if(random >= 48 && random < 50) item = (Item) itemTable.get("mid strength");
			else if(random >= 50 && random < 52) item = (Item) itemTable.get("mid weakness");
			else if(random >= 52 && random < 54) item = (Item) itemTable.get("mid exposure");
			else if(random >= 54 && random < 56) item = (Item) itemTable.get("mid sight");
			else if(random >= 56 && random < 58) item = (Item) itemTable.get("mid blind");
			else if(random >= 58 && random < 60) item = (Item) itemTable.get("mid agility");
			else if(random >= 60 && random < 62) item = (Item) itemTable.get("mid paralysis");
			else if(random >= 62 && random < 64) item = (Item) itemTable.get("mid opening");
			else if(random >= 64 && random < 66) item = (Item) itemTable.get("mid accelerate");
			else if(random >= 66 && random < 68) item = (Item) itemTable.get("mid brakes");
			else if(random >= 68 && random < 70) item = (Item) itemTable.get("mid shield");
			else if(random >= 70 && random < 72) item = (Item) itemTable.get("mid barrier");
			else if(random >= 72 && random < 74) item = (Item) itemTable.get("mid stupidity");
			else if(random >= 74 && random < 76) item = (Item) itemTable.get("iron sword");
			else if(random >= 76 && random < 78) item = (Item) itemTable.get("iron shield");
			else if(random >= 78 && random < 80) item = (Item) itemTable.get("iron helmet");
			else if(random >= 80 && random < 82) item = (Item) itemTable.get("iron armor");
			else if(random >= 82 && random < 84) item = (Item) itemTable.get("iron gauntlets");
			else if(random >= 84 && random < 86) item = (Item) itemTable.get("apprentice staff");
			else if(random >= 86 && random < 88) item = (Item) itemTable.get("apprentice hood");
			else if(random >= 88 && random < 90) item = (Item) itemTable.get("apprentice robe");
			else if(random >= 90 && random < 92) item = (Item) itemTable.get("apprentice ring");
			else if(random >= 92 && random < 94) item = (Item) itemTable.get("iron dagger");
			else if(random >= 94 && random < 96) item = (Item) itemTable.get("robber mask");
			else if(random >= 96 && random < 98) item = (Item) itemTable.get("robber tunic");
			else if(random >= 98 && random < 100) item = (Item) itemTable.get("robber boots");
		}
		else if(dungeonLevel >= 16 && dungeonLevel <= 20)
		{
			if(random >= 0 && random < 15) item = (Item) itemTable.get("strong herb");
			else if(random >= 15 && random < 30) item = (Item) itemTable.get("strong potion");
			else if(random >= 30 && random < 44) item = (Item) itemTable.get("warp scroll");
			else if(random >= 44 && random < 46) item = (Item) itemTable.get("mid heal");
			else if(random >= 46 && random < 48) item = (Item) itemTable.get("mid blast");
			else if(random >= 48 && random < 50) item = (Item) itemTable.get("mid strength");
			else if(random >= 50 && random < 52) item = (Item) itemTable.get("mid weakness");
			else if(random >= 52 && random < 54) item = (Item) itemTable.get("mid exposure");
			else if(random >= 54 && random < 56) item = (Item) itemTable.get("mid sight");
			else if(random >= 56 && random < 58) item = (Item) itemTable.get("mid blind");
			else if(random >= 58 && random < 60) item = (Item) itemTable.get("mid agility");
			else if(random >= 60 && random < 62) item = (Item) itemTable.get("mid paralysis");
			else if(random >= 62 && random < 64) item = (Item) itemTable.get("mid opening");
			else if(random >= 64 && random < 66) item = (Item) itemTable.get("mid accelerate");
			else if(random >= 66 && random < 68) item = (Item) itemTable.get("mid brakes");
			else if(random >= 68 && random < 70) item = (Item) itemTable.get("mid shield");
			else if(random >= 70 && random < 72) item = (Item) itemTable.get("mid barrier");
			else if(random >= 72 && random < 74) item = (Item) itemTable.get("mid stupidity");
			else if(random >= 74 && random < 76) item = (Item) itemTable.get("steel sword");
			else if(random >= 76 && random < 78) item = (Item) itemTable.get("steel shield");
			else if(random >= 78 && random < 80) item = (Item) itemTable.get("steel helmet");
			else if(random >= 80 && random < 82) item = (Item) itemTable.get("steel armor");
			else if(random >= 82 && random < 84) item = (Item) itemTable.get("steel gauntlets");
			else if(random >= 84 && random < 86) item = (Item) itemTable.get("journeyman staff");
			else if(random >= 86 && random < 88) item = (Item) itemTable.get("journeyman hat");
			else if(random >= 88 && random < 90) item = (Item) itemTable.get("journeyman robe");
			else if(random >= 90 && random < 92) item = (Item) itemTable.get("journeyman ring");
			else if(random >= 92 && random < 94) item = (Item) itemTable.get("steel dagger");
			else if(random >= 94 && random < 96) item = (Item) itemTable.get("burglar mask");
			else if(random >= 96 && random < 98) item = (Item) itemTable.get("burglar tunic");
			else if(random >= 98 && random < 100) item = (Item) itemTable.get("burglar shoes");
		}
		else if(dungeonLevel >= 21 && dungeonLevel <= 25)
		{
			if(random >= 0 && random < 15) item = (Item) itemTable.get("strong herb");
			else if(random >= 15 && random < 30) item = (Item) itemTable.get("strong potion");
			else if(random >= 30 && random < 44) item = (Item) itemTable.get("warp scroll");
			else if(random >= 44 && random < 46) item = (Item) itemTable.get("mid heal");
			else if(random >= 46 && random < 48) item = (Item) itemTable.get("mid blast");
			else if(random >= 48 && random < 50) item = (Item) itemTable.get("mid strength");
			else if(random >= 50 && random < 52) item = (Item) itemTable.get("mid weakness");
			else if(random >= 52 && random < 54) item = (Item) itemTable.get("mid exposure");
			else if(random >= 54 && random < 56) item = (Item) itemTable.get("mid sight");
			else if(random >= 56 && random < 58) item = (Item) itemTable.get("mid blind");
			else if(random >= 58 && random < 60) item = (Item) itemTable.get("mid agility");
			else if(random >= 60 && random < 62) item = (Item) itemTable.get("mid paralysis");
			else if(random >= 62 && random < 64) item = (Item) itemTable.get("mid opening");
			else if(random >= 64 && random < 66) item = (Item) itemTable.get("mid accelerate");
			else if(random >= 66 && random < 68) item = (Item) itemTable.get("mid brakes");
			else if(random >= 68 && random < 70) item = (Item) itemTable.get("mid shield");
			else if(random >= 70 && random < 72) item = (Item) itemTable.get("mid barrier");
			else if(random >= 72 && random < 74) item = (Item) itemTable.get("mid stupidity");
			else if(random >= 74 && random < 76) item = (Item) itemTable.get("silver sword");
			else if(random >= 76 && random < 78) item = (Item) itemTable.get("silver shield");
			else if(random >= 78 && random < 80) item = (Item) itemTable.get("silver helmet");
			else if(random >= 80 && random < 82) item = (Item) itemTable.get("silver armor");
			else if(random >= 82 && random < 84) item = (Item) itemTable.get("silver bracers");
			else if(random >= 84 && random < 86) item = (Item) itemTable.get("master staff");
			else if(random >= 86 && random < 88) item = (Item) itemTable.get("master hat");
			else if(random >= 88 && random < 90) item = (Item) itemTable.get("master robe");
			else if(random >= 90 && random < 92) item = (Item) itemTable.get("master ring");
			else if(random >= 92 && random < 94) item = (Item) itemTable.get("thief dagger");
			else if(random >= 94 && random < 96) item = (Item) itemTable.get("thief cap");
			else if(random >= 96 && random < 98) item = (Item) itemTable.get("thief tunic");
			else if(random >= 98 && random < 100) item = (Item) itemTable.get("thief boots");
		}
		else if(dungeonLevel >= 26 && dungeonLevel <= 30)
		{
			if(random >= 0 && random < 15) item = (Item) itemTable.get("strong herb");
			else if(random >= 15 && random < 30) item = (Item) itemTable.get("strong potion");
			else if(random >= 30 && random < 44) item = (Item) itemTable.get("warp scroll");
			else if(random >= 44 && random < 46) item = (Item) itemTable.get("major heal");
			else if(random >= 46 && random < 48) item = (Item) itemTable.get("major blast");
			else if(random >= 48 && random < 50) item = (Item) itemTable.get("major strength");
			else if(random >= 50 && random < 52) item = (Item) itemTable.get("major weakness");
			else if(random >= 52 && random < 54) item = (Item) itemTable.get("major exposure");
			else if(random >= 54 && random < 56) item = (Item) itemTable.get("major sight");
			else if(random >= 56 && random < 58) item = (Item) itemTable.get("major blind");
			else if(random >= 58 && random < 60) item = (Item) itemTable.get("major agility");
			else if(random >= 60 && random < 62) item = (Item) itemTable.get("major paralysis");
			else if(random >= 62 && random < 64) item = (Item) itemTable.get("major opening");
			else if(random >= 64 && random < 66) item = (Item) itemTable.get("major accelerate");
			else if(random >= 66 && random < 68) item = (Item) itemTable.get("major brakes");
			else if(random >= 68 && random < 70) item = (Item) itemTable.get("major shield");
			else if(random >= 70 && random < 72) item = (Item) itemTable.get("major barrier");
			else if(random >= 72 && random < 74) item = (Item) itemTable.get("major stupidity");
			else if(random >= 74 && random < 76) item = (Item) itemTable.get("platinum sword");
			else if(random >= 76 && random < 78) item = (Item) itemTable.get("platinum shield");
			else if(random >= 78 && random < 80) item = (Item) itemTable.get("platinum helmet");
			else if(random >= 80 && random < 82) item = (Item) itemTable.get("platinum armor");
			else if(random >= 82 && random < 84) item = (Item) itemTable.get("platinum bracers");
			else if(random >= 84 && random < 86) item = (Item) itemTable.get("hermit staff");
			else if(random >= 86 && random < 88) item = (Item) itemTable.get("hermit hood");
			else if(random >= 88 && random < 90) item = (Item) itemTable.get("hermit robe");
			else if(random >= 90 && random < 92) item = (Item) itemTable.get("hermit ring");
			else if(random >= 92 && random < 94) item = (Item) itemTable.get("hunting bow");
			else if(random >= 94 && random < 96) item = (Item) itemTable.get("hunting cap");
			else if(random >= 96 && random < 98) item = (Item) itemTable.get("hunting vest");
			else if(random >= 98 && random < 100) item = (Item) itemTable.get("hunting boots");
		}
		else if(dungeonLevel >= 31 && dungeonLevel <= 35)
		{
			if(random >= 0 && random < 22) item = (Item) itemTable.get("special herb");
			else if(random >= 22 && random < 44) item = (Item) itemTable.get("special potion");
			else if(random >= 44 && random < 46) item = (Item) itemTable.get("major heal");
			else if(random >= 46 && random < 48) item = (Item) itemTable.get("major blast");
			else if(random >= 48 && random < 50) item = (Item) itemTable.get("major strength");
			else if(random >= 50 && random < 52) item = (Item) itemTable.get("major weakness");
			else if(random >= 52 && random < 54) item = (Item) itemTable.get("major exposure");
			else if(random >= 54 && random < 56) item = (Item) itemTable.get("major sight");
			else if(random >= 56 && random < 58) item = (Item) itemTable.get("major blind");
			else if(random >= 58 && random < 60) item = (Item) itemTable.get("major agility");
			else if(random >= 60 && random < 62) item = (Item) itemTable.get("major paralysis");
			else if(random >= 62 && random < 64) item = (Item) itemTable.get("major opening");
			else if(random >= 64 && random < 66) item = (Item) itemTable.get("major accelerate");
			else if(random >= 66 && random < 68) item = (Item) itemTable.get("major brakes");
			else if(random >= 68 && random < 70) item = (Item) itemTable.get("major shield");
			else if(random >= 70 && random < 72) item = (Item) itemTable.get("major barrier");
			else if(random >= 72 && random < 74) item = (Item) itemTable.get("major stupidity");
			else if(random >= 74 && random < 76) item = (Item) itemTable.get("mythril sword");
			else if(random >= 76 && random < 78) item = (Item) itemTable.get("mythril shield");
			else if(random >= 78 && random < 80) item = (Item) itemTable.get("mythril helmet");
			else if(random >= 80 && random < 82) item = (Item) itemTable.get("mythril armor");
			else if(random >= 82 && random < 84) item = (Item) itemTable.get("mythril gauntlets");
			else if(random >= 84 && random < 86) item = (Item) itemTable.get("wizard staff");
			else if(random >= 86 && random < 88) item = (Item) itemTable.get("wizard hat");
			else if(random >= 88 && random < 90) item = (Item) itemTable.get("wizard robe");
			else if(random >= 90 && random < 92) item = (Item) itemTable.get("wizard ring");
			else if(random >= 92 && random < 94) item = (Item) itemTable.get("katana");
			else if(random >= 94 && random < 96) item = (Item) itemTable.get("ninja mask");
			else if(random >= 96 && random < 98) item = (Item) itemTable.get("ninja gi");
			else if(random >= 98 && random < 100) item = (Item) itemTable.get("ninja soles");
		}
		else if(dungeonLevel >= 36 && dungeonLevel <= 40)
		{
			if(random >= 0 && random < 15) item = (Item) itemTable.get("special herb");
			else if(random >= 15 && random < 30) item = (Item) itemTable.get("special potion");
			else if(random >= 30 && random < 44) item = (Item) itemTable.get("warp scroll");
			else if(random >= 44 && random < 46) item = (Item) itemTable.get("major heal");
			else if(random >= 46 && random < 48) item = (Item) itemTable.get("major blast");
			else if(random >= 48 && random < 50) item = (Item) itemTable.get("major strength");
			else if(random >= 50 && random < 52) item = (Item) itemTable.get("major weakness");
			else if(random >= 52 && random < 54) item = (Item) itemTable.get("major exposure");
			else if(random >= 54 && random < 56) item = (Item) itemTable.get("major sight");
			else if(random >= 56 && random < 58) item = (Item) itemTable.get("major blind");
			else if(random >= 58 && random < 60) item = (Item) itemTable.get("major agility");
			else if(random >= 60 && random < 62) item = (Item) itemTable.get("major paralysis");
			else if(random >= 62 && random < 64) item = (Item) itemTable.get("major opening");
			else if(random >= 64 && random < 66) item = (Item) itemTable.get("major accelerate");
			else if(random >= 66 && random < 68) item = (Item) itemTable.get("major brakes");
			else if(random >= 68 && random < 70) item = (Item) itemTable.get("major shield");
			else if(random >= 70 && random < 72) item = (Item) itemTable.get("major barrier");
			else if(random >= 72 && random < 74) item = (Item) itemTable.get("major stupidity");
			else if(random >= 74 && random < 76) item = (Item) itemTable.get("dragon slayer");
			else if(random >= 76 && random < 78) item = (Item) itemTable.get("dragon shield");
			else if(random >= 78 && random < 80) item = (Item) itemTable.get("dragon helmet");
			else if(random >= 80 && random < 82) item = (Item) itemTable.get("dragon armor");
			else if(random >= 82 && random < 84) item = (Item) itemTable.get("dragon gauntlets");
			else if(random >= 84 && random < 86) item = (Item) itemTable.get("dragon staff");
			else if(random >= 86 && random < 88) item = (Item) itemTable.get("dragon hood");
			else if(random >= 88 && random < 90) item = (Item) itemTable.get("dragon robe");
			else if(random >= 90 && random < 92) item = (Item) itemTable.get("dragon ring");
			else if(random >= 92 && random < 94) item = (Item) itemTable.get("dragon fang");
			else if(random >= 94 && random < 96) item = (Item) itemTable.get("dragon mask");
			else if(random >= 96 && random < 98) item = (Item) itemTable.get("dragon gi");
			else if(random >= 98 && random < 100) item = (Item) itemTable.get("dragon soles");
		}
		else if(dungeonLevel >= 41 && dungeonLevel <= 45)
		{
			if(random >= 0 && random < 15) item = (Item) itemTable.get("special herb");
			else if(random >= 15 && random < 30) item = (Item) itemTable.get("special potion");
			else if(random >= 30 && random < 44) item = (Item) itemTable.get("warp scroll");
			else if(random >= 44 && random < 46) item = (Item) itemTable.get("major heal");
			else if(random >= 46 && random < 48) item = (Item) itemTable.get("major blast");
			else if(random >= 48 && random < 50) item = (Item) itemTable.get("major strength");
			else if(random >= 50 && random < 52) item = (Item) itemTable.get("major weakness");
			else if(random >= 52 && random < 54) item = (Item) itemTable.get("major exposure");
			else if(random >= 54 && random < 56) item = (Item) itemTable.get("major sight");
			else if(random >= 56 && random < 58) item = (Item) itemTable.get("major blind");
			else if(random >= 58 && random < 60) item = (Item) itemTable.get("major agility");
			else if(random >= 60 && random < 62) item = (Item) itemTable.get("major paralysis");
			else if(random >= 62 && random < 64) item = (Item) itemTable.get("major opening");
			else if(random >= 64 && random < 66) item = (Item) itemTable.get("major accelerate");
			else if(random >= 66 && random < 68) item = (Item) itemTable.get("major brakes");
			else if(random >= 68 && random < 70) item = (Item) itemTable.get("major shield");
			else if(random >= 70 && random < 72) item = (Item) itemTable.get("major barrier");
			else if(random >= 72 && random < 74) item = (Item) itemTable.get("major stupidity");
			else if(random >= 74 && random < 76) item = (Item) itemTable.get("dragon slayer");
			else if(random >= 76 && random < 78) item = (Item) itemTable.get("dragon shield");
			else if(random >= 78 && random < 80) item = (Item) itemTable.get("dragon helmet");
			else if(random >= 80 && random < 82) item = (Item) itemTable.get("dragon armor");
			else if(random >= 82 && random < 84) item = (Item) itemTable.get("dragon gauntlets");
			else if(random >= 84 && random < 86) item = (Item) itemTable.get("dragon staff");
			else if(random >= 86 && random < 88) item = (Item) itemTable.get("dragon hood");
			else if(random >= 88 && random < 90) item = (Item) itemTable.get("dragon robe");
			else if(random >= 90 && random < 92) item = (Item) itemTable.get("dragon ring");
			else if(random >= 92 && random < 94) item = (Item) itemTable.get("dragon fang");
			else if(random >= 94 && random < 96) item = (Item) itemTable.get("dragon mask");
			else if(random >= 96 && random < 98) item = (Item) itemTable.get("dragon gi");
			else if(random >= 98 && random < 100) item = (Item) itemTable.get("dragon soles");
		}
		else if(dungeonLevel >= 46 && dungeonLevel <= 50)
		{
			if(random >= 0 && random < 15) item = (Item) itemTable.get("special herb");
			else if(random >= 15 && random < 30) item = (Item) itemTable.get("special potion");
			else if(random >= 30 && random < 44) item = (Item) itemTable.get("warp scroll");
			else if(random == 44) item = (Item) itemTable.get("major heal");
			else if(random == 45) item = (Item) itemTable.get("major blast");
			else if(random == 46) item = (Item) itemTable.get("major strength");
			else if(random == 47) item = (Item) itemTable.get("major weakness");
			else if(random == 48) item = (Item) itemTable.get("major exposure");
			else if(random == 49) item = (Item) itemTable.get("major sight");
			else if(random == 50) item = (Item) itemTable.get("major blind");
			else if(random == 51) item = (Item) itemTable.get("major agility");
			else if(random == 52) item = (Item) itemTable.get("major paralysis");
			else if(random == 53) item = (Item) itemTable.get("major opening");
			else if(random == 54) item = (Item) itemTable.get("major accelerate");
			else if(random == 55) item = (Item) itemTable.get("major brakes");
			else if(random == 56) item = (Item) itemTable.get("major shield");
			else if(random == 57) item = (Item) itemTable.get("major barrier");
			else if(random == 58) item = (Item) itemTable.get("major stupidity");
			else if(random == 59) item = (Item) itemTable.get("full heal");
			else if(random == 60) item = (Item) itemTable.get("full blast");
			else if(random == 61) item = (Item) itemTable.get("full strength");
			else if(random == 62) item = (Item) itemTable.get("full weakness");
			else if(random == 63) item = (Item) itemTable.get("full exposure");
			else if(random == 64) item = (Item) itemTable.get("full sight");
			else if(random == 65) item = (Item) itemTable.get("full blind");
			else if(random == 66) item = (Item) itemTable.get("full agility");
			else if(random == 67) item = (Item) itemTable.get("full paralysis");
			else if(random == 68) item = (Item) itemTable.get("full opening");
			else if(random == 69) item = (Item) itemTable.get("full accelerate");
			else if(random == 70) item = (Item) itemTable.get("full brakes");
			else if(random == 71) item = (Item) itemTable.get("full shield");
			else if(random == 72) item = (Item) itemTable.get("full barrier");
			else if(random == 73) item = (Item) itemTable.get("full stupidity");
			else if(random == 74) item = (Item) itemTable.get("dragon slayer");
			else if(random == 75) item = (Item) itemTable.get("dragon shield");
			else if(random == 76) item = (Item) itemTable.get("dragon helmet");
			else if(random == 77) item = (Item) itemTable.get("dragon armor");
			else if(random == 78) item = (Item) itemTable.get("dragon gauntlets");
			else if(random == 79) item = (Item) itemTable.get("dragon staff");
			else if(random == 80) item = (Item) itemTable.get("dragon hood");
			else if(random == 81) item = (Item) itemTable.get("dragon robe");
			else if(random == 82) item = (Item) itemTable.get("dragon ring");
			else if(random == 83) item = (Item) itemTable.get("dragon fang");
			else if(random == 84) item = (Item) itemTable.get("dragon mask");
			else if(random == 85) item = (Item) itemTable.get("dragon gi");
			else if(random == 86) item = (Item) itemTable.get("dragon soles");
			else if(random == 87) item = (Item) itemTable.get("Excalibur");
			else if(random == 88) item = (Item) itemTable.get("Arthur's shield");
			else if(random == 89) item = (Item) itemTable.get("Arthur's helmet");
			else if(random == 90) item = (Item) itemTable.get("Arthur's armor");
			else if(random == 91) item = (Item) itemTable.get("Arthur's gauntlets");
			else if(random == 92) item = (Item) itemTable.get("Merlin's staff");
			else if(random == 93) item = (Item) itemTable.get("Merlin's hat");
			else if(random == 94) item = (Item) itemTable.get("Merlin's robe");
			else if(random == 95) item = (Item) itemTable.get("Merlin's ring");
			else if(random == 96) item = (Item) itemTable.get("Robin's bow");
			else if(random == 97) item = (Item) itemTable.get("Robin's hood");
			else if(random == 98) item = (Item) itemTable.get("Robin's tunic");
			else if(random == 99) item = (Item) itemTable.get("Robin's boots");
		}

		return item;
	}
}