/*
FILE: Item.java
AUTHOR: Trevor Evans
CREATED: 12-19-05
MODIFIED: 4-24-06
*/

import java.io.*;
import java.applet.*;
import java.net.*;

/*
CLASS: Item
PURPOSE: Creates a new item. There are two categories of items: usable and equippable.
Usable items disappear from inventory after one use. Items of type HEALING and MAGIC_SCROLL
fall under this category. Equippable items are allocated to equipment slots to give the
user the stat boosts they provide and stay in inventory until they are dropped or sold.
Items of type WEAPON, SHIELD, BODY, HEAD, and ACCESSORY fall under this category.
*/
public class Item implements Serializable
{
	String name; //the name of the item
	String description; //a short description of the item
	int value; //the value, in gold, of the item
	int type; //the item's type; determines how it is used
	int quantity; //indicates how many copies of this item are currently in the hero's inventory.
	AudioClip soundEffectClip; //the sound effect associated with the item

	public static final int EMPTY = -1; //item's of this type are place holders
	public static final int WEAPON = 0;
	public static final int SHIELD = 1;
	public static final int HEAD = 2;
	public static final int BODY = 3;
	public static final int ACCESSORY = 4;
	public static final int HEALING = 5;
	public static final int MAGIC_SCROLL = 6;
	public static final int WARP_SCROLL = 7;

	public Item()
	{
		name = "";
		description = "";
		value = 0;
		type = EMPTY;
		quantity = 0;
	}

	public Item(String nameIn, int valueIn)
	{
		name = nameIn;
		description = "";
		value = valueIn;
		type = EMPTY;
		quantity = 1;
	}

	/*
	METHOD: getName
	PURPOSE: Returns the name of this item.
	*/
	public String getName()
	{
		return name;
	}

	/*
	METHOD: getDescription
	PURPOSE: Returns the description of this item.
	*/
	public String getDescription()
	{
		return description;
	}

	/*
	METHOD: setDescription(String)
	PURPOSE; Sets this item's description to the specified string.
	*/
	public void setDescription(String textIn)
	{
		description = textIn;
	}

	/*
	METHOD: getValue
	PURPOSE: Returns the value of this item.
	*/
	public int getValue()
	{
		return value;
	}

	/*
	METHOD: getType
	PUPOSE: Returns the type of this item.
	*/
	public int getType()
	{
		return type;
	}

	/*
	METHOD: getQuantity
	PURPOSE: Returns the quantity of this item.
	*/
	public int getQuantity()
	{
		return quantity;
	}

	/*
	METHOD: setQuantity(int)
	PURPOSE: Sets the quantity of this item to the specified value.
	*/
	public void setQuantity(int quantityIn)
	{
		quantity = quantityIn;
	}
}