/*
FILE: Hero.java
AUTHOR: Trevor Evans
CREATED: 2-27-06
MODIFIED: 4-24-06
*/

import java.io.*;
import javax.imageio.*;
import java.awt.*;

/*
CLASS: GameCharacter
PURPOSE: Creates a new hero. A hero is a game character controlled directly by the player.
*/
public class Hero extends GameCharacter implements Serializable
{
	private int lastVisitedDungeonLevel; //the most recently visited dungeon level
	private int SP; //Skill Points: points gained at level up that can be used to raise other stats
	private Item[] inventory; //the hero's inventory of items
	private Spell[] spellList; //the hero's list of spells
	private Equipment[] equipment; //slots where the hero can allocated equipment
	private ItemLookUpTable itemTable; //a look-up table containing all items
	private SpellLookUpTable spellTable; //a look-up table containing all spells

	public Hero()
	{
		super();
		//initialize stats
		LVL = 1;
		EXP = 0;
		SP = 3;
		stat[MAX_HP] = 10;
		stat[MAX_MP] = 5;
		HP = stat[MAX_HP];
	 	MP = stat[MAX_MP];
		stat[ATK] = 1;
		stat[ACC] = 1;
		stat[DEF] = 1;
		stat[EVA] = 1;
		stat[WIS] = 1;
		stat[MDEF] = 1;
		stat[SPD] = 1;
		gold = 50;
		lastVisitedDungeonLevel = 1;
		//initialize inventory
		inventory = new Item[10];
		itemTable = new ItemLookUpTable();
		inventory[0] = itemTable.getItem("wooden sword");
		inventory[1] = itemTable.getItem("wooden shield");
		inventory[2] = itemTable.getItem("bandana");
		inventory[3] = itemTable.getItem("cloth shirt");
		inventory[4] = itemTable.getItem("herb");
		inventory[5] = itemTable.getItem("potion");
		inventory[6] = itemTable.getItem("warp scroll");
		inventory[7] = itemTable.getItem("");
		inventory[8] = itemTable.getItem("");
		inventory[9] = itemTable.getItem("");
		//initialize equipment
		equipment = new Equipment[5];
		equipment[Item.WEAPON] = (Equipment) itemTable.getItem("");
		equipment[Item.SHIELD] = (Equipment) itemTable.getItem("");
		equipment[Item.HEAD] = (Equipment) itemTable.getItem("");
		equipment[Item.BODY] = (Equipment) itemTable.getItem("");
		equipment[Item.ACCESSORY] = (Equipment) itemTable.getItem("");
		//initialize spell list
		spellList = new Spell[10];
		spellTable = new SpellLookUpTable();
		spellList[0] = spellTable.getSpell("");
		spellList[1] = spellTable.getSpell("");
		spellList[2] = spellTable.getSpell("");
		spellList[3] = spellTable.getSpell("");
		spellList[4] = spellTable.getSpell("");
		spellList[5] = spellTable.getSpell("");
		spellList[6] = spellTable.getSpell("");
		spellList[7] = spellTable.getSpell("");
		spellList[8] = spellTable.getSpell("");
		spellList[9] = spellTable.getSpell("");
	}

	/*
	METHOD: getLastVisitedDungeonLevel
	PURPOSE: Returns the most recently dungeon level visited by the hero.
	*/
	public int getLastVisitedDungeonLevel()
	{
		return lastVisitedDungeonLevel;
	}

	/*
	METHOD: setLastVisitedDungeonLevel(int)
	PURPOSE: Sets the most recently visited dungeon level to the level specified.
	*/
	public void setLastVisitedDungeonLevel(int levelIn)
	{
		lastVisitedDungeonLevel = levelIn;
	}

	/*
	METHOD: getSP
	PURPOSE: Returns the hero's skill points.
	*/
	public int getSP()
	{
		return SP;
	}

	/*
	METHOD: setSP(int)
	PURPOSE: Sets this character's skill points to the specified value.
	*/
	public void setSP(int spIn)
	{
		SP = spIn;
	}

	/*
	METHOD: addGold(int)
	PURPOSE: Adds the specified amount of gold to the hero's gold count. Returns the
	appropriate message to be displayed in the battle log.
	*/
	public String addGold(int goldIn)
	{
		String message = (" drops " + goldIn + " gold.\n");
		gold += goldIn;

		return message;
	}

	/*
	METHOD: addEXP(int)
	PURPOSE: Adds the specified value of EXP to the hero's EXP. Returns the
	appropriate message to be displayed in the battle log.
	*/
	public String addEXP(int EXPin)
	{
		String message = (this.name + " gains " + EXPin + " EXP.\n");
		EXP += EXPin;

		if(LVL == 1 && EXP >= 10) message += levelUp();
		if(LVL == 2 && EXP >= 25) message += levelUp();
		if(LVL == 3 && EXP >= 50) message += levelUp();
		if(LVL == 4 && EXP >= 75) message += levelUp();
		if(LVL == 5 && EXP >= 100) message += levelUp();
		if(LVL == 6 && EXP >= 150) message += levelUp();
		if(LVL == 7 && EXP >= 200) message += levelUp();
		if(LVL == 8 && EXP >= 250) message += levelUp();
		if(LVL == 9 && EXP >= 325) message += levelUp();
		if(LVL == 10 && EXP >= 400) message += levelUp();
		if(LVL == 11 && EXP >= 550) message += levelUp();
		if(LVL == 12 && EXP >= 750) message += levelUp();
		if(LVL == 13 && EXP >= 975) message += levelUp();
		if(LVL == 14 && EXP >= 1200) message += levelUp();
		if(LVL == 15 && EXP >= 1450) message += levelUp();
		if(LVL == 16 && EXP >= 1700) message += levelUp();
		if(LVL == 17 && EXP >= 2000) message += levelUp();
		if(LVL == 18 && EXP >= 2300) message += levelUp();
		if(LVL == 19 && EXP >= 2650) message += levelUp();
		if(LVL == 20 && EXP >= 3000) message += levelUp();
		if(LVL == 21 && EXP >= 3500) message += levelUp();
		if(LVL == 22 && EXP >= 4050) message += levelUp();
		if(LVL == 23 && EXP >= 4600) message += levelUp();
		if(LVL == 24 && EXP >= 5200) message += levelUp();
		if(LVL == 25 && EXP >= 5800) message += levelUp();
		if(LVL == 26 && EXP >= 6450) message += levelUp();
		if(LVL == 27 && EXP >= 7150) message += levelUp();
		if(LVL == 28 && EXP >= 7900) message += levelUp();
		if(LVL == 29 && EXP >= 8700) message += levelUp();
		if(LVL == 30 && EXP >= 9550) message += levelUp();
		if(LVL == 31 && EXP >= 10800) message += levelUp();
		if(LVL == 32 && EXP >= 12100) message += levelUp();
		if(LVL == 33 && EXP >= 13400) message += levelUp();
		if(LVL == 34 && EXP >= 14700) message += levelUp();
		if(LVL == 35 && EXP >= 16100) message += levelUp();
		if(LVL == 36 && EXP >= 17550) message += levelUp();
		if(LVL == 37 && EXP >= 19150) message += levelUp();
		if(LVL == 38 && EXP >= 20800) message += levelUp();
		if(LVL == 39 && EXP >= 22500) message += levelUp();
		if(LVL == 40 && EXP >= 24300) message += levelUp();
		if(LVL == 41 && EXP >= 26800) message += levelUp();
		if(LVL == 42 && EXP >= 29400) message += levelUp();
		if(LVL == 43 && EXP >= 32100) message += levelUp();
		if(LVL == 44 && EXP >= 35000) message += levelUp();
		if(LVL == 45 && EXP >= 38000) message += levelUp();
		if(LVL == 46 && EXP >= 41250) message += levelUp();
		if(LVL == 47 && EXP >= 44500) message += levelUp();
		if(LVL == 48 && EXP >= 48000) message += levelUp();
		if(LVL == 49 && EXP >= 52000) message += levelUp();

		return message;
	}

	/*
	METHOD: levelUp
	PURPOSE: Increments the hero's level and skill points by 1 and 10, respectively.
	Returns the appropriate message to be displayed in the battle log.
	*/
	public String levelUp()
	{
		LVL++;
		SP += 10;

		return (this.name + " attains LVL " + LVL + ", receives 10 SP.\n");
	}

	/*
	METHOD: getItem(int)
	PURPOSE: Returns the item in the specified slot in the hero's inventory.
	*/
	public Item getItem(int slot)
	{
		return inventory[slot];
	}

	/*
	METHOD: setItem(Item, int)
	PURPOSE: Adds the specified item to the specified slot in the hero's inventory.
	*/
	public void setItem(Item itemIn, int slot)
	{
		inventory[slot] = itemIn;
	}

	/*
	METHOD: getSpell(int)
	PURPOSE: Returns the item in the specified slot in the hero's spell list.
	*/
	public Spell getSpell(int slot)
	{
		return spellList[slot];
	}

	/*
	METHOD: setSpell(Spell, int)
	PURPOSE: Adds the specified spell to the specified slot in the hero's spell list.
	*/
	public void setSpell(Spell spellIn, int slot)
	{
		spellList[slot] = spellIn;
	}

	/*
	METHOD: getEquipment(int)
	PURPOSE: Returns the equipment in the specified equipment slot.
	*/
	public Equipment getEquipment(int slot)
	{
		return equipment[slot];
	}

	/*
	METHOD: setEquipment(Equipment, int)
	PURPOSE: Returns the equipment in the specified equipment slot.
	*/
	public void setEquipment(Equipment itemIn, int slot)
	{
		equipment[slot] = itemIn;
	}

	/*
	METHOD: removeEquipment(int)
	PURPOSE: Removes the equipment in the specified equipment slot.
	*/
	public void removeEquipment(int slot)
	{	//remove any stat bonuses
		for(int i = 0; i < 9; i++)
		{
			setStat(getStat(i) - getEquipment(slot).getStatBonus(i), i);
		}
		//remove equipment
		equipment[slot] = (Equipment) itemTable.getItem("");
	}

	/*
	METHOD: hasInInventory(String)
	PURPOSE: Checks if an item (specified by its name) is already in the hero's inventory.
	If so, returns the slot in inventory where the item is located. Otherwise, returns -1
	to indicate the item is not in inventory.
	*/
	public int hasInInventory(String itemName)
	{
		for(int i = 0; i < 10; i++)
		{
			if(itemName.equals(inventory[i].getName()))
			{
				return i;
			}
		}

		return -1;
	}

	/*
	METHOD: hasEquipped(String)
	PURPOSE: Checks if an item (specified by its name) is currently equipped by the hero.
	Returns true to indicate the hero has the item equipped, or false to indicate he doesn't.
	*/
	public boolean hasEquipped(String itemName)
	{
		for(int i = 0; i < 5; i++)
		{
			if(itemName.equals(equipment[i].getName()))
			{
				return true;
			}
		}

		return false;
	}

	/*
	METHOD: firstEmptySlotInInventory
	PURPOSE: Returns the index of the first empty slot in the hero's inventory. If there
	are no empty slots, returns -1 to indicate so.
	*/
	public int firstEmptySlotInInventory()
	{
		for(int i = 0; i < 10; i++)
		{
			if(inventory[i].getName().equals(""))
			{
				return i;
			}
		}

		return -1;
	}

	/*
	METHOD: inventoryIsEmpty
	PURPOSE: Checks if the hero's inventory is completely empty. Returns true to indicate
	it is empty, or false to indicate it isn't.
	*/
	public boolean inventoryIsEmpty()
	{
		String s = "";

		for(int i = 0; i < 10; i++)
		{
			s += inventory[i].getName();
		}

		if(s.equals(""))
		{
			return true;
		}

		return false;
	}

	/*
	METHOD: hasNoHealingItems
	PURPOSE: Checks if the hero's inventory contains any items of type HEALING. Returns
	true if the hero has no healing items, false if he does.
	*/
	public boolean hasNoHealingItems()
	{
		for(int i = 0; i < 10; i++)
		{
			if(inventory[i].getType() == Item.HEALING)
			{
				return false;
			}
		}

		return true;
	}

	/*
	METHOD: removeSpell(int)
	PURPOSE: Removes the spell in the specified slot from the hero's spell list.
	*/
	public void removeSpell(int slot)
	{
		spellList[slot] = spellTable.getSpell("");
	}

	/*
	METHOD: hasInSpellList(String)
	PURPOSE: Checks if a spell (specified by its name) is already in the hero's spell list.
	If so, returns the slot in the spell list where the spell is located. Otherwise,
	returns -1 to indicate the spell is not in the spell list.
	*/
	public boolean hasInSpellList(String spellName)
	{
		for(int i = 0; i < 10; i++)
		{
			if(spellName.equals(spellList[i].getName()))
			{
				return true;
			}
		}

		return false;
	}

	/*
	METHOD: firstEmptySlotInSpellList
	PURPOSE: Returns the index of the first empty slot in the hero's spell list. If there
	are no empty slots, returns -1 to indicate so.
	*/
	public int firstEmptySlotInSpellList()
	{
		for(int i = 0; i < 10; i++)
		{
			if(spellList[i].getName().equals(""))
			{
				return i;
			}
		}

		return -1;
	}

	/*
	METHOD: spellListIsEmpty
	PURPOSE: Checks if the hero's spell list is completely empty. Returns true to indicate
	it is empty, or false to indicate it isn't.
	*/
	public boolean spellListIsEmpty()
	{
		String s = "";

		for(int i = 0; i < 10; i++)
		{
			s += spellList[i].getName();
		}

		if(s.equals(""))
		{
			return true;
		}

		return false;
	}
}