/*
FILE: HealingSpell.java
AUTHOR: Trevor Evans
CREATED: 3-14-06
MODIFIED: 4-24-06
*/

import java.io.*;
import java.applet.*;
import java.net.*;

/*
CLASS: HealingSpell
PURPOSE: Creates a spell of type HEALING. These spells recover the caster's HP when cast.
*/
public class HealingSpell extends Spell implements Serializable
{
	private double WISmultiplier; //this multiplied by caster's WIS determines the strength of the spell

	public HealingSpell(String nameIn, int costIn, double multiplierIn)
	{
		super(nameIn, costIn);
		type = HEALING;
		WISmultiplier = multiplierIn;
	}

	/*
	METHOD: cast(Hero, Hero)
	PURPOSE: Casts this spell on the specified target. Returns the appropriate message to
	be displayed in the battle log. Called when the hero is both the caster and the target.
	*/
	public String cast(Hero caster, Hero target)
	{	//calculate strength of spell
		int HPrecovered = (int) (caster.getStat(GameCharacter.WIS) * WISmultiplier);
		if(HPrecovered < 0) HPrecovered = 0; //HP recovered cannot be negative
		//if the spell restores more HP than the target has lost...
		if((target.getStat(GameCharacter.MAX_HP) - target.getHP()) < HPrecovered)
		{
			HPrecovered = target.getStat(GameCharacter.MAX_HP) - target.getHP();
		}
		//update target's and caster's affected stats
		target.setHP(target.getHP() + HPrecovered);
		caster.setMP(caster.getMP() - MPcost);
		//play casting sound effect
		try
		{
			soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" +
													  	  "audio_files/spell.wav"));
		}
		catch (IOException exception)
		{
			soundEffectClip = null;
		}
		soundEffectClip.play();
		//return appropriate message
		return (caster.getName() + " casts " + this.name + ". He recovers " + HPrecovered + " HP.");
	}

	/*
	METHOD: cast(Monster, Monster)
	PURPOSE: Casts this spell on the specified target. Returns the appropriate message to
	be displayed in the battle log. Called when a monster is both the caster and the target.
	*/
	public String cast(Monster caster, Monster target)
	{	//calculate strength of spell
		int HPrecovered = (int) (caster.getStat(GameCharacter.WIS) * WISmultiplier);
		if(HPrecovered < 0) HPrecovered = 0; //HP recovered cannot be negative
		//if the spell restores more HP than the target has lost...
		if((target.getStat(GameCharacter.MAX_HP) - target.getHP()) < HPrecovered)
		{
			HPrecovered = target.getStat(GameCharacter.MAX_HP) - target.getHP();
		}
		//update target's and caster's affected stats
		target.setHP(target.getHP() + HPrecovered);
		caster.setMP(caster.getMP() - MPcost);
		//play casting sound effect
		try
		{
			soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" +
													  	  "audio_files/spell.wav"));
		}
		catch (IOException exception)
		{
			soundEffectClip = null;
		}
		soundEffectClip.play();
		//return appropriate message
		return ("The " + caster.getName() + " casts " + this.name + ". It recovers " + HPrecovered + " HP.");
	}
}