/*
FILE: Equipment.java
AUTHOR: Trevor Evans
CREATED: 3-2-06
MODIFIED: 4-24-06
*/

import java.io.*;

/*
CLASS: Equipment
PURPOSE: Creates an equippable item. These items are not removed from the inventory after
one use. They are allocated to an equipment slot to boost the hero's stats.
*/
public class Equipment extends Item implements Serializable
{
	int[] statBonus; //determines how each stat is modified by equipping this item

	public Equipment(String nameIn, int valueIn)
	{
		super(nameIn, valueIn);

		statBonus = new int[9];

		for(int i = 0; i < 9; i++)
		{
			statBonus[i] = 0;
		}
	}

	/*
	METHOD: getStatBonus(int)
	PURPOSE: Returns the bonus for the specified stat.
	*/
	public int getStatBonus(int stat)
	{
		return statBonus[stat];
	}

	/*
	METHOD: setStatBonus(int, int)
	PURPOSE: Sets the bonus of the specified stat to the specified value.
	*/
	public void setStatBonus(int value, int stat)
	{
		statBonus[stat] = value;
	}

	/*
	METHOD: equip(Hero)
	PURPOSE: Equips this item to the specified hero.
	*/
	public void equip(Hero hero)
	{	//remove the stat bonuses of the item currently equipped in the slot type.
		for(int i = 0; i < 9; i++)
		{
			hero.setStat(hero.getStat(i) - hero.getEquipment(type).getStatBonus(i), i);
		}
		//equip this item to the appropriate slot
		hero.setEquipment(this, type);
		//add on the stat bonuses
		for(int i = 0; i < 9; i++)
		{
			hero.setStat(hero.getStat(i) + hero.getEquipment(type).getStatBonus(i), i);
		}
	}
}