/*
FILE: DQFileFilter.java
AUTHOR: Trevor Evans
CREATED: 4-13-06
MODIFIED: 4-24-06
*/

import javax.swing.filechooser.FileFilter;
import java.io.*;

/*
CLASS: DQFileFilter
PURPOSE: Called by the saved game loader to filter out all but Dungeon Quest Save (.dq)
files from the file chooser.
*/
public class DQFileFilter extends FileFilter
{
	public boolean accept(File file)
	{
		return file.getName().toLowerCase().endsWith(".dq") || file.isDirectory();
	}

	public String getDescription()
	{
		return "Dungeon Quest Save";
	}
}