/*
FILE: BuffingSpell.java
AUTHOR: Trevor Evans
CREATED: 3-31-06
MODIFIED: 4-24-06
*/

import java.io.*;
import java.applet.*;
import java.net.*;

/*
CLASS: BuffingSpell
PURPOSE: Creates a spell of type BUFFING. These spells raise the caster's stats when cast.
*/
public class BuffingSpell extends Spell implements Serializable
{
	private double WISmultiplier; //this multiplied by caster's WIS determines the strength of the spell
	private int stat; //determines the stat that is affected by this spell

	public BuffingSpell(String nameIn, int costIn, double multiplierIn, int statIn)
	{
		super(nameIn, costIn);
		type = BUFFING;
		WISmultiplier = multiplierIn;
		stat = statIn;
	}

	/*
	METHOD: cast(Hero, Hero)
	PURPOSE: Casts this spell on the specified target. Returns the appropriate message to
	be displayed in the battle log. Called when the hero is both the caster and the target.
	*/
	public String cast(Hero caster, Hero target)
	{	//calculate strength of spell
		int statIncrease = (int)(caster.getStat(GameCharacter.WIS) * WISmultiplier);
		if(statIncrease < 0) statIncrease = 0; //stat increase cannot be negative
		//update target's and caster's affected stats
		target.setStat(target.getStat(stat) + statIncrease, stat);
		caster.setMP(caster.getMP() - MPcost);
		//play casting sound effect
		try
		{
			soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" +
													 	  "audio_files/spell.wav"));
		}
		catch (IOException exception)
		{
			soundEffectClip = null;
		}
		soundEffectClip.play();
		//return appropriate message
		String statName = "";
		if(stat == GameCharacter.ATK) statName = "ATK";
		else if(stat == GameCharacter.ACC) statName = "ACC";
		else if(stat == GameCharacter.DEF) statName = "DEF";
		else if(stat == GameCharacter.EVA) statName = "EVA";
		else if(stat == GameCharacter.WIS) statName = "WIS";
		else if(stat == GameCharacter.MDEF) statName = "MDEF";
		else if(stat == GameCharacter.SPD) statName = "SPD";
		return (caster.getName() + " casts " + this.name + ". His " + statName + " increases by " + statIncrease + ".");
	}

	/*
	METHOD: cast(Monster, Monster)
	PURPOSE: Casts this spell on the specified target. Returns the appropriate message to
	be displayed in the battle log. Called when a monster is both the caster and the target.
	*/
	public String cast(Monster caster, Monster target)
	{	//calculate strength of spell
		int statIncrease = (int)(caster.getStat(GameCharacter.WIS) * WISmultiplier);
		if(statIncrease < 0) statIncrease = 0; //stat increase cannot be negative
		//update target's and caster's affected stats
		target.setStat(target.getStat(stat) + statIncrease, stat);
		caster.setMP(caster.getMP() - MPcost);
		//play casting sound effect
		try
		{
			soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" +
													  	  "audio_files/spell.wav"));
		}
		catch (IOException exception)
		{
			soundEffectClip = null;
		}
		soundEffectClip.play();
		//return appropriate message
		String statName = "";
		if(stat == GameCharacter.ATK) statName = "ATK";
		else if(stat == GameCharacter.ACC) statName = "ACC";
		else if(stat == GameCharacter.DEF) statName = "DEF";
		else if(stat == GameCharacter.EVA) statName = "EVA";
		else if(stat == GameCharacter.WIS) statName = "WIS";
		else if(stat == GameCharacter.MDEF) statName = "MDEF";
		else if(stat == GameCharacter.SPD) statName = "SPD";
		return ("The " + caster.getName() + " casts " + this.name + ". Its " + statName + " increases by " + statIncrease + ".");
	}

	/*
	METHOD: getStat
	PURPOSE: Returns the stat affected by this spell.
	*/
	public int getStat()
	{
		return stat;
	}
}