/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.MaskFormatter;

class DQFrame
extends JFrame {
    private Container contentPane;
    private MapPanel mapPanel;
    private Hero hero;
    private ItemLookUpTable itemTable;
    private SpellLookUpTable spellTable;
    private AudioClip musicClip;
    private AudioClip soundEffectClip;
    private int dungeonLevel;
    private int encounterCounter;
    private boolean gameOver;
    public static final int DEFAULT_WIDTH = 326;
    public static final int DEFAULT_HEIGHT = 320;

    public DQFrame() {
        this.setTitle("Dungeon Quest");
        this.setSize(326, 320);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.hero = new Hero();
        this.itemTable = new ItemLookUpTable();
        this.spellTable = new SpellLookUpTable();
        try {
            this.musicClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/blank.wav"));
            this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/blank.wav"));
        }
        catch (IOException exception) {
            this.musicClip = null;
            this.soundEffectClip = null;
        }
        this.contentPane = this.getContentPane();
        this.mapPanel = new MapPanel();
        this.contentPane.add(this.mapPanel);
    }

    public MapPanel getMapPanel() {
        return this.mapPanel;
    }

    public AudioClip getMusicClip() {
        return this.musicClip;
    }

    public void setMusicClip(AudioClip clipIn) {
        this.musicClip = clipIn;
    }

    public AudioClip getSoundEffectClip() {
        return this.soundEffectClip;
    }

    private class BattleWindow
    extends JDialog {
        private JPanel battlePanel;
        private JButton attackButton;
        private JButton spellsButton;
        private JButton itemsButton;
        private JButton fleeButton;
        private JTextField hpField;
        private JTextField mpField;
        private JFormattedTextField maxHpField;
        private JFormattedTextField maxMpField;
        private JTextArea battleLog;
        private MonsterLookUpTable monsterTable;
        private Monster monster;
        private Timer timer;
        private int random;
        private boolean battleOver;
        private int[] startStat;

        public BattleWindow(JFrame owner) {
            super(owner, "", true);
            this.timer = new Timer();
            this.battleOver = false;
            this.monsterTable = new MonsterLookUpTable();
            this.monster = this.monsterTable.getRandomMonster(DQFrame.this.dungeonLevel);
            this.startStat = new int[9];
            for (int i = 0; i < 9; ++i) {
                this.startStat[i] = DQFrame.this.hero.getStat(i);
            }
            this.setSize(326, 320);
            this.setLocation(owner.getX(), owner.getY());
            this.setResizable(false);
            this.setFocusable(true);
            this.setDefaultCloseOperation(0);
            this.battlePanel = new BattlePanel();
            this.add(this.battlePanel);
        }

        private class CloseTask
        extends TimerTask {
            private CloseTask() {
            }

            public void run() {
                for (int i = 0; i < 9; ++i) {
                    DQFrame.this.hero.setStat(BattleWindow.this.startStat[i], i);
                }
                BattleWindow.this.timer.cancel();
                BattleWindow.this.dispose();
            }
        }

        private class EndRound
        extends TimerTask {
            private EndRound() {
            }

            public void run() {
                if (!BattleWindow.this.battleOver) {
                    BattleWindow.this.attackButton.setEnabled(true);
                    if (!DQFrame.this.hero.spellListIsEmpty()) {
                        BattleWindow.this.spellsButton.setEnabled(true);
                    }
                    if (!DQFrame.this.hero.hasNoHealingItems()) {
                        BattleWindow.this.itemsButton.setEnabled(true);
                    }
                    BattleWindow.this.fleeButton.setEnabled(true);
                }
            }
        }

        private class CheckIfHeroSlain
        extends TimerTask {
            private CheckIfHeroSlain() {
            }

            public void run() {
                if (DQFrame.this.hero.getHP() == 0) {
                    BattleWindow.this.battleLog.append(DQFrame.this.hero.getName() + " is slain.\n");
                    try {
                        BattleWindow.this.battleLog.setCaretPosition(BattleWindow.this.battleLog.getLineEndOffset(BattleWindow.this.battleLog.getLineCount() - 1));
                    }
                    catch (BadLocationException exception) {
                        System.out.println("Caught exception: " + exception);
                    }
                    BattleWindow.this.battleOver = true;
                    DQFrame.this.gameOver = true;
                    DQFrame.this.musicClip.stop();
                    BattleWindow.this.timer.schedule((TimerTask)new CloseTask(), 5000L);
                }
            }
        }

        private class CheckIfMonsterSlain
        extends TimerTask {
            private CheckIfMonsterSlain() {
            }

            public void run() {
                if (BattleWindow.this.monster.getHP() == 0) {
                    BattleWindow.this.monster.setImageFileName("blank.gif");
                    BattleWindow.this.battlePanel.repaint();
                    BattleWindow.this.battleLog.append("The " + BattleWindow.this.monster.getName() + " is slain.\n");
                    BattleWindow.this.battleLog.append("The " + BattleWindow.this.monster.getName() + DQFrame.this.hero.addGold(BattleWindow.this.monster.getGold()));
                    BattleWindow.this.battleLog.append(DQFrame.this.hero.addEXP(BattleWindow.this.monster.getEXP()));
                    try {
                        BattleWindow.this.battleLog.setCaretPosition(BattleWindow.this.battleLog.getLineEndOffset(BattleWindow.this.battleLog.getLineCount() - 1));
                    }
                    catch (BadLocationException exception) {
                        System.out.println("Caught exception: " + exception);
                    }
                    BattleWindow.this.battleOver = true;
                    DQFrame.this.musicClip.stop();
                    try {
                        DQFrame.this.musicClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/dungeon.mid"));
                    }
                    catch (IOException exception) {
                        DQFrame.this.musicClip = null;
                    }
                    DQFrame.this.musicClip.loop();
                    try {
                        DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/win_battle.wav"));
                    }
                    catch (IOException exception) {
                        DQFrame.this.soundEffectClip = null;
                    }
                    DQFrame.this.soundEffectClip.play();
                    BattleWindow.this.timer.schedule((TimerTask)new CloseTask(), 5000L);
                }
            }
        }

        private class MonsterActionSecond
        extends TimerTask {
            private MonsterActionSecond() {
            }

            public void run() {
                if (!BattleWindow.this.battleOver) {
                    Spell monsterAction = BattleWindow.this.monster.chooseRandomAction();
                    if (monsterAction.getType() == 0) {
                        BattleWindow.this.battleLog.append(((HealingSpell)monsterAction).cast(BattleWindow.this.monster, BattleWindow.this.monster) + "\n");
                    } else if (monsterAction.getType() == 1) {
                        BattleWindow.this.battleLog.append(((OffensiveSpell)monsterAction).cast(BattleWindow.this.monster, DQFrame.this.hero) + "\n");
                    } else if (monsterAction.getType() == 2) {
                        BattleWindow.this.battleLog.append(((BuffingSpell)monsterAction).cast(BattleWindow.this.monster, BattleWindow.this.monster) + "\n");
                    } else if (monsterAction.getType() == 3) {
                        BattleWindow.this.battleLog.append(((DebuffingSpell)monsterAction).cast(BattleWindow.this.monster, DQFrame.this.hero) + "\n");
                    } else if (monsterAction.getType() == 4) {
                        BattleWindow.this.battleLog.append(((MonsterMelee)monsterAction).attack(BattleWindow.this.monster, DQFrame.this.hero) + "\n");
                    }
                    try {
                        BattleWindow.this.battleLog.setCaretPosition(BattleWindow.this.battleLog.getLineEndOffset(BattleWindow.this.battleLog.getLineCount() - 1));
                    }
                    catch (BadLocationException exception) {
                        System.out.println("Caught exception: " + exception);
                    }
                    BattleWindow.this.hpField.setText(DQFrame.this.hero.getHP() + "/");
                    BattleWindow.this.timer.schedule((TimerTask)new CheckIfHeroSlain(), 1000L);
                }
            }
        }

        private class MonsterActionFirst
        extends TimerTask {
            private MonsterActionFirst() {
            }

            public void run() {
                Spell monsterAction = BattleWindow.this.monster.chooseRandomAction();
                if (monsterAction.getType() == 0) {
                    BattleWindow.this.battleLog.append(((HealingSpell)monsterAction).cast(BattleWindow.this.monster, BattleWindow.this.monster) + "\n");
                } else if (monsterAction.getType() == 1) {
                    BattleWindow.this.battleLog.append(((OffensiveSpell)monsterAction).cast(BattleWindow.this.monster, DQFrame.this.hero) + "\n");
                } else if (monsterAction.getType() == 2) {
                    BattleWindow.this.battleLog.append(((BuffingSpell)monsterAction).cast(BattleWindow.this.monster, BattleWindow.this.monster) + "\n");
                } else if (monsterAction.getType() == 3) {
                    BattleWindow.this.battleLog.append(((DebuffingSpell)monsterAction).cast(BattleWindow.this.monster, DQFrame.this.hero) + "\n");
                } else if (monsterAction.getType() == 4) {
                    BattleWindow.this.battleLog.append(((MonsterMelee)monsterAction).attack(BattleWindow.this.monster, DQFrame.this.hero) + "\n");
                }
                try {
                    BattleWindow.this.battleLog.setCaretPosition(BattleWindow.this.battleLog.getLineEndOffset(BattleWindow.this.battleLog.getLineCount() - 1));
                }
                catch (BadLocationException exception) {
                    System.out.println("Caught exception: " + exception);
                }
                BattleWindow.this.hpField.setText(DQFrame.this.hero.getHP() + "/");
            }
        }

        private class HeroUseItemSecond
        extends TimerTask {
            private int inventorySlot;
            private Item item;

            public HeroUseItemSecond(int slotIn) {
                this.inventorySlot = slotIn;
                this.item = DQFrame.this.hero.getItem(this.inventorySlot);
            }

            public void run() {
                if (!BattleWindow.this.battleOver) {
                    BattleWindow.this.battleLog.append(((HealingItem)this.item).use(DQFrame.this.hero) + "\n");
                    if (this.item.getQuantity() > 1) {
                        this.item.setQuantity(this.item.getQuantity() - 1);
                    } else {
                        DQFrame.this.hero.setItem((Equipment)DQFrame.this.itemTable.getItem(""), this.inventorySlot);
                    }
                    try {
                        BattleWindow.this.battleLog.setCaretPosition(BattleWindow.this.battleLog.getLineEndOffset(BattleWindow.this.battleLog.getLineCount() - 1));
                    }
                    catch (BadLocationException exception) {
                        System.out.println("Caught exception: " + exception);
                    }
                    BattleWindow.this.hpField.setText(DQFrame.this.hero.getHP() + "/");
                    BattleWindow.this.mpField.setText(DQFrame.this.hero.getMP() + "/");
                }
            }
        }

        private class HeroUseItemFirst
        extends TimerTask {
            private int inventorySlot;
            private Item item;

            public HeroUseItemFirst(int slotIn) {
                this.inventorySlot = slotIn;
                this.item = DQFrame.this.hero.getItem(this.inventorySlot);
            }

            public void run() {
                BattleWindow.this.battleLog.append(((HealingItem)this.item).use(DQFrame.this.hero) + "\n");
                if (this.item.getQuantity() > 1) {
                    this.item.setQuantity(this.item.getQuantity() - 1);
                } else {
                    DQFrame.this.hero.setItem((Equipment)DQFrame.this.itemTable.getItem(""), this.inventorySlot);
                }
                try {
                    BattleWindow.this.battleLog.setCaretPosition(BattleWindow.this.battleLog.getLineEndOffset(BattleWindow.this.battleLog.getLineCount() - 1));
                }
                catch (BadLocationException exception) {
                    System.out.println("Caught exception: " + exception);
                }
                BattleWindow.this.hpField.setText(DQFrame.this.hero.getHP() + "/");
                BattleWindow.this.mpField.setText(DQFrame.this.hero.getMP() + "/");
            }
        }

        private class HeroCastSpellSecond
        extends TimerTask {
            Spell spell;

            public HeroCastSpellSecond(Spell spellIn) {
                this.spell = spellIn;
            }

            public void run() {
                if (!BattleWindow.this.battleOver) {
                    if (this.spell.getType() == 0) {
                        BattleWindow.this.battleLog.append(((HealingSpell)this.spell).cast(DQFrame.this.hero, DQFrame.this.hero) + "\n");
                    } else if (this.spell.getType() == 1) {
                        BattleWindow.this.battleLog.append(((OffensiveSpell)this.spell).cast(DQFrame.this.hero, BattleWindow.this.monster) + "\n");
                    } else if (this.spell.getType() == 2) {
                        BattleWindow.this.battleLog.append(((BuffingSpell)this.spell).cast(DQFrame.this.hero, DQFrame.this.hero) + "\n");
                    } else if (this.spell.getType() == 3) {
                        BattleWindow.this.battleLog.append(((DebuffingSpell)this.spell).cast(DQFrame.this.hero, BattleWindow.this.monster) + "\n");
                    }
                    try {
                        BattleWindow.this.battleLog.setCaretPosition(BattleWindow.this.battleLog.getLineEndOffset(BattleWindow.this.battleLog.getLineCount() - 1));
                    }
                    catch (BadLocationException exception) {
                        System.out.println("Caught exception: " + exception);
                    }
                    BattleWindow.this.hpField.setText(DQFrame.this.hero.getHP() + "/");
                    BattleWindow.this.mpField.setText(DQFrame.this.hero.getMP() + "/");
                    BattleWindow.this.timer.schedule((TimerTask)new CheckIfMonsterSlain(), 1000L);
                }
            }
        }

        private class HeroCastSpellFirst
        extends TimerTask {
            Spell spell;

            public HeroCastSpellFirst(Spell spellIn) {
                this.spell = spellIn;
            }

            public void run() {
                if (this.spell.getType() == 0) {
                    BattleWindow.this.battleLog.append(((HealingSpell)this.spell).cast(DQFrame.this.hero, DQFrame.this.hero) + "\n");
                } else if (this.spell.getType() == 1) {
                    BattleWindow.this.battleLog.append(((OffensiveSpell)this.spell).cast(DQFrame.this.hero, BattleWindow.this.monster) + "\n");
                } else if (this.spell.getType() == 2) {
                    BattleWindow.this.battleLog.append(((BuffingSpell)this.spell).cast(DQFrame.this.hero, DQFrame.this.hero) + "\n");
                } else if (this.spell.getType() == 3) {
                    BattleWindow.this.battleLog.append(((DebuffingSpell)this.spell).cast(DQFrame.this.hero, BattleWindow.this.monster) + "\n");
                }
                try {
                    BattleWindow.this.battleLog.setCaretPosition(BattleWindow.this.battleLog.getLineEndOffset(BattleWindow.this.battleLog.getLineCount() - 1));
                }
                catch (BadLocationException exception) {
                    System.out.println("Caught exception: " + exception);
                }
                BattleWindow.this.hpField.setText(DQFrame.this.hero.getHP() + "/");
                BattleWindow.this.mpField.setText(DQFrame.this.hero.getMP() + "/");
            }
        }

        private class HeroAttackSecond
        extends TimerTask {
            private HeroAttackSecond() {
            }

            public void run() {
                if (!BattleWindow.this.battleOver) {
                    BattleWindow.this.random = (int)(Math.random() * 100.0);
                    if (BattleWindow.this.random >= 50 - (DQFrame.this.hero.getStat(3) - BattleWindow.this.monster.getStat(5))) {
                        int damage = DQFrame.this.hero.getStat(2) - BattleWindow.this.monster.getStat(4);
                        if (damage <= 0) {
                            damage = 1;
                        }
                        BattleWindow.this.monster.setHP(BattleWindow.this.monster.getHP() - damage);
                        BattleWindow.this.battleLog.append(DQFrame.this.hero.getName() + " hits the " + BattleWindow.this.monster.getName() + " for " + damage + " HP.\n");
                        try {
                            DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/hit.wav"));
                        }
                        catch (IOException exception) {
                            DQFrame.this.soundEffectClip = null;
                        }
                        DQFrame.this.soundEffectClip.play();
                    } else {
                        BattleWindow.this.battleLog.append(DQFrame.this.hero.getName() + " takes a swing at the " + BattleWindow.this.monster.getName() + ", but it evades his attack.\n");
                        try {
                            DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/dodge.wav"));
                        }
                        catch (IOException exception) {
                            DQFrame.this.soundEffectClip = null;
                        }
                        DQFrame.this.soundEffectClip.play();
                    }
                    try {
                        BattleWindow.this.battleLog.setCaretPosition(BattleWindow.this.battleLog.getLineEndOffset(BattleWindow.this.battleLog.getLineCount() - 1));
                    }
                    catch (BadLocationException exception) {
                        System.out.println("Caught exception: " + exception);
                    }
                    BattleWindow.this.timer.schedule((TimerTask)new CheckIfMonsterSlain(), 1000L);
                }
            }
        }

        private class HeroAttackFirst
        extends TimerTask {
            private HeroAttackFirst() {
            }

            public void run() {
                BattleWindow.this.random = (int)(Math.random() * 100.0);
                if (BattleWindow.this.random >= 50 - (DQFrame.this.hero.getStat(3) - BattleWindow.this.monster.getStat(5))) {
                    int damage = DQFrame.this.hero.getStat(2) - BattleWindow.this.monster.getStat(4);
                    if (damage <= 0) {
                        damage = 1;
                    }
                    BattleWindow.this.monster.setHP(BattleWindow.this.monster.getHP() - damage);
                    BattleWindow.this.battleLog.append(DQFrame.this.hero.getName() + " hits the " + BattleWindow.this.monster.getName() + " for " + damage + " HP.\n");
                    try {
                        DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/hit.wav"));
                    }
                    catch (IOException exception) {
                        DQFrame.this.soundEffectClip = null;
                    }
                    DQFrame.this.soundEffectClip.play();
                } else {
                    BattleWindow.this.battleLog.append(DQFrame.this.hero.getName() + " takes a swing at the " + BattleWindow.this.monster.getName() + ", but it evades his attack.\n");
                    try {
                        DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/dodge.wav"));
                    }
                    catch (IOException exception) {
                        DQFrame.this.soundEffectClip = null;
                    }
                    DQFrame.this.soundEffectClip.play();
                }
                try {
                    BattleWindow.this.battleLog.setCaretPosition(BattleWindow.this.battleLog.getLineEndOffset(BattleWindow.this.battleLog.getLineCount() - 1));
                }
                catch (BadLocationException exception) {
                    System.out.println("Caught exception: " + exception);
                }
            }
        }

        private class FleeAction
        implements ActionListener {
            private FleeAction() {
            }

            public void actionPerformed(ActionEvent event) {
                BattleWindow.this.attackButton.setEnabled(false);
                BattleWindow.this.spellsButton.setEnabled(false);
                BattleWindow.this.itemsButton.setEnabled(false);
                BattleWindow.this.fleeButton.setEnabled(false);
                BattleWindow.this.random = (int)(Math.random() * 100.0);
                if (BattleWindow.this.random >= 50 - (DQFrame.this.hero.getLVL() - BattleWindow.this.monster.getLVL())) {
                    BattleWindow.this.battleLog.append(DQFrame.this.hero.getName() + " flees from the " + BattleWindow.this.monster.getName() + ".\n");
                    DQFrame.this.musicClip.stop();
                    try {
                        DQFrame.this.musicClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/dungeon.mid"));
                    }
                    catch (IOException exception) {
                        DQFrame.this.musicClip = null;
                    }
                    DQFrame.this.musicClip.loop();
                    try {
                        DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/stairs.wav"));
                    }
                    catch (IOException exception) {
                        DQFrame.this.soundEffectClip = null;
                    }
                    DQFrame.this.soundEffectClip.play();
                    BattleWindow.this.timer.schedule((TimerTask)new CloseTask(), 2000L);
                } else {
                    BattleWindow.this.battleLog.append(DQFrame.this.hero.getName() + " tries to escape, but the " + BattleWindow.this.monster.getName() + " blocks his path.\n");
                    BattleWindow.this.timer.schedule((TimerTask)new MonsterActionFirst(), 2000L);
                    BattleWindow.this.timer.schedule((TimerTask)new CheckIfHeroSlain(), 3000L);
                    BattleWindow.this.timer.schedule((TimerTask)new EndRound(), 4000L);
                }
            }
        }

        private class ItemsAction
        implements ActionListener {
            private ItemsAction() {
            }

            public void actionPerformed(ActionEvent event) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem[] menuItem = new JMenuItem[10];
                for (int i = 0; i < 10; ++i) {
                    menuItem[i] = new JMenuItem(DQFrame.this.hero.getItem(i).getName() + " x" + DQFrame.this.hero.getItem(i).getQuantity());
                    if (DQFrame.this.hero.getItem(i).getName().equals("") || DQFrame.this.hero.getItem(i).getType() != 5) continue;
                    menuItem[i].setToolTipText(DQFrame.this.hero.getItem(i).getDescription());
                    menuItem[i].addActionListener(new ItemsMenuItemAction(i));
                    popup.add(menuItem[i]);
                }
                popup.show(BattleWindow.this.itemsButton, BattleWindow.this.itemsButton.getWidth() - 1, 0);
            }

            private class ItemsMenuItemAction
            implements ActionListener {
                private int inventorySlot;

                public ItemsMenuItemAction(int slotIn) {
                    this.inventorySlot = slotIn;
                }

                public void actionPerformed(ActionEvent event) {
                    BattleWindow.this.attackButton.setEnabled(false);
                    BattleWindow.this.spellsButton.setEnabled(false);
                    BattleWindow.this.itemsButton.setEnabled(false);
                    BattleWindow.this.fleeButton.setEnabled(false);
                    if (DQFrame.this.hero.getStat(8) >= BattleWindow.this.monster.getStat(8)) {
                        BattleWindow.this.timer.schedule((TimerTask)new HeroUseItemFirst(this.inventorySlot), 0L);
                        BattleWindow.this.timer.schedule((TimerTask)new MonsterActionSecond(), 2000L);
                        BattleWindow.this.timer.schedule((TimerTask)new EndRound(), 4000L);
                    } else {
                        BattleWindow.this.timer.schedule((TimerTask)new MonsterActionFirst(), 0L);
                        BattleWindow.this.timer.schedule((TimerTask)new CheckIfHeroSlain(), 1000L);
                        BattleWindow.this.timer.schedule((TimerTask)new HeroUseItemSecond(this.inventorySlot), 2000L);
                        BattleWindow.this.timer.schedule((TimerTask)new EndRound(), 4000L);
                    }
                }
            }
        }

        private class SpellsAction
        implements ActionListener {
            private SpellsAction() {
            }

            public void actionPerformed(ActionEvent event) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem[] menuItem = new JMenuItem[10];
                for (int i = 0; i < 10; ++i) {
                    menuItem[i] = new JMenuItem(DQFrame.this.hero.getSpell(i).getName());
                    if (DQFrame.this.hero.getSpell(i).getName().equals("")) continue;
                    menuItem[i].setToolTipText(DQFrame.this.hero.getSpell(i).getDescription());
                    menuItem[i].addActionListener(new SpellsMenuItemAction(DQFrame.this.hero.getSpell(i)));
                    if (DQFrame.this.hero.getMP() < DQFrame.this.hero.getSpell(i).getMPcost()) {
                        menuItem[i].setEnabled(false);
                    }
                    popup.add(menuItem[i]);
                }
                popup.show(BattleWindow.this.spellsButton, BattleWindow.this.spellsButton.getWidth() - 1, 0);
            }

            private class SpellsMenuItemAction
            implements ActionListener {
                Spell spell;

                public SpellsMenuItemAction(Spell spellIn) {
                    this.spell = spellIn;
                }

                public void actionPerformed(ActionEvent event) {
                    BattleWindow.this.attackButton.setEnabled(false);
                    BattleWindow.this.spellsButton.setEnabled(false);
                    BattleWindow.this.itemsButton.setEnabled(false);
                    BattleWindow.this.fleeButton.setEnabled(false);
                    if (DQFrame.this.hero.getStat(8) >= BattleWindow.this.monster.getStat(8)) {
                        BattleWindow.this.timer.schedule((TimerTask)new HeroCastSpellFirst(this.spell), 0L);
                        BattleWindow.this.timer.schedule((TimerTask)new CheckIfMonsterSlain(), 1000L);
                        BattleWindow.this.timer.schedule((TimerTask)new MonsterActionSecond(), 2000L);
                        BattleWindow.this.timer.schedule((TimerTask)new EndRound(), 4000L);
                    } else {
                        BattleWindow.this.timer.schedule((TimerTask)new MonsterActionFirst(), 0L);
                        BattleWindow.this.timer.schedule((TimerTask)new CheckIfHeroSlain(), 1000L);
                        BattleWindow.this.timer.schedule((TimerTask)new HeroCastSpellSecond(this.spell), 2000L);
                        BattleWindow.this.timer.schedule((TimerTask)new EndRound(), 4000L);
                    }
                }
            }
        }

        private class AttackAction
        implements ActionListener {
            private AttackAction() {
            }

            public void actionPerformed(ActionEvent event) {
                BattleWindow.this.attackButton.setEnabled(false);
                BattleWindow.this.spellsButton.setEnabled(false);
                BattleWindow.this.itemsButton.setEnabled(false);
                BattleWindow.this.fleeButton.setEnabled(false);
                if (DQFrame.this.hero.getStat(8) >= BattleWindow.this.monster.getStat(8)) {
                    BattleWindow.this.timer.schedule((TimerTask)new HeroAttackFirst(), 0L);
                    BattleWindow.this.timer.schedule((TimerTask)new CheckIfMonsterSlain(), 1000L);
                    BattleWindow.this.timer.schedule((TimerTask)new MonsterActionSecond(), 2000L);
                    BattleWindow.this.timer.schedule((TimerTask)new EndRound(), 4000L);
                } else {
                    BattleWindow.this.timer.schedule((TimerTask)new MonsterActionFirst(), 0L);
                    BattleWindow.this.timer.schedule((TimerTask)new CheckIfHeroSlain(), 1000L);
                    BattleWindow.this.timer.schedule((TimerTask)new HeroAttackSecond(), 2000L);
                    BattleWindow.this.timer.schedule((TimerTask)new EndRound(), 4000L);
                }
            }
        }

        private class BattlePanel
        extends JPanel {
            public BattlePanel() {
                this.setLayout(null);
                BattleWindow.this.attackButton = new JButton("ATTACK");
                BattleWindow.this.spellsButton = new JButton("SPELLS");
                BattleWindow.this.itemsButton = new JButton("ITEMS");
                BattleWindow.this.fleeButton = new JButton("FLEE");
                JLabel nameLabel = new JLabel(DQFrame.this.hero.getName());
                JLabel hpLabel = new JLabel("HP");
                JLabel mpLabel = new JLabel("MP");
                BattleWindow.this.hpField = new JTextField(DQFrame.this.hero.getHP() + "/");
                BattleWindow.this.mpField = new JTextField(DQFrame.this.hero.getMP() + "/");
                BattleWindow.this.maxHpField = new JFormattedTextField(new Integer(DQFrame.this.hero.getStat(0)));
                BattleWindow.this.maxMpField = new JFormattedTextField(new Integer(DQFrame.this.hero.getStat(1)));
                if (BattleWindow.this.monster.getName().charAt(0) == 'a' || BattleWindow.this.monster.getName().charAt(0) == 'e' || BattleWindow.this.monster.getName().charAt(0) == 'i' || BattleWindow.this.monster.getName().charAt(0) == 'o' || BattleWindow.this.monster.getName().charAt(0) == 'u') {
                    BattleWindow.this.battleLog = new JTextArea("An " + BattleWindow.this.monster.getName() + " approaches. ");
                } else {
                    BattleWindow.this.battleLog = new JTextArea("A " + BattleWindow.this.monster.getName() + " approaches. ");
                }
                if (DQFrame.this.hero.getLVL() - BattleWindow.this.monster.getLVL() >= 5) {
                    BattleWindow.this.battleLog.append("This fight looks way too easy.\n");
                } else if (DQFrame.this.hero.getLVL() - BattleWindow.this.monster.getLVL() >= 2 && DQFrame.this.hero.getLVL() - BattleWindow.this.monster.getLVL() <= 4) {
                    BattleWindow.this.battleLog.append("This looks like an easy fight.\n");
                } else if (DQFrame.this.hero.getLVL() - BattleWindow.this.monster.getLVL() >= -1 && DQFrame.this.hero.getLVL() - BattleWindow.this.monster.getLVL() <= 1) {
                    BattleWindow.this.battleLog.append("This looks like a fair fight.\n");
                } else if (DQFrame.this.hero.getLVL() - BattleWindow.this.monster.getLVL() >= -4 && DQFrame.this.hero.getLVL() - BattleWindow.this.monster.getLVL() <= -2) {
                    BattleWindow.this.battleLog.append("This looks like a tough fight.\n");
                } else {
                    BattleWindow.this.battleLog.append("This fight looks hopeless. Fleeing is highly recommended.\n");
                }
                JScrollPane battleLogScrollPane = new JScrollPane(BattleWindow.this.battleLog, 22, 31);
                BattleWindow.this.attackButton.setMargin(new Insets(0, 0, 0, 0));
                BattleWindow.this.attackButton.setSize(60, 20);
                BattleWindow.this.attackButton.setLocation(20, 160);
                BattleWindow.this.spellsButton.setMargin(new Insets(0, 0, 0, 0));
                BattleWindow.this.spellsButton.setSize(60, 20);
                BattleWindow.this.spellsButton.setLocation(20, 190);
                BattleWindow.this.itemsButton.setMargin(new Insets(0, 0, 0, 0));
                BattleWindow.this.itemsButton.setSize(60, 20);
                BattleWindow.this.itemsButton.setLocation(20, 220);
                BattleWindow.this.fleeButton.setMargin(new Insets(0, 0, 0, 0));
                BattleWindow.this.fleeButton.setSize(60, 20);
                BattleWindow.this.fleeButton.setLocation(20, 250);
                nameLabel.setSize(100, 10);
                nameLabel.setLocation(100, 160);
                hpLabel.setSize(20, 10);
                hpLabel.setLocation(100, 175);
                mpLabel.setSize(20, 10);
                mpLabel.setLocation(200, 175);
                BattleWindow.this.hpField.setEditable(false);
                BattleWindow.this.hpField.setFocusable(false);
                BattleWindow.this.hpField.setSize(30, 16);
                BattleWindow.this.hpField.setLocation(120, 172);
                BattleWindow.this.mpField.setEditable(false);
                BattleWindow.this.mpField.setFocusable(false);
                BattleWindow.this.mpField.setSize(30, 16);
                BattleWindow.this.mpField.setLocation(220, 172);
                BattleWindow.this.maxHpField.setEditable(false);
                BattleWindow.this.maxHpField.setFocusable(false);
                BattleWindow.this.maxHpField.setSize(25, 16);
                BattleWindow.this.maxHpField.setLocation(150, 172);
                BattleWindow.this.maxMpField.setEditable(false);
                BattleWindow.this.maxMpField.setFocusable(false);
                BattleWindow.this.maxMpField.setSize(25, 16);
                BattleWindow.this.maxMpField.setLocation(250, 172);
                BattleWindow.this.battleLog.setEditable(false);
                BattleWindow.this.battleLog.setFocusable(false);
                BattleWindow.this.battleLog.setLineWrap(true);
                BattleWindow.this.battleLog.setWrapStyleWord(true);
                battleLogScrollPane.setSize(200, 80);
                battleLogScrollPane.setLocation(100, 190);
                if (DQFrame.this.hero.spellListIsEmpty()) {
                    BattleWindow.this.spellsButton.setEnabled(false);
                }
                if (DQFrame.this.hero.hasNoHealingItems()) {
                    BattleWindow.this.itemsButton.setEnabled(false);
                }
                BattleWindow.this.attackButton.addActionListener(new AttackAction());
                BattleWindow.this.spellsButton.addActionListener(new SpellsAction());
                BattleWindow.this.itemsButton.addActionListener(new ItemsAction());
                BattleWindow.this.fleeButton.addActionListener(new FleeAction());
                this.add(BattleWindow.this.attackButton);
                this.add(BattleWindow.this.spellsButton);
                this.add(BattleWindow.this.itemsButton);
                this.add(BattleWindow.this.fleeButton);
                this.add(nameLabel);
                this.add(hpLabel);
                this.add(BattleWindow.this.hpField);
                this.add(BattleWindow.this.maxHpField);
                this.add(mpLabel);
                this.add(BattleWindow.this.mpField);
                this.add(BattleWindow.this.maxMpField);
                this.add(battleLogScrollPane);
                DQFrame.this.musicClip.stop();
                try {
                    DQFrame.this.musicClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/battle.mid"));
                }
                catch (IOException exception) {
                    DQFrame.this.musicClip = null;
                }
                DQFrame.this.musicClip.loop();
            }

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                BufferedImage monsterImage = null;
                try {
                    monsterImage = ImageIO.read(new File("image_files/" + BattleWindow.this.monster.getImageFileName()));
                }
                catch (IOException exception) {
                    System.out.println("Caught exception: " + exception);
                }
                g.drawImage(monsterImage, 80, 0, null);
            }
        }
    }

    private class ItemShopMenu
    extends JDialog {
        private JTextField[] itemField;
        private JTextField[] itemQuantityField;
        private JTextField buyGoldField;
        private JTextField sellGoldField;

        public ItemShopMenu(JFrame owner) {
            super(owner, "Item Shop", true);
            this.setSize(326, 320);
            this.setLocation(owner.getX(), owner.getY());
            this.setResizable(false);
            this.setFocusable(true);
            this.setDefaultCloseOperation(2);
            JTabbedPane tabbedMenuPane = new JTabbedPane();
            BuyPanel buyPanel = new BuyPanel();
            SellPanel sellPanel = new SellPanel();
            tabbedMenuPane.add("Buy", buyPanel);
            tabbedMenuPane.add("Sell", sellPanel);
            this.add(tabbedMenuPane);
        }

        static /* synthetic */ JTextField[] access$8802(ItemShopMenu x0, JTextField[] x1) {
            x0.itemField = x1;
            return x1;
        }

        static /* synthetic */ JTextField[] access$8902(ItemShopMenu x0, JTextField[] x1) {
            x0.itemQuantityField = x1;
            return x1;
        }

        private class SellPanel
        extends JPanel {
            private JTextArea descriptionArea;
            private JButton sellButton;

            public SellPanel() {
                this.setLayout(null);
                ItemShopMenu.access$8802(ItemShopMenu.this, new JTextField[10]);
                ItemShopMenu.access$8902(ItemShopMenu.this, new JTextField[10]);
                for (int i = 0; i < 10; ++i) {
                    ((ItemShopMenu)ItemShopMenu.this).itemField[i] = new JTextField(DQFrame.this.hero.getItem(i).getName());
                    ((ItemShopMenu)ItemShopMenu.this).itemQuantityField[i] = !DQFrame.this.hero.getItem(i).getName().equals("") ? new JTextField("x" + DQFrame.this.hero.getItem(i).getQuantity()) : new JTextField();
                    ItemShopMenu.this.itemField[i].setEditable(false);
                    ItemShopMenu.this.itemField[i].setLocation(20, 20 + i * 16);
                    ItemShopMenu.this.itemField[i].setSize(100, 16);
                    ItemShopMenu.this.itemQuantityField[i].setEditable(false);
                    ItemShopMenu.this.itemQuantityField[i].setFocusable(false);
                    ItemShopMenu.this.itemQuantityField[i].setLocation(120, 20 + i * 16);
                    ItemShopMenu.this.itemQuantityField[i].setSize(25, 16);
                    ItemShopMenu.this.itemField[i].addMouseListener(new ItemFieldClicked(ItemShopMenu.this.itemField[i]));
                    this.add(ItemShopMenu.this.itemField[i]);
                    this.add(ItemShopMenu.this.itemQuantityField[i]);
                }
                this.descriptionArea = new JTextArea("\"Do you have anything you would like to sell?\"");
                JLabel goldLabel = new JLabel("GOLD");
                ItemShopMenu.this.sellGoldField = new JTextField("" + DQFrame.this.hero.getGold());
                this.sellButton = new JButton("Sell");
                this.descriptionArea.setLineWrap(true);
                this.descriptionArea.setWrapStyleWord(true);
                this.descriptionArea.setEditable(false);
                this.descriptionArea.setFocusable(false);
                this.descriptionArea.setLocation(20, 200);
                this.descriptionArea.setSize(200, 40);
                this.descriptionArea.setFont(new Font("Arial", 0, 10));
                goldLabel.setLocation(165, 167);
                goldLabel.setSize(100, 10);
                ItemShopMenu.this.sellGoldField.setEditable(false);
                ItemShopMenu.this.sellGoldField.setFocusable(false);
                ItemShopMenu.this.sellGoldField.setLocation(200, 164);
                ItemShopMenu.this.sellGoldField.setSize(90, 16);
                this.sellButton.setEnabled(false);
                this.sellButton.setLocation(236, 218);
                this.sellButton.setSize(56, 22);
                this.sellButton.setMargin(new Insets(0, 0, 0, 0));
                this.sellButton.addActionListener(new SellAction());
                this.add(this.descriptionArea);
                this.add(goldLabel);
                this.add(ItemShopMenu.this.sellGoldField);
                this.add(this.sellButton);
            }

            private class SellAction
            implements ActionListener {
                private SellAction() {
                }

                public void actionPerformed(ActionEvent event) {
                    for (int i = 0; i < 10; ++i) {
                        String selectedItem = ItemShopMenu.this.itemField[i].getSelectedText();
                        try {
                            if (selectedItem.equals("")) continue;
                            if (DQFrame.this.hero.getItem(i).getQuantity() > 1) {
                                DQFrame.this.hero.getItem(i).setQuantity(DQFrame.this.hero.getItem(i).getQuantity() - 1);
                                ItemShopMenu.this.itemQuantityField[i].setText("x" + DQFrame.this.hero.getItem(i).getQuantity());
                            } else {
                                if (selectedItem.equals(DQFrame.this.hero.getEquipment(0).getName())) {
                                    DQFrame.this.hero.removeEquipment(0);
                                } else if (selectedItem.equals(DQFrame.this.hero.getEquipment(1).getName())) {
                                    DQFrame.this.hero.removeEquipment(1);
                                } else if (selectedItem.equals(DQFrame.this.hero.getEquipment(2).getName())) {
                                    DQFrame.this.hero.removeEquipment(2);
                                } else if (selectedItem.equals(DQFrame.this.hero.getEquipment(3).getName())) {
                                    DQFrame.this.hero.removeEquipment(3);
                                } else if (selectedItem.equals(DQFrame.this.hero.getEquipment(4).getName())) {
                                    DQFrame.this.hero.removeEquipment(4);
                                }
                                DQFrame.this.hero.setItem((Equipment)DQFrame.this.itemTable.getItem(""), i);
                                ItemShopMenu.this.itemField[i].setText("");
                                ItemShopMenu.this.itemQuantityField[i].setText("");
                                SellPanel.this.descriptionArea.setText("");
                                SellPanel.this.sellButton.setEnabled(false);
                            }
                            DQFrame.this.hero.setGold(DQFrame.this.hero.getGold() + DQFrame.this.itemTable.getItem(selectedItem).getValue() / 2);
                            ItemShopMenu.this.buyGoldField.setText("" + DQFrame.this.hero.getGold());
                            ItemShopMenu.this.sellGoldField.setText("" + DQFrame.this.hero.getGold());
                            break;
                        }
                        catch (NullPointerException exception) {
                            System.out.println("Caught exception: " + exception);
                        }
                    }
                }
            }

            private class ItemFieldClicked
            extends MouseAdapter {
                private JTextField textField;

                public ItemFieldClicked(JTextField fieldClicked) {
                    this.textField = fieldClicked;
                }

                public void mouseReleased(MouseEvent event) {
                    for (int i = 0; i < 10; ++i) {
                        ItemShopMenu.this.itemField[i].setCaretPosition(0);
                    }
                    this.textField.selectAll();
                    SellPanel.this.descriptionArea.setText("Price: " + DQFrame.this.itemTable.getItem(this.textField.getText()).getValue() / 2 + " gold\n" + DQFrame.this.itemTable.getItem(this.textField.getText()).getDescription());
                    if (this.textField.getText().equals("")) {
                        SellPanel.this.sellButton.setEnabled(false);
                        SellPanel.this.descriptionArea.setText("");
                    } else {
                        SellPanel.this.sellButton.setEnabled(true);
                    }
                }
            }
        }

        private class BuyPanel
        extends JPanel {
            private JTextArea inventoryArea;
            private JTextArea descriptionArea;
            private JButton buyButton;

            public BuyPanel() {
                this.setLayout(null);
                this.inventoryArea = new JTextArea("");
                this.inventoryArea.append("herb\n");
                this.inventoryArea.append("potion\n");
                this.inventoryArea.append("strong herb\n");
                this.inventoryArea.append("strong potion\n");
                this.inventoryArea.append("special herb\n");
                this.inventoryArea.append("special potion\n");
                this.inventoryArea.append("warp scroll\n");
                this.inventoryArea.append("minor heal\n");
                this.inventoryArea.append("minor blast\n");
                this.inventoryArea.append("minor strength\n");
                this.inventoryArea.append("minor weakness\n");
                this.inventoryArea.append("minor shield\n");
                this.inventoryArea.append("minor exposure\n");
                this.inventoryArea.append("minor sight\n");
                this.inventoryArea.append("minor blind\n");
                this.inventoryArea.append("minor agility\n");
                this.inventoryArea.append("minor paralysis\n");
                this.inventoryArea.append("minor barrier\n");
                this.inventoryArea.append("minor opening\n");
                this.inventoryArea.append("minor accelerate\n");
                this.inventoryArea.append("minor brakes\n");
                this.inventoryArea.append("minor stupidity\n");
                this.inventoryArea.append("mid heal\n");
                this.inventoryArea.append("mid blast\n");
                this.inventoryArea.append("mid strength\n");
                this.inventoryArea.append("mid weakness\n");
                this.inventoryArea.append("mid shield\n");
                this.inventoryArea.append("mid exposure\n");
                this.inventoryArea.append("mid sight\n");
                this.inventoryArea.append("mid blind\n");
                this.inventoryArea.append("mid agility\n");
                this.inventoryArea.append("mid paralysis\n");
                this.inventoryArea.append("mid barrier\n");
                this.inventoryArea.append("mid opening\n");
                this.inventoryArea.append("mid accelerate\n");
                this.inventoryArea.append("mid brakes\n");
                this.inventoryArea.append("mid stupidity\n");
                this.inventoryArea.append("major heal\n");
                this.inventoryArea.append("major blast\n");
                this.inventoryArea.append("major strength\n");
                this.inventoryArea.append("major weakness\n");
                this.inventoryArea.append("major shield\n");
                this.inventoryArea.append("major exposure\n");
                this.inventoryArea.append("major sight\n");
                this.inventoryArea.append("major blind\n");
                this.inventoryArea.append("major agility\n");
                this.inventoryArea.append("major paralysis\n");
                this.inventoryArea.append("major barrier\n");
                this.inventoryArea.append("major opening\n");
                this.inventoryArea.append("major accelerate\n");
                this.inventoryArea.append("major brakes\n");
                this.inventoryArea.append("major stupidity");
                this.inventoryArea.setCaretPosition(0);
                this.inventoryArea.setEditable(false);
                this.inventoryArea.addMouseListener(new InventoryAreaClicked());
                JScrollPane inventoryScrollPane = new JScrollPane(this.inventoryArea, 22, 31);
                inventoryScrollPane.setLocation(20, 20);
                inventoryScrollPane.setSize(125, 160);
                this.add(inventoryScrollPane);
                this.descriptionArea = new JTextArea("\"Do you see anything you would like to buy?\"");
                JLabel goldLabel = new JLabel("GOLD");
                ItemShopMenu.this.buyGoldField = new JTextField("" + DQFrame.this.hero.getGold());
                this.buyButton = new JButton("Buy");
                this.descriptionArea.setLineWrap(true);
                this.descriptionArea.setWrapStyleWord(true);
                this.descriptionArea.setEditable(false);
                this.descriptionArea.setFocusable(false);
                this.descriptionArea.setLocation(20, 200);
                this.descriptionArea.setSize(200, 40);
                this.descriptionArea.setFont(new Font("Arial", 0, 10));
                goldLabel.setLocation(165, 167);
                goldLabel.setSize(100, 10);
                ItemShopMenu.this.buyGoldField.setEditable(false);
                ItemShopMenu.this.buyGoldField.setFocusable(false);
                ItemShopMenu.this.buyGoldField.setLocation(200, 164);
                ItemShopMenu.this.buyGoldField.setSize(90, 16);
                this.buyButton.setEnabled(false);
                this.buyButton.setLocation(236, 218);
                this.buyButton.setSize(56, 22);
                this.buyButton.setMargin(new Insets(0, 0, 0, 0));
                this.buyButton.addActionListener(new BuyAction());
                this.add(this.descriptionArea);
                this.add(goldLabel);
                this.add(ItemShopMenu.this.buyGoldField);
                this.add(this.buyButton);
            }

            private class BuyAction
            implements ActionListener {
                private BuyAction() {
                }

                public void actionPerformed(ActionEvent event) {
                    try {
                        String selectedItem = BuyPanel.this.inventoryArea.getSelectedText().trim();
                        if (DQFrame.this.itemTable.getItem(selectedItem).getValue() <= DQFrame.this.hero.getGold()) {
                            if (DQFrame.this.hero.hasInInventory(selectedItem) != -1) {
                                int slot = DQFrame.this.hero.hasInInventory(selectedItem);
                                DQFrame.this.hero.getItem(slot).setQuantity(DQFrame.this.hero.getItem(slot).getQuantity() + 1);
                                DQFrame.this.hero.setGold(DQFrame.this.hero.getGold() - DQFrame.this.itemTable.getItem(selectedItem).getValue());
                            } else if (DQFrame.this.hero.firstEmptySlotInInventory() != -1) {
                                DQFrame.this.hero.setItem(DQFrame.this.itemTable.getItem(selectedItem), DQFrame.this.hero.firstEmptySlotInInventory());
                                DQFrame.this.hero.setGold(DQFrame.this.hero.getGold() - DQFrame.this.itemTable.getItem(selectedItem).getValue());
                            } else {
                                BuyPanel.this.descriptionArea.setText("\"I'm sorry, but it looks like your inventory is full. You'll have to make room before you can purchase this item.\"");
                            }
                            ItemShopMenu.this.buyGoldField.setText("" + DQFrame.this.hero.getGold());
                            ItemShopMenu.this.sellGoldField.setText("" + DQFrame.this.hero.getGold());
                            for (int i = 0; i < 10; ++i) {
                                if (DQFrame.this.hero.getItem(i).getName().equals("")) continue;
                                ItemShopMenu.this.itemField[i].setText(DQFrame.this.hero.getItem(i).getName());
                                ItemShopMenu.this.itemQuantityField[i].setText("x" + DQFrame.this.hero.getItem(i).getQuantity());
                            }
                            if (DQFrame.this.hero.getGold() < DQFrame.this.itemTable.getItem(selectedItem).getValue()) {
                                BuyPanel.this.buyButton.setEnabled(false);
                            }
                        }
                    }
                    catch (NullPointerException exception) {
                        System.out.println("Caught exception: " + exception);
                    }
                }
            }

            private class InventoryAreaClicked
            extends MouseAdapter {
                private InventoryAreaClicked() {
                }

                public void mouseReleased(MouseEvent event) {
                    try {
                        BuyPanel.this.inventoryArea.select(BuyPanel.this.inventoryArea.getLineStartOffset(BuyPanel.this.inventoryArea.getLineOfOffset(BuyPanel.this.inventoryArea.getCaretPosition())), BuyPanel.this.inventoryArea.getLineEndOffset(BuyPanel.this.inventoryArea.getLineOfOffset(BuyPanel.this.inventoryArea.getCaretPosition())));
                    }
                    catch (BadLocationException exception) {
                        System.out.println("Caught exception: " + exception);
                    }
                    try {
                        if (!BuyPanel.this.inventoryArea.getSelectedText().equals("")) {
                            String selectedItem = BuyPanel.this.inventoryArea.getSelectedText().trim();
                            BuyPanel.this.descriptionArea.setText("Price: " + DQFrame.this.itemTable.getItem(selectedItem).getValue() + " gold\n" + DQFrame.this.itemTable.getItem(selectedItem).getDescription());
                            if (DQFrame.this.hero.getGold() >= DQFrame.this.itemTable.getItem(selectedItem).getValue()) {
                                BuyPanel.this.buyButton.setEnabled(true);
                            } else {
                                BuyPanel.this.buyButton.setEnabled(false);
                            }
                        }
                    }
                    catch (NullPointerException exception) {
                        BuyPanel.this.descriptionArea.setText("");
                        BuyPanel.this.buyButton.setEnabled(false);
                    }
                }
            }
        }
    }

    private class WeaponAndArmorShopMenu
    extends JDialog {
        private JTextField[] itemField;
        private JTextField[] itemQuantityField;
        private JTextField buyGoldField;
        private JTextField sellGoldField;

        public WeaponAndArmorShopMenu(JFrame owner) {
            super(owner, "Weapon Shop", true);
            this.setSize(326, 320);
            this.setLocation(owner.getX(), owner.getY());
            this.setResizable(false);
            this.setFocusable(true);
            this.setDefaultCloseOperation(2);
            JTabbedPane tabbedMenuPane = new JTabbedPane();
            BuyPanel buyPanel = new BuyPanel();
            SellPanel sellPanel = new SellPanel();
            tabbedMenuPane.add("Buy", buyPanel);
            tabbedMenuPane.add("Sell", sellPanel);
            this.add(tabbedMenuPane);
        }

        static /* synthetic */ JTextField[] access$7602(WeaponAndArmorShopMenu x0, JTextField[] x1) {
            x0.itemField = x1;
            return x1;
        }

        static /* synthetic */ JTextField[] access$7702(WeaponAndArmorShopMenu x0, JTextField[] x1) {
            x0.itemQuantityField = x1;
            return x1;
        }

        private class SellPanel
        extends JPanel {
            private JTextArea descriptionArea;
            private JButton sellButton;

            public SellPanel() {
                this.setLayout(null);
                WeaponAndArmorShopMenu.access$7602(WeaponAndArmorShopMenu.this, new JTextField[10]);
                WeaponAndArmorShopMenu.access$7702(WeaponAndArmorShopMenu.this, new JTextField[10]);
                for (int i = 0; i < 10; ++i) {
                    ((WeaponAndArmorShopMenu)WeaponAndArmorShopMenu.this).itemField[i] = new JTextField(DQFrame.this.hero.getItem(i).getName());
                    ((WeaponAndArmorShopMenu)WeaponAndArmorShopMenu.this).itemQuantityField[i] = !DQFrame.this.hero.getItem(i).getName().equals("") ? new JTextField("x" + DQFrame.this.hero.getItem(i).getQuantity()) : new JTextField();
                    WeaponAndArmorShopMenu.this.itemField[i].setEditable(false);
                    WeaponAndArmorShopMenu.this.itemField[i].setLocation(20, 20 + i * 16);
                    WeaponAndArmorShopMenu.this.itemField[i].setSize(100, 16);
                    WeaponAndArmorShopMenu.this.itemQuantityField[i].setEditable(false);
                    WeaponAndArmorShopMenu.this.itemQuantityField[i].setFocusable(false);
                    WeaponAndArmorShopMenu.this.itemQuantityField[i].setLocation(120, 20 + i * 16);
                    WeaponAndArmorShopMenu.this.itemQuantityField[i].setSize(25, 16);
                    WeaponAndArmorShopMenu.this.itemField[i].addMouseListener(new ItemFieldClicked(WeaponAndArmorShopMenu.this.itemField[i]));
                    this.add(WeaponAndArmorShopMenu.this.itemField[i]);
                    this.add(WeaponAndArmorShopMenu.this.itemQuantityField[i]);
                }
                this.descriptionArea = new JTextArea("\"Do you have anything you would like to sell?\"");
                JLabel goldLabel = new JLabel("GOLD");
                WeaponAndArmorShopMenu.this.sellGoldField = new JTextField("" + DQFrame.this.hero.getGold());
                this.sellButton = new JButton("Sell");
                this.descriptionArea.setLineWrap(true);
                this.descriptionArea.setWrapStyleWord(true);
                this.descriptionArea.setEditable(false);
                this.descriptionArea.setFocusable(false);
                this.descriptionArea.setLocation(20, 200);
                this.descriptionArea.setSize(200, 40);
                this.descriptionArea.setFont(new Font("Arial", 0, 10));
                goldLabel.setLocation(165, 167);
                goldLabel.setSize(100, 10);
                WeaponAndArmorShopMenu.this.sellGoldField.setEditable(false);
                WeaponAndArmorShopMenu.this.sellGoldField.setFocusable(false);
                WeaponAndArmorShopMenu.this.sellGoldField.setLocation(200, 164);
                WeaponAndArmorShopMenu.this.sellGoldField.setSize(90, 16);
                this.sellButton.setEnabled(false);
                this.sellButton.setLocation(236, 218);
                this.sellButton.setSize(56, 22);
                this.sellButton.setMargin(new Insets(0, 0, 0, 0));
                this.sellButton.addActionListener(new SellAction());
                this.add(this.descriptionArea);
                this.add(goldLabel);
                this.add(WeaponAndArmorShopMenu.this.sellGoldField);
                this.add(this.sellButton);
            }

            private class SellAction
            implements ActionListener {
                private SellAction() {
                }

                public void actionPerformed(ActionEvent event) {
                    for (int i = 0; i < 10; ++i) {
                        String selectedItem = WeaponAndArmorShopMenu.this.itemField[i].getSelectedText();
                        try {
                            if (selectedItem.equals("")) continue;
                            if (DQFrame.this.hero.getItem(i).getQuantity() > 1) {
                                DQFrame.this.hero.getItem(i).setQuantity(DQFrame.this.hero.getItem(i).getQuantity() - 1);
                                WeaponAndArmorShopMenu.this.itemQuantityField[i].setText("x" + DQFrame.this.hero.getItem(i).getQuantity());
                            } else {
                                if (selectedItem.equals(DQFrame.this.hero.getEquipment(0).getName())) {
                                    DQFrame.this.hero.removeEquipment(0);
                                } else if (selectedItem.equals(DQFrame.this.hero.getEquipment(1).getName())) {
                                    DQFrame.this.hero.removeEquipment(1);
                                } else if (selectedItem.equals(DQFrame.this.hero.getEquipment(2).getName())) {
                                    DQFrame.this.hero.removeEquipment(2);
                                } else if (selectedItem.equals(DQFrame.this.hero.getEquipment(3).getName())) {
                                    DQFrame.this.hero.removeEquipment(3);
                                } else if (selectedItem.equals(DQFrame.this.hero.getEquipment(4).getName())) {
                                    DQFrame.this.hero.removeEquipment(4);
                                }
                                DQFrame.this.hero.setItem((Equipment)DQFrame.this.itemTable.getItem(""), i);
                                WeaponAndArmorShopMenu.this.itemField[i].setText("");
                                WeaponAndArmorShopMenu.this.itemQuantityField[i].setText("");
                                SellPanel.this.descriptionArea.setText("");
                                SellPanel.this.sellButton.setEnabled(false);
                            }
                            DQFrame.this.hero.setGold(DQFrame.this.hero.getGold() + DQFrame.this.itemTable.getItem(selectedItem).getValue() / 2);
                            WeaponAndArmorShopMenu.this.buyGoldField.setText("" + DQFrame.this.hero.getGold());
                            WeaponAndArmorShopMenu.this.sellGoldField.setText("" + DQFrame.this.hero.getGold());
                            break;
                        }
                        catch (NullPointerException exception) {
                            System.out.println("Caught exception: " + exception);
                        }
                    }
                }
            }

            private class ItemFieldClicked
            extends MouseAdapter {
                private JTextField textField;

                public ItemFieldClicked(JTextField fieldClicked) {
                    this.textField = fieldClicked;
                }

                public void mouseReleased(MouseEvent event) {
                    for (int i = 0; i < 10; ++i) {
                        WeaponAndArmorShopMenu.this.itemField[i].setCaretPosition(0);
                    }
                    this.textField.selectAll();
                    SellPanel.this.descriptionArea.setText("Price: " + DQFrame.this.itemTable.getItem(this.textField.getText()).getValue() / 2 + " gold\n" + DQFrame.this.itemTable.getItem(this.textField.getText()).getDescription());
                    if (this.textField.getText().equals("")) {
                        SellPanel.this.sellButton.setEnabled(false);
                        SellPanel.this.descriptionArea.setText("");
                    } else {
                        SellPanel.this.sellButton.setEnabled(true);
                    }
                }
            }
        }

        private class BuyPanel
        extends JPanel {
            private JTextArea inventoryArea;
            private JTextArea descriptionArea;
            private JButton buyButton;

            public BuyPanel() {
                this.setLayout(null);
                this.inventoryArea = new JTextArea("");
                this.inventoryArea.append("copper sword\n");
                this.inventoryArea.append("leather shield\n");
                this.inventoryArea.append("leather hat\n");
                this.inventoryArea.append("leather armor\n");
                this.inventoryArea.append("copper bracers\n");
                this.inventoryArea.append("copper dagger\n");
                this.inventoryArea.append("leather cap\n");
                this.inventoryArea.append("leather tunic\n");
                this.inventoryArea.append("leather boots\n");
                this.inventoryArea.append("walking stick\n");
                this.inventoryArea.append("fur hood\n");
                this.inventoryArea.append("fur robe\n");
                this.inventoryArea.append("magic ring\n");
                this.inventoryArea.append("bronze sword\n");
                this.inventoryArea.append("bronze shield\n");
                this.inventoryArea.append("bronze helmet\n");
                this.inventoryArea.append("bronze armor\n");
                this.inventoryArea.append("bronze bracers\n");
                this.inventoryArea.append("bronze knife\n");
                this.inventoryArea.append("bandit bandana\n");
                this.inventoryArea.append("bandit tunic\n");
                this.inventoryArea.append("bandit shoes\n");
                this.inventoryArea.append("novice staff\n");
                this.inventoryArea.append("novice hood\n");
                this.inventoryArea.append("novice robe\n");
                this.inventoryArea.append("novice ring\n");
                this.inventoryArea.append("iron sword\n");
                this.inventoryArea.append("iron shield\n");
                this.inventoryArea.append("iron helmet\n");
                this.inventoryArea.append("iron armor\n");
                this.inventoryArea.append("iron gauntlets\n");
                this.inventoryArea.append("iron dagger\n");
                this.inventoryArea.append("robber mask\n");
                this.inventoryArea.append("robber tunic\n");
                this.inventoryArea.append("robber boots\n");
                this.inventoryArea.append("apprentice staff\n");
                this.inventoryArea.append("apprentice hood\n");
                this.inventoryArea.append("apprentice robe\n");
                this.inventoryArea.append("apprentice ring\n");
                this.inventoryArea.append("steel sword\n");
                this.inventoryArea.append("steel shield\n");
                this.inventoryArea.append("steel helmet\n");
                this.inventoryArea.append("steel armor\n");
                this.inventoryArea.append("steel gauntlets\n");
                this.inventoryArea.append("steel dagger\n");
                this.inventoryArea.append("burglar mask\n");
                this.inventoryArea.append("burglar tunic\n");
                this.inventoryArea.append("burglar shoes\n");
                this.inventoryArea.append("journeyman staff\n");
                this.inventoryArea.append("journeyman hat\n");
                this.inventoryArea.append("journeyman robe\n");
                this.inventoryArea.append("journeyman ring\n");
                this.inventoryArea.append("silver sword\n");
                this.inventoryArea.append("silver shield\n");
                this.inventoryArea.append("silver helmet\n");
                this.inventoryArea.append("silver armor\n");
                this.inventoryArea.append("silver bracers\n");
                this.inventoryArea.append("thief dagger\n");
                this.inventoryArea.append("thief cap\n");
                this.inventoryArea.append("thief tunic\n");
                this.inventoryArea.append("thief boots\n");
                this.inventoryArea.append("master staff\n");
                this.inventoryArea.append("master hat\n");
                this.inventoryArea.append("master robe\n");
                this.inventoryArea.append("master ring\n");
                this.inventoryArea.append("platinum sword\n");
                this.inventoryArea.append("platinum shield\n");
                this.inventoryArea.append("platinum helmet\n");
                this.inventoryArea.append("platinum armor\n");
                this.inventoryArea.append("platinum bracers\n");
                this.inventoryArea.append("hunting bow\n");
                this.inventoryArea.append("hunting cap\n");
                this.inventoryArea.append("hunting vest\n");
                this.inventoryArea.append("hunting boots\n");
                this.inventoryArea.append("hermit staff\n");
                this.inventoryArea.append("hermit hood\n");
                this.inventoryArea.append("hermit robe\n");
                this.inventoryArea.append("hermit ring\n");
                this.inventoryArea.append("mythril sword\n");
                this.inventoryArea.append("mythril shield\n");
                this.inventoryArea.append("mythril helmet\n");
                this.inventoryArea.append("mythril armor\n");
                this.inventoryArea.append("mythril gauntlets\n");
                this.inventoryArea.append("katana\n");
                this.inventoryArea.append("ninja mask\n");
                this.inventoryArea.append("ninja gi\n");
                this.inventoryArea.append("ninja soles\n");
                this.inventoryArea.append("wizard staff\n");
                this.inventoryArea.append("wizard hat\n");
                this.inventoryArea.append("wizard robe\n");
                this.inventoryArea.append("wizard ring");
                this.inventoryArea.setCaretPosition(0);
                this.inventoryArea.setEditable(false);
                this.inventoryArea.addMouseListener(new InventoryAreaClicked());
                JScrollPane inventoryScrollPane = new JScrollPane(this.inventoryArea, 22, 31);
                inventoryScrollPane.setLocation(20, 20);
                inventoryScrollPane.setSize(125, 160);
                this.add(inventoryScrollPane);
                this.descriptionArea = new JTextArea("\"Do you see anything you would like to buy?\"");
                JLabel goldLabel = new JLabel("GOLD");
                WeaponAndArmorShopMenu.this.buyGoldField = new JTextField("" + DQFrame.this.hero.getGold());
                this.buyButton = new JButton("Buy");
                this.descriptionArea.setLineWrap(true);
                this.descriptionArea.setWrapStyleWord(true);
                this.descriptionArea.setEditable(false);
                this.descriptionArea.setFocusable(false);
                this.descriptionArea.setLocation(20, 200);
                this.descriptionArea.setSize(200, 40);
                this.descriptionArea.setFont(new Font("Arial", 0, 10));
                goldLabel.setLocation(165, 167);
                goldLabel.setSize(100, 10);
                WeaponAndArmorShopMenu.this.buyGoldField.setEditable(false);
                WeaponAndArmorShopMenu.this.buyGoldField.setFocusable(false);
                WeaponAndArmorShopMenu.this.buyGoldField.setLocation(200, 164);
                WeaponAndArmorShopMenu.this.buyGoldField.setSize(90, 16);
                this.buyButton.setEnabled(false);
                this.buyButton.setLocation(236, 218);
                this.buyButton.setSize(56, 22);
                this.buyButton.setMargin(new Insets(0, 0, 0, 0));
                this.buyButton.addActionListener(new BuyAction());
                this.add(this.descriptionArea);
                this.add(goldLabel);
                this.add(WeaponAndArmorShopMenu.this.buyGoldField);
                this.add(this.buyButton);
            }

            private class BuyAction
            implements ActionListener {
                private BuyAction() {
                }

                public void actionPerformed(ActionEvent event) {
                    try {
                        String selectedItem = BuyPanel.this.inventoryArea.getSelectedText().trim();
                        if (DQFrame.this.itemTable.getItem(selectedItem).getValue() <= DQFrame.this.hero.getGold()) {
                            if (DQFrame.this.hero.hasInInventory(selectedItem) != -1) {
                                int slot = DQFrame.this.hero.hasInInventory(selectedItem);
                                DQFrame.this.hero.getItem(slot).setQuantity(DQFrame.this.hero.getItem(slot).getQuantity() + 1);
                                DQFrame.this.hero.setGold(DQFrame.this.hero.getGold() - DQFrame.this.itemTable.getItem(selectedItem).getValue());
                            } else if (DQFrame.this.hero.firstEmptySlotInInventory() != -1) {
                                DQFrame.this.hero.setItem(DQFrame.this.itemTable.getItem(selectedItem), DQFrame.this.hero.firstEmptySlotInInventory());
                                DQFrame.this.hero.setGold(DQFrame.this.hero.getGold() - DQFrame.this.itemTable.getItem(selectedItem).getValue());
                            } else {
                                BuyPanel.this.descriptionArea.setText("\"I'm sorry, but it looks like your inventory is full. You'll have to make room before you can purchase this item.\"");
                            }
                            WeaponAndArmorShopMenu.this.buyGoldField.setText("" + DQFrame.this.hero.getGold());
                            WeaponAndArmorShopMenu.this.sellGoldField.setText("" + DQFrame.this.hero.getGold());
                            for (int i = 0; i < 10; ++i) {
                                if (DQFrame.this.hero.getItem(i).getName().equals("")) continue;
                                WeaponAndArmorShopMenu.this.itemField[i].setText(DQFrame.this.hero.getItem(i).getName());
                                WeaponAndArmorShopMenu.this.itemQuantityField[i].setText("x" + DQFrame.this.hero.getItem(i).getQuantity());
                            }
                            if (DQFrame.this.hero.getGold() < DQFrame.this.itemTable.getItem(selectedItem).getValue()) {
                                BuyPanel.this.buyButton.setEnabled(false);
                            }
                        }
                    }
                    catch (NullPointerException exception) {
                        System.out.println("Caught exception: " + exception);
                    }
                }
            }

            private class InventoryAreaClicked
            extends MouseAdapter {
                private InventoryAreaClicked() {
                }

                public void mouseReleased(MouseEvent event) {
                    try {
                        BuyPanel.this.inventoryArea.select(BuyPanel.this.inventoryArea.getLineStartOffset(BuyPanel.this.inventoryArea.getLineOfOffset(BuyPanel.this.inventoryArea.getCaretPosition())), BuyPanel.this.inventoryArea.getLineEndOffset(BuyPanel.this.inventoryArea.getLineOfOffset(BuyPanel.this.inventoryArea.getCaretPosition())));
                    }
                    catch (BadLocationException exception) {
                        System.out.println("Caught exception: " + exception);
                    }
                    try {
                        if (!BuyPanel.this.inventoryArea.getSelectedText().equals("")) {
                            String selectedItem = BuyPanel.this.inventoryArea.getSelectedText().trim();
                            BuyPanel.this.descriptionArea.setText("Price: " + DQFrame.this.itemTable.getItem(selectedItem).getValue() + " gold\n" + DQFrame.this.itemTable.getItem(selectedItem).getDescription());
                            if (DQFrame.this.hero.getGold() >= DQFrame.this.itemTable.getItem(selectedItem).getValue()) {
                                BuyPanel.this.buyButton.setEnabled(true);
                            } else {
                                BuyPanel.this.buyButton.setEnabled(false);
                            }
                        }
                    }
                    catch (NullPointerException exception) {
                        BuyPanel.this.descriptionArea.setText("");
                        BuyPanel.this.buyButton.setEnabled(false);
                    }
                }
            }
        }
    }

    private class InnMenu
    extends JDialog {
        private int fee;
        private JTextArea promptArea;
        private JButton yesButton;
        private JButton noButton;
        private JButton goodbyeButton;

        public InnMenu(JFrame owner) {
            super(owner, "", true);
            this.setSize(326, 157);
            this.setLocation(owner.getX(), owner.getY());
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            this.setLayout(new FlowLayout());
            this.fee = DQFrame.this.hero.getLVL() * 10;
            this.promptArea = new JTextArea("\"Welcome weary traveler. Would you like to rest for the night? The fee is " + this.fee + " gold.\"\n\n\n");
            this.yesButton = new JButton("\"Yes please.\"");
            this.noButton = new JButton("\"No thanks.\"");
            this.goodbyeButton = new JButton("\"Goodbye.\"");
            this.promptArea.setLineWrap(true);
            this.promptArea.setWrapStyleWord(true);
            this.promptArea.setEditable(false);
            this.promptArea.setFocusable(false);
            this.promptArea.setSize(320, 100);
            this.yesButton.addActionListener(new YesAction());
            this.noButton.addActionListener(new NoAction());
            this.goodbyeButton.addActionListener(new GoodbyeAction());
            this.add(this.promptArea);
            this.add(this.yesButton);
            this.add(this.noButton);
        }

        private class GoodbyeAction
        implements ActionListener {
            private GoodbyeAction() {
            }

            public void actionPerformed(ActionEvent event) {
                InnMenu.this.dispose();
            }
        }

        private class NoAction
        implements ActionListener {
            private NoAction() {
            }

            public void actionPerformed(ActionEvent event) {
                InnMenu.this.promptArea.setText("\"Alright, have a good day then.\"\n\n\n\n");
                InnMenu.this.remove(InnMenu.this.yesButton);
                InnMenu.this.remove(InnMenu.this.noButton);
                InnMenu.this.add(InnMenu.this.goodbyeButton);
            }
        }

        private class YesAction
        implements ActionListener {
            private YesAction() {
            }

            public void actionPerformed(ActionEvent event) {
                if (DQFrame.this.hero.getGold() >= InnMenu.this.fee) {
                    DQFrame.this.hero.setHP(DQFrame.this.hero.getStat(0));
                    DQFrame.this.hero.setMP(DQFrame.this.hero.getStat(1));
                    DQFrame.this.hero.setGold(DQFrame.this.hero.getGold() - InnMenu.this.fee);
                    InnMenu.this.promptArea.setText("\"I hope you enjoyed your stay. Goodbye.\"\n\n\n\n");
                } else {
                    InnMenu.this.promptArea.setText("\"I'm sorry, but you don't have enough gold. Please come again when you do. Goodbye.\"\n\n\n");
                }
                InnMenu.this.remove(InnMenu.this.yesButton);
                InnMenu.this.remove(InnMenu.this.noButton);
                InnMenu.this.add(InnMenu.this.goodbyeButton);
            }
        }
    }

    private class ChurchMenu
    extends JDialog {
        private JTextArea promptArea;
        private JButton yesButton;
        private JButton noButton;
        private JButton goodbyeButton;

        public ChurchMenu(JFrame owner) {
            super(owner, "", true);
            this.setSize(326, 157);
            this.setLocation(owner.getX(), owner.getY());
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            this.setLayout(new FlowLayout());
            this.promptArea = new JTextArea("\"Welcome. Have you come for confession?\"\n\n\n\n");
            this.yesButton = new JButton("\"Yes.\"");
            this.noButton = new JButton("\"Uhhh...not today.\"");
            this.goodbyeButton = new JButton("\"Goodbye.\"");
            this.promptArea.setLineWrap(true);
            this.promptArea.setWrapStyleWord(true);
            this.promptArea.setEditable(false);
            this.promptArea.setFocusable(false);
            this.promptArea.setSize(320, 100);
            this.yesButton.addActionListener(new YesAction());
            this.noButton.addActionListener(new NoAction());
            this.goodbyeButton.addActionListener(new GoodbyeAction());
            this.add(this.promptArea);
            this.add(this.yesButton);
            this.add(this.noButton);
        }

        private class GoodbyeAction
        implements ActionListener {
            private GoodbyeAction() {
            }

            public void actionPerformed(ActionEvent event) {
                ChurchMenu.this.dispose();
            }
        }

        private class NoAction
        implements ActionListener {
            private NoAction() {
            }

            public void actionPerformed(ActionEvent event) {
                ChurchMenu.this.promptArea.setText("\"Hmmm. You should try to come to confession more often. May the gods watch over you during all your adventures.\"\n\n\n");
                ChurchMenu.this.remove(ChurchMenu.this.yesButton);
                ChurchMenu.this.remove(ChurchMenu.this.noButton);
                ChurchMenu.this.add(ChurchMenu.this.goodbyeButton);
            }
        }

        private class YesAction
        implements ActionListener {
            private YesAction() {
            }

            public void actionPerformed(ActionEvent event) {
                try {
                    ObjectOutputStream objOut = new ObjectOutputStream(new FileOutputStream(DQFrame.this.hero.getName() + ".dq"));
                    objOut.writeObject(DQFrame.this.hero);
                }
                catch (IOException exception) {
                    System.out.println("Caught exception: " + exception);
                }
                ChurchMenu.this.promptArea.setText("\"Bless you. May the gods watch over you during all your adventures.\"\n\n\n");
                ChurchMenu.this.remove(ChurchMenu.this.yesButton);
                ChurchMenu.this.remove(ChurchMenu.this.noButton);
                ChurchMenu.this.add(ChurchMenu.this.goodbyeButton);
            }
        }
    }

    private class MainMenu
    extends JDialog {
        private JTextField hpField;
        private JTextField mpField;
        private JFormattedTextField[] statField;
        private JFormattedTextField spField;
        private JTextField[] spellField;
        private JTextField mpRemainingField;
        private JButton[] incStatButton;
        private JButton[] decStatButton;
        private JButton applyButton;
        private int[] startStat;
        private int startSP;
        private int remainingSP;

        public MainMenu(JFrame owner) {
            super(owner, "Main Menu", true);
            this.setSize(326, 320);
            this.setLocation(owner.getX(), owner.getY());
            this.setResizable(false);
            this.setFocusable(true);
            this.setDefaultCloseOperation(2);
            JTabbedPane tabbedMenuPane = new JTabbedPane();
            StatusPanel statusPanel = new StatusPanel();
            tabbedMenuPane.add("Status", statusPanel);
            InventoryPanel inventoryPanel = new InventoryPanel();
            tabbedMenuPane.add("Inventory", inventoryPanel);
            SpellsPanel spellsPanel = new SpellsPanel();
            tabbedMenuPane.add("Spells", spellsPanel);
            this.add(tabbedMenuPane);
            this.addKeyListener(new KeyHandler());
        }

        static /* synthetic */ int[] access$2702(MainMenu x0, int[] x1) {
            x0.startStat = x1;
            return x1;
        }

        static /* synthetic */ JButton[] access$3002(MainMenu x0, JButton[] x1) {
            x0.decStatButton = x1;
            return x1;
        }

        static /* synthetic */ JFormattedTextField[] access$3402(MainMenu x0, JFormattedTextField[] x1) {
            x0.statField = x1;
            return x1;
        }

        static /* synthetic */ JButton[] access$3502(MainMenu x0, JButton[] x1) {
            x0.incStatButton = x1;
            return x1;
        }

        static /* synthetic */ JTextField[] access$4602(MainMenu x0, JTextField[] x1) {
            x0.spellField = x1;
            return x1;
        }

        private class SpellsPanel
        extends JPanel {
            private JTextArea descriptionArea;
            private JButton removeButton;
            private JButton castButton;

            public SpellsPanel() {
                this.setLayout(null);
                MainMenu.access$4602(MainMenu.this, new JTextField[10]);
                for (int i = 0; i < 10; ++i) {
                    ((MainMenu)MainMenu.this).spellField[i] = new JTextField(DQFrame.this.hero.getSpell(i).getName());
                    MainMenu.this.spellField[i].setEditable(false);
                    MainMenu.this.spellField[i].setLocation(20, 20 + 16 * i);
                    MainMenu.this.spellField[i].setSize(125, 16);
                    MainMenu.this.spellField[i].addMouseListener(new SpellFieldClicked(MainMenu.this.spellField[i]));
                    this.add(MainMenu.this.spellField[i]);
                }
                JLabel descriptionLabel = new JLabel("DESCRIPTION");
                JLabel mpLabel = new JLabel("MP REMAINING");
                descriptionLabel.setSize(100, 10);
                descriptionLabel.setLocation(20, 185);
                mpLabel.setSize(100, 10);
                mpLabel.setLocation(165, 200);
                this.add(descriptionLabel);
                this.add(mpLabel);
                this.descriptionArea = new JTextArea();
                this.descriptionArea.setLineWrap(true);
                this.descriptionArea.setWrapStyleWord(true);
                this.descriptionArea.setEditable(false);
                this.descriptionArea.setFocusable(false);
                this.descriptionArea.setSize(125, 40);
                this.descriptionArea.setLocation(20, 200);
                this.descriptionArea.setFont(new Font("Arial", 0, 10));
                this.add(this.descriptionArea);
                MainMenu.this.mpRemainingField = new JTextField("" + DQFrame.this.hero.getMP());
                MainMenu.this.mpRemainingField.setEditable(false);
                MainMenu.this.mpRemainingField.setFocusable(false);
                MainMenu.this.mpRemainingField.setLocation(255, 197);
                MainMenu.this.mpRemainingField.setSize(35, 16);
                this.add(MainMenu.this.mpRemainingField);
                this.removeButton = new JButton("REMOVE");
                this.castButton = new JButton("CAST");
                this.removeButton.setMargin(new Insets(0, 0, 0, 0));
                this.removeButton.setSize(56, 22);
                this.removeButton.setLocation(165, 218);
                this.removeButton.setEnabled(false);
                this.castButton.setMargin(new Insets(0, 0, 0, 0));
                this.castButton.setSize(56, 22);
                this.castButton.setLocation(236, 218);
                this.castButton.setEnabled(false);
                this.removeButton.addActionListener(new RemoveAction());
                this.castButton.addActionListener(new CastAction());
                this.add(this.removeButton);
                this.add(this.castButton);
            }

            private class RemoveAction
            implements ActionListener {
                private RemoveAction() {
                }

                public void actionPerformed(ActionEvent event) {
                    String selectedSpell = "";
                    for (int i = 0; i < 10; ++i) {
                        selectedSpell = MainMenu.this.spellField[i].getSelectedText();
                        try {
                            if (selectedSpell.equals("")) continue;
                            DQFrame.this.hero.removeSpell(i);
                            MainMenu.this.spellField[i].setText(DQFrame.this.hero.getSpell(i).getName());
                            SpellsPanel.this.descriptionArea.setText("");
                            SpellsPanel.this.removeButton.setEnabled(false);
                            break;
                        }
                        catch (NullPointerException exception) {
                            System.out.println("Caught exception: " + exception);
                        }
                    }
                }
            }

            private class CastAction
            implements ActionListener {
                private CastAction() {
                }

                public void actionPerformed(ActionEvent event) {
                    String selectedSpell = "";
                    for (int i = 0; i < 10; ++i) {
                        selectedSpell = MainMenu.this.spellField[i].getSelectedText();
                        try {
                            if (selectedSpell.equals("")) continue;
                            SpellsPanel.this.descriptionArea.setText(((HealingSpell)DQFrame.this.hero.getSpell(i)).cast(DQFrame.this.hero, DQFrame.this.hero));
                            try {
                                DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/spell.wav"));
                            }
                            catch (IOException exception) {
                                DQFrame.this.soundEffectClip = null;
                            }
                            DQFrame.this.soundEffectClip.play();
                            MainMenu.this.hpField.setText(DQFrame.this.hero.getHP() + "/");
                            break;
                        }
                        catch (NullPointerException exception) {
                            System.out.println("Caught exception: " + exception);
                        }
                    }
                    MainMenu.this.mpField.setText(DQFrame.this.hero.getMP() + "/");
                    MainMenu.this.mpRemainingField.setText("" + DQFrame.this.hero.getMP());
                    if (DQFrame.this.hero.getMP() < DQFrame.this.spellTable.getSpell(selectedSpell).getMPcost()) {
                        SpellsPanel.this.castButton.setEnabled(false);
                    }
                }
            }

            private class SpellFieldClicked
            extends MouseAdapter {
                private JTextField textField;

                public SpellFieldClicked(JTextField fieldClicked) {
                    this.textField = fieldClicked;
                }

                public void mouseReleased(MouseEvent event) {
                    for (int i = 0; i < 10; ++i) {
                        MainMenu.this.spellField[i].setCaretPosition(0);
                    }
                    this.textField.selectAll();
                    SpellsPanel.this.descriptionArea.setText(DQFrame.this.spellTable.getSpell(this.textField.getText()).getDescription());
                    if (this.textField.getText().equals("")) {
                        SpellsPanel.this.castButton.setEnabled(false);
                        SpellsPanel.this.removeButton.setEnabled(false);
                    } else if (DQFrame.this.hero.getMP() >= DQFrame.this.spellTable.getSpell(this.textField.getText()).getMPcost() && DQFrame.this.spellTable.getSpell(this.textField.getText()).getType() == 0) {
                        SpellsPanel.this.castButton.setEnabled(true);
                        SpellsPanel.this.removeButton.setEnabled(true);
                    } else {
                        SpellsPanel.this.castButton.setEnabled(false);
                        SpellsPanel.this.removeButton.setEnabled(true);
                    }
                }
            }
        }

        private class InventoryPanel
        extends JPanel {
            private JTextArea descriptionArea;
            private JTextField[] itemField;
            private JTextField[] itemQuantityField;
            private JTextField[] equipmentField;
            private JButton useButton;
            private JButton removeButton;

            public InventoryPanel() {
                this.setLayout(null);
                this.itemField = new JTextField[10];
                this.itemQuantityField = new JTextField[10];
                for (int i = 0; i < 10; ++i) {
                    this.itemField[i] = new JTextField(DQFrame.this.hero.getItem(i).getName());
                    this.itemField[i].setEditable(false);
                    this.itemField[i].setLocation(20, 20 + i * 16);
                    this.itemField[i].setSize(100, 16);
                    this.itemField[i].addMouseListener(new ItemFieldClicked(this.itemField[i]));
                    this.add(this.itemField[i]);
                    this.itemQuantityField[i] = !DQFrame.this.hero.getItem(i).getName().equals("") ? new JTextField("x" + DQFrame.this.hero.getItem(i).getQuantity()) : new JTextField();
                    this.itemQuantityField[i].setEditable(false);
                    this.itemQuantityField[i].setFocusable(false);
                    this.itemQuantityField[i].setLocation(120, 20 + i * 16);
                    this.itemQuantityField[i].setSize(25, 16);
                    this.add(this.itemQuantityField[i]);
                }
                JLabel descriptionLabel = new JLabel("DESCRIPTION");
                JLabel weaponLabel = new JLabel("WEAPON");
                JLabel shieldLabel = new JLabel("SHIELD");
                JLabel headLabel = new JLabel("HEAD");
                JLabel bodyLabel = new JLabel("BODY");
                JLabel accessoryLabel = new JLabel("ACCESSORY");
                JLabel goldLabel = new JLabel("GOLD");
                descriptionLabel.setSize(100, 10);
                descriptionLabel.setLocation(20, 185);
                weaponLabel.setSize(100, 10);
                weaponLabel.setLocation(165, 20);
                shieldLabel.setSize(100, 10);
                shieldLabel.setLocation(165, 52);
                headLabel.setSize(100, 10);
                headLabel.setLocation(165, 84);
                bodyLabel.setSize(100, 10);
                bodyLabel.setLocation(165, 116);
                accessoryLabel.setSize(100, 10);
                accessoryLabel.setLocation(165, 148);
                goldLabel.setSize(100, 10);
                goldLabel.setLocation(165, 180);
                this.add(descriptionLabel);
                this.add(weaponLabel);
                this.add(shieldLabel);
                this.add(headLabel);
                this.add(bodyLabel);
                this.add(accessoryLabel);
                this.add(goldLabel);
                this.descriptionArea = new JTextArea();
                this.descriptionArea.setLineWrap(true);
                this.descriptionArea.setWrapStyleWord(true);
                this.descriptionArea.setEditable(false);
                this.descriptionArea.setFocusable(false);
                this.descriptionArea.setSize(125, 40);
                this.descriptionArea.setLocation(20, 200);
                this.descriptionArea.setFont(new Font("Arial", 0, 10));
                this.add(this.descriptionArea);
                this.equipmentField = new JTextField[5];
                for (int i = 0; i < 5; ++i) {
                    this.equipmentField[i] = new JTextField(DQFrame.this.hero.getEquipment(i).getName());
                    this.equipmentField[i].setEditable(false);
                    this.equipmentField[i].setLocation(165, 33 + 32 * i);
                    this.equipmentField[i].setSize(125, 16);
                    this.equipmentField[i].addMouseListener(new EquipmentFieldClicked(this.equipmentField[i]));
                    this.add(this.equipmentField[i]);
                }
                JTextField goldField = new JTextField("" + DQFrame.this.hero.getGold());
                goldField.setEditable(false);
                goldField.setFocusable(false);
                goldField.setLocation(165, 193);
                goldField.setSize(125, 16);
                this.add(goldField);
                this.removeButton = new JButton("DROP");
                this.useButton = new JButton("USE");
                this.removeButton.setMargin(new Insets(0, 0, 0, 0));
                this.removeButton.setSize(56, 22);
                this.removeButton.setLocation(165, 218);
                this.removeButton.setEnabled(false);
                this.useButton.setMargin(new Insets(0, 0, 0, 0));
                this.useButton.setSize(56, 22);
                this.useButton.setLocation(236, 218);
                this.useButton.setEnabled(false);
                this.removeButton.addActionListener(new RemoveAction());
                this.useButton.addActionListener(new UseAction());
                this.add(this.removeButton);
                this.add(this.useButton);
            }

            private class RemoveAction
            implements ActionListener {
                private RemoveAction() {
                }

                public void actionPerformed(ActionEvent event) {
                    int j;
                    String selectedItem;
                    int i;
                    for (i = 0; i < 5; ++i) {
                        selectedItem = InventoryPanel.this.equipmentField[i].getSelectedText();
                        try {
                            if (selectedItem.equals("")) continue;
                            DQFrame.this.hero.removeEquipment(i);
                            InventoryPanel.this.equipmentField[i].setText("");
                            MainMenu.this.hpField.setText(DQFrame.this.hero.getHP() + "/");
                            MainMenu.this.mpField.setText(DQFrame.this.hero.getMP() + "/");
                            for (j = 0; j < 9; ++j) {
                                MainMenu.this.statField[j].setValue(new Integer(DQFrame.this.hero.getStat(j)));
                            }
                            MainMenu.this.mpRemainingField.setText("" + DQFrame.this.hero.getMP());
                            for (j = 0; j < 9; ++j) {
                                ((MainMenu)MainMenu.this).startStat[j] = DQFrame.this.hero.getStat(j);
                            }
                            MainMenu.this.startSP = DQFrame.this.hero.getSP();
                            MainMenu.this.remainingSP = MainMenu.this.startSP;
                            MainMenu.this.spField.setValue(new Integer(MainMenu.this.remainingSP));
                            if (MainMenu.this.remainingSP == 0) {
                                for (j = 0; j < 9; ++j) {
                                    MainMenu.this.incStatButton[j].setEnabled(false);
                                }
                            } else {
                                for (j = 0; j < 9; ++j) {
                                    MainMenu.this.incStatButton[j].setEnabled(true);
                                }
                            }
                            if (MainMenu.this.remainingSP == MainMenu.this.startSP) {
                                for (j = 0; j < 9; ++j) {
                                    MainMenu.this.decStatButton[j].setEnabled(false);
                                }
                                MainMenu.this.applyButton.setEnabled(false);
                            }
                            InventoryPanel.this.descriptionArea.setText("");
                            InventoryPanel.this.useButton.setEnabled(false);
                            InventoryPanel.this.removeButton.setEnabled(false);
                            break;
                        }
                        catch (NullPointerException exception) {
                            System.out.println("Caught exception: " + exception);
                        }
                    }
                    for (i = 0; i < 10; ++i) {
                        selectedItem = InventoryPanel.this.itemField[i].getSelectedText();
                        try {
                            if (selectedItem.equals("")) continue;
                            if (DQFrame.this.hero.getItem(i).getQuantity() > 1) {
                                DQFrame.this.hero.getItem(i).setQuantity(DQFrame.this.hero.getItem(i).getQuantity() - 1);
                                InventoryPanel.this.itemQuantityField[i].setText("x" + DQFrame.this.hero.getItem(i).getQuantity());
                            } else {
                                if (selectedItem.equals(DQFrame.this.hero.getEquipment(0).getName())) {
                                    DQFrame.this.hero.removeEquipment(0);
                                    InventoryPanel.this.equipmentField[0].setText("");
                                } else if (selectedItem.equals(DQFrame.this.hero.getEquipment(1).getName())) {
                                    DQFrame.this.hero.removeEquipment(1);
                                    InventoryPanel.this.equipmentField[1].setText("");
                                } else if (selectedItem.equals(DQFrame.this.hero.getEquipment(2).getName())) {
                                    DQFrame.this.hero.removeEquipment(2);
                                    InventoryPanel.this.equipmentField[2].setText("");
                                } else if (selectedItem.equals(DQFrame.this.hero.getEquipment(3).getName())) {
                                    DQFrame.this.hero.removeEquipment(3);
                                    InventoryPanel.this.equipmentField[3].setText("");
                                } else if (selectedItem.equals(DQFrame.this.hero.getEquipment(4).getName())) {
                                    DQFrame.this.hero.removeEquipment(4);
                                    InventoryPanel.this.equipmentField[4].setText("");
                                }
                                DQFrame.this.hero.setItem((Equipment)DQFrame.this.itemTable.getItem(""), i);
                                InventoryPanel.this.itemField[i].setText("");
                                InventoryPanel.this.itemQuantityField[i].setText("");
                                InventoryPanel.this.descriptionArea.setText("");
                                InventoryPanel.this.useButton.setEnabled(false);
                                InventoryPanel.this.removeButton.setEnabled(false);
                            }
                            MainMenu.this.hpField.setText(DQFrame.this.hero.getHP() + "/");
                            MainMenu.this.mpField.setText(DQFrame.this.hero.getMP() + "/");
                            for (j = 0; j < 9; ++j) {
                                MainMenu.this.statField[j].setValue(new Integer(DQFrame.this.hero.getStat(j)));
                            }
                            MainMenu.this.mpRemainingField.setText("" + DQFrame.this.hero.getMP());
                            for (j = 0; j < 9; ++j) {
                                ((MainMenu)MainMenu.this).startStat[j] = DQFrame.this.hero.getStat(j);
                            }
                            MainMenu.this.startSP = DQFrame.this.hero.getSP();
                            MainMenu.this.remainingSP = MainMenu.this.startSP;
                            MainMenu.this.spField.setValue(new Integer(MainMenu.this.remainingSP));
                            if (MainMenu.this.remainingSP == 0) {
                                for (j = 0; j < 9; ++j) {
                                    MainMenu.this.incStatButton[j].setEnabled(false);
                                }
                            } else {
                                for (j = 0; j < 9; ++j) {
                                    MainMenu.this.incStatButton[j].setEnabled(true);
                                }
                            }
                            if (MainMenu.this.remainingSP != MainMenu.this.startSP) break;
                            for (j = 0; j < 9; ++j) {
                                MainMenu.this.decStatButton[j].setEnabled(false);
                            }
                            MainMenu.this.applyButton.setEnabled(false);
                            break;
                        }
                        catch (NullPointerException exception) {
                            System.out.println("Caught exception: " + exception);
                        }
                    }
                }
            }

            private class UseAction
            implements ActionListener {
                private UseAction() {
                }

                public void actionPerformed(ActionEvent event) {
                    for (int i = 0; i < 10; ++i) {
                        String selectedItem = InventoryPanel.this.itemField[i].getSelectedText();
                        try {
                            int j;
                            if (selectedItem.equals("")) continue;
                            if (DQFrame.this.itemTable.getItem(selectedItem).getType() == 5) {
                                InventoryPanel.this.descriptionArea.setText(((HealingItem)DQFrame.this.hero.getItem(i)).use(DQFrame.this.hero));
                                if (DQFrame.this.hero.getItem(i).getQuantity() > 1) {
                                    DQFrame.this.hero.getItem(i).setQuantity(DQFrame.this.hero.getItem(i).getQuantity() - 1);
                                    InventoryPanel.this.itemQuantityField[i].setText("x" + DQFrame.this.hero.getItem(i).getQuantity());
                                } else {
                                    DQFrame.this.hero.setItem((Equipment)DQFrame.this.itemTable.getItem(""), i);
                                    InventoryPanel.this.itemField[i].setText("");
                                    InventoryPanel.this.itemQuantityField[i].setText("");
                                    InventoryPanel.this.removeButton.setEnabled(false);
                                    InventoryPanel.this.useButton.setEnabled(false);
                                }
                            } else if (DQFrame.this.itemTable.getItem(selectedItem).getType() == 6) {
                                InventoryPanel.this.descriptionArea.setText(((MagicScroll)DQFrame.this.hero.getItem(i)).use(DQFrame.this.hero));
                                if (DQFrame.this.hero.getItem(i).getQuantity() > 1) {
                                    DQFrame.this.hero.getItem(i).setQuantity(DQFrame.this.hero.getItem(i).getQuantity() - 1);
                                    InventoryPanel.this.itemQuantityField[i].setText("x" + DQFrame.this.hero.getItem(i).getQuantity());
                                } else {
                                    DQFrame.this.hero.setItem((Equipment)DQFrame.this.itemTable.getItem(""), i);
                                    InventoryPanel.this.itemField[i].setText("");
                                    InventoryPanel.this.itemQuantityField[i].setText("");
                                    InventoryPanel.this.removeButton.setEnabled(false);
                                }
                                InventoryPanel.this.useButton.setEnabled(false);
                                for (j = 0; j < 10; ++j) {
                                    MainMenu.this.spellField[j].setText(DQFrame.this.hero.getSpell(j).getName());
                                }
                            } else if (DQFrame.this.itemTable.getItem(selectedItem).getType() == 7) {
                                ((WarpScroll)DQFrame.this.hero.getItem(i)).use(DQFrame.this.hero, DQFrame.this);
                                if (DQFrame.this.hero.getItem(i).getQuantity() > 1) {
                                    DQFrame.this.hero.getItem(i).setQuantity(DQFrame.this.hero.getItem(i).getQuantity() - 1);
                                } else {
                                    DQFrame.this.hero.setItem((Equipment)DQFrame.this.itemTable.getItem(""), i);
                                }
                                DQFrame.this.mapPanel.repaint();
                                MainMenu.this.dispose();
                            } else {
                                ((Equipment)DQFrame.this.hero.getItem(i)).equip(DQFrame.this.hero);
                                InventoryPanel.this.equipmentField[DQFrame.this.hero.getItem(i).getType()].setText(selectedItem);
                                InventoryPanel.this.equipmentField[DQFrame.this.hero.getItem(i).getType()].selectAll();
                                InventoryPanel.this.itemField[i].setCaretPosition(0);
                                InventoryPanel.this.removeButton.setText("REMOVE");
                                InventoryPanel.this.removeButton.setEnabled(true);
                                InventoryPanel.this.useButton.setEnabled(false);
                            }
                            MainMenu.this.hpField.setText(DQFrame.this.hero.getHP() + "/");
                            MainMenu.this.mpField.setText(DQFrame.this.hero.getMP() + "/");
                            for (j = 0; j < 9; ++j) {
                                MainMenu.this.statField[j].setValue(new Integer(DQFrame.this.hero.getStat(j)));
                            }
                            MainMenu.this.mpRemainingField.setText("" + DQFrame.this.hero.getMP());
                            for (j = 0; j < 9; ++j) {
                                ((MainMenu)MainMenu.this).startStat[j] = DQFrame.this.hero.getStat(j);
                            }
                            MainMenu.this.startSP = DQFrame.this.hero.getSP();
                            MainMenu.this.remainingSP = MainMenu.this.startSP;
                            MainMenu.this.spField.setValue(new Integer(MainMenu.this.remainingSP));
                            if (MainMenu.this.remainingSP == 0) {
                                for (j = 0; j < 9; ++j) {
                                    MainMenu.this.incStatButton[j].setEnabled(false);
                                }
                            } else {
                                for (j = 0; j < 9; ++j) {
                                    MainMenu.this.incStatButton[j].setEnabled(true);
                                }
                            }
                            if (MainMenu.this.remainingSP != MainMenu.this.startSP) break;
                            for (j = 0; j < 9; ++j) {
                                MainMenu.this.decStatButton[j].setEnabled(false);
                            }
                            MainMenu.this.applyButton.setEnabled(false);
                            break;
                        }
                        catch (NullPointerException exception) {
                            System.out.println("Caught exception: " + exception);
                        }
                    }
                }
            }

            private class EquipmentFieldClicked
            extends MouseAdapter {
                private JTextField textField;

                public EquipmentFieldClicked(JTextField fieldClicked) {
                    this.textField = fieldClicked;
                }

                public void mouseReleased(MouseEvent event) {
                    int i;
                    for (i = 0; i < 10; ++i) {
                        InventoryPanel.this.itemField[i].setCaretPosition(0);
                    }
                    for (i = 0; i < 5; ++i) {
                        InventoryPanel.this.equipmentField[i].setCaretPosition(0);
                    }
                    this.textField.selectAll();
                    InventoryPanel.this.descriptionArea.setText(DQFrame.this.itemTable.getItem(this.textField.getText()).getDescription());
                    InventoryPanel.this.useButton.setEnabled(false);
                    if (this.textField.getText().equals("")) {
                        InventoryPanel.this.useButton.setText("EQUIP");
                        InventoryPanel.this.removeButton.setText("REMOVE");
                        InventoryPanel.this.removeButton.setEnabled(false);
                    } else {
                        InventoryPanel.this.useButton.setText("EQUIP");
                        InventoryPanel.this.removeButton.setText("REMOVE");
                        InventoryPanel.this.removeButton.setEnabled(true);
                    }
                }
            }

            private class ItemFieldClicked
            extends MouseAdapter {
                private JTextField textField;

                public ItemFieldClicked(JTextField fieldClicked) {
                    this.textField = fieldClicked;
                }

                public void mouseReleased(MouseEvent event) {
                    int i;
                    for (i = 0; i < 10; ++i) {
                        InventoryPanel.this.itemField[i].setCaretPosition(0);
                    }
                    for (i = 0; i < 5; ++i) {
                        InventoryPanel.this.equipmentField[i].setCaretPosition(0);
                    }
                    this.textField.selectAll();
                    InventoryPanel.this.descriptionArea.setText(DQFrame.this.itemTable.getItem(this.textField.getText()).getDescription());
                    if (this.textField.getText().equals("")) {
                        InventoryPanel.this.useButton.setText("USE");
                        InventoryPanel.this.removeButton.setText("DROP");
                        InventoryPanel.this.useButton.setEnabled(false);
                        InventoryPanel.this.removeButton.setEnabled(false);
                    } else if (DQFrame.this.hero.hasEquipped(this.textField.getSelectedText())) {
                        InventoryPanel.this.useButton.setText("EQUIP");
                        InventoryPanel.this.removeButton.setText("DROP");
                        InventoryPanel.this.useButton.setEnabled(false);
                        InventoryPanel.this.removeButton.setEnabled(true);
                    } else if (DQFrame.this.itemTable.getItem(this.textField.getText()).getType() == 6) {
                        String thisScrollsSpell = ((MagicScroll)DQFrame.this.itemTable.getItem(this.textField.getText())).getSpell().getName();
                        if (DQFrame.this.hero.hasInSpellList(thisScrollsSpell)) {
                            InventoryPanel.this.useButton.setText("USE");
                            InventoryPanel.this.useButton.setEnabled(false);
                        } else {
                            InventoryPanel.this.useButton.setText("USE");
                            InventoryPanel.this.useButton.setEnabled(true);
                        }
                        InventoryPanel.this.removeButton.setText("DROP");
                        InventoryPanel.this.removeButton.setEnabled(true);
                    } else if (DQFrame.this.itemTable.getItem(this.textField.getText()).getType() == 5 || DQFrame.this.itemTable.getItem(this.textField.getText()).getType() == 7) {
                        InventoryPanel.this.useButton.setText("USE");
                        InventoryPanel.this.removeButton.setText("DROP");
                        InventoryPanel.this.useButton.setEnabled(true);
                        InventoryPanel.this.removeButton.setEnabled(true);
                    } else {
                        InventoryPanel.this.useButton.setText("EQUIP");
                        InventoryPanel.this.removeButton.setText("DROP");
                        InventoryPanel.this.useButton.setEnabled(true);
                        InventoryPanel.this.removeButton.setEnabled(true);
                    }
                }
            }
        }

        private class StatusPanel
        extends JPanel {
            public StatusPanel() {
                int i;
                this.setLayout(null);
                MainMenu.access$2702(MainMenu.this, new int[9]);
                for (int i2 = 0; i2 < 9; ++i2) {
                    ((MainMenu)MainMenu.this).startStat[i2] = DQFrame.this.hero.getStat(i2);
                }
                MainMenu.this.startSP = DQFrame.this.hero.getSP();
                MainMenu.this.remainingSP = MainMenu.this.startSP;
                JLabel nameLabel = new JLabel(DQFrame.this.hero.getName());
                JLabel lvlLabel = new JLabel("LVL " + DQFrame.this.hero.getLVL());
                JLabel hpLabel = new JLabel("HP");
                JLabel mpLabel = new JLabel("MP");
                JLabel atkLabel = new JLabel("ATK");
                JLabel accLabel = new JLabel("ACC");
                JLabel defLabel = new JLabel("DEF");
                JLabel evaLabel = new JLabel("EVA");
                JLabel wisLabel = new JLabel("WIS");
                JLabel mdefLabel = new JLabel("MDEF");
                JLabel spdLabel = new JLabel("SPD");
                JLabel spLabel = new JLabel("SP");
                JLabel expLabel = new JLabel("EXP");
                JLabel expValueLabel = new JLabel("" + DQFrame.this.hero.getEXP());
                nameLabel.setSize(100, 10);
                nameLabel.setLocation(20, 15);
                lvlLabel.setSize(100, 10);
                lvlLabel.setLocation(100, 15);
                hpLabel.setSize(100, 10);
                hpLabel.setLocation(20, 35);
                mpLabel.setSize(100, 10);
                mpLabel.setLocation(20, 55);
                atkLabel.setSize(100, 10);
                atkLabel.setLocation(20, 75);
                accLabel.setSize(100, 10);
                accLabel.setLocation(20, 95);
                defLabel.setSize(100, 10);
                defLabel.setLocation(20, 115);
                evaLabel.setSize(100, 10);
                evaLabel.setLocation(20, 135);
                wisLabel.setSize(100, 10);
                wisLabel.setLocation(20, 155);
                mdefLabel.setSize(100, 10);
                mdefLabel.setLocation(20, 175);
                spdLabel.setSize(100, 10);
                spdLabel.setLocation(20, 195);
                spLabel.setSize(100, 10);
                spLabel.setLocation(20, 215);
                expLabel.setSize(100, 10);
                expLabel.setLocation(20, 235);
                expValueLabel.setSize(100, 10);
                expValueLabel.setLocation(100, 235);
                this.add(nameLabel);
                this.add(lvlLabel);
                this.add(hpLabel);
                this.add(mpLabel);
                this.add(atkLabel);
                this.add(accLabel);
                this.add(defLabel);
                this.add(evaLabel);
                this.add(wisLabel);
                this.add(mdefLabel);
                this.add(spdLabel);
                this.add(spLabel);
                this.add(expLabel);
                this.add(expValueLabel);
                MainMenu.access$3002(MainMenu.this, new JButton[9]);
                for (i = 0; i < 9; ++i) {
                    ((MainMenu)MainMenu.this).decStatButton[i] = new JButton("-");
                    MainMenu.this.decStatButton[i].setMargin(new Insets(0, 0, 0, 0));
                    MainMenu.this.decStatButton[i].setSize(16, 16);
                    MainMenu.this.decStatButton[i].setLocation(84, 32 + 20 * i);
                    MainMenu.this.decStatButton[i].addActionListener(new DecStatAction(i));
                    this.add(MainMenu.this.decStatButton[i]);
                }
                MainMenu.this.hpField = new JTextField(DQFrame.this.hero.getHP() + "/");
                MainMenu.this.mpField = new JTextField(DQFrame.this.hero.getMP() + "/");
                MainMenu.this.spField = new JFormattedTextField(NumberFormat.getIntegerInstance());
                MainMenu.this.hpField.setEditable(false);
                MainMenu.this.hpField.setFocusable(false);
                MainMenu.this.hpField.setSize(30, 16);
                MainMenu.this.hpField.setLocation(100, 32);
                MainMenu.this.mpField.setEditable(false);
                MainMenu.this.mpField.setFocusable(false);
                MainMenu.this.mpField.setSize(30, 16);
                MainMenu.this.mpField.setLocation(100, 52);
                MainMenu.this.spField.setValue(new Integer(MainMenu.this.remainingSP));
                MainMenu.this.spField.setEditable(false);
                MainMenu.this.spField.setFocusable(false);
                MainMenu.this.spField.setSize(25, 16);
                MainMenu.this.spField.setLocation(100, 212);
                this.add(MainMenu.this.hpField);
                this.add(MainMenu.this.mpField);
                this.add(MainMenu.this.spField);
                MainMenu.access$3402(MainMenu.this, new JFormattedTextField[9]);
                for (i = 0; i < 9; ++i) {
                    ((MainMenu)MainMenu.this).statField[i] = new JFormattedTextField(NumberFormat.getIntegerInstance());
                    MainMenu.this.statField[i].setValue(new Integer(DQFrame.this.hero.getStat(i)));
                    MainMenu.this.statField[i].setEditable(false);
                    MainMenu.this.statField[i].setFocusable(false);
                    MainMenu.this.statField[i].setSize(25, 16);
                    if (i == 0 || i == 1) {
                        MainMenu.this.statField[i].setLocation(130, 32 + 20 * i);
                    } else {
                        MainMenu.this.statField[i].setLocation(100, 32 + 20 * i);
                    }
                    this.add(MainMenu.this.statField[i]);
                }
                MainMenu.access$3502(MainMenu.this, new JButton[9]);
                for (i = 0; i < 9; ++i) {
                    ((MainMenu)MainMenu.this).incStatButton[i] = new JButton("+");
                    MainMenu.this.incStatButton[i].setMargin(new Insets(0, 0, 0, 0));
                    MainMenu.this.incStatButton[i].setSize(16, 16);
                    if (i == 0 || i == 1) {
                        MainMenu.this.incStatButton[i].setLocation(155, 32 + 20 * i);
                    } else {
                        MainMenu.this.incStatButton[i].setLocation(125, 32 + 20 * i);
                    }
                    MainMenu.this.incStatButton[i].addActionListener(new IncStatAction(i));
                    this.add(MainMenu.this.incStatButton[i]);
                }
                MainMenu.this.applyButton = new JButton("APPLY");
                MainMenu.this.applyButton.setMargin(new Insets(0, 0, 0, 0));
                MainMenu.this.applyButton.setSize(56, 22);
                MainMenu.this.applyButton.setLocation(236, 218);
                MainMenu.this.applyButton.addActionListener(new ApplyAction());
                this.add(MainMenu.this.applyButton);
                if (MainMenu.this.remainingSP == 0) {
                    for (i = 0; i < 9; ++i) {
                        MainMenu.this.incStatButton[i].setEnabled(false);
                    }
                }
                if (MainMenu.this.remainingSP == MainMenu.this.startSP) {
                    for (i = 0; i < 9; ++i) {
                        MainMenu.this.decStatButton[i].setEnabled(false);
                    }
                    MainMenu.this.applyButton.setEnabled(false);
                }
            }

            private class ApplyAction
            implements ActionListener {
                private ApplyAction() {
                }

                public void actionPerformed(ActionEvent event) {
                    for (int i = 0; i < 9; ++i) {
                        Number value = (Number)MainMenu.this.statField[i].getValue();
                        DQFrame.this.hero.setStat(new Integer(value.intValue()), i);
                        ((MainMenu)MainMenu.this).startStat[i] = DQFrame.this.hero.getStat(i);
                        MainMenu.this.decStatButton[i].setEnabled(false);
                    }
                    DQFrame.this.hero.setSP(MainMenu.this.remainingSP);
                    MainMenu.this.startSP = DQFrame.this.hero.getSP();
                    MainMenu.this.applyButton.setEnabled(false);
                }
            }

            private class IncStatAction
            implements ActionListener {
                private int stat;

                public IncStatAction(int statIn) {
                    this.stat = statIn;
                }

                public void actionPerformed(ActionEvent event) {
                    if (MainMenu.this.remainingSP > 0) {
                        Number value = (Number)MainMenu.this.statField[this.stat].getValue();
                        int v = value.intValue();
                        v = this.stat == 0 ? (v += 10) : (this.stat == 1 ? (v += 5) : ++v);
                        MainMenu.this.statField[this.stat].setValue(new Integer(v));
                        MainMenu.this.remainingSP--;
                        MainMenu.this.spField.setValue(new Integer(MainMenu.this.remainingSP));
                        MainMenu.this.decStatButton[this.stat].setEnabled(true);
                        if (MainMenu.this.remainingSP == 0) {
                            for (int i = 0; i < 9; ++i) {
                                MainMenu.this.incStatButton[i].setEnabled(false);
                            }
                        }
                        MainMenu.this.applyButton.setEnabled(true);
                    }
                }
            }

            private class DecStatAction
            implements ActionListener {
                private int stat;

                public DecStatAction(int statIn) {
                    this.stat = statIn;
                }

                public void actionPerformed(ActionEvent event) {
                    Number value;
                    int v;
                    if (MainMenu.this.remainingSP < MainMenu.this.startSP && (v = (value = (Number)MainMenu.this.statField[this.stat].getValue()).intValue()) > 0) {
                        int i;
                        v = this.stat == 0 ? (v -= 10) : (this.stat == 1 ? (v -= 5) : --v);
                        MainMenu.this.statField[this.stat].setValue(new Integer(v));
                        MainMenu.this.remainingSP++;
                        MainMenu.this.spField.setValue(new Integer(MainMenu.this.remainingSP));
                        for (i = 0; i < 9; ++i) {
                            MainMenu.this.incStatButton[i].setEnabled(true);
                        }
                        if (MainMenu.this.remainingSP == MainMenu.this.startSP) {
                            for (i = 0; i < 9; ++i) {
                                MainMenu.this.decStatButton[i].setEnabled(false);
                            }
                            MainMenu.this.applyButton.setEnabled(false);
                        }
                        if (v == MainMenu.this.startStat[this.stat]) {
                            MainMenu.this.decStatButton[this.stat].setEnabled(false);
                        }
                    }
                }
            }
        }

        private class KeyHandler
        extends KeyAdapter {
            private KeyHandler() {
            }

            public void keyPressed(KeyEvent event) {
                int key = event.getKeyCode();
                if (key == 27) {
                    MainMenu.this.dispose();
                }
            }
        }
    }

    public class MapPanel
    extends JPanel {
        private int upperLeftX;
        private int upperLeftY;
        private int lowerRightX;
        private int lowerRightY;
        private int mapWidth;
        private int mapHeight;
        private int heroFacing = 0;
        private int currentMap = 0;
        private Map map;
        private Image mapImage;
        private Image heroImage;
        public static final int TITLE = 0;
        public static final int WORLD = 1;
        public static final int TOWN = 2;
        public static final int DUNGEON = 3;
        public static final int FRONT = 0;
        public static final int BACK = 1;
        public static final int RIGHT = 2;
        public static final int LEFT = 3;

        public MapPanel() {
            DQFrame.this.dungeonLevel = 0;
            DQFrame.this.encounterCounter = -1;
            DQFrame.this.gameOver = false;
            this.addKeyListener(new KeyHandler());
            this.setFocusable(true);
            try {
                this.mapImage = ImageIO.read(new File("image_files/title_screen.gif"));
                DQFrame.this.musicClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/title.mid"));
            }
            catch (IOException exception) {
                DQFrame.this.musicClip = null;
            }
            DQFrame.this.musicClip.play();
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.mapImage == null) {
                return;
            }
            if (this.currentMap == 0) {
                g.drawImage(this.mapImage, 0, 0, null);
            } else {
                this.map.drawMap(g, this.upperLeftX, this.upperLeftY, this.lowerRightX, this.lowerRightY);
                try {
                    if (this.heroFacing == 0) {
                        this.heroImage = ImageIO.read(new File("image_files/hero1.gif"));
                    }
                    if (this.heroFacing == 1) {
                        this.heroImage = ImageIO.read(new File("image_files/hero3.gif"));
                    }
                    if (this.heroFacing == 2) {
                        this.heroImage = ImageIO.read(new File("image_files/hero6.gif"));
                    }
                    if (this.heroFacing == 3) {
                        this.heroImage = ImageIO.read(new File("image_files/hero7.gif"));
                    }
                }
                catch (IOException exception) {
                    System.out.println("Caught exception: " + exception);
                }
                g.drawImage(this.heroImage, 160, 128, null);
            }
        }

        public void setUpWorldMap(int heroColumnIn, int heroRowIn) {
            this.currentMap = 1;
            this.map = new WorldMap(heroColumnIn, heroRowIn);
            this.upperLeftX = (this.map.getHeroColumn() - 5) * 32;
            this.upperLeftY = (this.map.getHeroRow() - 4) * 32;
            this.lowerRightX = (this.map.getHeroColumn() + 5) * 32;
            this.lowerRightY = (this.map.getHeroRow() + 5) * 32;
            this.mapImage = this.map.getImage();
            this.mapWidth = this.map.getWidth() * 32;
            this.mapHeight = this.map.getHeight() * 32;
            DQFrame.this.musicClip.stop();
            try {
                DQFrame.this.musicClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/world.mid"));
            }
            catch (IOException exception) {
                DQFrame.this.musicClip = null;
            }
            DQFrame.this.musicClip.loop();
        }

        public void setUpTownMap(int heroColumnIn, int heroRowIn) {
            this.currentMap = 2;
            this.map = new TownMap(heroColumnIn, heroRowIn);
            this.upperLeftX = (this.map.getHeroColumn() - 5) * 32;
            this.upperLeftY = (this.map.getHeroRow() - 4) * 32;
            this.lowerRightX = (this.map.getHeroColumn() + 5) * 32;
            this.lowerRightY = (this.map.getHeroRow() + 5) * 32;
            this.mapImage = this.map.getImage();
            this.mapWidth = this.map.getWidth() * 32;
            this.mapHeight = this.map.getHeight() * 32;
            DQFrame.this.musicClip.stop();
            try {
                DQFrame.this.musicClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/town.mid"));
            }
            catch (IOException exception) {
                DQFrame.this.musicClip = null;
            }
            DQFrame.this.musicClip.loop();
        }

        public void setUpDungeonMap(int levelChange) {
            try {
                DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/stairs.wav"));
            }
            catch (IOException exception) {
                DQFrame.this.soundEffectClip = null;
            }
            DQFrame.this.soundEffectClip.play();
            this.currentMap = 3;
            DQFrame.this.dungeonLevel += levelChange;
            if (DQFrame.this.dungeonLevel > 0) {
                this.map = new DungeonMap(DQFrame.this.dungeonLevel, levelChange);
                this.upperLeftX = (this.map.getHeroColumn() - 5) * 32;
                this.upperLeftY = (this.map.getHeroRow() - 4) * 32;
                this.lowerRightX = (this.map.getHeroColumn() + 5) * 32;
                this.lowerRightY = (this.map.getHeroRow() + 5) * 32;
                this.mapImage = this.map.getImage();
                this.mapWidth = this.map.getWidth() * 32;
                this.mapHeight = this.map.getHeight() * 32;
            } else {
                this.setUpWorldMap(15, 5);
            }
        }

        public int getCurrentMap() {
            return this.currentMap;
        }

        public int getDungeonLevel() {
            return DQFrame.this.dungeonLevel;
        }

        public void setDungeonLevel(int levelIn) {
            DQFrame.this.dungeonLevel = levelIn;
        }

        public void setHeroFacing(int directionIn) {
            this.heroFacing = directionIn;
        }

        private class NameEntryPrompt
        extends JDialog {
            private JDialog owner;
            private JFormattedTextField nameField;

            public NameEntryPrompt(JDialog ownerIn) {
                super(ownerIn, "", true);
                this.owner = ownerIn;
                this.setSize(150, 100);
                this.setLocation(this.owner.getX(), this.owner.getY());
                this.setResizable(false);
                this.setDefaultCloseOperation(2);
                this.setLayout(new FlowLayout());
                JLabel promptLabel = new JLabel("Enter your name:");
                try {
                    this.nameField = new JFormattedTextField(new MaskFormatter("**********"));
                    this.nameField.setColumns(8);
                }
                catch (Exception exception) {
                    System.out.println("Caught exception: " + exception);
                }
                JButton doneButton = new JButton("DONE");
                doneButton.setMargin(new Insets(0, 0, 0, 0));
                doneButton.addActionListener(new DoneAction());
                this.add(promptLabel);
                this.add(this.nameField);
                this.add(doneButton);
            }

            private class DoneAction
            implements ActionListener {
                private DoneAction() {
                }

                public void actionPerformed(ActionEvent event) {
                    DQFrame.this.hero.setName(NameEntryPrompt.this.nameField.getText().trim());
                    MapPanel.this.setUpWorldMap(5, 14);
                    NameEntryPrompt.this.owner.dispose();
                    NameEntryPrompt.this.dispose();
                }
            }
        }

        private class TitleMenu
        extends JDialog {
            public TitleMenu(JFrame owner) {
                super(owner, "", true);
                this.setSize(150, 100);
                this.setLocation(owner.getX() + 88, owner.getY() + 160);
                this.setResizable(false);
                this.setDefaultCloseOperation(2);
                this.setLayout(new FlowLayout());
                JButton newGameButton = new JButton("Start New Game");
                JButton loadGameButton = new JButton("Load Saved Game");
                newGameButton.setMargin(new Insets(2, 15, 2, 15));
                loadGameButton.setMargin(new Insets(2, 10, 2, 10));
                newGameButton.addActionListener(new NewGameAction());
                loadGameButton.addActionListener(new LoadGameAction());
                this.add(newGameButton);
                this.add(loadGameButton);
            }

            private class LoadGameAction
            implements ActionListener {
                private LoadGameAction() {
                }

                public void actionPerformed(ActionEvent event) {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setFileFilter(new DQFileFilter());
                    chooser.setAcceptAllFileFilterUsed(false);
                    chooser.setCurrentDirectory(new File("."));
                    chooser.showOpenDialog(DQFrame.this);
                    String fileName = chooser.getSelectedFile().getPath();
                    try {
                        ObjectInputStream objIn = new ObjectInputStream(new FileInputStream(fileName));
                        DQFrame.this.hero = (Hero)objIn.readObject();
                    }
                    catch (IOException exception) {
                        System.out.println("Caught exception: " + exception);
                    }
                    catch (ClassNotFoundException exception) {
                        System.out.println("Caught exception: " + exception);
                    }
                    MapPanel.this.heroFacing = 2;
                    MapPanel.this.setUpTownMap(27, 8);
                    TitleMenu.this.dispose();
                }
            }

            private class NewGameAction
            implements ActionListener {
                private NewGameAction() {
                }

                public void actionPerformed(ActionEvent event) {
                    new NameEntryPrompt(TitleMenu.this).show();
                }
            }
        }

        private class TreasureChestPrompt
        extends JDialog {
            private JTextArea promptArea;
            private JButton takeButton;
            private JButton yesButton;
            private JButton noButton;
            private TreasureChest chest;

            public TreasureChestPrompt(JFrame owner, TreasureChest chestIn) {
                super(owner, "", true);
                this.setSize(326, 157);
                this.setLocation(owner.getX(), owner.getY());
                this.setResizable(false);
                this.setDefaultCloseOperation(0);
                this.setLayout(new FlowLayout());
                this.chest = chestIn;
                this.promptArea = new JTextArea(DQFrame.this.hero.getName() + " opens the chest. It contains:     " + this.chest.getContents().getName() + "\n");
                this.promptArea.setLineWrap(true);
                this.promptArea.setWrapStyleWord(true);
                this.promptArea.setEditable(false);
                this.promptArea.setFocusable(false);
                this.promptArea.setSize(320, 100);
                this.add(this.promptArea);
                this.takeButton = new JButton("Take it");
                this.yesButton = new JButton("Yes");
                this.noButton = new JButton("No");
                this.takeButton.addActionListener(new TakeAction());
                this.yesButton.addActionListener(new YesAction());
                this.noButton.addActionListener(new NoAction());
                if (DQFrame.this.hero.firstEmptySlotInInventory() != -1 || DQFrame.this.hero.hasInInventory(this.chest.getContents().getName()) != -1) {
                    this.promptArea.append("\n\n\n");
                    this.add(this.takeButton);
                } else {
                    this.promptArea.append(DQFrame.this.hero.getName() + "'s inventory is full. Would you like to make room for this item?\n" + "Warning: Choosing \"No\" will destroy the chest along with its contents.");
                    this.add(this.yesButton);
                    this.add(this.noButton);
                }
            }

            private class NoAction
            implements ActionListener {
                private NoAction() {
                }

                public void actionPerformed(ActionEvent event) {
                    ((MazeTile)MapPanel.this.map.getTile(TreasureChestPrompt.this.chest.getColumn(), TreasureChestPrompt.this.chest.getRow())).setTreasureChest(false);
                    ((MazeTile)MapPanel.this.map.getTile(TreasureChestPrompt.this.chest.getColumn(), TreasureChestPrompt.this.chest.getRow())).setPassable(true);
                    TreasureChestPrompt.this.dispose();
                }
            }

            private class TakeAction
            implements ActionListener {
                private TakeAction() {
                }

                public void actionPerformed(ActionEvent event) {
                    String itemName = TreasureChestPrompt.this.chest.getContents().getName();
                    if (DQFrame.this.hero.hasInInventory(itemName) != -1) {
                        int itemQuantity = DQFrame.this.hero.getItem(DQFrame.this.hero.hasInInventory(itemName)).getQuantity();
                        DQFrame.this.hero.getItem(DQFrame.this.hero.hasInInventory(itemName)).setQuantity(itemQuantity + 1);
                    } else {
                        DQFrame.this.hero.setItem(TreasureChestPrompt.this.chest.getContents(), DQFrame.this.hero.firstEmptySlotInInventory());
                    }
                    ((MazeTile)MapPanel.this.map.getTile(TreasureChestPrompt.this.chest.getColumn(), TreasureChestPrompt.this.chest.getRow())).setTreasureChest(false);
                    ((MazeTile)MapPanel.this.map.getTile(TreasureChestPrompt.this.chest.getColumn(), TreasureChestPrompt.this.chest.getRow())).setPassable(true);
                    TreasureChestPrompt.this.dispose();
                }
            }

            private class YesAction
            implements ActionListener {
                private YesAction() {
                }

                public void actionPerformed(ActionEvent event) {
                    TreasureChestPrompt.this.dispose();
                }
            }
        }

        private class KeyHandler
        extends KeyAdapter {
            private KeyHandler() {
            }

            public void keyReleased(KeyEvent event) {
                int key = event.getKeyCode();
                if (DQFrame.this.gameOver) {
                    DQFrame.this.hero = new Hero();
                    DQFrame.this.itemTable = new ItemLookUpTable();
                    DQFrame.this.spellTable = new SpellLookUpTable();
                    MapPanel.this.heroFacing = 0;
                    MapPanel.this.currentMap = 0;
                    DQFrame.this.dungeonLevel = 0;
                    DQFrame.this.encounterCounter = -1;
                    DQFrame.this.gameOver = false;
                    DQFrame.this.musicClip.stop();
                    try {
                        MapPanel.this.mapImage = ImageIO.read(new File("image_files/title_screen.gif"));
                        DQFrame.this.musicClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/title.mid"));
                    }
                    catch (IOException exception) {
                        DQFrame.this.musicClip = null;
                    }
                    DQFrame.this.musicClip.play();
                } else if (key == 37) {
                    if (MapPanel.this.map.getTile(MapPanel.this.map.getHeroColumn() - 1, MapPanel.this.map.getHeroRow()).isPassable()) {
                        MapPanel.this.upperLeftX -= 32;
                        MapPanel.this.lowerRightX -= 32;
                        MapPanel.this.map.moveHeroLeft();
                        if (MapPanel.this.currentMap == 3) {
                            DQFrame.this.encounterCounter--;
                        }
                    } else {
                        DQFrame.this.soundEffectClip.stop();
                        try {
                            DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/bump.wav"));
                        }
                        catch (IOException exception) {
                            DQFrame.this.soundEffectClip = null;
                        }
                        DQFrame.this.soundEffectClip.play();
                    }
                    MapPanel.this.heroFacing = 3;
                } else if (key == 39) {
                    if (MapPanel.this.map.getTile(MapPanel.this.map.getHeroColumn() + 1, MapPanel.this.map.getHeroRow()).isPassable()) {
                        MapPanel.this.upperLeftX += 32;
                        MapPanel.this.lowerRightX += 32;
                        MapPanel.this.map.moveHeroRight();
                        if (MapPanel.this.currentMap == 3) {
                            DQFrame.this.encounterCounter--;
                        }
                    } else {
                        DQFrame.this.soundEffectClip.stop();
                        try {
                            DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/bump.wav"));
                        }
                        catch (IOException exception) {
                            DQFrame.this.soundEffectClip = null;
                        }
                        DQFrame.this.soundEffectClip.play();
                    }
                    MapPanel.this.heroFacing = 2;
                } else if (key == 38) {
                    if (MapPanel.this.map.getTile(MapPanel.this.map.getHeroColumn(), MapPanel.this.map.getHeroRow() - 1).isPassable()) {
                        MapPanel.this.upperLeftY -= 32;
                        MapPanel.this.lowerRightY -= 32;
                        MapPanel.this.map.moveHeroUp();
                        if (MapPanel.this.currentMap == 3) {
                            DQFrame.this.encounterCounter--;
                        }
                    } else {
                        DQFrame.this.soundEffectClip.stop();
                        try {
                            DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/bump.wav"));
                        }
                        catch (IOException exception) {
                            DQFrame.this.soundEffectClip = null;
                        }
                        DQFrame.this.soundEffectClip.play();
                    }
                    MapPanel.this.heroFacing = 1;
                } else if (key == 40) {
                    if (MapPanel.this.map.getTile(MapPanel.this.map.getHeroColumn(), MapPanel.this.map.getHeroRow() + 1).isPassable()) {
                        MapPanel.this.upperLeftY += 32;
                        MapPanel.this.lowerRightY += 32;
                        MapPanel.this.map.moveHeroDown();
                        if (MapPanel.this.currentMap == 3) {
                            DQFrame.this.encounterCounter--;
                        }
                    } else {
                        DQFrame.this.soundEffectClip.stop();
                        try {
                            DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/bump.wav"));
                        }
                        catch (IOException exception) {
                            DQFrame.this.soundEffectClip = null;
                        }
                        DQFrame.this.soundEffectClip.play();
                    }
                    MapPanel.this.heroFacing = 0;
                } else if (key == 10) {
                    if (MapPanel.this.currentMap == 0) {
                        new TitleMenu(DQFrame.this).show();
                    } else if (MapPanel.this.currentMap == 3 && ((MazeTile)MapPanel.this.map.getTile(MapPanel.this.map.getHeroColumn(), MapPanel.this.map.getHeroRow())).isExit()) {
                        DQFrame.this.encounterCounter = (int)(10.0 + Math.random() * 15.0);
                        MapPanel.this.setUpDungeonMap(1);
                    } else if (MapPanel.this.currentMap == 3 && ((MazeTile)MapPanel.this.map.getTile(MapPanel.this.map.getHeroColumn(), MapPanel.this.map.getHeroRow())).isEntrance()) {
                        DQFrame.this.encounterCounter = (int)(10.0 + Math.random() * 15.0);
                        MapPanel.this.setUpDungeonMap(-1);
                    } else if (MapPanel.this.currentMap == 3 && MapPanel.this.heroFacing == 0) {
                        if (((MazeTile)MapPanel.this.map.getTile(MapPanel.this.map.getHeroColumn(), MapPanel.this.map.getHeroRow() + 1)).isTreasureChest()) {
                            try {
                                DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/treasure_chest.wav"));
                            }
                            catch (IOException exception) {
                                DQFrame.this.soundEffectClip = null;
                            }
                            DQFrame.this.soundEffectClip.play();
                            new TreasureChestPrompt(DQFrame.this, ((DungeonMap)MapPanel.this.map).getChest(MapPanel.this.map.getHeroColumn(), MapPanel.this.map.getHeroRow() + 1)).show();
                        }
                    } else if (MapPanel.this.currentMap == 3 && MapPanel.this.heroFacing == 1) {
                        if (((MazeTile)MapPanel.this.map.getTile(MapPanel.this.map.getHeroColumn(), MapPanel.this.map.getHeroRow() - 1)).isTreasureChest()) {
                            try {
                                DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/treasure_chest.wav"));
                            }
                            catch (IOException exception) {
                                DQFrame.this.soundEffectClip = null;
                            }
                            DQFrame.this.soundEffectClip.play();
                            new TreasureChestPrompt(DQFrame.this, ((DungeonMap)MapPanel.this.map).getChest(MapPanel.this.map.getHeroColumn(), MapPanel.this.map.getHeroRow() - 1)).show();
                        }
                    } else if (MapPanel.this.currentMap == 3 && MapPanel.this.heroFacing == 2) {
                        if (((MazeTile)MapPanel.this.map.getTile(MapPanel.this.map.getHeroColumn() + 1, MapPanel.this.map.getHeroRow())).isTreasureChest()) {
                            try {
                                DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/treasure_chest.wav"));
                            }
                            catch (IOException exception) {
                                DQFrame.this.soundEffectClip = null;
                            }
                            DQFrame.this.soundEffectClip.play();
                            new TreasureChestPrompt(DQFrame.this, ((DungeonMap)MapPanel.this.map).getChest(MapPanel.this.map.getHeroColumn() + 1, MapPanel.this.map.getHeroRow())).show();
                        }
                    } else if (MapPanel.this.currentMap == 3 && MapPanel.this.heroFacing == 3) {
                        if (((MazeTile)MapPanel.this.map.getTile(MapPanel.this.map.getHeroColumn() - 1, MapPanel.this.map.getHeroRow())).isTreasureChest()) {
                            try {
                                DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/treasure_chest.wav"));
                            }
                            catch (IOException exception) {
                                DQFrame.this.soundEffectClip = null;
                            }
                            DQFrame.this.soundEffectClip.play();
                            new TreasureChestPrompt(DQFrame.this, ((DungeonMap)MapPanel.this.map).getChest(MapPanel.this.map.getHeroColumn() - 1, MapPanel.this.map.getHeroRow())).show();
                        }
                    } else if (MapPanel.this.currentMap == 2 && MapPanel.this.map.getHeroColumn() == 27 && MapPanel.this.map.getHeroRow() == 8 && MapPanel.this.heroFacing == 2) {
                        new ChurchMenu(DQFrame.this).show();
                    } else if (MapPanel.this.currentMap == 2 && MapPanel.this.map.getHeroColumn() == 13 && MapPanel.this.map.getHeroRow() == 25 && MapPanel.this.heroFacing == 2) {
                        new InnMenu(DQFrame.this).show();
                    } else if (MapPanel.this.currentMap == 2 && MapPanel.this.map.getHeroColumn() == 9 && MapPanel.this.map.getHeroRow() == 10 && MapPanel.this.heroFacing == 1) {
                        new WeaponAndArmorShopMenu(DQFrame.this).show();
                    } else if (MapPanel.this.currentMap == 2 && MapPanel.this.map.getHeroColumn() == 28 && MapPanel.this.map.getHeroRow() == 29 && MapPanel.this.heroFacing == 2) {
                        new ItemShopMenu(DQFrame.this).show();
                    }
                } else if (key == 32 && MapPanel.this.currentMap != 0) {
                    new MainMenu(DQFrame.this).show();
                }
                if (MapPanel.this.currentMap == 2 && MapPanel.this.map.getHeroRow() == 3) {
                    try {
                        DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/stairs.wav"));
                    }
                    catch (IOException exception) {
                        DQFrame.this.soundEffectClip = null;
                    }
                    DQFrame.this.soundEffectClip.play();
                    MapPanel.this.setUpWorldMap(5, 14);
                }
                if (MapPanel.this.currentMap == 1 && MapPanel.this.map.getHeroColumn() == 5 && MapPanel.this.map.getHeroRow() == 15) {
                    try {
                        DQFrame.this.soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/stairs.wav"));
                    }
                    catch (IOException exception) {
                        DQFrame.this.soundEffectClip = null;
                    }
                    DQFrame.this.soundEffectClip.play();
                    MapPanel.this.setUpTownMap(19, 4);
                }
                if (MapPanel.this.currentMap == 1 && MapPanel.this.map.getHeroColumn() == 15 && MapPanel.this.map.getHeroRow() == 4) {
                    DQFrame.this.musicClip.stop();
                    try {
                        DQFrame.this.musicClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" + "audio_files/dungeon.mid"));
                    }
                    catch (IOException exception) {
                        DQFrame.this.musicClip = null;
                    }
                    DQFrame.this.musicClip.loop();
                    DQFrame.this.encounterCounter = (int)(10.0 + Math.random() * 15.0);
                    MapPanel.this.setUpDungeonMap(1);
                }
                if (DQFrame.this.encounterCounter == 0) {
                    new BattleWindow(DQFrame.this).show();
                    DQFrame.this.encounterCounter = (int)(10.0 + Math.random() * 15.0);
                }
                MapPanel.this.repaint();
            }
        }
    }
}

