using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using Microsoft.Ink;

namespace MhsModelCSharp
{
	/// <summary>
	/// Summary description for Vector3InkerEditorControl.
	/// </summary>
	public class Vector3InkerEditorControl : System.Windows.Forms.Form
	{


		// first stroke in set it to true
		private bool userIsInkingX = false;
		private bool userIsInkingY = false;
		private bool userIsInkingZ = false;

		// original values
		string origX=null;
		string origY=null;
		string origZ=null;

		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label3;
		private Microsoft.Ink.InkEdit inkEditZ;
		private Microsoft.Ink.InkEdit inkEditX;
		private Microsoft.Ink.InkEdit inkEditY;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Panel pnlX;
		private System.Windows.Forms.Panel pnlY;
		private System.Windows.Forms.Panel pnlZ;
		private System.Windows.Forms.Panel pnlButtons;

		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// 
		/// </summary>
		public Vector3InkerEditorControl()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			// TODO: Add any initialization after the InitializeComponent call

		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{

			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.inkEditX = new Microsoft.Ink.InkEdit();
			this.inkEditY = new Microsoft.Ink.InkEdit();
			this.label2 = new System.Windows.Forms.Label();
			this.inkEditZ = new Microsoft.Ink.InkEdit();
			this.label1 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.button1 = new System.Windows.Forms.Button();
			this.button2 = new System.Windows.Forms.Button();
			this.label4 = new System.Windows.Forms.Label();
			this.pnlX = new System.Windows.Forms.Panel();
			this.pnlY = new System.Windows.Forms.Panel();
			this.pnlZ = new System.Windows.Forms.Panel();
			this.pnlButtons = new System.Windows.Forms.Panel();
			this.pnlX.SuspendLayout();
			this.pnlY.SuspendLayout();
			this.pnlZ.SuspendLayout();
			this.pnlButtons.SuspendLayout();
			this.SuspendLayout();
			// 
			// inkEditX
			// 
			this.inkEditX.Cursor = System.Windows.Forms.Cursors.Default;
			this.inkEditX.Dock = System.Windows.Forms.DockStyle.Fill;
			this.inkEditX.Factoid = "Number";
			this.inkEditX.InkMode = Microsoft.Ink.InkMode.Ink;
			this.inkEditX.Location = new System.Drawing.Point(20, 0);
			this.inkEditX.Multiline = false;
			this.inkEditX.Name = "inkEditX";
			this.inkEditX.Size = new System.Drawing.Size(332, 84);
			this.inkEditX.TabIndex = 0;
			this.inkEditX.Text = "0";
			this.inkEditX.Stroke += new Microsoft.Ink.InkEditStrokeEventHandler(this.inkEditX_Stroke);
			this.inkEditX.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.Vector3InkerEditorControl_KeyPress);
			this.inkEditX.TextChanged += new System.EventHandler(this.inkEditX_TextChanged);
			this.inkEditX.Enter += new System.EventHandler(this.inkEditX_Enter);
			// 
			// inkEditY
			// 
			this.inkEditY.Cursor = System.Windows.Forms.Cursors.Default;
			this.inkEditY.Dock = System.Windows.Forms.DockStyle.Fill;
			this.inkEditY.Factoid = "Number";
			this.inkEditY.InkMode = Microsoft.Ink.InkMode.Ink;
			this.inkEditY.Location = new System.Drawing.Point(20, 0);
			this.inkEditY.Multiline = false;
			this.inkEditY.Name = "inkEditY";
			this.inkEditY.Size = new System.Drawing.Size(332, 84);
			this.inkEditY.TabIndex = 0;
			this.inkEditY.Text = "0";
			this.inkEditY.Stroke += new Microsoft.Ink.InkEditStrokeEventHandler(this.inkEditY_Stroke);
			this.inkEditY.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.Vector3InkerEditorControl_KeyPress);
			this.inkEditY.TextChanged += new System.EventHandler(this.inkEditY_TextChanged);
			this.inkEditY.Enter += new System.EventHandler(this.inkEditY_Enter);
			// 
			// label2
			// 
			this.label2.Dock = System.Windows.Forms.DockStyle.Left;
			this.label2.Location = new System.Drawing.Point(0, 0);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(20, 84);
			this.label2.TabIndex = 4;
			this.label2.Text = "Y";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// inkEditZ
			// 
			this.inkEditZ.Cursor = System.Windows.Forms.Cursors.Default;
			this.inkEditZ.Dock = System.Windows.Forms.DockStyle.Fill;
			this.inkEditZ.Factoid = "Number";
			this.inkEditZ.InkMode = Microsoft.Ink.InkMode.Ink;
			this.inkEditZ.Location = new System.Drawing.Point(20, 0);
			this.inkEditZ.Multiline = false;
			this.inkEditZ.Name = "inkEditZ";
			this.inkEditZ.Size = new System.Drawing.Size(332, 84);
			this.inkEditZ.TabIndex = 0;
			this.inkEditZ.Text = "0";
			this.inkEditZ.Stroke += new Microsoft.Ink.InkEditStrokeEventHandler(this.inkEditZ_Stroke);
			this.inkEditZ.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.Vector3InkerEditorControl_KeyPress);
			this.inkEditZ.TextChanged += new System.EventHandler(this.inkEditZ_TextChanged);
			this.inkEditZ.Enter += new System.EventHandler(this.inkEditZ_Enter);
			// 
			// label1
			// 
			this.label1.Cursor = System.Windows.Forms.Cursors.IBeam;
			this.label1.Dock = System.Windows.Forms.DockStyle.Left;
			this.label1.Location = new System.Drawing.Point(0, 0);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(20, 84);
			this.label1.TabIndex = 4;
			this.label1.Text = "X";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label3
			// 
			this.label3.Dock = System.Windows.Forms.DockStyle.Left;
			this.label3.Location = new System.Drawing.Point(0, 0);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(20, 84);
			this.label3.TabIndex = 4;
			this.label3.Text = "Z";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// button1
			// 
			this.button1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.button1.Location = new System.Drawing.Point(240, 8);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(44, 23);
			this.button1.TabIndex = 5;
			this.button1.Text = "OK";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// button2
			// 
			this.button2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.button2.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.button2.Location = new System.Drawing.Point(288, 8);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(60, 23);
			this.button2.TabIndex = 6;
			this.button2.Text = "Cancel";
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// label4
			// 
			this.label4.Dock = System.Windows.Forms.DockStyle.Top;
			this.label4.Location = new System.Drawing.Point(0, 0);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(356, 44);
			this.label4.TabIndex = 7;
			this.label4.Text = "Input the floating point coordinates of a  Vector3. You can type or use handwriti" +
				"ng. After writing there will be a short pause before the number is checked and c" +
				"onverted to text.";
			// 
			// pnlX
			// 
			this.pnlX.Controls.Add(this.inkEditX);
			this.pnlX.Controls.Add(this.label1);
			this.pnlX.Location = new System.Drawing.Point(0, 48);
			this.pnlX.Name = "pnlX";
			this.pnlX.Size = new System.Drawing.Size(352, 84);
			this.pnlX.TabIndex = 8;
			// 
			// pnlY
			// 
			this.pnlY.Controls.Add(this.inkEditY);
			this.pnlY.Controls.Add(this.label2);
			this.pnlY.Location = new System.Drawing.Point(0, 144);
			this.pnlY.Name = "pnlY";
			this.pnlY.Size = new System.Drawing.Size(352, 84);
			this.pnlY.TabIndex = 9;
			// 
			// pnlZ
			// 
			this.pnlZ.Controls.Add(this.inkEditZ);
			this.pnlZ.Controls.Add(this.label3);
			this.pnlZ.Location = new System.Drawing.Point(0, 240);
			this.pnlZ.Name = "pnlZ";
			this.pnlZ.Size = new System.Drawing.Size(352, 84);
			this.pnlZ.TabIndex = 10;
			// 
			// pnlButtons
			// 
			this.pnlButtons.Controls.Add(this.button1);
			this.pnlButtons.Controls.Add(this.button2);
			this.pnlButtons.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.pnlButtons.Location = new System.Drawing.Point(0, 345);
			this.pnlButtons.Name = "pnlButtons";
			this.pnlButtons.Size = new System.Drawing.Size(356, 32);
			this.pnlButtons.TabIndex = 11;
			// 
			// Vector3InkerEditorControl
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(356, 377);
			this.Controls.Add(this.pnlButtons);
			this.Controls.Add(this.pnlZ);
			this.Controls.Add(this.pnlX);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.pnlY);
			this.MaximizeBox = false;
			this.MaximumSize = new System.Drawing.Size(364, 404);
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(364, 404);
			this.Name = "Vector3InkerEditorControl";
			this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide;
			this.Text = "Vector 3 Ink Editor";
			this.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.Vector3InkerEditorControl_KeyPress);
			this.Load += new System.EventHandler(this.Vector3InkerEditorControl_Load);
			this.pnlX.ResumeLayout(false);
			this.pnlY.ResumeLayout(false);
			this.pnlZ.ResumeLayout(false);
			this.pnlButtons.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion


		private void InkBoxTextChangeValidator( ref InkEdit inkedit, ref bool userIsInking )
		{
			try
			{
				// the user just put in some text. 
				// a single character when typing.
				// a string when inking
				if( inkedit.Text.Length > 0 )
				{
					// when keying ignore an initial decimal point
					// and a trailing E. These could stil be valid floats.
					// wait to see what the string looks like after the
					// next TextChanged event. The use might exit with these
					// values, but the Vector3DataConverter will catch it.
					if( inkedit.Text.CompareTo(".") != 0 )
					{
						// is it a good float? throws FormatException
						float.Parse( inkedit.Text );
						if( userIsInking )
							inkedit.SelectAll();
					}				
				}

				if( userIsInking  )
					userIsInking = false;
			}
			catch( FormatException )
			{
				inkedit.Clear();
				MessageBox.Show("Invalid floating point number. The value you typed or wrote (" + inkedit.Text + ") is not a valid floating point number.\n 1. Try writing again\n 2. Use the on screen or attached keyboard.","Invalid floating point number",MessageBoxButtons.OK,MessageBoxIcon.Error); 
			}
		}

		private void inkEditX_TextChanged(object sender, System.EventArgs e)
		{
			InkBoxTextChangeValidator(ref inkEditX,ref userIsInkingX);
		}

		private void inkEditY_TextChanged(object sender, System.EventArgs e)
		{
			InkBoxTextChangeValidator(ref inkEditY, ref userIsInkingY);	
		}

		private void inkEditZ_TextChanged(object sender, System.EventArgs e)
		{
			InkBoxTextChangeValidator(ref inkEditZ,ref userIsInkingZ);
		}

		private void inkEditX_Stroke(object sender, Microsoft.Ink.InkEditStrokeEventArgs e)
		{
			if( userIsInkingX == false )
			{
				inkEditX.Clear();
				userIsInkingX = true;
			}
		}

		// cancel button
		private void button2_Click(object sender, System.EventArgs e)
		{
			// disable responding to text changed events internally
			this.inkEditX.TextChanged += null;		
			this.inkEditY.TextChanged += null;		
			this.inkEditZ.TextChanged += null;
		
			// set the text back to the original values
			this.inkEditX.Text=origX;
			this.inkEditY.Text=origY;
			this.inkEditZ.Text=origZ;

			this.Close();
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void inkEditY_Stroke(object sender, Microsoft.Ink.InkEditStrokeEventArgs e)
		{
			if( userIsInkingY == false )
			{
				inkEditY.Clear();
				userIsInkingY = true;
			}
		
		}


		private void inkEditZ_Stroke(object sender, Microsoft.Ink.InkEditStrokeEventArgs e)
		{
			if( userIsInkingZ == false )
			{
				inkEditZ.Clear();
				userIsInkingZ = true;
			}		
		}

		private void Vector3InkerEditorControl_Load(object sender, System.EventArgs e)
		{
			// cache the values in case the user hits cancel.
			origX = inkEditX.Text;
			origY = inkEditY.Text;
			origZ = inkEditZ.Text;
		}

		private void Vector3InkerEditorControl_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			// same as clicking ok
			if( e.KeyChar == (char)Keys.Enter)
			{
				this.Close();
			}
		}

		private void inkEditX_Enter(object sender, System.EventArgs e)
		{
			inkEditX.SelectAll();
		}

		private void inkEditY_Enter(object sender, System.EventArgs e)
		{
			inkEditY.SelectAll();
		}

		private void inkEditZ_Enter(object sender, System.EventArgs e)
		{
			inkEditZ.SelectAll();		
		}



		/// <summary>
		/// 
		/// </summary>
		public float X
		{
			get
			{
				return float.Parse(inkEditX.Text);
			}
			set
			{
				inkEditX.Text = value.ToString("##0.0##");
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public float Y
		{
			get
			{
				return float.Parse(inkEditY.Text);
			}
			set
			{
				inkEditY.Text  = value.ToString("##0.0##");
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public float Z
		{
			get
			{
				return float.Parse(inkEditZ.Text);
			}
			set
			{
				inkEditZ.Text  = value.ToString("##0.0##");
			}
		}
	}
}
