using System;
using System.Collections;
using System.ComponentModel;
using System.Reflection;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;
using System.Windows.Forms;
using System.Drawing;

using System.Xml;
using System.Xml.Serialization;

using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;
using D3D = Microsoft.DirectX.Direct3D;
using Vector3 = Microsoft.DirectX.Vector3;
using Vector2 = Microsoft.DirectX.Vector2;

namespace MhsModelCSharp
{
	/// <summary>
	/// 
	/// </summary>
	public class TimeableBase
	{
		/// <summary>
		/// 
		/// </summary>
		public DateTime StartDateTime
		{
			get { return startTime; }
			set {startTime = value; }
		}
		private DateTime startTime = DateTime.Now;

		/// <summary>
		/// 
		/// </summary>
		public DateTime StopDateTime
		{
			get { return stopTime; }
			set { stopTime = value; }
		}
		private DateTime stopTime  = DateTime.Now;

		/// <summary>
		/// 
		/// </summary>
		public TimeSpan Duration
		{
			get { return stopTime - startTime; }
		}
	}

	/// <summary>
	/// 
	/// </summary>
	public class CygSamplingManager
		: TimeableBase
	{
		/// <summary>
		/// 
		/// </summary>
		public CygSamplingManager()
		{
			ResetSampling();
		}

		/// <summary>
		/// indexer
		/// </summary>
		public bool[] Steps
		{
			get { return steps; }
			set { steps = value; }
		}
		private bool[] steps = new bool[ModelParameters.NUM_STEPS_PER_CYG_SAMPLE];

		/// <summary>
		/// 
		/// </summary>
		public CygStep CurrentStep
		{
			get { return currentStep; }
			set { currentStep = value; }
		}
		private CygStep currentStep;

		/// <summary>
		/// 
		/// </summary>
		public CygStep NextStep
		{
			get 
			{ 
				switch( currentStep )
				{
					case CygStep.BASE_POINT:
						return CygStep.TIP_POINT;
					case CygStep.TIP_POINT:
						return CygStep.BASE_DIAMETER;
					case CygStep.BASE_DIAMETER:
					default:
						return CygStep.NONE;
				};
			}
		}


		/// <summary>
		/// 
		/// </summary>
		public CygStep PreviousStep
		{
			get 
			{ 
				switch( currentStep )
				{
					case CygStep.BASE_DIAMETER:
						return CygStep.TIP_POINT;
					case CygStep.TIP_POINT:
						return CygStep.BASE_POINT;
					case CygStep.BASE_POINT:
					default:
						return CygStep.NONE;
				};
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public void ResetSampling()
		{
			currentStep = CygStep.BASE_POINT;			
			for( int i=0;i<steps.Length;i++)
			{
				steps[i] = false;
			}										
		}

		/// <summary>
		/// See if any steps have been completed
		/// </summary>
		/// <returns></returns>
		public bool IsSamplingStarted()
		{
			bool isStarted = false;
			for(int i=0; i<steps.Length;i++)
			{
				isStarted = isStarted || steps[i];
			}
			return isStarted;
		}

		/// <summary>
		/// See if all steps have been completed
		/// </summary>
		/// <returns></returns>
		public bool IsSamplingComplete()
		{
			bool isComplete = true;
			for(int i=0; i<steps.Length;i++)
			{
				isComplete = isComplete && steps[i];
			}
			return isComplete;
		}

	}

	/// <summary>
	/// 
	/// </summary>
	public class PlantPatchSamplingManager
	{
		/// <summary>
		/// 
		/// </summary>
		public PlantPatchSamplingManager()
		{
			this.ResetSampling();
		}

		/// <summary>
		/// Accessor
		/// </summary>
		public CygSamplingManager[] CygSteps
		{
			get { return cygSteps; }
			set { cygSteps = value; }
		}
		CygSamplingManager[] cygSteps = new CygSamplingManager[ModelParameters.NUM_CYGS_PER_PLANTPATCH];

		/// <summary>
		/// Reset
		/// </summary>
		public void ResetSampling()
		{
			for( int i=0;i<cygSteps.Length;i++)
			{
				cygSteps[i].ResetSampling();
			}										
		}

		/// <summary>
		/// See if any steps have been completed
		/// </summary>
		/// <returns></returns>
		public bool IsSamplingStarted()
		{
			bool isStarted = false;
			for(int i=0; i<cygSteps.Length;i++)
			{
				isStarted = isStarted || cygSteps[i].IsSamplingStarted();
			}
			return isStarted;
		}

		/// <summary>
		/// See if all steps have been completed
		/// </summary>
		/// <returns></returns>
		public bool IsSamplingComplete()
		{
			bool isComplete = true;
			for(int i=0; i<cygSteps.Length;i++)
			{
				isComplete = isComplete && cygSteps[i].IsSamplingComplete();
			}
			return isComplete;
		}

	}

	/// <summary>
	/// 
	/// </summary>
	public  class WaypointSamplingManager
	{
		/// <summary>
		/// 
		/// </summary>
		public WaypointSamplingManager()
		{
		}

		/// <summary>
		/// Plant patches, variable length
		/// </summary>
		public PlantPatchSamplingManagerCollection PatchSteps
		{
			get { return patchSteps; }
			set { patchSteps = value; }
		}
		private PlantPatchSamplingManagerCollection patchSteps = new PlantPatchSamplingManagerCollection();

		/// <summary>
		/// Reset
		/// </summary>
		public void ResetSampling()
		{
			for( int i=0;i<patchSteps.Count;i++)
			{
				patchSteps[i].ResetSampling();
			}										
		}

		/// <summary>
		/// See if any steps have been completed
		/// </summary>
		/// <returns></returns>
		public bool IsSamplingStarted()
		{
			bool isStarted = false;
			for(int i=0; i<patchSteps.Count;i++)
			{
				isStarted = isStarted || patchSteps[i].IsSamplingStarted();
			}
			return isStarted;
		}

		/// <summary>
		/// See if all steps have been completed
		/// </summary>
		/// <returns></returns>
		public bool IsSamplingComplete()
		{
			bool isComplete = true;
			for(int i=0; i<patchSteps.Count;i++)
			{
				isComplete = isComplete && patchSteps[i].IsSamplingComplete();
			}
			return isComplete;
		}	
	}








	/// <summary>
	/// 
	/// </summary>
	public  class FieldtripSamplingManager
	{
		/// <summary>
		/// 
		/// </summary>
		public FieldtripSamplingManager()
		{
		}

		/// <summary>
		/// Plant waypointes, variable length
		/// </summary>
		public WaypointSamplingManagerCollection WaypointSteps
		{
			get { return waypointSteps; }
			set { waypointSteps = value; }
		}
		private WaypointSamplingManagerCollection waypointSteps = new WaypointSamplingManagerCollection();

		/// <summary>
		/// Reset
		/// </summary>
		public void ResetSampling()
		{
			for( int i=0;i<waypointSteps.Count;i++)
			{
				waypointSteps[i].ResetSampling();
			}										
		}

		/// <summary>
		/// See if any steps have been completed
		/// </summary>
		/// <returns></returns>
		public bool IsSamplingStarted()
		{
			bool isStarted = false;
			for(int i=0; i<waypointSteps.Count;i++)
			{
				isStarted = isStarted || waypointSteps[i].IsSamplingStarted();
			}
			return isStarted;
		}

		/// <summary>
		/// See if all steps have been completed
		/// </summary>
		/// <returns></returns>
		public bool IsSamplingComplete()
		{
			bool isComplete = true;
			for(int i=0; i<waypointSteps.Count;i++)
			{
				isComplete = isComplete && waypointSteps[i].IsSamplingComplete();
			}
			return isComplete;
		}	
	}
}
