using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using Microsoft.Ink;

namespace MhsModelCSharp
{
	/// <summary>
	/// Summary description for FloatInkerEditorControl.
	/// </summary>
	public class FloatInkerEditorControl : System.Windows.Forms.Form
	{


		// first stroke in set it to true
		private bool userIsInkingX = false;

		// original values
		string origX=null;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.Panel panel2;
		private System.Windows.Forms.Label label4;
		private Microsoft.Ink.InkEdit inkEditX;

		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// 
		/// </summary>
		public FloatInkerEditorControl()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			// TODO: Add any initialization after the InitializeComponent call

		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{

			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.button1 = new System.Windows.Forms.Button();
			this.button2 = new System.Windows.Forms.Button();
			this.panel2 = new System.Windows.Forms.Panel();
			this.label4 = new System.Windows.Forms.Label();
			this.inkEditX = new Microsoft.Ink.InkEdit();
			this.panel2.SuspendLayout();
			this.SuspendLayout();
			// 
			// button1
			// 
			this.button1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.button1.Location = new System.Drawing.Point(172, 4);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(44, 23);
			this.button1.TabIndex = 5;
			this.button1.Text = "OK";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// button2
			// 
			this.button2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.button2.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.button2.Location = new System.Drawing.Point(220, 4);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(60, 23);
			this.button2.TabIndex = 6;
			this.button2.Text = "Cancel";
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// panel2
			// 
			this.panel2.Controls.Add(this.button1);
			this.panel2.Controls.Add(this.button2);
			this.panel2.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.panel2.Location = new System.Drawing.Point(0, 125);
			this.panel2.Name = "panel2";
			this.panel2.Size = new System.Drawing.Size(284, 28);
			this.panel2.TabIndex = 9;
			// 
			// label4
			// 
			this.label4.Dock = System.Windows.Forms.DockStyle.Top;
			this.label4.Location = new System.Drawing.Point(0, 0);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(284, 44);
			this.label4.TabIndex = 10;
			this.label4.Text = "Input a floating point number. You can type or use handwriting. After writing the" +
				"re will be a short pause before the number is verified and converted to text.";
			// 
			// inkEditX
			// 
			this.inkEditX.Cursor = System.Windows.Forms.Cursors.Default;
			this.inkEditX.Dock = System.Windows.Forms.DockStyle.Fill;
			this.inkEditX.Factoid = "None";
			this.inkEditX.InkMode = Microsoft.Ink.InkMode.Ink;
			this.inkEditX.Location = new System.Drawing.Point(0, 44);
			this.inkEditX.Multiline = false;
			this.inkEditX.Name = "inkEditX";
			this.inkEditX.Size = new System.Drawing.Size(284, 81);
			this.inkEditX.TabIndex = 11;
			this.inkEditX.Text = "0";
			this.inkEditX.Stroke += new Microsoft.Ink.InkEditStrokeEventHandler(this.inkEditX_Stroke);
			this.inkEditX.TextChanged += new System.EventHandler(this.inkEditX_TextChanged);
			// 
			// FloatInkerEditorControl
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(284, 153);
			this.Controls.Add(this.inkEditX);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.panel2);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "FloatInkerEditorControl";
			this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Show;
			this.Text = "Float Ink Editor";
			this.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.FloatInkerEditorControl_KeyPress);
			this.Load += new System.EventHandler(this.FloatInkerEditorControl_Load);
			this.panel2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion


		private void InkBoxTextChangeValidator( ref InkEdit inkedit, ref bool userIsInking )
		{
			try
			{
				// the user just put in some text. 
				// a single character when typing.
				// a string when inking
				if( inkedit.Text.Length > 0 )
				{
					// when keying ignore an initial decimal point
					// and a trailing E. These could stil be valid floats.
					// wait to see what the string looks like after the
					// next TextChanged event. The use might exit with these
					// values, but the Vector3DataConverter will catch it.
					if( inkedit.Text.CompareTo(".") != 0 )
					{
						// is it a good float? throws FormatException
						float.Parse( inkedit.Text );
						if( userIsInking )
							inkedit.SelectAll();
					}				
				}

				if( userIsInking  )
					userIsInking = false;
			}
			catch( FormatException )
			{
				inkedit.Clear();
				MessageBox.Show("Invalid floating point number. The value you typed or wrote (" + inkedit.Text + ") is not a valid floating point number.\n 1. Try writing again\n 2. Use the on screen or attached keyboard.","Invalid floating point number",MessageBoxButtons.OK,MessageBoxIcon.Error); 
			}
		}

		private void inkEditX_TextChanged(object sender, System.EventArgs e)
		{
			InkBoxTextChangeValidator(ref inkEditX,ref userIsInkingX);
		}


		private void inkEditX_Stroke(object sender, Microsoft.Ink.InkEditStrokeEventArgs e)
		{
			if( userIsInkingX == false )
			{
				inkEditX.Clear();
				userIsInkingX = true;
			}
		}

		// cancel button
		private void button2_Click(object sender, System.EventArgs e)
		{
			// disable responding to text changed events internally
			this.inkEditX.TextChanged += null;		
		
			// set the text back to the original values
			this.inkEditX.Text=origX;

			this.Close();
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}


		private void FloatInkerEditorControl_Load(object sender, System.EventArgs e)
		{
			// cache the values in case the user hits cancel.
			origX = inkEditX.Text;
		}

		private void FloatInkerEditorControl_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			// same as clicking ok
			if( e.KeyChar == (char)Keys.Enter)
			{
				this.Close();
			}
		}

		private void inkEditX_Enter(object sender, System.EventArgs e)
		{
			inkEditX.SelectAll();
		}



		/// <summary>
		/// 
		/// </summary>
		public float X
		{
			get
			{
				return float.Parse(inkEditX.Text);
			}
			set
			{
				inkEditX.Text = value.ToString("##0.0##");
			}
		}

	}
}
