/** Waypoint.cpp class.
* Contains all the constructors and methods required to operate an instance of Waypoint.
* @author - Max Konovalov;
*/
#include "stdafx.h"
#include "Model.h"
/**
* Constructor for Waypoint.  Creates a Waypoint with given coordinates, name and habitat type;<br>
* sets totalPlantPatches to 0 and startTime to current time.<br>
* @param float lat - <b>latitude</b> coordinate for the Waypoint;
* @param float lon - <b>longitude</b> coordinate for the Waypoint;
* @param String nam - <b>name</b> of the Waypoint;
* @param String habitatTyp - <b>Habitat Type</b> of the Waypoint;
*/
MhsModel::Waypoint::Waypoint(float lat, float lon, System::String __gc* nam, System::String __gc* habitatTyp)
{	
	name = nam;
    latitude = lat;
	longitude = lon;
	habitatType = habitatTyp;

	plantPatches = new ArrayList();

	totalPlantPatches = 0;

	startTime = DateTime::Now;
}

/** Default constructor for Waypoint.  Takes no input.<br>
* Creates an instance of Waypoint class with totalPlantPatches set to 0 and current time.
* @param none;
*/
MhsModel::Waypoint::Waypoint()
{
	plantPatches = new ArrayList();
	totalPlantPatches = 0;
	startTime.Now;
}

/** Waypoint Destructor.
* @param - none;
*/
MhsModel::Waypoint::~Waypoint()
{
}

/** Overrides default toString() methods.
* @return - String representation of the Waypoint in "<i>latitude, longitude, name;</i>" format.
*/
String __gc* MhsModel::Waypoint::toString()
{
	System::Text::StringBuilder __gc* sb = new System::Text::StringBuilder;
	PlantPatch __gc* tmpPlantPatch;


	sb->Append("[");

	sb->Append(name);
	sb->Append(",");

	sb->Append(habitatType);
	sb->Append(",");

	sb->Append(latitude);
	sb->Append(",");

	sb->Append(longitude);
	sb->Append(",\n");


	for(int i = 0; i < totalPlantPatches; i++)
			{	tmpPlantPatch = static_cast<PlantPatch*>(plantPatches->Item[i]);
				sb->Append(tmpPlantPatch->toString());
			}
	sb->Append("]");
	return sb->ToString();
}

/** Unit test for Waypoint.
* @return - String representation of the predefined tests' results.
*/
String __gc* MhsModel::Waypoint::unitTest()
{	//Building sample Waypoints using two constructors
	StringBuilder __gc* sb = new StringBuilder();
	Waypoint __gc* blankWaypoint = new Waypoint();
	Waypoint __gc* realWaypoint = new Waypoint(17.67f, 19.99f, S"The_First Waypoint#5&%", S"Nevergreen");
	//Building an instance of PlantPatch object
	PlantPatch __gc* testPlantPatch = new PlantPatch();

	//Printing out string representation for the Waypoints using toString() method
	sb->Append("Printing blank waypoint: \n");
	sb->Append(blankWaypoint->toString());
	sb->Append("\n");
	sb->Append("Printing realWaypoint using toString(): ");
	sb->Append(realWaypoint->toString());
	sb->Append("\n");

	//Printing out all instance variables of the realWaypoint
	sb->Append("Name: ");
	sb->Append(realWaypoint->name);
	sb->Append("\nLat: ");
	sb->Append(realWaypoint->latitude);
	sb->Append("\nLon: ");
	sb->Append(realWaypoint->longitude);
	sb->Append("\nHabitat Type: ");
	sb->Append(realWaypoint->habitatType);
	sb->Append("\nStart Time: ");
	sb->Append(realWaypoint->startTime.ToString());
	sb->Append("\nNumber of Plants: ");
	sb->Append(realWaypoint->totalPlantPatches);
	
	//Appending plant patch to the waypoint
	realWaypoint->addPlantPatch(testPlantPatch);
	sb->Append("\nAdding plant patch...  Total number of patches: ");
	sb->Append(realWaypoint->totalPlantPatches);
	//Testing toExport() method
	sb->Append("\nGetting data from toExport():\n");
	sb->Append(realWaypoint->toExport());
	sb->Append("\n");

	//Testing toString() method
	sb->Append("\nGetting data from toString():\n");
	sb->Append(realWaypoint->toString());
	sb->Append("\n");


	//Deleting plant patch from the waypoint
	sb->Append("\nDeleting plant patch... Total number of patches: ");
	realWaypoint->delPlantPatch(0);
	sb->Append(realWaypoint->totalPlantPatches);
	
	return sb->ToString();

}

String __gc* MhsModel::Waypoint::toExport()
{	PlantPatch __gc* tmpPlantPatch;
	StringBuilder __gc* sb = new System::Text::StringBuilder;
	StringBuilder __gc* waypointInfo = new System::Text::StringBuilder;
	
	waypointInfo->Append(latitude);
	waypointInfo->Append(",");

	waypointInfo->Append(longitude);
	waypointInfo->Append(",");

	waypointInfo->Append(habitatType);
	waypointInfo->Append(",");

	waypointInfo->Append(name);
	waypointInfo->Append(";");

	if(totalPlantPatches != 0)
	{	for(int i = 0; i < totalPlantPatches; i++)
			{	tmpPlantPatch = static_cast<PlantPatch*>(plantPatches->Item[i]);
				//sb->Append(waypointInfo);
				//sb->Append(tmpPlantPatch->toExport(this->toString()));
				sb->Append(tmpPlantPatch->toExport(waypointInfo->ToString()));
				sb->Append("\n");
			}
			return sb->ToString();
	}
	else
	{	return waypointInfo->ToString();
	}

}

/** Adds an instance of PlantPatch to the Waypoint.
* @param PlantPatch pp - instance of PlantPatch object to be added to the Waypoint.
* @return int totalPlantPatches - total number of PlantPatches in the Waypoint after new PlantPatch insertinon.
*/
int MhsModel::Waypoint::addPlantPatch(PlantPatch __gc* pp)
{	plantPatches->Add(pp);
	totalPlantPatches = plantPatches->Count;
	return (totalPlantPatches);
}
/** Deletes given instance of PlantPatch from the Waypoint.
* @param int idx - index of the PlantPatch in the Waypoint to be deleted.
*/
void MhsModel::Waypoint::delPlantPatch(int idx)
{	plantPatches->RemoveAt(idx);
	totalPlantPatches = plantPatches->Count;
}