#include "stdafx.h"
#include "Model.h"

/**
* Constructor for PlantPatch.  Creates a PlantPatch with an arraylist of 9 CYG's.
*/

MhsModel::PlantPatch::PlantPatch(void)
{
	name = S"PlantPatch1";
	species = S"NoSpecies";
	diameter = 0.0f;
	distance = 0.0f;

	// build the array of randomly selected three 3D points
	srand(time(NULL));
	for( int i = 0; i < 3; i++ ){
		random3dPoints[i].X = (float) (rand() % 1500);
		random3dPoints[i].Y = (float) (rand() % 1500);
		random3dPoints[i].Z = (float) (rand() % 1500);
	}

	// Add CYGCOUNT CYG's to the PlantPatch
	cygs = new ArrayList();
	for( int i = 0; i < CYGCOUNT; i++ ){
		cygs->Add( new CurrentYearGrowth());
		CurrentYearGrowth __gc* tmpCyg = static_cast<CurrentYearGrowth*>(cygs->Item[i]);

		StringBuilder __gc* pfx = new StringBuilder("cyg");
		pfx->Append(i);
		tmpCyg->name = pfx->ToString();

		tmpCyg->setRef(&random3dPoints[i/3]);
	}
}


MhsModel::PlantPatch::~PlantPatch(void)
{
}

/** Overrides default toString() methods.
* @return - String representation of the PlantPatch in "<i>name, species, distance, diameter;</i>" format.
*/
String __gc* MhsModel::PlantPatch::toString()
{
	StringBuilder *sb = new StringBuilder();
	sb->Append("\t[");
	sb->Append(name);
	sb->Append(",");
	sb->Append(species);
	sb->Append(",dist=");
	sb->Append(distance);
	sb->Append(",diam=");
	sb->Append(diameter);
	sb->Append("\n");
	for( int i = 0; i < CYGCOUNT; i++ )
	{
		sb->Append(" ");
		CurrentYearGrowth * tmpCyg = static_cast<CurrentYearGrowth*>(cygs->Item[i]);
		sb->Append(tmpCyg->toString());
		sb->Append("\n");
	}
	sb->Append("\t]\n");
	return sb->ToString();
}

/** Export function for PlantPatch.
* @return - String representation of all data for this PlantPatch.
*/
String __gc* MhsModel::PlantPatch::toExport(String __gc* prefix)
{
	StringBuilder __gc* sb = new StringBuilder();

	// build our part of the prefix
	sb->Append(prefix);
	sb->Append(",");
	sb->Append(name);
	sb->Append(",");
	sb->Append(species);

	for(int i=0; i<CYGCOUNT; i++)
	{
		CurrentYearGrowth __gc* tmpCyg = static_cast<CurrentYearGrowth*>(cygs->Item[i]);
		sb->Append(",");
		sb->Append(tmpCyg->toExport());
	}

	sb->Append("\n");
	return sb->ToString();
}

/** Unit test for PlantPatch.
* @return - String representation of the predefined tests' results.
*/
String __gc* MhsModel::PlantPatch::unitTest()
{
	StringBuilder *sb = new StringBuilder();
	PlantPatch __gc* tmpPp = new PlantPatch();

	// matches default values?
	sb->Append("Default PlantPatch\n");
	sb->Append(tmpPp->toString());
	sb->Append("\n");

	// set values and display
	Vector3 __nogc* OneOneOne = __nogc new Vector3(1.0f,1.0f,1.0f);
	tmpPp->name = S"PlantPatch99";
	tmpPp->species = S"Willow";
	tmpPp->distance = 100;
	tmpPp->diameter = 1600;
	for(int i=0; i < CYGCOUNT; i++)
	{
		CurrentYearGrowth __gc* tmpCyg = static_cast<CurrentYearGrowth*>(tmpPp->cygs->Item[i]);
		tmpCyg->setBase(OneOneOne);
		tmpCyg->setTip(OneOneOne);
		tmpCyg->baseDiameter = i * 1.0f ;
	}

	sb->Append("Modified PlantPatch\n");
	sb->Append(tmpPp->toString());
	sb->Append("\n");

	// to export?
	sb->Append(tmpPp->toExport(S"PREFIX"));

	return sb->ToString();
}
