#pragma once

/**
	Containing namespace for the Model component of the MVC architecture
*/
namespace MhsModel
{	

	/** number of CYG's per plant patch */
	static const int CYGCOUNT=9;
	/** number of levels per plant patch */
	static const int LEVELCOUNT=3;

	/** Container and calculator new growth on a plant patch */
	__gc class CurrentYearGrowth
	{
	public:
	    //DECLARE_SERIAL( CurrentYearGrowth ) // allows serialization
		CurrentYearGrowth(void);
		~CurrentYearGrowth(void);
		String __gc* toString();
		String __gc* toExport();
		String __gc* unitTest();

		String __gc* name;
		Vector3 ref3dPoint;
		Vector3 base3dPoint;
		Vector3 tip3dPoint;
		float baseDiameter;
		void setBase(Vector3 * v);
		void setTip(Vector3 * v);
		void setRef(Vector3 * v);

	private:
		float distanceFrom3dRefPoint();
		float length();
		int calcDepthLevel();
	};

	/** Facade class for accessing Waypoint, PlantPatch, and CurrentYearGrowth contained in the Model */
	__gc class FieldTrip
	{
	public:
		FieldTrip();
		~FieldTrip();
		String __gc* toString();
		String __gc* unitTest();
		String __gc* toExport();

		String __gc* name;
		ArrayList __gc* waypoints;
		ArrayList __gc* fieldbiologists;
		
		// Waypoint methods
		int getWaypointCount(int wp_idx);
		void setWaypointName(int wp_idx, String __gc* nam);
		String __gc* getWaypointName(int wp_idx);
		String __gc* getWaypointHabitatType(int wp_idx);
		float getWaypointLatitude(int wp_idx);
		float getWaypointLongitude(int wp_idx);
		void setWaypointStartTime(int wp_idx, DateTime dt);
		DateTime getWaypointStartTime(int wp_idx);

		// PlantPatch methods
		void addPlantPatch( int wp_idx, String __gc* name, String __gc* species);
		void delPlantPatch( int wp_idx, int pp_idx);
		void setPlantPatchName(int wp_idx, int pp_idx, String __gc* nam);
		String __gc* getPlantPatchName(int wp_idx, int pp_idx);
		void setPlantPatchSpecies(int wp_idx, int pp_idx, String __gc* spec);
		String __gc* getPlantPatchSpecies(int wp_idx, int pp_idx);
		void setPlantPatchDiameter(int wp_idx, int pp_idx, float diam);
		float getPlantPatchDiameter(int wp_idx, int pp_idx);
		void setPlantPatchDistance(int wp_idx, int pp_idx, float dist);
		float getPlantPatchDistance(int wp_idx, int pp_idx);
		int getPlantPatchCount(int wp_idx);

		// CurrentYearGrowth methods
		void setCygBase(int wp_idx, int pp_idx, int cyg_idx, Vector3 __gc* b3d);
		Vector3 __gc* getCygBase(int wp_idx, int pp_idx, int cyg_idx);
		void setCygTip(int wp_idx, int pp_idx, int cyg_idx, Vector3 __gc* t3d);
		Vector3 __gc* getCygTip(int wp_idx, int pp_idx, int cyg_idx);
		void setCygRef(int wp_idx, int pp_idx, int cyg_idx, Vector3 __gc* t3d);
		Vector3 __gc* getCygRef(int wp_idx, int pp_idx, int cyg_idx);
		float getCygDiameter(int wp_idx, int pp_idx, int cyg_idx);
		void setCygDiameter(int wp_idx, int pp_idx, int cyg_idx, float diam);
		

	};


	/** A plant patch is a random 1x1x3 meter square selected from a plant at a waypoint. It contains 9 CYG's, 3 at each of 3 one-meter depth levels */
	__gc class PlantPatch
	{
	public:
		PlantPatch(void);
		~PlantPatch(void);
		String __gc* toString();
		String __gc* toExport(String __gc*);
		String __gc* unitTest();

		String __gc* name;
		String __gc* species;
		float distance;
		float diameter;
		ArrayList __gc* cygs;
		Vector3 random3dPoints __nogc [3];
	};

	/** Represents a gps location within a FieldTrip. It contains growable list of PlantPatches */
	__gc class Waypoint
	{
	public:
		Waypoint(float lat, float lon, String __gc* nam, String __gc* habitatTyp);
		Waypoint();
		~Waypoint();
		String __gc* toString();
		String __gc* toExport();
		String __gc* unitTest();
		int addPlantPatch(PlantPatch __gc* pp);
		void delPlantPatch(int idx);


		String *name;
		String *habitatType;
		float latitude;
		float longitude;
		ArrayList *plantPatches;
		DateTime startTime;
		int totalPlantPatches;
	};

}

using namespace MhsModel;