using System;
using System.IO;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Text;
using System.Reflection;

using System.Runtime.InteropServices;

using System.Xml;
using System.Xml.Serialization;

using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

using MhsModelCSharp;
using Mhs=MhsModelCSharp;

namespace MhsApplication
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class MhsMainAppForm : System.Windows.Forms.Form
	{
		private PlantPatchSoundRenderer patchSound1 = null;
		private int sampleTickCounter = 0;

		/// <summary>
		/// A timer that fires at the desired FPS rate
		/// <seealso cref="renderFps"/>
		/// <seealso cref="millisPerSec"/>
		/// </summary>
		//private Timer renderFpsTimer = new Timer();

		/// <summary>
		/// The desired framerate. The human eye sees realtime between 25-30 frames per second.
		/// It cannot exceed 60 because the Polhemu Patriot only cyles at 60hz. <= 30 is a 
		/// good choice.
		/// <seealso cref="renderFpsTimer"/>
		/// <seealso cref="millisPerSec"/>
		/// </summary>
		private const int renderFps = 30;

		/// <summary>
		/// 1000 milliseconds in a second. Used for FPS calculations.
		/// <seealso cref="renderFpsTimer"/>
		/// <seealso cref="renderFpsTimer"/>
		/// </summary>
		private const int millisPerSec = 1000;

		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem miOpen;
		private System.Windows.Forms.MenuItem miSave;
		private System.Windows.Forms.MenuItem miSaveAs;
		private System.Windows.Forms.MenuItem miImport;
		private System.Windows.Forms.MenuItem miExit;
		private System.Windows.Forms.MenuItem miCut;
		private System.Windows.Forms.MenuItem miCopy;
		private System.Windows.Forms.MenuItem miPaste;
		private System.Windows.Forms.MenuItem miHelpContents;
		private System.Windows.Forms.MenuItem miAbout;
		private System.Windows.Forms.MenuItem miSeparator1;
		private System.Windows.Forms.MenuItem miSeparator2;
		private System.Windows.Forms.MenuItem miExport;


		private System.Windows.Forms.ImageList imageList1;
		private System.Windows.Forms.ImageList imageList2;

		private FieldTrip fieldtrip = new FieldTrip();

		int wpIdx=-1, ppIdx=-1, cygIdx=-1;
		private System.Windows.Forms.MenuItem miPolhemusAutoReconnect;
		private System.Windows.Forms.MenuItem miConnectPolhemus;
		private System.Windows.Forms.MenuItem miDisconnectPolhemus;
		private AxCPolhemusStatusBarActiveXControlLib.AxCPolhemusStatusBarActiveXControl CPolhemus;
		private System.Windows.Forms.MenuItem miSoundEnabled;
		private System.Windows.Forms.StatusBar statusBar1;
		private System.Windows.Forms.Splitter splitter2;
		private System.Windows.Forms.StatusBarPanel statusBarPanel1;
		private System.Windows.Forms.StatusBarPanel statusBarPanel2;
		private System.Windows.Forms.StatusBarPanel statusBarPanel3;


		private Icon icnPolhemusConnected;
		private Icon icnPolhemusDisconnected;
		private System.Windows.Forms.ToolTip tooltip1;
		private System.Windows.Forms.MenuItem miDrawStylusDot;
		private System.Windows.Forms.MenuItem miDrawCylinder;

		private bool soundEnabled = true;
		private bool samplingMode = false;

		private Vector3 stylusPositionSum;
		private System.Windows.Forms.MenuItem miDrawOnlySelectedCygs;
		private System.Windows.Forms.Label lblStylusDistance;
		private System.Windows.Forms.Label lblCygReferencePoint;
		private System.Windows.Forms.Label lblStylusPositionText;
		private System.Windows.Forms.PictureBox pbCygReferencePoint;
		private System.Windows.Forms.PictureBox pbStylusDistance;
		private System.Windows.Forms.ToolBarButton tbbToggleStylus;
		private System.Windows.Forms.ToolBarButton tbbToggleSound;
		private System.Windows.Forms.ToolBarButton tbbToggleCylinder;
		private System.Windows.Forms.TreeView treeview1;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.TabControl tabControl1;
		private System.Windows.Forms.TabPage tpWaypointRenderer;
		private System.Windows.Forms.TabPage tpProperties;
		private System.Windows.Forms.ToolBarButton tbbAddNewPlantPatch;
		private System.Windows.Forms.ToolBarButton tbbSamplePlantPatch;
		private System.Windows.Forms.ToolBarButton tbbDeletePlantPatch;
		private System.Windows.Forms.Panel pnlWizard;
		private System.Windows.Forms.PropertyGrid propertyGrid1;
		private System.Windows.Forms.Panel pnlPolhemusReadoutIcons;
		private System.Windows.Forms.Panel pnlAboveStatusBar;
		private System.Windows.Forms.GroupBox gbWpRenderAndProperties;
		private System.Windows.Forms.Panel pnlTreeviewToolbar;
		private System.Windows.Forms.Panel pnlPolhemusReadoutRightOfToolbar;
		private System.Windows.Forms.Panel pnlPolhemusReadoutLabels;
		private System.Windows.Forms.GroupBox gb3dRender;
		private System.Windows.Forms.GroupBox gbModelHierarchy;
		private System.Windows.Forms.GroupBox gbPolhemusReadout;
		private System.Windows.Forms.MenuItem miDrawPolhemusBaseStation;
		private System.Windows.Forms.PictureBox pbPolhemusStylusPosition;
		private System.Windows.Forms.ToolBarButton tbbPlantPatchAdd;
		private System.Windows.Forms.ToolBarButton tbbPlantPatchDelete;
		private System.Windows.Forms.Panel pnlLeftBottom;
		private System.Windows.Forms.MenuItem miDrawAltimeters;
		private System.Windows.Forms.MenuItem miDrawSky;
		private System.Windows.Forms.Panel pnlLeft;
		private System.Windows.Forms.Panel pnlLeftMiddle;
		private System.Windows.Forms.Panel pnlLeftTop;
		private System.Windows.Forms.MenuItem miOptionsMenu;
		private System.Windows.Forms.MenuItem miFileMenu;
		private System.Windows.Forms.MenuItem miEditMenu;
		private System.Windows.Forms.MenuItem miPolhemusMenu;
		private System.Windows.Forms.MenuItem miDrawAxis;
		private System.Windows.Forms.MenuItem miDrawGround;
		private System.Windows.Forms.MenuItem miHelpMenu;
		private System.Windows.Forms.MenuItem miDebugMenu;
		private System.Windows.Forms.MenuItem miBlinkSelectedCyg;
		private System.Windows.Forms.Panel pnlBigOneOnTopOfStatusBar;
		private System.Windows.Forms.Panel pnlRight;
		private MhsApplication.PlantPatchRenderer usrPlantPatchRenderer;
		private MhsApplication.PlantPatchWizard usrPlantPatchWizard;
		private System.Windows.Forms.ToolBar toolbarModelHierarchy;
		private System.Windows.Forms.Panel pnlPolhemusReadout;
		private System.Windows.Forms.ToolBar toolbarPolhemusReadout;
		private System.Windows.Forms.Timer timerPolhemusSample;
		private System.Windows.Forms.Timer timerPolhemusStatusCheck;
		private System.Windows.Forms.ToolBarButton tbbPlantPatchSample;
		private System.Windows.Forms.ToolBarButton toolBarButton4;
		private MhsApplication.WaypointRenderer usrWaypointRenderer;
		private System.Windows.Forms.ToolBarButton tbbProperties;
		private Vector3 stylusPositionAvg;

		public MhsMainAppForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(MhsMainAppForm));

			icnPolhemusConnected = new Icon(Assembly.GetExecutingAssembly().GetManifestResourceStream("MhsApplication.choice-yes.ico"));
			icnPolhemusDisconnected = new Icon(Assembly.GetExecutingAssembly().GetManifestResourceStream("MhsApplication.choice-no.ico"));

			
			string[] rs= Assembly.GetExecutingAssembly().GetManifestResourceNames();

//			LoadFieldTripFromFile("C:\\Documents and Settings\\axjww\\Desktop\\CS470 Software project\\mhs\\data\\Presentation.xml");
//
//			// TODO
//			Random r = new Random();
//			foreach(PlantPatch pp in fieldtrip.Waypoints[0].PlantPatches)
//			{
//				int cygi = 0;
//				foreach(CurrentYearGrowth cyg in pp.Cygs)
//				{
//
//					float depthlevel = (float) ( cygi / 3 ); // truncates
//
//					// base point
//					float bx = (float) (80 * r.NextDouble());
//					float by = (float) (80 * r.NextDouble());
//					float bz = (float) (80 * (r.NextDouble()+depthlevel));
//					cyg.BasePoint = new Vector3(bx,by,bz);
//
//					// modifier
//					float lenMod = 30f;
//					float mx = (float) (bx + ((r.NextDouble()-0.5) * lenMod));
//					float my = (float) (by + ((r.NextDouble()-0.5) * lenMod));
//					float mz = (float) (bz + ((r.NextDouble()-0.5) * lenMod));
//					cyg.TipPoint  = new Vector3(mx,my,mz);
//
//					// base diameter, proportional to length
//					cyg.BaseDiameter = cyg.Length * .2f;
//
//					// random point
//					float rx = (float) (r.NextDouble() * 100f);
//					float ry = (float) (r.NextDouble() * 100f);
//					float rz = (float) ((r.NextDouble()+depthlevel) * 100f);
//					cyg.ReferencePoint = new Vector3(rx,ry,rz);
//		
//					cygi++;
//				}
//			}

			SetupTooltips();

		}

		private void SetupTooltips()
		{
			tooltip1.SetToolTip(this.lblStylusPositionText,"Polhemus stylus current coordinates in the PlantPatch's 3D cartesian space");
			tooltip1.SetToolTip(this.lblCygReferencePoint,"CYG's random reference point in the PlantPatch's 3D cartesian space that must be pin pointed with the stylus");
			tooltip1.SetToolTip(this.pbCygReferencePoint,"CYG's random reference point in the PlantPatch's 3D cartesian space that must be pin pointed with the stylus");
			tooltip1.SetToolTip(this.lblStylusDistance,"The distance in centimeters between the stylus and the target reference point.");
			tooltip1.SetToolTip(this.pbStylusDistance,"The distance in centimeters between the stylus and the target reference point.");
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				CPolhemus.DisconnectPolhemus();
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(MhsMainAppForm));
			this.CPolhemus = new AxCPolhemusStatusBarActiveXControlLib.AxCPolhemusStatusBarActiveXControl();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.miFileMenu = new System.Windows.Forms.MenuItem();
			this.miOpen = new System.Windows.Forms.MenuItem();
			this.miSave = new System.Windows.Forms.MenuItem();
			this.miSaveAs = new System.Windows.Forms.MenuItem();
			this.miSeparator1 = new System.Windows.Forms.MenuItem();
			this.miImport = new System.Windows.Forms.MenuItem();
			this.miExport = new System.Windows.Forms.MenuItem();
			this.miSeparator2 = new System.Windows.Forms.MenuItem();
			this.miExit = new System.Windows.Forms.MenuItem();
			this.miEditMenu = new System.Windows.Forms.MenuItem();
			this.miCut = new System.Windows.Forms.MenuItem();
			this.miCopy = new System.Windows.Forms.MenuItem();
			this.miPaste = new System.Windows.Forms.MenuItem();
			this.miOptionsMenu = new System.Windows.Forms.MenuItem();
			this.miDrawAxis = new System.Windows.Forms.MenuItem();
			this.miDrawAltimeters = new System.Windows.Forms.MenuItem();
			this.miDrawGround = new System.Windows.Forms.MenuItem();
			this.miDrawOnlySelectedCygs = new System.Windows.Forms.MenuItem();
			this.miDrawPolhemusBaseStation = new System.Windows.Forms.MenuItem();
			this.miDrawCylinder = new System.Windows.Forms.MenuItem();
			this.miDrawSky = new System.Windows.Forms.MenuItem();
			this.miDrawStylusDot = new System.Windows.Forms.MenuItem();
			this.miBlinkSelectedCyg = new System.Windows.Forms.MenuItem();
			this.miSoundEnabled = new System.Windows.Forms.MenuItem();
			this.miPolhemusMenu = new System.Windows.Forms.MenuItem();
			this.miPolhemusAutoReconnect = new System.Windows.Forms.MenuItem();
			this.miConnectPolhemus = new System.Windows.Forms.MenuItem();
			this.miDisconnectPolhemus = new System.Windows.Forms.MenuItem();
			this.miHelpMenu = new System.Windows.Forms.MenuItem();
			this.miHelpContents = new System.Windows.Forms.MenuItem();
			this.miAbout = new System.Windows.Forms.MenuItem();
			this.miDebugMenu = new System.Windows.Forms.MenuItem();
			this.imageList1 = new System.Windows.Forms.ImageList(this.components);
			this.imageList2 = new System.Windows.Forms.ImageList(this.components);
			this.pnlAboveStatusBar = new System.Windows.Forms.Panel();
			this.pnlBigOneOnTopOfStatusBar = new System.Windows.Forms.Panel();
			this.pnlRight = new System.Windows.Forms.Panel();
			this.gb3dRender = new System.Windows.Forms.GroupBox();
			this.usrPlantPatchRenderer = new MhsApplication.PlantPatchRenderer();
			this.pnlWizard = new System.Windows.Forms.Panel();
			this.usrPlantPatchWizard = new MhsApplication.PlantPatchWizard();
			this.splitter2 = new System.Windows.Forms.Splitter();
			this.pnlLeft = new System.Windows.Forms.Panel();
			this.pnlLeftBottom = new System.Windows.Forms.Panel();
			this.gbWpRenderAndProperties = new System.Windows.Forms.GroupBox();
			this.tabControl1 = new System.Windows.Forms.TabControl();
			this.tpWaypointRenderer = new System.Windows.Forms.TabPage();
			this.usrWaypointRenderer = new MhsApplication.WaypointRenderer();
			this.tpProperties = new System.Windows.Forms.TabPage();
			this.propertyGrid1 = new System.Windows.Forms.PropertyGrid();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.pnlLeftMiddle = new System.Windows.Forms.Panel();
			this.gbModelHierarchy = new System.Windows.Forms.GroupBox();
			this.pnlTreeviewToolbar = new System.Windows.Forms.Panel();
			this.treeview1 = new System.Windows.Forms.TreeView();
			this.toolbarModelHierarchy = new System.Windows.Forms.ToolBar();
			this.tbbAddNewPlantPatch = new System.Windows.Forms.ToolBarButton();
			this.tbbSamplePlantPatch = new System.Windows.Forms.ToolBarButton();
			this.tbbDeletePlantPatch = new System.Windows.Forms.ToolBarButton();
			this.tbbProperties = new System.Windows.Forms.ToolBarButton();
			this.pnlLeftTop = new System.Windows.Forms.Panel();
			this.gbPolhemusReadout = new System.Windows.Forms.GroupBox();
			this.pnlPolhemusReadout = new System.Windows.Forms.Panel();
			this.pnlPolhemusReadoutRightOfToolbar = new System.Windows.Forms.Panel();
			this.pnlPolhemusReadoutLabels = new System.Windows.Forms.Panel();
			this.lblStylusDistance = new System.Windows.Forms.Label();
			this.lblCygReferencePoint = new System.Windows.Forms.Label();
			this.lblStylusPositionText = new System.Windows.Forms.Label();
			this.pnlPolhemusReadoutIcons = new System.Windows.Forms.Panel();
			this.pbPolhemusStylusPosition = new System.Windows.Forms.PictureBox();
			this.pbCygReferencePoint = new System.Windows.Forms.PictureBox();
			this.pbStylusDistance = new System.Windows.Forms.PictureBox();
			this.toolbarPolhemusReadout = new System.Windows.Forms.ToolBar();
			this.tbbToggleStylus = new System.Windows.Forms.ToolBarButton();
			this.tbbToggleSound = new System.Windows.Forms.ToolBarButton();
			this.tbbToggleCylinder = new System.Windows.Forms.ToolBarButton();
			this.statusBar1 = new System.Windows.Forms.StatusBar();
			this.statusBarPanel1 = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanel2 = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanel3 = new System.Windows.Forms.StatusBarPanel();
			this.timerPolhemusSample = new System.Windows.Forms.Timer(this.components);
			this.timerPolhemusStatusCheck = new System.Windows.Forms.Timer(this.components);
			this.tbbPlantPatchAdd = new System.Windows.Forms.ToolBarButton();
			this.tbbPlantPatchSample = new System.Windows.Forms.ToolBarButton();
			this.tbbPlantPatchDelete = new System.Windows.Forms.ToolBarButton();
			this.tooltip1 = new System.Windows.Forms.ToolTip(this.components);
			this.toolBarButton4 = new System.Windows.Forms.ToolBarButton();
			((System.ComponentModel.ISupportInitialize)(this.CPolhemus)).BeginInit();
			this.pnlAboveStatusBar.SuspendLayout();
			this.pnlBigOneOnTopOfStatusBar.SuspendLayout();
			this.pnlRight.SuspendLayout();
			this.gb3dRender.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.usrPlantPatchRenderer)).BeginInit();
			this.pnlWizard.SuspendLayout();
			this.pnlLeft.SuspendLayout();
			this.pnlLeftBottom.SuspendLayout();
			this.gbWpRenderAndProperties.SuspendLayout();
			this.tabControl1.SuspendLayout();
			this.tpWaypointRenderer.SuspendLayout();
			this.tpProperties.SuspendLayout();
			this.pnlLeftMiddle.SuspendLayout();
			this.gbModelHierarchy.SuspendLayout();
			this.pnlTreeviewToolbar.SuspendLayout();
			this.pnlLeftTop.SuspendLayout();
			this.gbPolhemusReadout.SuspendLayout();
			this.pnlPolhemusReadout.SuspendLayout();
			this.pnlPolhemusReadoutRightOfToolbar.SuspendLayout();
			this.pnlPolhemusReadoutLabels.SuspendLayout();
			this.pnlPolhemusReadoutIcons.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel1)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel2)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel3)).BeginInit();
			this.SuspendLayout();
			// 
			// CPolhemus
			// 
			this.CPolhemus.Enabled = true;
			this.CPolhemus.Location = new System.Drawing.Point(0, 0);
			this.CPolhemus.Name = "CPolhemus";
			this.CPolhemus.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("CPolhemus.OcxState")));
			this.CPolhemus.Size = new System.Drawing.Size(0, 0);
			this.CPolhemus.TabIndex = 0;
			this.CPolhemus.Visible = false;
			this.CPolhemus.WM_CPOLHEMUS_STYLUSBTN_DATA += new AxCPolhemusStatusBarActiveXControlLib._DCPolhemusStatusBarActiveXControlEvents_WM_CPOLHEMUS_STYLUSBTN_DATAEventHandler(this.CPolhemus_StylusButtonPress);
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.miFileMenu,
																					  this.miEditMenu,
																					  this.miOptionsMenu,
																					  this.miPolhemusMenu,
																					  this.miHelpMenu,
																					  this.miDebugMenu});
			// 
			// miFileMenu
			// 
			this.miFileMenu.Index = 0;
			this.miFileMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					   this.miOpen,
																					   this.miSave,
																					   this.miSaveAs,
																					   this.miSeparator1,
																					   this.miImport,
																					   this.miExport,
																					   this.miSeparator2,
																					   this.miExit});
			this.miFileMenu.Text = "File";
			// 
			// miOpen
			// 
			this.miOpen.Index = 0;
			this.miOpen.Text = "&Open";
			this.miOpen.Click += new System.EventHandler(this.miOpen_Click);
			// 
			// miSave
			// 
			this.miSave.Index = 1;
			this.miSave.Text = "&Save";
			this.miSave.Click += new System.EventHandler(this.miSave_Click);
			// 
			// miSaveAs
			// 
			this.miSaveAs.Index = 2;
			this.miSaveAs.Text = "Save &As...";
			this.miSaveAs.Visible = false;
			// 
			// miSeparator1
			// 
			this.miSeparator1.Index = 3;
			this.miSeparator1.Text = "-";
			// 
			// miImport
			// 
			this.miImport.Index = 4;
			this.miImport.Text = "&Import...";
			this.miImport.Click += new System.EventHandler(this.miImport_Click);
			// 
			// miExport
			// 
			this.miExport.Index = 5;
			this.miExport.Text = "&Export...";
			this.miExport.Click += new System.EventHandler(this.miExport_Click);
			// 
			// miSeparator2
			// 
			this.miSeparator2.Index = 6;
			this.miSeparator2.Text = "-";
			// 
			// miExit
			// 
			this.miExit.Index = 7;
			this.miExit.Text = "E&xit";
			// 
			// miEditMenu
			// 
			this.miEditMenu.Index = 1;
			this.miEditMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					   this.miCut,
																					   this.miCopy,
																					   this.miPaste});
			this.miEditMenu.Text = "Edit";
			// 
			// miCut
			// 
			this.miCut.Index = 0;
			this.miCut.Text = "Cut";
			// 
			// miCopy
			// 
			this.miCopy.Index = 1;
			this.miCopy.Text = "Copy";
			// 
			// miPaste
			// 
			this.miPaste.Index = 2;
			this.miPaste.Text = "Paste";
			// 
			// miOptionsMenu
			// 
			this.miOptionsMenu.Index = 2;
			this.miOptionsMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						  this.miDrawAxis,
																						  this.miDrawAltimeters,
																						  this.miDrawGround,
																						  this.miDrawOnlySelectedCygs,
																						  this.miDrawPolhemusBaseStation,
																						  this.miDrawCylinder,
																						  this.miDrawSky,
																						  this.miDrawStylusDot,
																						  this.miBlinkSelectedCyg,
																						  this.miSoundEnabled});
			this.miOptionsMenu.Text = "Options";
			// 
			// miDrawAxis
			// 
			this.miDrawAxis.Checked = true;
			this.miDrawAxis.Index = 0;
			this.miDrawAxis.Text = "Draw Coordinate Axis";
			this.miDrawAxis.Click += new System.EventHandler(this.miDrawAxis_Click);
			// 
			// miDrawAltimeters
			// 
			this.miDrawAltimeters.Checked = true;
			this.miDrawAltimeters.Index = 1;
			this.miDrawAltimeters.Text = "Draw Altimeters";
			this.miDrawAltimeters.Click += new System.EventHandler(this.miDrawAltimeters_Click);
			// 
			// miDrawGround
			// 
			this.miDrawGround.Checked = true;
			this.miDrawGround.Index = 2;
			this.miDrawGround.Text = "Draw Ground";
			this.miDrawGround.Click += new System.EventHandler(this.miDrawGround_Click);
			// 
			// miDrawOnlySelectedCygs
			// 
			this.miDrawOnlySelectedCygs.Checked = true;
			this.miDrawOnlySelectedCygs.Index = 3;
			this.miDrawOnlySelectedCygs.Text = "Draw Only Selected CYG";
			this.miDrawOnlySelectedCygs.Click += new System.EventHandler(this.miDrawOnlySelectedCygs_Click);
			// 
			// miDrawPolhemusBaseStation
			// 
			this.miDrawPolhemusBaseStation.Checked = true;
			this.miDrawPolhemusBaseStation.Index = 4;
			this.miDrawPolhemusBaseStation.Text = "Draw Polhemus Base Station";
			this.miDrawPolhemusBaseStation.Click += new System.EventHandler(this.miDrawPolhemusBaseStation_Click);
			// 
			// miDrawCylinder
			// 
			this.miDrawCylinder.Checked = true;
			this.miDrawCylinder.Index = 5;
			this.miDrawCylinder.Text = "Draw Sampling Cylinder";
			this.miDrawCylinder.Click += new System.EventHandler(this.miDrawSamplingCylinder_Click);
			// 
			// miDrawSky
			// 
			this.miDrawSky.Index = 6;
			this.miDrawSky.Text = "Draw Sky";
			this.miDrawSky.Click += new System.EventHandler(this.miDrawSky_Click);
			// 
			// miDrawStylusDot
			// 
			this.miDrawStylusDot.Checked = true;
			this.miDrawStylusDot.Index = 7;
			this.miDrawStylusDot.Text = "Draw Stylus Dot";
			this.miDrawStylusDot.Click += new System.EventHandler(this.miDrawStylusDot_Click);
			// 
			// miBlinkSelectedCyg
			// 
			this.miBlinkSelectedCyg.Checked = true;
			this.miBlinkSelectedCyg.Index = 8;
			this.miBlinkSelectedCyg.Text = "Blink Selected CYG";
			this.miBlinkSelectedCyg.Click += new System.EventHandler(this.miBlinkSelectedCyg_Click);
			// 
			// miSoundEnabled
			// 
			this.miSoundEnabled.Checked = true;
			this.miSoundEnabled.Index = 9;
			this.miSoundEnabled.Text = "Sound Enabled";
			this.miSoundEnabled.Click += new System.EventHandler(this.miSoundEnabled_Click);
			// 
			// miPolhemusMenu
			// 
			this.miPolhemusMenu.Index = 3;
			this.miPolhemusMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						   this.miPolhemusAutoReconnect,
																						   this.miConnectPolhemus,
																						   this.miDisconnectPolhemus});
			this.miPolhemusMenu.Text = "Polhemus";
			// 
			// miPolhemusAutoReconnect
			// 
			this.miPolhemusAutoReconnect.Index = 0;
			this.miPolhemusAutoReconnect.RadioCheck = true;
			this.miPolhemusAutoReconnect.Text = "Automatically Connect";
			this.miPolhemusAutoReconnect.Click += new System.EventHandler(this.miPolhemusAutoReconnect_Click);
			// 
			// miConnectPolhemus
			// 
			this.miConnectPolhemus.Index = 1;
			this.miConnectPolhemus.Text = "Connect";
			this.miConnectPolhemus.Click += new System.EventHandler(this.miConnectPolhemus_Click);
			// 
			// miDisconnectPolhemus
			// 
			this.miDisconnectPolhemus.Index = 2;
			this.miDisconnectPolhemus.Text = "Disconnect";
			this.miDisconnectPolhemus.Click += new System.EventHandler(this.miDisconnectPolhemus_Click);
			// 
			// miHelpMenu
			// 
			this.miHelpMenu.Index = 4;
			this.miHelpMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					   this.miHelpContents,
																					   this.miAbout});
			this.miHelpMenu.Text = "Help";
			// 
			// miHelpContents
			// 
			this.miHelpContents.Index = 0;
			this.miHelpContents.Text = "Help Contents";
			this.miHelpContents.Click += new System.EventHandler(this.miHelpContents_Click);
			// 
			// miAbout
			// 
			this.miAbout.Index = 1;
			this.miAbout.Text = "About";
			// 
			// miDebugMenu
			// 
			this.miDebugMenu.Index = 5;
			this.miDebugMenu.Text = "Debug";
			this.miDebugMenu.Visible = false;
			// 
			// imageList1
			// 
			this.imageList1.ColorDepth = System.Windows.Forms.ColorDepth.Depth24Bit;
			this.imageList1.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.imageList1.TransparentColor = System.Drawing.Color.Yellow;
			// 
			// imageList2
			// 
			this.imageList2.ColorDepth = System.Windows.Forms.ColorDepth.Depth24Bit;
			this.imageList2.ImageSize = new System.Drawing.Size(24, 24);
			this.imageList2.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList2.ImageStream")));
			this.imageList2.TransparentColor = System.Drawing.Color.Yellow;
			// 
			// pnlAboveStatusBar
			// 
			this.pnlAboveStatusBar.BackColor = System.Drawing.SystemColors.Control;
			this.pnlAboveStatusBar.Controls.Add(this.pnlBigOneOnTopOfStatusBar);
			this.pnlAboveStatusBar.Controls.Add(this.statusBar1);
			this.pnlAboveStatusBar.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlAboveStatusBar.Location = new System.Drawing.Point(0, 0);
			this.pnlAboveStatusBar.Name = "pnlAboveStatusBar";
			this.pnlAboveStatusBar.Size = new System.Drawing.Size(1016, 701);
			this.pnlAboveStatusBar.TabIndex = 7;
			// 
			// pnlBigOneOnTopOfStatusBar
			// 
			this.pnlBigOneOnTopOfStatusBar.Controls.Add(this.pnlRight);
			this.pnlBigOneOnTopOfStatusBar.Controls.Add(this.splitter2);
			this.pnlBigOneOnTopOfStatusBar.Controls.Add(this.pnlLeft);
			this.pnlBigOneOnTopOfStatusBar.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlBigOneOnTopOfStatusBar.Location = new System.Drawing.Point(0, 0);
			this.pnlBigOneOnTopOfStatusBar.Name = "pnlBigOneOnTopOfStatusBar";
			this.pnlBigOneOnTopOfStatusBar.Size = new System.Drawing.Size(1016, 679);
			this.pnlBigOneOnTopOfStatusBar.TabIndex = 6;
			// 
			// pnlRight
			// 
			this.pnlRight.Controls.Add(this.gb3dRender);
			this.pnlRight.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlRight.DockPadding.All = 4;
			this.pnlRight.Location = new System.Drawing.Point(435, 0);
			this.pnlRight.Name = "pnlRight";
			this.pnlRight.Size = new System.Drawing.Size(581, 679);
			this.pnlRight.TabIndex = 8;
			// 
			// gb3dRender
			// 
			this.gb3dRender.Controls.Add(this.usrPlantPatchRenderer);
			this.gb3dRender.Controls.Add(this.pnlWizard);
			this.gb3dRender.Dock = System.Windows.Forms.DockStyle.Fill;
			this.gb3dRender.Location = new System.Drawing.Point(4, 4);
			this.gb3dRender.Name = "gb3dRender";
			this.gb3dRender.Size = new System.Drawing.Size(573, 671);
			this.gb3dRender.TabIndex = 10;
			this.gb3dRender.TabStop = false;
			this.gb3dRender.Text = "PlantPatch 3D View";
			// 
			// usrPlantPatchRenderer
			// 
			this.usrPlantPatchRenderer.BlinkSelectedCyg = true;
			this.usrPlantPatchRenderer.CameraPositionIndex = 4;
			this.usrPlantPatchRenderer.CygIndex = -1;
			this.usrPlantPatchRenderer.Dock = System.Windows.Forms.DockStyle.Fill;
			this.usrPlantPatchRenderer.DrawAltimeter = true;
			this.usrPlantPatchRenderer.DrawAxis = true;
			this.usrPlantPatchRenderer.DrawAxisLabels = false;
			this.usrPlantPatchRenderer.DrawBoundingCylinder = true;
			this.usrPlantPatchRenderer.DrawCygs = true;
			this.usrPlantPatchRenderer.DrawGround = true;
			this.usrPlantPatchRenderer.DrawOnlySelectedCygs = true;
			this.usrPlantPatchRenderer.DrawPolhemusBaseStation = true;
			this.usrPlantPatchRenderer.DrawSky = false;
			this.usrPlantPatchRenderer.DrawStylusContinuousSprite = false;
			this.usrPlantPatchRenderer.DrawStylusDepressedSprite = false;
			this.usrPlantPatchRenderer.DrawStylusPosition = true;
			this.usrPlantPatchRenderer.Location = new System.Drawing.Point(3, 64);
			this.usrPlantPatchRenderer.Name = "usrPlantPatchRenderer";
			this.usrPlantPatchRenderer.RenderPaused = true;
			this.usrPlantPatchRenderer.Size = new System.Drawing.Size(567, 604);
			this.usrPlantPatchRenderer.TabIndex = 12;
			// 
			// pnlWizard
			// 
			this.pnlWizard.BackColor = System.Drawing.SystemColors.Window;
			this.pnlWizard.Controls.Add(this.usrPlantPatchWizard);
			this.pnlWizard.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlWizard.Location = new System.Drawing.Point(3, 16);
			this.pnlWizard.Name = "pnlWizard";
			this.pnlWizard.Size = new System.Drawing.Size(567, 48);
			this.pnlWizard.TabIndex = 11;
			// 
			// usrPlantPatchWizard
			// 
			this.usrPlantPatchWizard.Dock = System.Windows.Forms.DockStyle.Fill;
			this.usrPlantPatchWizard.Location = new System.Drawing.Point(0, 0);
			this.usrPlantPatchWizard.Name = "usrPlantPatchWizard";
			this.usrPlantPatchWizard.Size = new System.Drawing.Size(567, 48);
			this.usrPlantPatchWizard.TabIndex = 0;
			// 
			// splitter2
			// 
			this.splitter2.Location = new System.Drawing.Point(432, 0);
			this.splitter2.Name = "splitter2";
			this.splitter2.Size = new System.Drawing.Size(3, 679);
			this.splitter2.TabIndex = 7;
			this.splitter2.TabStop = false;
			// 
			// pnlLeft
			// 
			this.pnlLeft.Controls.Add(this.pnlLeftBottom);
			this.pnlLeft.Controls.Add(this.splitter1);
			this.pnlLeft.Controls.Add(this.pnlLeftMiddle);
			this.pnlLeft.Controls.Add(this.pnlLeftTop);
			this.pnlLeft.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlLeft.Location = new System.Drawing.Point(0, 0);
			this.pnlLeft.Name = "pnlLeft";
			this.pnlLeft.Size = new System.Drawing.Size(432, 679);
			this.pnlLeft.TabIndex = 6;
			// 
			// pnlLeftBottom
			// 
			this.pnlLeftBottom.Controls.Add(this.gbWpRenderAndProperties);
			this.pnlLeftBottom.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlLeftBottom.DockPadding.All = 4;
			this.pnlLeftBottom.Location = new System.Drawing.Point(0, 315);
			this.pnlLeftBottom.Name = "pnlLeftBottom";
			this.pnlLeftBottom.Size = new System.Drawing.Size(432, 364);
			this.pnlLeftBottom.TabIndex = 15;
			// 
			// gbWpRenderAndProperties
			// 
			this.gbWpRenderAndProperties.Controls.Add(this.tabControl1);
			this.gbWpRenderAndProperties.Dock = System.Windows.Forms.DockStyle.Fill;
			this.gbWpRenderAndProperties.Location = new System.Drawing.Point(4, 4);
			this.gbWpRenderAndProperties.Name = "gbWpRenderAndProperties";
			this.gbWpRenderAndProperties.Size = new System.Drawing.Size(424, 356);
			this.gbWpRenderAndProperties.TabIndex = 0;
			this.gbWpRenderAndProperties.TabStop = false;
			this.gbWpRenderAndProperties.Text = "Model Details";
			// 
			// tabControl1
			// 
			this.tabControl1.Controls.Add(this.tpWaypointRenderer);
			this.tabControl1.Controls.Add(this.tpProperties);
			this.tabControl1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.tabControl1.ItemSize = new System.Drawing.Size(96, 18);
			this.tabControl1.Location = new System.Drawing.Point(3, 16);
			this.tabControl1.Name = "tabControl1";
			this.tabControl1.SelectedIndex = 0;
			this.tabControl1.Size = new System.Drawing.Size(418, 337);
			this.tabControl1.TabIndex = 9;
			// 
			// tpWaypointRenderer
			// 
			this.tpWaypointRenderer.Controls.Add(this.usrWaypointRenderer);
			this.tpWaypointRenderer.Location = new System.Drawing.Point(4, 22);
			this.tpWaypointRenderer.Name = "tpWaypointRenderer";
			this.tpWaypointRenderer.Size = new System.Drawing.Size(410, 311);
			this.tpWaypointRenderer.TabIndex = 1;
			this.tpWaypointRenderer.Text = "Waypoint Viewer";
			// 
			// usrWaypointRenderer
			// 
			this.usrWaypointRenderer.BackColor = System.Drawing.SystemColors.Control;
			this.usrWaypointRenderer.Dock = System.Windows.Forms.DockStyle.Fill;
			this.usrWaypointRenderer.Location = new System.Drawing.Point(0, 0);
			this.usrWaypointRenderer.Name = "usrWaypointRenderer";
			this.usrWaypointRenderer.PauseRender = false;
			this.usrWaypointRenderer.Size = new System.Drawing.Size(410, 311);
			this.usrWaypointRenderer.TabIndex = 0;
			this.usrWaypointRenderer.Waypoint = null;
			// 
			// tpProperties
			// 
			this.tpProperties.Controls.Add(this.propertyGrid1);
			this.tpProperties.Location = new System.Drawing.Point(4, 22);
			this.tpProperties.Name = "tpProperties";
			this.tpProperties.Size = new System.Drawing.Size(410, 311);
			this.tpProperties.TabIndex = 0;
			this.tpProperties.Text = "Properties";
			this.tpProperties.Visible = false;
			// 
			// propertyGrid1
			// 
			this.propertyGrid1.CommandsVisibleIfAvailable = true;
			this.propertyGrid1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.propertyGrid1.HelpVisible = false;
			this.propertyGrid1.LargeButtons = false;
			this.propertyGrid1.LineColor = System.Drawing.SystemColors.ScrollBar;
			this.propertyGrid1.Location = new System.Drawing.Point(0, 0);
			this.propertyGrid1.Name = "propertyGrid1";
			this.propertyGrid1.PropertySort = System.Windows.Forms.PropertySort.NoSort;
			this.propertyGrid1.Size = new System.Drawing.Size(410, 311);
			this.propertyGrid1.TabIndex = 3;
			this.propertyGrid1.Text = "propertyGrid1";
			this.propertyGrid1.ToolbarVisible = false;
			this.propertyGrid1.ViewBackColor = System.Drawing.SystemColors.Window;
			this.propertyGrid1.ViewForeColor = System.Drawing.SystemColors.WindowText;
			this.propertyGrid1.PropertyValueChanged += new System.Windows.Forms.PropertyValueChangedEventHandler(this.propertyGrid1_PropertyValueChanged);
			// 
			// splitter1
			// 
			this.splitter1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.splitter1.Dock = System.Windows.Forms.DockStyle.Top;
			this.splitter1.Location = new System.Drawing.Point(0, 312);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(432, 3);
			this.splitter1.TabIndex = 14;
			this.splitter1.TabStop = false;
			// 
			// pnlLeftMiddle
			// 
			this.pnlLeftMiddle.BackColor = System.Drawing.SystemColors.Control;
			this.pnlLeftMiddle.Controls.Add(this.gbModelHierarchy);
			this.pnlLeftMiddle.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlLeftMiddle.DockPadding.All = 4;
			this.pnlLeftMiddle.Location = new System.Drawing.Point(0, 128);
			this.pnlLeftMiddle.Name = "pnlLeftMiddle";
			this.pnlLeftMiddle.Size = new System.Drawing.Size(432, 184);
			this.pnlLeftMiddle.TabIndex = 13;
			// 
			// gbModelHierarchy
			// 
			this.gbModelHierarchy.Controls.Add(this.pnlTreeviewToolbar);
			this.gbModelHierarchy.Dock = System.Windows.Forms.DockStyle.Fill;
			this.gbModelHierarchy.Location = new System.Drawing.Point(4, 4);
			this.gbModelHierarchy.Name = "gbModelHierarchy";
			this.gbModelHierarchy.Size = new System.Drawing.Size(424, 176);
			this.gbModelHierarchy.TabIndex = 0;
			this.gbModelHierarchy.TabStop = false;
			this.gbModelHierarchy.Text = "Model Hierarchy";
			// 
			// pnlTreeviewToolbar
			// 
			this.pnlTreeviewToolbar.BackColor = System.Drawing.SystemColors.Control;
			this.pnlTreeviewToolbar.Controls.Add(this.treeview1);
			this.pnlTreeviewToolbar.Controls.Add(this.toolbarModelHierarchy);
			this.pnlTreeviewToolbar.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlTreeviewToolbar.Location = new System.Drawing.Point(3, 16);
			this.pnlTreeviewToolbar.Name = "pnlTreeviewToolbar";
			this.pnlTreeviewToolbar.Size = new System.Drawing.Size(418, 157);
			this.pnlTreeviewToolbar.TabIndex = 8;
			// 
			// treeview1
			// 
			this.treeview1.BorderStyle = System.Windows.Forms.BorderStyle.None;
			this.treeview1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.treeview1.ImageList = this.imageList1;
			this.treeview1.Location = new System.Drawing.Point(34, 0);
			this.treeview1.Name = "treeview1";
			this.treeview1.ShowLines = false;
			this.treeview1.Size = new System.Drawing.Size(384, 157);
			this.treeview1.TabIndex = 9;
			this.treeview1.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.treeview1_AfterSelect);
			// 
			// toolbarModelHierarchy
			// 
			this.toolbarModelHierarchy.Appearance = System.Windows.Forms.ToolBarAppearance.Flat;
			this.toolbarModelHierarchy.AutoSize = false;
			this.toolbarModelHierarchy.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
																									 this.tbbAddNewPlantPatch,
																									 this.tbbSamplePlantPatch,
																									 this.tbbDeletePlantPatch,
																									 this.tbbProperties});
			this.toolbarModelHierarchy.ButtonSize = new System.Drawing.Size(24, 24);
			this.toolbarModelHierarchy.Divider = false;
			this.toolbarModelHierarchy.Dock = System.Windows.Forms.DockStyle.Left;
			this.toolbarModelHierarchy.DropDownArrows = true;
			this.toolbarModelHierarchy.ImageList = this.imageList2;
			this.toolbarModelHierarchy.Location = new System.Drawing.Point(0, 0);
			this.toolbarModelHierarchy.Name = "toolbarModelHierarchy";
			this.toolbarModelHierarchy.ShowToolTips = true;
			this.toolbarModelHierarchy.Size = new System.Drawing.Size(34, 157);
			this.toolbarModelHierarchy.TabIndex = 8;
			this.toolbarModelHierarchy.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.toolbarModelHierarchy_ButtonClick);
			// 
			// tbbAddNewPlantPatch
			// 
			this.tbbAddNewPlantPatch.ImageIndex = 1;
			this.tbbAddNewPlantPatch.ToolTipText = "Add a new PlantPatch to this waypoint";
			// 
			// tbbSamplePlantPatch
			// 
			this.tbbSamplePlantPatch.ImageIndex = 0;
			this.tbbSamplePlantPatch.ToolTipText = "Sample the CYG\'s in this PlantPatch";
			// 
			// tbbDeletePlantPatch
			// 
			this.tbbDeletePlantPatch.ImageIndex = 2;
			this.tbbDeletePlantPatch.ToolTipText = "Delete the selected PlantPatch";
			// 
			// tbbProperties
			// 
			this.tbbProperties.ImageIndex = 3;
			// 
			// pnlLeftTop
			// 
			this.pnlLeftTop.Controls.Add(this.gbPolhemusReadout);
			this.pnlLeftTop.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlLeftTop.DockPadding.All = 4;
			this.pnlLeftTop.Location = new System.Drawing.Point(0, 0);
			this.pnlLeftTop.Name = "pnlLeftTop";
			this.pnlLeftTop.Size = new System.Drawing.Size(432, 128);
			this.pnlLeftTop.TabIndex = 12;
			// 
			// gbPolhemusReadout
			// 
			this.gbPolhemusReadout.Controls.Add(this.pnlPolhemusReadout);
			this.gbPolhemusReadout.Dock = System.Windows.Forms.DockStyle.Fill;
			this.gbPolhemusReadout.Location = new System.Drawing.Point(4, 4);
			this.gbPolhemusReadout.Name = "gbPolhemusReadout";
			this.gbPolhemusReadout.Size = new System.Drawing.Size(424, 120);
			this.gbPolhemusReadout.TabIndex = 0;
			this.gbPolhemusReadout.TabStop = false;
			this.gbPolhemusReadout.Text = "Polhemus Readout";
			// 
			// pnlPolhemusReadout
			// 
			this.pnlPolhemusReadout.BackColor = System.Drawing.SystemColors.Control;
			this.pnlPolhemusReadout.Controls.Add(this.pnlPolhemusReadoutRightOfToolbar);
			this.pnlPolhemusReadout.Controls.Add(this.toolbarPolhemusReadout);
			this.pnlPolhemusReadout.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlPolhemusReadout.Location = new System.Drawing.Point(3, 16);
			this.pnlPolhemusReadout.Name = "pnlPolhemusReadout";
			this.pnlPolhemusReadout.Size = new System.Drawing.Size(418, 101);
			this.pnlPolhemusReadout.TabIndex = 5;
			// 
			// pnlPolhemusReadoutRightOfToolbar
			// 
			this.pnlPolhemusReadoutRightOfToolbar.BackColor = System.Drawing.SystemColors.Window;
			this.pnlPolhemusReadoutRightOfToolbar.Controls.Add(this.pnlPolhemusReadoutLabels);
			this.pnlPolhemusReadoutRightOfToolbar.Controls.Add(this.pnlPolhemusReadoutIcons);
			this.pnlPolhemusReadoutRightOfToolbar.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlPolhemusReadoutRightOfToolbar.Location = new System.Drawing.Point(36, 0);
			this.pnlPolhemusReadoutRightOfToolbar.Name = "pnlPolhemusReadoutRightOfToolbar";
			this.pnlPolhemusReadoutRightOfToolbar.Size = new System.Drawing.Size(382, 101);
			this.pnlPolhemusReadoutRightOfToolbar.TabIndex = 2;
			// 
			// pnlPolhemusReadoutLabels
			// 
			this.pnlPolhemusReadoutLabels.BackColor = System.Drawing.SystemColors.Window;
			this.pnlPolhemusReadoutLabels.Controls.Add(this.lblStylusDistance);
			this.pnlPolhemusReadoutLabels.Controls.Add(this.lblCygReferencePoint);
			this.pnlPolhemusReadoutLabels.Controls.Add(this.lblStylusPositionText);
			this.pnlPolhemusReadoutLabels.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlPolhemusReadoutLabels.Location = new System.Drawing.Point(0, 0);
			this.pnlPolhemusReadoutLabels.Name = "pnlPolhemusReadoutLabels";
			this.pnlPolhemusReadoutLabels.Size = new System.Drawing.Size(350, 101);
			this.pnlPolhemusReadoutLabels.TabIndex = 3;
			// 
			// lblStylusDistance
			// 
			this.lblStylusDistance.Dock = System.Windows.Forms.DockStyle.Fill;
			this.lblStylusDistance.Font = new System.Drawing.Font("Microsoft Sans Serif", 26.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblStylusDistance.Location = new System.Drawing.Point(0, 48);
			this.lblStylusDistance.Name = "lblStylusDistance";
			this.lblStylusDistance.Size = new System.Drawing.Size(350, 53);
			this.lblStylusDistance.TabIndex = 13;
			this.lblStylusDistance.Text = "000.00";
			this.lblStylusDistance.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// lblCygReferencePoint
			// 
			this.lblCygReferencePoint.Dock = System.Windows.Forms.DockStyle.Top;
			this.lblCygReferencePoint.Font = new System.Drawing.Font("Microsoft Sans Serif", 18F);
			this.lblCygReferencePoint.Location = new System.Drawing.Point(0, 24);
			this.lblCygReferencePoint.Name = "lblCygReferencePoint";
			this.lblCygReferencePoint.Size = new System.Drawing.Size(350, 24);
			this.lblCygReferencePoint.TabIndex = 11;
			this.lblCygReferencePoint.Text = "000.00 , 000.00 , 000.00";
			this.lblCygReferencePoint.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// lblStylusPositionText
			// 
			this.lblStylusPositionText.Dock = System.Windows.Forms.DockStyle.Top;
			this.lblStylusPositionText.Font = new System.Drawing.Font("Microsoft Sans Serif", 18F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblStylusPositionText.ImageAlign = System.Drawing.ContentAlignment.TopRight;
			this.lblStylusPositionText.Location = new System.Drawing.Point(0, 0);
			this.lblStylusPositionText.Name = "lblStylusPositionText";
			this.lblStylusPositionText.Size = new System.Drawing.Size(350, 24);
			this.lblStylusPositionText.TabIndex = 12;
			this.lblStylusPositionText.Text = "000.00 , 000.00 , 000.00";
			this.lblStylusPositionText.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// pnlPolhemusReadoutIcons
			// 
			this.pnlPolhemusReadoutIcons.Controls.Add(this.pbPolhemusStylusPosition);
			this.pnlPolhemusReadoutIcons.Controls.Add(this.pbCygReferencePoint);
			this.pnlPolhemusReadoutIcons.Controls.Add(this.pbStylusDistance);
			this.pnlPolhemusReadoutIcons.Dock = System.Windows.Forms.DockStyle.Right;
			this.pnlPolhemusReadoutIcons.Location = new System.Drawing.Point(350, 0);
			this.pnlPolhemusReadoutIcons.Name = "pnlPolhemusReadoutIcons";
			this.pnlPolhemusReadoutIcons.Size = new System.Drawing.Size(32, 101);
			this.pnlPolhemusReadoutIcons.TabIndex = 2;
			// 
			// pbPolhemusStylusPosition
			// 
			this.pbPolhemusStylusPosition.Image = ((System.Drawing.Image)(resources.GetObject("pbPolhemusStylusPosition.Image")));
			this.pbPolhemusStylusPosition.Location = new System.Drawing.Point(4, 2);
			this.pbPolhemusStylusPosition.Name = "pbPolhemusStylusPosition";
			this.pbPolhemusStylusPosition.Size = new System.Drawing.Size(24, 24);
			this.pbPolhemusStylusPosition.TabIndex = 2;
			this.pbPolhemusStylusPosition.TabStop = false;
			// 
			// pbCygReferencePoint
			// 
			this.pbCygReferencePoint.Image = ((System.Drawing.Image)(resources.GetObject("pbCygReferencePoint.Image")));
			this.pbCygReferencePoint.Location = new System.Drawing.Point(4, 28);
			this.pbCygReferencePoint.Name = "pbCygReferencePoint";
			this.pbCygReferencePoint.Size = new System.Drawing.Size(24, 24);
			this.pbCygReferencePoint.TabIndex = 0;
			this.pbCygReferencePoint.TabStop = false;
			// 
			// pbStylusDistance
			// 
			this.pbStylusDistance.Image = ((System.Drawing.Image)(resources.GetObject("pbStylusDistance.Image")));
			this.pbStylusDistance.Location = new System.Drawing.Point(4, 62);
			this.pbStylusDistance.Name = "pbStylusDistance";
			this.pbStylusDistance.Size = new System.Drawing.Size(24, 24);
			this.pbStylusDistance.TabIndex = 0;
			this.pbStylusDistance.TabStop = false;
			// 
			// toolbarPolhemusReadout
			// 
			this.toolbarPolhemusReadout.Appearance = System.Windows.Forms.ToolBarAppearance.Flat;
			this.toolbarPolhemusReadout.AutoSize = false;
			this.toolbarPolhemusReadout.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
																									  this.tbbToggleStylus,
																									  this.tbbToggleSound,
																									  this.tbbToggleCylinder});
			this.toolbarPolhemusReadout.Divider = false;
			this.toolbarPolhemusReadout.Dock = System.Windows.Forms.DockStyle.Left;
			this.toolbarPolhemusReadout.DropDownArrows = true;
			this.toolbarPolhemusReadout.ImageList = this.imageList2;
			this.toolbarPolhemusReadout.Location = new System.Drawing.Point(0, 0);
			this.toolbarPolhemusReadout.Name = "toolbarPolhemusReadout";
			this.toolbarPolhemusReadout.ShowToolTips = true;
			this.toolbarPolhemusReadout.Size = new System.Drawing.Size(36, 101);
			this.toolbarPolhemusReadout.TabIndex = 1;
			this.toolbarPolhemusReadout.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.toolbarPolhemusReadout_ButtonClick);
			// 
			// tbbToggleStylus
			// 
			this.tbbToggleStylus.ImageIndex = 4;
			this.tbbToggleStylus.ToolTipText = "Simulate a stylus click";
			// 
			// tbbToggleSound
			// 
			this.tbbToggleSound.ImageIndex = 5;
			this.tbbToggleSound.Pushed = true;
			this.tbbToggleSound.Style = System.Windows.Forms.ToolBarButtonStyle.ToggleButton;
			this.tbbToggleSound.ToolTipText = "Toggle audio feedback";
			// 
			// tbbToggleCylinder
			// 
			this.tbbToggleCylinder.ImageIndex = 6;
			this.tbbToggleCylinder.Pushed = true;
			this.tbbToggleCylinder.Style = System.Windows.Forms.ToolBarButtonStyle.ToggleButton;
			this.tbbToggleCylinder.ToolTipText = "Toggle the visibility of the bounding cylinder disks";
			// 
			// statusBar1
			// 
			this.statusBar1.Location = new System.Drawing.Point(0, 679);
			this.statusBar1.Name = "statusBar1";
			this.statusBar1.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
																						  this.statusBarPanel1,
																						  this.statusBarPanel2,
																						  this.statusBarPanel3});
			this.statusBar1.ShowPanels = true;
			this.statusBar1.Size = new System.Drawing.Size(1016, 22);
			this.statusBar1.SizingGrip = false;
			this.statusBar1.TabIndex = 5;
			this.statusBar1.Text = "statusBar1";
			this.statusBar1.Click += new System.EventHandler(this.lblPolhemusStatus_Click);
			// 
			// statusBarPanel1
			// 
			this.statusBarPanel1.Alignment = System.Windows.Forms.HorizontalAlignment.Center;
			this.statusBarPanel1.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
			this.statusBarPanel1.Icon = ((System.Drawing.Icon)(resources.GetObject("statusBarPanel1.Icon")));
			this.statusBarPanel1.MinWidth = 22;
			this.statusBarPanel1.Width = 31;
			// 
			// statusBarPanel2
			// 
			this.statusBarPanel2.Alignment = System.Windows.Forms.HorizontalAlignment.Center;
			this.statusBarPanel2.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
			this.statusBarPanel2.Text = "USB";
			this.statusBarPanel2.Width = 37;
			// 
			// statusBarPanel3
			// 
			this.statusBarPanel3.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
			this.statusBarPanel3.Text = "Polhemus is currently disconnected";
			this.statusBarPanel3.Width = 948;
			// 
			// timerPolhemusSample
			// 
			this.timerPolhemusSample.Enabled = true;
			this.timerPolhemusSample.Interval = 50;
			this.timerPolhemusSample.Tick += new System.EventHandler(this.polhemusSampleTimer_Tick);
			// 
			// timerPolhemusStatusCheck
			// 
			this.timerPolhemusStatusCheck.Enabled = true;
			this.timerPolhemusStatusCheck.Interval = 1000;
			this.timerPolhemusStatusCheck.Tick += new System.EventHandler(this.polhemusStatusCheckTimer_Tick);
			// 
			// tbbPlantPatchAdd
			// 
			this.tbbPlantPatchAdd.ImageIndex = 1;
			this.tbbPlantPatchAdd.ToolTipText = "Add a new plant patch to this waypoint";
			// 
			// tbbPlantPatchSample
			// 
			this.tbbPlantPatchSample.ImageIndex = 0;
			this.tbbPlantPatchSample.ToolTipText = "Sample the CYGs in this PlantPatch";
			// 
			// tbbPlantPatchDelete
			// 
			this.tbbPlantPatchDelete.ImageIndex = 2;
			this.tbbPlantPatchDelete.ToolTipText = "Delete this plant patch from the waypoint";
			// 
			// toolBarButton4
			// 
			this.toolBarButton4.ImageIndex = 3;
			this.toolBarButton4.ToolTipText = "Show the properties of the selected Waypoint, PlantPatch or CYG in the property g" +
				"rid";
			// 
			// MhsMainAppForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.SystemColors.Control;
			this.ClientSize = new System.Drawing.Size(1016, 701);
			this.Controls.Add(this.CPolhemus);
			this.Controls.Add(this.pnlAboveStatusBar);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Menu = this.mainMenu1;
			this.Name = "MhsMainAppForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.WindowsDefaultBounds;
			this.Text = "Moose Habitat Surveyor";
			this.WindowState = System.Windows.Forms.FormWindowState.Maximized;
			this.Load += new System.EventHandler(this.MhsMainAppForm_Load);
			((System.ComponentModel.ISupportInitialize)(this.CPolhemus)).EndInit();
			this.pnlAboveStatusBar.ResumeLayout(false);
			this.pnlBigOneOnTopOfStatusBar.ResumeLayout(false);
			this.pnlRight.ResumeLayout(false);
			this.gb3dRender.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.usrPlantPatchRenderer)).EndInit();
			this.pnlWizard.ResumeLayout(false);
			this.pnlLeft.ResumeLayout(false);
			this.pnlLeftBottom.ResumeLayout(false);
			this.gbWpRenderAndProperties.ResumeLayout(false);
			this.tabControl1.ResumeLayout(false);
			this.tpWaypointRenderer.ResumeLayout(false);
			this.tpProperties.ResumeLayout(false);
			this.pnlLeftMiddle.ResumeLayout(false);
			this.gbModelHierarchy.ResumeLayout(false);
			this.pnlTreeviewToolbar.ResumeLayout(false);
			this.pnlLeftTop.ResumeLayout(false);
			this.gbPolhemusReadout.ResumeLayout(false);
			this.pnlPolhemusReadout.ResumeLayout(false);
			this.pnlPolhemusReadoutRightOfToolbar.ResumeLayout(false);
			this.pnlPolhemusReadoutLabels.ResumeLayout(false);
			this.pnlPolhemusReadoutIcons.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel1)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel2)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel3)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			try
			{
				Application.Run(new MhsMainAppForm());
			}
			catch( Exception e)
			{
				MessageBox.Show(e.ToString() + "\n\n" + e.StackTrace);
			}
		}

		private void OnMhsPdiDataReady(object sender, System.EventArgs e)
		{
			MessageBox.Show("C# Data Ready");
		}

		/// <summary>
		/// When the stylus is depressed we should be in sample mode
		/// which is writing to the property grid. We can just treat
		/// the values that come off like strings and assign them to the selected
		/// area. This will really be a CYG list walker
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void CPolhemus_StylusButtonPress(object sender, AxCPolhemusStatusBarActiveXControlLib._DCPolhemusStatusBarActiveXControlEvents_WM_CPOLHEMUS_STYLUSBTN_DATAEvent e)
		{
			HandleStylusButtonPress(e.x,e.y,e.z);
		}

		private void HandleStylusButtonPress(float x, float y, float z)
		{
			Vector3 clickVector = new Vector3(x,y,-z+150);
			string vectorAxText =	clickVector.X.ToString("000.00") + " , " +
									clickVector.Y.ToString("000.00") + " , " +
									clickVector.Z.ToString("000.00");

			if( samplingMode )
			{
				CurrentYearGrowth cyg = (CurrentYearGrowth)propertyGrid1.SelectedObject;
				if( ! cyg.BasePointIsSet )
				{
					cyg.BasePoint = clickVector;
					propertyGrid1.SelectedObject= (object)cyg;
					usrPlantPatchWizard.DisplayText = cyg.Name + ": Tip point";
					propertyGrid1.SelectedGridItem = propertyGrid1.SelectedGridItem.Parent.GridItems["TipPoint"];
					patchSound1.PlayBeep();
				}
				else if( cyg.BasePointIsSet && ! cyg.TipPointIsSet )
				{
					cyg.TipPoint = clickVector;
					propertyGrid1.SelectedObject = (object)cyg;
					usrPlantPatchWizard.DisplayText = cyg.Name + ": Base diameter";
					propertyGrid1.SelectedGridItem = propertyGrid1.SelectedGridItem.Parent.GridItems["BaseDiameter"];
					patchSound1.PlayBeep();
				}
			}

		}

		private  void polhemusSampleTimer_Tick(object  sender, System.EventArgs e)
		{

			float nx=0f,ny=0f,nz=0f;

			// this is local/real space
			try
			{
				if( CPolhemus.IsConnected == 1 ) 
					CPolhemus.GetStylusPosition(ref nx, ref ny, ref nz);
			}
			catch(Exception ex)
			{
				// wierd? when you plug the USB connection 
				// back in to the computer
				// one of the GetStylusPostion() calls fails
				// with a Null pointer exception. You can
				// catch it, do nothing, and all is well				
				//this.polhemusSampleTimer.Enabled = false;
				//MessageBox.Show("GetStylusPostionFailed\n" + ex.ToString());
				//this.polhemusSampleTimer.Enabled = true;
				string s = ex.ToString();
			}
			// axtivex control input and stylus postion direct3d output are loosely coupled

			// the polhemus will be 150cm (1.5 meters) off of the ground on a pole.
			// That means that a -150 reading on the polhemus, is actually
			// 0 in model coordinates and 1500 is 3000. There is a positive offset
			// of 1500 vertical cm.

			stylusPositionSum += new Vector3(nx,ny,-nz+150);
			if( sampleTickCounter % 10 == 0 )
			{
				stylusPositionAvg = stylusPositionSum * (1f/10f);
				stylusPositionSum = Vector3.Empty;
			}

			Vector3 styPos = new Vector3(nx,ny,-nz+150);
			usrPlantPatchRenderer.StylusContinuousPosition = styPos;
			usrPlantPatchRenderer.Render();
			lblStylusPositionText.Text =		stylusPositionAvg.X.ToString("000.00") + " , " +
												stylusPositionAvg.Y.ToString("000.00") + " , " +
												stylusPositionAvg.Z.ToString("000.00");
 
			if( cygIdx != -1 )
			{
				Vector3 cygRef = fieldtrip.Waypoints[wpIdx].PlantPatches[ppIdx].Cygs[cygIdx].ReferencePoint;
				Vector3 distv = stylusPositionAvg - cygRef;
				this.lblStylusDistance.Text = distv.Length().ToString("000.00");

				// should we play a sound so show proximity to
				// to the cyg's reference point?
				if( soundEnabled )
				{
					// how far away on a scale of 1 to 100
					// world to model scale is 100/1
					int len = (int)Math.Round(distv.Length());
					len = (int)Math.Round((float)len);

					// render a sound every len sample frames, render at full speed if at zero, render at a default speed
					bool shouldTick = len == 0 ||  sampleTickCounter % len == 0;
					if( shouldTick && samplingMode)
						patchSound1.PlayTick();

					if( ! shouldTick && sampleTickCounter % 10 == 0 && samplingMode )
						patchSound1.PlayTick();

				}
			}

			sampleTickCounter++;

		}





		private void menuItem2_Click(object sender, System.EventArgs e)
		{
			//PlantPatchSamplingWizard.Wizard w = new PlantPatchSamplingWizard.Wizard();
			//w.ShowDialog();
		}

		private void SetupTreeView()
		{
			treeview1.Nodes.Clear();
			for( int w=0;w < fieldtrip.Waypoints.Count;w++)
			{
				treeview1.Nodes.Add( new TreeNode( fieldtrip.Waypoints[w].Name) );
				treeview1.Nodes[w].ImageIndex=0;
				treeview1.Nodes[w].SelectedImageIndex=0;
				for( int p=0;p < fieldtrip.Waypoints[w].PlantPatches.Count;p++)
				{
					treeview1.Nodes[w].Nodes.Add( new TreeNode( fieldtrip.Waypoints[w].PlantPatches[p].Name) );
					treeview1.Nodes[w].Nodes[p].ImageIndex=1;
					treeview1.Nodes[w].Nodes[p].SelectedImageIndex=1;
					for( int c=0;c < fieldtrip.Waypoints[w].PlantPatches[p].Cygs.Count;c++)
					{
						treeview1.Nodes[w].Nodes[p].Nodes.Add( new TreeNode( fieldtrip.Waypoints[w].PlantPatches[p].Cygs[c].Name) );
						treeview1.Nodes[w].Nodes[p].Nodes[c].ImageIndex=2;
						treeview1.Nodes[w].Nodes[p].Nodes[c].SelectedImageIndex=2;
					}
				}
			}
		}

		private void miImport_Click(object sender, System.EventArgs e)
		{
			OpenFileDialog ofd = new OpenFileDialog();
			if( ofd.ShowDialog() == DialogResult.OK )
			{
				try
				{
					fieldtrip.BuildFromImportFile(ofd.FileName);
					SetupTreeView();
					if( fieldtrip.Waypoints.Count > 0 && fieldtrip.Waypoints[0] != null )
						propertyGrid1.SelectedObject=fieldtrip.Waypoints[0];
				}
				catch(Exception ex)
				{
					MessageBox.Show("Error opening: " + ofd.FileName + "\n" + ex.Message);
				}
			}
		}



		/// <summary>
		/// Calculates the depth of a TreeNode in it's TreeView.
		/// This is important to determine what type of object
		/// the user has clicked. Waypoints==0. PlantPatches==1.
		/// CYGs==2.
		/// </summary>
		/// <param name="tnode">The TreeNode who's depth to determine</param>
		/// <returns></returns>
		private int treeNodeDepth( TreeNode tnode )
		{
			if(tnode == null )
				return -1;

			int i=0;
			TreeNode tn = tnode;
			while( tn.Parent != null )
			{
				tn = tn.Parent;
				i++;
			}

			return i;
		}


		private void treeview1_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			int depth = treeNodeDepth( e.Node );
			if( depth == -1 )
				return;

			//toolbarModelHierarchy.Buttons[0].Enabled=false;
			toolbarModelHierarchy.Buttons[1].Enabled=false;
			toolbarModelHierarchy.Buttons[2].Enabled=false;

			wpIdx=-1; 
			ppIdx=-1;
			cygIdx=-1;

			if( depth == 0 ) // waypoint
			{
				// enable the add plant patch button
				toolbarModelHierarchy.Buttons[0].Enabled=true;

				// set the global waypoint index
				wpIdx = e.Node.Index;

				// give view components a reference
				propertyGrid1.SelectedObject=fieldtrip.Waypoints[wpIdx];
				tabControl1.TabPages[0].Text = fieldtrip.Waypoints[wpIdx].Name + " (" + fieldtrip.Waypoints[wpIdx].Latitude + "," + fieldtrip.Waypoints[wpIdx].Longitude+")";
				tabControl1.TabPages[1].Text = "Waypoint: " + fieldtrip.Waypoints[wpIdx].Name;
				usrWaypointRenderer.Waypoint=fieldtrip.Waypoints[wpIdx];
				usrWaypointRenderer.SelectedPlantPatchIndex = -1;
				usrWaypointRenderer.Invalidate(true);

			}
			else if ( depth == 1 ) // plantpatch
			{
				toolbarModelHierarchy.Buttons[1].Enabled=true;
				toolbarModelHierarchy.Buttons[2].Enabled=true;
				ppIdx = e.Node.Index;
				wpIdx = e.Node.Parent.Index;
				cygIdx = 0;

				propertyGrid1.SelectedObject=fieldtrip.Waypoints[wpIdx].PlantPatches[ppIdx];
				tabControl1.TabPages[0].Text = fieldtrip.Waypoints[wpIdx].Name + " (" + fieldtrip.Waypoints[wpIdx].Latitude + "," + fieldtrip.Waypoints[wpIdx].Longitude+")";
				tabControl1.TabPages[1].Text = fieldtrip.Waypoints[wpIdx].PlantPatches[ppIdx].Name;
				usrPlantPatchRenderer.PlantPatch=fieldtrip.Waypoints[wpIdx].PlantPatches[ppIdx];
				usrPlantPatchRenderer.CygIndex = cygIdx;
				usrWaypointRenderer.Waypoint=fieldtrip.Waypoints[wpIdx];
				usrWaypointRenderer.SelectedPlantPatchIndex = ppIdx;
				usrWaypointRenderer.Invalidate(true);

				Vector3 cygRef = fieldtrip.Waypoints[wpIdx].PlantPatches[ppIdx].Cygs[cygIdx].ReferencePoint;
				lblCygReferencePoint.Text = cygRef.X.ToString("000.00") + " , " +
					cygRef.Y.ToString("000.00") + " , " +
					cygRef.Z.ToString("000.00");
			}
			else if ( depth == 2 ) // CYG
			{
				cygIdx = e.Node.Index;
				ppIdx = e.Node.Parent.Index;
				wpIdx = e.Node.Parent.Parent.Index;

				propertyGrid1.SelectedObject=fieldtrip.Waypoints[wpIdx].PlantPatches[ppIdx].Cygs[cygIdx];
				tabControl1.TabPages[0].Text = fieldtrip.Waypoints[wpIdx].Name + " (" + fieldtrip.Waypoints[wpIdx].Latitude + "," + fieldtrip.Waypoints[wpIdx].Longitude+")";
				tabControl1.TabPages[1].Text = fieldtrip.Waypoints[wpIdx].PlantPatches[ppIdx].Name + " : " + fieldtrip.Waypoints[wpIdx].PlantPatches[ppIdx].Cygs[cygIdx].Name;
				usrPlantPatchRenderer.PlantPatch=fieldtrip.Waypoints[wpIdx].PlantPatches[ppIdx];
				usrPlantPatchRenderer.CygIndex = cygIdx;
				usrWaypointRenderer.Waypoint=fieldtrip.Waypoints[wpIdx];
				usrWaypointRenderer.SelectedPlantPatchIndex = ppIdx;
				usrWaypointRenderer.Invalidate(true);

				Vector3 cygRef = fieldtrip.Waypoints[wpIdx].PlantPatches[ppIdx].Cygs[cygIdx].ReferencePoint;
				lblCygReferencePoint.Text = cygRef.X.ToString("000.00") + " , " +
					cygRef.Y.ToString("000.00") + " , " +
					cygRef.Z.ToString("000.00");

			}
		}

		private void toolbarModelHierarchy_ButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
		{
			if( e.Button == this.toolbarModelHierarchy.Buttons[0] )
			{
				TreeNode n = treeview1.SelectedNode;
				while( n.Parent != null )
				{
					n = n.Parent;
				}

				int _wpIdx = n.Index;
				int _ppIdx = fieldtrip.Waypoints[_wpIdx].PlantPatches.Add(new PlantPatch());
				fieldtrip.Waypoints[_wpIdx].PlantPatches[_ppIdx].Name = "PlantPatch" + (_ppIdx+1);
				int nodeIdx = n.Nodes.Add(new TreeNode(fieldtrip.Waypoints[_wpIdx].PlantPatches[_ppIdx].Name));
				n.Nodes[nodeIdx].ImageIndex=1;
				n.Nodes[nodeIdx].SelectedImageIndex=1;
				for(int i=0;i< ModelParameters.NUM_CYGS_PER_PLANTPATCH;i++)
				{
					int _cygIdx = fieldtrip.Waypoints[_wpIdx].PlantPatches[_ppIdx].Cygs.Add(new CurrentYearGrowth(i+1));
					int cygNodeIdx = n.Nodes[nodeIdx].Nodes.Add(new TreeNode(fieldtrip.Waypoints[_wpIdx].PlantPatches[_ppIdx].Cygs[_cygIdx].Name));
					n.Nodes[nodeIdx].Nodes[cygNodeIdx].ImageIndex=2;
					n.Nodes[nodeIdx].Nodes[cygNodeIdx].SelectedImageIndex=2;
				}
				treeview1.SelectedNode = n.Nodes[nodeIdx];
			}
			else if ( e.Button == this.toolbarModelHierarchy.Buttons[1] )
			{
				int depth = treeNodeDepth(this.treeview1.SelectedNode);
				if( depth == 1 )
				{
					samplingMode = true;
					MessageBox.Show("Begin Sampling.");
					treeview1.SelectedNode = treeview1.SelectedNode.Nodes[0];
					treeview1.SelectedNode.BackColor = Color.Orange;
					usrPlantPatchWizard.DisplayText = "Cyg1: Base point";

					pnlWizard.BackColor = Color.Orange;
//					llblWizardBack.Text = "<< Back";
//					llblWizardNext.Text = "Next >>";
//					llblWizardSkip.Text = "Skip level";

					tabControl1.SelectedTab = tabControl1.TabPages[1];
					propertyGrid1.Focus();
					propertyGrid1.SelectedGridItem = propertyGrid1.SelectedGridItem.Parent.GridItems["BasePoint"];
				}
			}
			else if ( e.Button == this.toolbarModelHierarchy.Buttons[2] )
			{
				int _ppIdx = treeview1.SelectedNode.Index;
				TreeNode parent = treeview1.SelectedNode.Parent;
				int _wpIdx = parent.Index;
				parent.Nodes.RemoveAt(_ppIdx);
				fieldtrip.Waypoints[_wpIdx].PlantPatches.RemoveAt(_ppIdx);
			}
			else if ( e.Button == this.toolbarModelHierarchy.Buttons[3] )
			{
				tabControl1.SelectedTab = tabControl1.TabPages[1];
			}
		}

		private void miExport_Click(object sender, System.EventArgs e)
		{
			SaveFileDialog sfd = new SaveFileDialog();
			if( sfd.ShowDialog() == DialogResult.OK )
			{
				try
				{
					fieldtrip.ExportToFile(sfd.FileName);
				}
				catch(Exception exc)
				{
					MessageBox.Show("Error exporting to file (" + sfd.FileName + "). " + exc.Message );
				}			
			}
		}

		private void miSave_Click(object sender, System.EventArgs e)
		{
			SaveFileDialog sfd = new SaveFileDialog();
			if( sfd.ShowDialog() == DialogResult.OK )
			{
				try
				{
					XmlSerializer serializer = new XmlSerializer(typeof(FieldTrip)); 

					// Create an XmlTextWriter using a FileStream.
					Stream fs = new FileStream(sfd.FileName, FileMode.Create);
					XmlTextWriter writer = new XmlTextWriter(fs, new System.Text.UnicodeEncoding() );
					writer.Formatting = Formatting.Indented;
					writer.Indentation=4;

					// Serialize using the XmlTextWriter.
					serializer.Serialize(writer,fieldtrip);
					writer.Close();
					fs.Close();
				}		
				catch(Exception exc)
				{
					MessageBox.Show("Error saving to file (" + sfd.FileName + "). " + exc.Message );
				}
			}	 
				
		}

		private void miOpen_Click(object sender, System.EventArgs e)
		{
			OpenFileDialog ofd = new OpenFileDialog();
			if( ofd.ShowDialog() == DialogResult.OK )
			{
				LoadFieldTripFromFile( ofd.FileName);
			}	 
		
		}

		private void LoadFieldTripFromFile( string filename )
		{
			try
			{
				XmlSerializer serializer = new XmlSerializer(typeof(FieldTrip)); 

				// Create an XmlTextWriter using a FileStream.
				Stream fs = new FileStream(filename, FileMode.Open);
				XmlReader reader = new XmlTextReader(fs);

				// Serialize using the XmlTextWriter.
				fieldtrip = (FieldTrip) serializer.Deserialize(reader);
				reader.Close();
				fs.Close();
				SetupTreeView();
			}		
			catch(Exception exc)
			{
				MessageBox.Show("Error opening to file (" + filename + "). " + exc.Message );
			}		
		}

		
		private void propertyGrid1_Closed(object o, EventArgs e)
		{
			if( wpIdx > -1 && ppIdx == -1 && cygIdx ==-1 )
			{ // Waypoint
				treeview1.Nodes[wpIdx].Text = fieldtrip.Waypoints[wpIdx].Name;
				usrWaypointRenderer.Waypoint = fieldtrip.Waypoints[wpIdx];
			}
			else if( wpIdx > -1 && ppIdx > -1 && cygIdx ==-1 )
			{ // PlantPatch
				treeview1.Nodes[wpIdx].Nodes[ppIdx].Text = fieldtrip.Waypoints[wpIdx].PlantPatches[ppIdx].Name;
			}
			else if( wpIdx > -1 && ppIdx > -1 && cygIdx  > -1 )
			{ // Cyg
				treeview1.Nodes[wpIdx].Nodes[ppIdx].Nodes[cygIdx].Text = fieldtrip.Waypoints[wpIdx].PlantPatches[ppIdx].Cygs[cygIdx].Name;
			}
			else
			{
				// jerk
				MessageBox.Show("Fatal Error on property change. (wp="+wpIdx+",pp="+ppIdx+",cyg="+cygIdx+")" );
			}		
		}



		private void miPolhemusAutoReconnect_Click(object sender, System.EventArgs e)
		{
			CPolhemus.AutoReconnectPolhemus = ( CPolhemus.AutoReconnectPolhemus == 1 ? 0 : 1 );
			this.miPolhemusAutoReconnect.Checked = ( CPolhemus.AutoReconnectPolhemus == 0 ? false : true );
		
		}

		private void miConnectPolhemus_Click(object sender, System.EventArgs e)
		{
			CPolhemus.ConnectPolhemus();
		}

		private void miDisconnectPolhemus_Click(object sender, System.EventArgs e)
		{
			CPolhemus.DisconnectPolhemus();
			this.miPolhemusAutoReconnect.Checked = false;
			CPolhemus.AutoReconnectPolhemus = 0;
		}

		private void polhemusStatusCheckTimer_Tick(object sender, System.EventArgs e)
		{
			bool isConn = CPolhemus.IsConnected == 1  ;
			StringBuilder sb = new StringBuilder();
			sb.Append("Polhemus is ");

			if( isConn ) 
			{
				this.miConnectPolhemus.Enabled = false;
				this.miDisconnectPolhemus.Enabled = true;
				//this.miConnectPolhemus.Checked = true;
				//this.miDisconnectPolhemus.Checked = false;
				this.statusBarPanel1.Icon = this.icnPolhemusConnected;
				this.statusBarPanel2.Text= "USB";
				sb.Append( "connected" );
				this.statusBarPanel3.Text = sb.ToString();
			}
			else
			{
				//statusBarPanel3.BackColor = Color.DarkOrange;
				this.miConnectPolhemus.Enabled = true;
				this.miDisconnectPolhemus.Enabled = false;
				//this.miConnectPolhemus.Checked = false;
				//this.miDisconnectPolhemus.Checked = true;
				this.statusBarPanel1.Icon = this.icnPolhemusDisconnected;
				this.statusBarPanel2.Text= "ERR";
				sb.Append( "disconnected. Click here for more information.");
				this.statusBarPanel3.Text = sb.ToString();
			}

//			if( CPolhemus.AutoReconnectPolhemus == 1 )
//			{
//				miPolhemusAutoReconnect.Checked = true;
//			}
//			else
//			{
//				miPolhemusAutoReconnect.Checked = false;
//			}
		}

		private void lblPolhemusStatus_Click(object sender, System.EventArgs e)
		{
			PolhemusStatusMessageBox();
		}

		private void PolhemusStatusMessageBox()
		{
			StringBuilder sb = new StringBuilder();
			sb.Append("Polhemus 3DRP is ");
			sb.Append( ( CPolhemus.IsConnected == 0 ) ? "disconnected. To establish a connection\n\n1. Verify your USB or Serial plug.\n2. Verify the polhemus device in windows device manager.\n3. Use the Polhemus>Auto Connect or Polhemus>Connect menu items." : "connected" );
			MessageBox.Show(sb.ToString(),"Polhemus Status Details");
		}

		private void miPlantPatchCamera0_Click(object sender, System.EventArgs e)
		{
			CameraPositionSelect(0);
		}

		private void miPlantPatchCamera1_Click(object sender, System.EventArgs e)
		{
			CameraPositionSelect(1);
		}

		private void miPlantPatchCamera2_Click(object sender, System.EventArgs e)
		{
			CameraPositionSelect(2);
		}

		private void miPlantPatchCamera3_Click(object sender, System.EventArgs e)
		{		
				CameraPositionSelect(3);
		}


		private void CameraPositionSelect(int sel)
		{
			usrPlantPatchRenderer.CameraPositionIndex=sel;
//			for(int i=0;i<miPlantPatchCameraMenu.MenuItems.Count;i++)
//			{
//				this.miPlantPatchCameraMenu.MenuItems[i].Checked = (i==usrPlantPatchRenderer.CameraPositionIndex?true:false);
//				this.cxmusrPlantPatchRenderer.MenuItems[i].Checked = (i==usrPlantPatchRenderer.CameraPositionIndex?true:false);
//			}
		}

		private void treeview1_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			e.Handled = true;
		}

		private void MhsMainAppForm_Load(object sender, System.EventArgs e)
		{
			CPolhemus.AutoReconnectPolhemus = 0;
			this.miPolhemusAutoReconnect.Checked = CPolhemus.AutoReconnectPolhemus == 1;

			patchSound1 = new PlantPatchSoundRenderer((Control)this);
		}

		private void miDrawOnlySelectedCygs_Click(object sender, System.EventArgs e)
		{
			MenuItem ctl = (MenuItem) sender;
			usrPlantPatchRenderer.DrawOnlySelectedCygs = ! ctl.Checked;
			ctl.Checked = usrPlantPatchRenderer.DrawOnlySelectedCygs; 
		}

		private void miBlinkSelectedCyg_Click(object sender, System.EventArgs e)
		{
			MenuItem ctl = (MenuItem) sender;
			usrPlantPatchRenderer.BlinkSelectedCyg = ! ctl.Checked;
			ctl.Checked = usrPlantPatchRenderer.BlinkSelectedCyg; 
		}

		private void miDrawSamplingCylinder_Click(object sender, System.EventArgs e)
		{
			ToggleCylinder();
		}

		private void ToggleCylinder()
		{
			usrPlantPatchRenderer.DrawBoundingCylinder = ! usrPlantPatchRenderer.DrawBoundingCylinder;
			tbbToggleCylinder.Pushed = usrPlantPatchRenderer.DrawBoundingCylinder;
			miDrawCylinder.Checked = usrPlantPatchRenderer.DrawBoundingCylinder;

		}

		private void miDrawAxis_Click(object sender, System.EventArgs e)
		{
			
			MenuItem ctl = (MenuItem) sender;
			usrPlantPatchRenderer.DrawAxis = ! ctl.Checked;
			ctl.Checked = usrPlantPatchRenderer.DrawAxis; 
		}

		private void miDrawGround_Click(object sender, System.EventArgs e)
		{			
			MenuItem ctl = (MenuItem) sender;
			usrPlantPatchRenderer.DrawGround = ! ctl.Checked;
			ctl.Checked = usrPlantPatchRenderer.DrawGround; 
		}

		private void miDrawSky_Click(object sender, System.EventArgs e)
		{
			MenuItem ctl = (MenuItem) sender;
			usrPlantPatchRenderer.DrawSky = ! ctl.Checked;
			ctl.Checked = usrPlantPatchRenderer.DrawSky; 
			
		}

		private void miDrawAltimeters_Click(object sender, System.EventArgs e)
		{
			MenuItem ctl = (MenuItem) sender;
			usrPlantPatchRenderer.DrawAltimeter = ! ctl.Checked;
			ctl.Checked = usrPlantPatchRenderer.DrawAltimeter; 
			
		}

		private void propertyGrid1_PropertyValueChanged(object s, System.Windows.Forms.PropertyValueChangedEventArgs e)
		{

			GridItem gi = (GridItem) e.ChangedItem;
			if( gi.PropertyDescriptor.Name == "Name" )
			{
				treeview1.SelectedNode.Text = (string) gi.Value;
			}


			if( fieldtrip.Waypoints != null && 
				fieldtrip.Waypoints.Count > 0 &&
				fieldtrip.Waypoints.Count > wpIdx &&
				wpIdx > -1 )
			{
				usrWaypointRenderer.Waypoint=fieldtrip.Waypoints[wpIdx];

				if( fieldtrip.Waypoints[wpIdx].PlantPatches != null &&
					fieldtrip.Waypoints[wpIdx].PlantPatches.Count > 0 &&
					fieldtrip.Waypoints[wpIdx].PlantPatches.Count > ppIdx &&
					ppIdx > -1 )
				{
					usrWaypointRenderer.SelectedPlantPatchIndex=ppIdx;
					usrPlantPatchRenderer.PlantPatch = fieldtrip.Waypoints[wpIdx].PlantPatches[ppIdx];
					if( cygIdx > -1 )
						usrPlantPatchRenderer.CygIndex   = cygIdx;
					else
						usrPlantPatchRenderer.CygIndex = 0;
				}
				else // no plant patches
				{
					usrWaypointRenderer.SelectedPlantPatchIndex = -1;
					usrPlantPatchRenderer.PlantPatch = null;
					usrPlantPatchRenderer.CygIndex = -1;
				}	
			}
			else // no waypoints
			{
					usrWaypointRenderer.SelectedPlantPatchIndex = -1;
					usrPlantPatchRenderer.PlantPatch = null;
					usrPlantPatchRenderer.CygIndex = -1;
			}


			if( samplingMode && gi.PropertyDescriptor.Name == "BaseDiameter" )
			{
				if( treeview1.SelectedNode.Text == "Cyg9" )
				{
					samplingMode = false;
					propertyGrid1.SelectedGridItem = propertyGrid1.SelectedGridItem.Parent.GridItems["Length"];
					treeview1.SelectedNode.BackColor = Color.White;
					

					pnlWizard.BackColor = SystemColors.Window;
//					lblWizardInstructions.Text = null;
//					llblWizardBack.Text = null;
//					llblWizardNext.Text = null;
//					llblWizardSkip.Text = null;
					patchSound1.PlayBeep();
					MessageBox.Show("PlantPatch Sampling Complete");
				}
				else
				{
					treeview1.SelectedNode.BackColor = Color.White;
					treeview1.SelectedNode = treeview1.SelectedNode.NextNode;
					treeview1.SelectedNode.BackColor = Color.Orange;
					CurrentYearGrowth cyg = (CurrentYearGrowth)propertyGrid1.SelectedObject;
//					lblWizardInstructions.Text = cyg.Name + ": Base point";
					patchSound1.PlayBeep();
					propertyGrid1.SelectedGridItem = propertyGrid1.SelectedGridItem.Parent.GridItems["BasePoint"];
				}
			}
		}
		private void miSoundEnabled_Click(object sender, System.EventArgs e)
		{
			ToggleSound();		
		}


		private void ToggleStylusDot()
		{
			usrPlantPatchRenderer.DrawStylusPosition = ! usrPlantPatchRenderer.DrawStylusPosition;
			usrPlantPatchRenderer.DrawAltimeter = usrPlantPatchRenderer.DrawStylusPosition;
			this.tbbToggleStylus.Pushed = usrPlantPatchRenderer.DrawStylusPosition;
			this.miDrawStylusDot.Checked = usrPlantPatchRenderer.DrawStylusPosition;
		}

		private void ToggleSound()
		{
			soundEnabled= ! soundEnabled;
			miSoundEnabled.Checked = soundEnabled;
			toolbarPolhemusReadout.Buttons[1].Pushed = soundEnabled;
		}

		private void toolbarPolhemusReadout_ButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
		{
			if( e.Button == this.toolbarPolhemusReadout.Buttons[0] )
			{
				float nx=0f,ny=0f,nz=0f;
				try
				{	
					if( CPolhemus.IsConnected == 1) 
						CPolhemus.GetStylusPosition(ref nx, ref ny, ref nz);
				}
				catch(Exception)
				{
				}

				HandleStylusButtonPress(nx,ny,nz);		
				//ToggleStylusDot();
			}

			if( e.Button == this.toolbarPolhemusReadout.Buttons[1] )
			{
				ToggleSound();
			}

			if( e.Button == this.toolbarPolhemusReadout.Buttons[2] )
			{
				ToggleCylinder();
			}


		}

		private void miDrawStylusDot_Click(object sender, System.EventArgs e)
		{
			ToggleStylusDot();
		}

		private void statusBar1_PanelClick(object sender, System.Windows.Forms.StatusBarPanelClickEventArgs e)
		{
			PolhemusStatusMessageBox();
		}

		private void btnPolhemusClickSimulate_Click(object sender, System.EventArgs e)
		{
			float nx=0f,ny=0f,nz=0f;
			try
			{	
				if( CPolhemus.IsConnected == 1) 
					CPolhemus.GetStylusPosition(ref nx, ref ny, ref nz);
			}
			catch(Exception)
			{
			}
			HandleStylusButtonPress(nx,ny,nz);		
		}

		private void miDrawPolhemusBaseStation_Click(object sender, System.EventArgs e)
		{	
			TogglePolhemusBaseStation()		;
		}

		private void TogglePolhemusBaseStation()
		{
			usrPlantPatchRenderer.DrawPolhemusBaseStation = ! usrPlantPatchRenderer.DrawPolhemusBaseStation;
			miDrawPolhemusBaseStation.Checked = usrPlantPatchRenderer.DrawPolhemusBaseStation;

		}

		private void miHelpContents_Click(object sender, System.EventArgs e)
		{
			System.IO.FileInfo fileinf = new System.IO.FileInfo(Assembly.GetExecutingAssembly().Location);
			System.Windows.Forms.Help.ShowHelp(this,fileinf.Directory.FullName + "\\User Manual.htm");
		}

	}
}
