#include "RunningState.h"


ChaosEngine::RunningState::RunningState( ChaosEngine::System* pSystem ) : State( pSystem , "RunningState" )
{
	m_oCameraPosition[ 0 ] = 0.0f;
	m_oCameraPosition[ 1 ] = 1.0f;
	m_oCameraPosition[ 2 ] = -20.0f;
	m_oCameraOrientation[ 0 ] = 0.0f;
	m_oCameraOrientation[ 1 ] = 0.0f;
	m_oCameraOrientation[ 2 ] = 0.0f;
	m_oCameraVelocity[ 0 ] = 0.0f;
	m_oCameraVelocity[ 1 ] = 0.0f;
	m_oCameraVelocity[ 2 ] = 0.0f;
	m_bMovingForward = false;
	m_bMovingBackward = false;
	m_bDown = false;
};


ChaosEngine::RunningState::~RunningState( void )
{
};


void ChaosEngine::RunningState::OnEnter( const std::string& oPrevious )
{
	GetSystem()->GetInput()->Startup();
	GetSystem()->GetInput()->Aquire();
};


void ChaosEngine::RunningState::Update( float fDeltaTime )
{
	GetSystem()->GetInput()->Poll();
	GetSystem()->GetPhysics()->Step( fDeltaTime );
	// update game objects

	float aPosition[ 3 ];
	float aOrientation[ 4 ];

	GetSystem()->GetPhysics()->GetBodyPosition( std::string( "Object" ) , aPosition );
	GetSystem()->GetPhysics()->GetBodyOrientation( std::string( "Object" ) , aOrientation );

	GetSystem()->GetGraphics()->SetObjectPosition( std::string( "Object" ) , aPosition );
	GetSystem()->GetGraphics()->SetObjectOrientation( std::string( "Object" ) , aOrientation );

	GetSystem()->GetAudio()->SetSoundSourcePosition( std::string( "Object" ) , aPosition );

	GetSystem()->GetPhysics()->GetBodyPosition( std::string( "Sphere" ) , aPosition );
	GetSystem()->GetPhysics()->GetBodyOrientation( std::string( "Sphere" ) , aOrientation );

	GetSystem()->GetGraphics()->SetObjectPosition( std::string( "Sphere" ) , aPosition );
	GetSystem()->GetGraphics()->SetObjectOrientation( std::string( "Sphere" ) , aOrientation );


	float aUp[ 3 ];
	float aDir[ 3 ];
	m_oCameraPosition[ 0 ] += m_oCameraVelocity[ 0 ] * fDeltaTime;
	m_oCameraPosition[ 1 ] += m_oCameraVelocity[ 1 ] * fDeltaTime;
	m_oCameraPosition[ 2 ] += m_oCameraVelocity[ 2 ] * fDeltaTime;

	GetSystem()->GetGraphics()->GetCameraDirection( aDir , aUp );
	GetSystem()->GetAudio()->SetListenerPosition( m_oCameraPosition , aDir , aUp );
	GetSystem()->GetAudio()->Update();
	GetSystem()->GetGraphics()->SetCamera( m_oCameraPosition , m_oCameraOrientation );

	if ( m_bMovingForward )
	{
		float aDir[ 3 ];
		float aUp[ 3 ];
		GetSystem()->GetGraphics()->GetCameraDirection( aDir , aUp );
		m_oCameraVelocity[ 0 ] = 3.0f * aDir[ 0 ];
		m_oCameraVelocity[ 1 ] = 3.0f * aDir[ 1 ];
		m_oCameraVelocity[ 2 ] = 3.0f * aDir[ 2 ];
	}
	else if ( m_bMovingBackward )
	{
		float aDir[ 3 ];
		float aUp[ 3 ];
		GetSystem()->GetGraphics()->GetCameraDirection( aDir , aUp );
		m_oCameraVelocity[ 0 ] = -3.0f * aDir[ 0 ];
		m_oCameraVelocity[ 1 ] = -3.0f * aDir[ 1 ];
		m_oCameraVelocity[ 2 ] = -3.0f * aDir[ 2 ];
	}
	else
	{
		m_oCameraVelocity[ 0 ] = 0.0f;
		m_oCameraVelocity[ 1 ] = 0.0f;
		m_oCameraVelocity[ 2 ] = 0.0f;
	}
};


void ChaosEngine::RunningState::OnExit( const std::string& oNext )
{
	GetSystem()->GetInput()->UnAquire();
	GetSystem()->GetInput()->Shutdown();
};


void ChaosEngine::RunningState::OnOverride( const std::string& oNext )
{
};


void ChaosEngine::RunningState::OnResume( const std::string& oPrevious )
{
};

void ChaosEngine::RunningState::MouseMoved( float* pAxisDeltas )
{
	m_oCameraOrientation[ 1 ] += pAxisDeltas[ 0 ] / 500.0f;
	m_oCameraOrientation[ 0 ] += -pAxisDeltas[ 1 ] / 500.0f;
	m_oCameraOrientation[ 0 ] = std::max< float >( -1.0f , std::min< float >( 1.0f , m_oCameraOrientation[ 0 ] ) );
	m_oCameraOrientation[ 2 ] = 0.0f;
};

void ChaosEngine::RunningState::KeyDown( const std::string& oKeyName )
{
	if ( oKeyName == "W" )
	{
		m_bMovingForward = true;
		m_bMovingBackward = false;
	}
	if ( oKeyName == "S" )
	{
		m_bMovingForward = false;
		m_bMovingBackward = true;
	}
};

void ChaosEngine::RunningState::KeyUp( const std::string& oKeyName )
{
	if ( oKeyName == "W" )
	{
		m_bMovingForward = false;
		m_bMovingBackward = false;
		m_oCameraVelocity[ 0 ] = 0.0f;
		m_oCameraVelocity[ 1 ] = 0.0f;
		m_oCameraVelocity[ 2 ] = 0.0f;
	}
	if ( oKeyName == "S" )
	{
		m_bMovingForward = false;
		m_bMovingBackward = false;
	}
};

void ChaosEngine::RunningState::ButtonDown( const std::string& oButtonName )
{
	GetSystem()->GetGraphics()->DestroyObject( std::string( "Sphere" ) );
	GetSystem()->GetPhysics()->DestroyBody( std::string( "Sphere" ) );
	float aOrientation[ 4 ];
	float aLinearVelocity[ 3 ];
	float aAngularVelocity[ 3 ];
	float fMass = 10.0f;
	float fRadius = 0.5f;

	aOrientation[ 0 ] = 0.0f;
	aOrientation[ 1 ] = 0.0f;
	aOrientation[ 2 ] = 0.0f;
	aOrientation[ 3 ] = 1.0f;

	aLinearVelocity[ 0 ] = 5.0f;
	aLinearVelocity[ 1 ] = 20.0f;
	aLinearVelocity[ 2 ] = 0.0f;

	aAngularVelocity[ 0 ] = 0.0f;
	aAngularVelocity[ 1 ] = 0.0f;
	aAngularVelocity[ 2 ] = 0.0f;

	float aDir[ 3 ];
	float aUp[ 3 ];
	GetSystem()->GetGraphics()->GetCameraDirection( aDir , aUp );

	aDir[ 0 ] = 20.0f * aDir[ 0 ];
	aDir[ 1 ] = 20.0f * aDir[ 1 ];
	aDir[ 2 ] = 20.0f * aDir[ 2 ];

	GetSystem()->GetGraphics()->CreateSphere( std::string( "Sphere" ) , std::string( "purple" ) , m_oCameraPosition , aOrientation , fRadius );
	GetSystem()->GetPhysics()->CreateSphereBody( std::string( "Sphere" ) , true , m_oCameraPosition , aOrientation , aDir , aAngularVelocity , fRadius , fMass );
};

void ChaosEngine::RunningState::ButtonUp( const std::string& oButtonName )
{
};

bool ChaosEngine::RunningState::ShouldCreateContact( const std::string& oBody1Name , const std::string& oBody2Name )
{
	float aPos[ 3 ];

	static bool bHmm = true;

	if ( oBody1Name == std::string( "Object" ) || oBody2Name == std::string( "Object" ) )
	{
		if ( bHmm )
		{
			GetSystem()->GetPhysics()->GetBodyPosition( std::string( "Object" ) , aPos );
			GetSystem()->GetAudio()->CreateSoundSource( std::string( "NoPoint" ) , std::string( "Ding" ) , aPos );
			bHmm = false;
		}
	}
	return true;
};

void ChaosEngine::RunningState::Collision( const std::string& oGeometry1Name , const std::string& oGeometry2Name )
{
};

