#include "LoadingState.h"


ChaosEngine::LoadingState::LoadingState( ChaosEngine::System* pSystem ) : State( pSystem , "LoadingState" )
{
};


ChaosEngine::LoadingState::~LoadingState( void )
{
};


void ChaosEngine::LoadingState::Update( float fDeltaTime )
{
	// load game objects
	// create ground box (physics, graphics)
	// create wall boxes (physics, graphics)
	// create trees (physics, graphics)
	// create rocks (physics, graphics)
	// create factories (physics, graphics)
	// create resources (physics, graphics)
	// create bases (physics, graphics)

	float aColor[ 3 ];
	float aPosition[ 3 ];
	float aOrientation[ 4 ];
	float aLinearVelocity[ 3 ];
	float aAngularVelocity[ 3 ];
	float aSides[ 3 ];
	float fMass = 20.0f;
	float fRadius = 1.0f;

	aColor[ 0 ] = 0.0f;
	aColor[ 1 ] = 0.0f;
	aColor[ 2 ] = 1.0f;
	GetSystem()->GetGraphics()->CreateMaterial( std::string( "blue" ) , aColor );

	aColor[ 0 ] = 1.0f;
	aColor[ 1 ] = 0.0f;
	aColor[ 2 ] = 0.0f;
	GetSystem()->GetGraphics()->CreateMaterial( std::string( "red" ) , aColor );

	aColor[ 0 ] = 0.0f;
	aColor[ 1 ] = 1.0f;
	aColor[ 2 ] = 0.0f;
	GetSystem()->GetGraphics()->CreateMaterial( std::string( "green" ) , aColor );

	aColor[ 0 ] = 0.0f;
	aColor[ 1 ] = 0.5f;
	aColor[ 2 ] = 0.0f;
	GetSystem()->GetGraphics()->CreateMaterial( std::string( "dark_green" ) , aColor );

	aColor[ 0 ] = 1.0f;
	aColor[ 1 ] = 1.0f;
	aColor[ 2 ] = 0.0f;
	GetSystem()->GetGraphics()->CreateMaterial( std::string( "yellow" ) , aColor );

	aColor[ 0 ] = 0.0f;
	aColor[ 1 ] = 1.0f;
	aColor[ 2 ] = 1.0f;
	GetSystem()->GetGraphics()->CreateMaterial( std::string( "cyan" ) , aColor );

	aColor[ 0 ] = 1.0f;
	aColor[ 1 ] = 0.0f;
	aColor[ 2 ] = 1.0f;
	GetSystem()->GetGraphics()->CreateMaterial( std::string( "purple" ) , aColor );


	aPosition[ 0 ] = -10.0f;
	aPosition[ 1 ] = 2.0f;
	aPosition[ 2 ] = 0.0f;

	aOrientation[ 0 ] = 0.0f;
	aOrientation[ 1 ] = 0.0f;
	aOrientation[ 2 ] = 0.0f;
	aOrientation[ 3 ] = 1.0f;

	aLinearVelocity[ 0 ] = 5.0f;
	aLinearVelocity[ 1 ] = 20.0f;
	aLinearVelocity[ 2 ] = 0.0f;

	aAngularVelocity[ 0 ] = 0.0f;
	aAngularVelocity[ 1 ] = 0.0f;
	aAngularVelocity[ 2 ] = 0.0f;

	aSides[ 0 ] = 2.0f;
	aSides[ 1 ] = 1.0f;
	aSides[ 2 ] = 1.0f;

	GetSystem()->GetGraphics()->CreateBox( std::string( "Object" ) , std::string( "red" ) , aPosition , aOrientation , aSides );
	GetSystem()->GetPhysics()->CreateBoxBody( std::string( "Object" ) , true , aPosition , aOrientation , aLinearVelocity , aAngularVelocity , aSides , fMass );
	GetSystem()->GetAudio()->LoadSound( std::string( "Tone" ) , true , std::string( "Tone.wav" ) );
	GetSystem()->GetAudio()->LoadSound( std::string( "Ding" ) , false , std::string( "Ding.wav" ) );
	GetSystem()->GetAudio()->CreateSoundSource( std::string( "Object" ) , std::string( "Tone" ) , aPosition );

	//GetSystem()->GetGraphics()->CreateSphere( std::string( "Sphere" ) , std::string( "red" ) , aPosition , aOrientation , fRadius );
	//GetSystem()->GetPhysics()->CreateSphereBody( std::string( "Sphere" ) , true , aPosition , aOrientation , aLinearVelocity , aAngularVelocity , fRadius , fMass );

	//aPosition[ 0 ] = 0.0f;
	//aPosition[ 1 ] = 4.0f;
	//aPosition[ 2 ] = 0.0f;
	//GetSystem()->GetPhysics()->CreateSphereBody( std::string( "Sphere" ) , true , aPosition , aOrientation , aLinearVelocity , aAngularVelocity , fRadius , fMass );

	aPosition[ 0 ] = 0.0f;
	aPosition[ 1 ] = -2.5f;
	aPosition[ 2 ] = 0.0f;

	aOrientation[ 0 ] = 0.0f;
	aOrientation[ 1 ] = 0.0f;
	aOrientation[ 2 ] = 0.0f;
	aOrientation[ 3 ] = 1.0f;

	aSides[ 0 ] = 50.0f;
	aSides[ 1 ] = 5.0f;
	aSides[ 2 ] = 50.0f;

	GetSystem()->GetGraphics()->CreateBox( std::string( "Ground" ) , std::string( "dark_green" ) , aPosition , aOrientation , aSides );
	GetSystem()->GetPhysics()->CreateBoxBody( std::string( "Ground" ) , false , aPosition , aOrientation , NULL , NULL , aSides , fMass );

	aPosition[ 0 ] = 0.0f;
	aPosition[ 1 ] = 25.0f;
	aPosition[ 2 ] = 27.5f;
	aSides[ 0 ] = 50.0f;
	aSides[ 1 ] = 50.0f;
	aSides[ 2 ] = 5.0f;
	GetSystem()->GetGraphics()->CreateBox( std::string( "Wall_1" ) , std::string( "yellow" ) , aPosition , aOrientation , aSides );
	GetSystem()->GetPhysics()->CreateBoxBody( std::string( "Wall_1" ) , false , aPosition , aOrientation , NULL , NULL , aSides , fMass );

	aPosition[ 0 ] = 0.0f;
	aPosition[ 1 ] = 25.0f;
	aPosition[ 2 ] = -27.5f;
	aSides[ 0 ] = 50.0f;
	aSides[ 1 ] = 50.0f;
	aSides[ 2 ] = 5.0f;
	GetSystem()->GetGraphics()->CreateBox( std::string( "Wall_2" ) , std::string( "yellow" ) , aPosition , aOrientation , aSides );
	GetSystem()->GetPhysics()->CreateBoxBody( std::string( "Wall_2" ) , false , aPosition , aOrientation , NULL , NULL , aSides , fMass );

	aPosition[ 0 ] = 27.5f;
	aPosition[ 1 ] = 25.0f;
	aPosition[ 2 ] = 0.0f;
	aSides[ 0 ] = 5.0f;
	aSides[ 1 ] = 50.0f;
	aSides[ 2 ] = 50.0f;
	GetSystem()->GetGraphics()->CreateBox( std::string( "Wall_3" ) , std::string( "yellow" ) , aPosition , aOrientation , aSides );
	GetSystem()->GetPhysics()->CreateBoxBody( std::string( "Wall_3" ) , false , aPosition , aOrientation , NULL , NULL , aSides , fMass );

	aPosition[ 0 ] = -27.5f;
	aPosition[ 1 ] = 25.0f;
	aPosition[ 2 ] = 0.0f;
	aSides[ 0 ] = 5.0f;
	aSides[ 1 ] = 50.0f;
	aSides[ 2 ] = 50.0f;
	GetSystem()->GetGraphics()->CreateBox( std::string( "Wall_4" ) , std::string( "yellow" ) , aPosition , aOrientation , aSides );
	GetSystem()->GetPhysics()->CreateBoxBody( std::string( "Wall_4" ) , false , aPosition , aOrientation , NULL , NULL , aSides , fMass );

	aPosition[ 0 ] = 0.0f;
	aPosition[ 1 ] = 5.0f;
	aPosition[ 2 ] = 0.0f;

	aOrientation[ 0 ] = 0.0f;
	aOrientation[ 1 ] = -1.0f;
	aOrientation[ 2 ] = 0.0f;
	aOrientation[ 3 ] = 0.0f;

	aColor[ 0 ] = 1.0f;
	aColor[ 1 ] = 1.0f;
	aColor[ 2 ] = 1.0f;

	GetSystem()->GetGraphics()->SetLight( aPosition , aOrientation , aColor );

	GetSystem()->ChangeState( std::string( "RunningState" ) );
};

