#pragma once
#include "StateManager.h"
#include "System.h"
#include "Log.h"

namespace ChaosEngine
{
	class State : public IBaseState, public IInputEventHandler, public IPhysicsEventHandler
	{
	public:
		State( System* pSystem , const std::string& oName );
		virtual ~State(void);

		std::string GetName( void );
		virtual void OnEnter( const std::string& oPrevious );
		virtual void Update( float fDeltaTime );
		virtual void OnExit( const std::string& oNext );
		virtual void OnOverride( const std::string& oNext );
		virtual void OnResume( const std::string& oPrevious );
		virtual bool ShouldCreateContact( const std::string& oBody1Name , const std::string& oBody2Name );
		virtual void Collision( const std::string& oGeometry1Name , const std::string& oGeometry2Name );
		virtual void KeyDown( const std::string& oKeyName );
		virtual void KeyUp( const std::string& oKeyName );
		virtual void ButtonDown( const std::string& oButtonName );
		virtual void ButtonUp( const std::string& oButtonName );
		virtual void MouseMoved( float* pAxisDeltas );

		System* GetSystem( void );
	private:
		std::string m_oName;
		System* m_pSystem;
	};
};
