#pragma once
#include <ode/ode.h>
#include "IPhysics.h"
#include "System.h"
#include <hash_map>
#include <sstream>

static void CollisionCallback( void* pData , dGeomID l_Geom1 , dGeomID l_Geom2 );

namespace ChaosEngine
{
	class ODEPhysics : public IPhysics
	{
	private:
		struct WorldDescriptor
		{
			dWorldID m_oWorldID;
			dSpaceID m_oSpaceID;
			dJointGroupID m_oJointGroupID;
		};

		struct Body
		{
			std::string m_oBodyName;
			dBodyID m_oBodyID;
			dGeomID m_oGeomID;

			Body( const std::string& oBodyName , dBodyID oBodyID , dGeomID oGeomID )
			{
				m_oBodyName = oBodyName;
				m_oBodyID = oBodyID;
				m_oGeomID = oGeomID;
			};
		};

		typedef stdext::hash_map< std::string , WorldDescriptor* > WorldHash;
		typedef stdext::hash_map< std::string , Body* > BodyHash;

		typedef stdext::hash_map< std::string , dSpaceID > SpaceHash;
		typedef stdext::hash_map< std::string , dGeomID > GeomHash;

		IPhysicsEventHandler* m_pHandler;

		WorldHash m_oWorlds;
		BodyHash m_oBodies;

		SpaceHash m_oSpaces;
		GeomHash m_oGeoms;

		System* m_pSystem;

	public:
		ODEPhysics( System* pSystem );
		virtual ~ODEPhysics( void );

		void Collision( dGeomID l_Geom1 , dGeomID l_Geom2 , void* pData );

		virtual void SetPhysicsEventHandler( IPhysicsEventHandler* pHandler );

		// rigid body dynamics #######################################################################################
		virtual void CreateWorld();
		virtual void DestroyWorld();
		virtual void CreateBoxBody( const std::string& oBodyName , bool bDynamic , float* pPosition , float* pOrientation , float* pLinearVelocity , float* pAngularVelocity , float* pSides , float fMass );
		virtual void CreateSphereBody( const std::string& oBodyName , bool bDynamic , float* pPosition , float* pOrientation , float* pLinearVelocity , float* pAngularVelocity , float fRadius , float fMass );
		virtual void DestroyBody( const std::string& oBodyName );
		virtual void Step( float fDeltaTime );
		virtual void SetBodyPosition( const std::string& oBodyName , float* pPosition );
		virtual void SetBodyOrientation( const std::string& oBodyName , float* pOrientation );
		virtual void SetBodyLinearVelocity( const std::string& oBodyName , float* pLinearVelocity );
		virtual void SetBodyAngularVelocity( const std::string& oBodyName , float* pAngularVelocity );
		virtual void GetBodyPosition( const std::string& oBodyName , float* pPosition );
		virtual void GetBodyOrientation( const std::string& oBodyName , float* pOrientation );
		virtual void GetBodyLinearVelocity( const std::string& oBodyName , float* pLinearVelocity );
		virtual void GetBodyAngularVelocity( const std::string& oBodyName , float* pAngularVelocity );

		// collision detection #######################################################################################
		virtual void CreateSpace( const std::string& oSpaceName );
		virtual void DestroySpace( const std::string& oSpaceName );
		virtual void CreateGeometry( const std::string& oGeometry , const std::string& oDescription );
		virtual void DestroyGeometry( const std::string& oGeometry );
		virtual void AddGeometryToSpace( const std::string& oSpaceName , const std::string& oGeometry );
		virtual void RemoveGeometryFromSpace( const std::string& oSpaceName , const std::string& oGeometry );
		virtual void SetGeometryPosition( const std::string& oGeometryName , float* pPosition );
		virtual void SetGeometryOrientation( const std::string& oGeometryName , float* pOrientation );
		virtual void GetGeometryPosition( const std::string& oGeometryName , float* pPosition );
		virtual void GetGeometryOrientation( const std::string& oGeometryName , float* pOrientation );
		virtual void EnumerateCollisions( const std::string& oSpaceName );
		virtual void EnumerateCollisions( const std::string& oSpaceName , const std::string& oGeometryName );
	};
};

