#pragma once
#include <hash_map>
#include <sstream>
#include <fmod.hpp>
#include "IAudio.h"
#include "System.h"

typedef stdext::hash_map< std::string , FMOD::Sound* > SoundHash;
typedef stdext::hash_map< std::string , FMOD::Channel* > ChannelHash;

namespace ChaosEngine
{
	class FMODAudio : public IAudio
	{
	private:
		System* m_pSystem;

		FMOD::System* m_pFMODSystem;
		SoundHash m_oSounds;
		ChannelHash m_oChannels;
	public:
		FMODAudio( System* pSystem );
		virtual ~FMODAudio( void );
		virtual void Update( void );
		virtual void LoadSound( const std::string& oSoundName , bool bLooping , const std::string& oFilename );
		virtual void CreateSoundSource( const std::string& oSoundSourceName , const std::string& oSoundName , float* pPosition );
		virtual void DestroySoundSource( const std::string& oSoundSourceName );
		virtual void SetListenerPosition( float* pPosition , float* pForward , float* pUp );
		virtual void SetSoundSourcePosition( const std::string& oSoundSourceName , float* pPosition );
		virtual void SetMasterVolume( float fVolume );
	};
};
