#include "Log.h"

std::ofstream* ChaosEngine::Log::m_pFileStream = NULL;

#if defined( DEBUG ) | defined( _DEBUG )
int ChaosEngine::Log::m_iLogMessageLevel = 3;
#else
int ChaosEngine::Log::m_iLogMessageLevel = 2;
#endif

void ChaosEngine::Log::Close( void )
{
	if ( m_pFileStream != NULL )
	{
		m_pFileStream->close();
		delete m_pFileStream;
		m_pFileStream = NULL;
	}
};

void ChaosEngine::Log::Open( const std::string& oFilename )
{
	Close();
	m_pFileStream = new std::ofstream( oFilename.c_str() , std::ios::out | std::ios::app );
};

void ChaosEngine::Log::SetLevel( int iMessageLevel )
{
	m_iLogMessageLevel = iMessageLevel;
};

void ChaosEngine::Log::WriteMessage( const std::string& oMessage , int iMessageLevel )
{
	if ( m_pFileStream != NULL && iMessageLevel <= m_iLogMessageLevel )
	{
		switch ( iMessageLevel )
		{
		case 0:
			(*m_pFileStream) << "Message: " << oMessage << std::endl;
			break;
		case 1:
			(*m_pFileStream) << "Warning: " << oMessage << std::endl;
			break;
		case 2:
			(*m_pFileStream) << "!!Error: " << oMessage << std::endl;
			break;
		case 3:
			(*m_pFileStream) << "Debug:   " << oMessage << std::endl;
			break;
		default:
			break;
		}
	}
};

