#include "State.h"


ChaosEngine::State::State( System* pSystem , const std::string& oName ) : m_pSystem( pSystem ) , m_oName( oName )
{
};

ChaosEngine::State::~State( void )
{
};

std::string ChaosEngine::State::GetName( void )
{
	return m_oName;
};

ChaosEngine::System* ChaosEngine::State::GetSystem( void )
{
	return m_pSystem;
};

void ChaosEngine::State::OnEnter( const std::string& oPrevious )
{
};

void ChaosEngine::State::Update( float fDeltaTime )
{
};

void ChaosEngine::State::OnExit( const std::string& oNext )
{
};

void ChaosEngine::State::OnOverride( const std::string& oNext )
{
};

void ChaosEngine::State::OnResume( const std::string& oPrevious )
{
};

bool ChaosEngine::State::ShouldCreateContact( const std::string& oBody1Name , const std::string& oBody2Name )
{
	return true;
};

void ChaosEngine::State::Collision( const std::string& oGeometry1Name , const std::string& oGeometry2Name )
{
};

void ChaosEngine::State::KeyDown( const std::string& oKeyName )
{
};

void ChaosEngine::State::KeyUp( const std::string& oKeyName )
{
};

void ChaosEngine::State::ButtonDown( const std::string& oButtonName )
{
};

void ChaosEngine::State::ButtonUp( const std::string& oButtonName )
{
};

void ChaosEngine::State::MouseMoved( float* pAxisDeltas )
{
};
