#include "InitializingState.h"


ChaosEngine::InitializingState::InitializingState( ChaosEngine::System* pSystem ) : State( pSystem , "InitializingState" )
{
};


ChaosEngine::InitializingState::~InitializingState( void )
{
};


void ChaosEngine::InitializingState::Update( float fDeltaTime )
{
	GetSystem()->AddState( new LoadingState( GetSystem() ) );
	GetSystem()->AddState( new RunningState( GetSystem() ) );
	GetSystem()->AddState( new UnloadingState( GetSystem() ) );
	GetSystem()->ChangeState( "LoadingState" );
};

