#pragma once
#include <string>
#include "IPhysicsEventHandler.h"

namespace ChaosEngine
{
	// This interface defines a set of methods a physics subsystem should provide
	class IPhysics
	{
	public:
		virtual ~IPhysics() { };

		virtual void SetPhysicsEventHandler( IPhysicsEventHandler* pHandler ) = 0;

		// rigid body dynamics #######################################################################################
		virtual void CreateWorld() = 0;
		virtual void DestroyWorld() = 0;
		virtual void CreateBoxBody( const std::string& oBodyName , bool bDynamic , float* pPosition , float* pOrientation , float* pLinearVelocity , float* pAngularVelocity , float* pSides , float fMass ) = 0;
		virtual void CreateSphereBody( const std::string& oBodyName , bool bDynamic , float* pPosition , float* pOrientation , float* pLinearVelocity , float* pAngularVelocity , float fRadius , float fMass ) = 0;
		virtual void DestroyBody( const std::string& oBodyName ) = 0;
		virtual void Step( float fDeltaTime ) = 0;
		virtual void SetBodyPosition( const std::string& oBodyName , float* pPosition ) = 0;
		virtual void SetBodyOrientation( const std::string& oBodyName , float* pOrientation ) = 0;
		virtual void SetBodyLinearVelocity( const std::string& oBodyName , float* pLinearVelocity ) = 0;
		virtual void SetBodyAngularVelocity( const std::string& oBodyName , float* pAngularVelocity ) = 0;
		virtual void GetBodyPosition( const std::string& oBodyName , float* pPosition ) = 0;
		virtual void GetBodyOrientation( const std::string& oBodyName , float* pOrientation ) = 0;
		virtual void GetBodyLinearVelocity( const std::string& oBodyName , float* pLinearVelocity ) = 0;
		virtual void GetBodyAngularVelocity( const std::string& oBodyName , float* pAngularVelocity ) = 0;

		// collision detection #######################################################################################
		virtual void CreateSpace( const std::string& oSpaceName ) = 0;
		virtual void DestroySpace( const std::string& oSpaceName ) = 0;
		virtual void CreateGeometry( const std::string& oGeometry , const std::string& oDescription ) = 0;
		virtual void DestroyGeometry( const std::string& oGeometry ) = 0;
		virtual void AddGeometryToSpace( const std::string& oSpaceName , const std::string& oGeometry ) = 0;
		virtual void RemoveGeometryFromSpace( const std::string& oSpaceName , const std::string& oGeometry ) = 0;
		virtual void SetGeometryPosition( const std::string& oGeometryName , float* pPosition ) = 0;
		virtual void SetGeometryOrientation( const std::string& oGeometryName , float* pOrientation ) = 0;
		virtual void GetGeometryPosition( const std::string& oGeometryName , float* pPosition ) = 0;
		virtual void GetGeometryOrientation( const std::string& oGeometryName , float* pOrientation ) = 0;
		virtual void EnumerateCollisions( const std::string& oSpaceName ) = 0;
		virtual void EnumerateCollisions( const std::string& oSpaceName , const std::string& oGeometryName ) = 0;
	};
};
