#pragma once

#define DIRECTINPUT_VERSION 0x0800

#include <dinput.h>
#include "IInput.h"
#include "System.h"

namespace ChaosEngine
{
	class DIInput : public IInput
	{
	private:
		System* m_pSystem;

		IInputEventHandler* m_pHandler;

		HINSTANCE             m_hInstance;    // application instance
		HWND                  m_hWindowMain; // application window

		bool m_bReady;
		bool m_bAquired;

		LPDIRECTINPUT8        m_pDI; 
		LPDIRECTINPUTDEVICE8  m_pDIKeyboardDevice;
		LPDIRECTINPUTDEVICE8  m_pDIMouseDevice;

		bool m_bMousePolled;
		DIMOUSESTATE2 m_oMouseState;
		DIMOUSESTATE2 m_oLastMouseState;

		bool m_bKeyboardPolled;
		char m_aKeyboardData[ 256 ]; 
		char m_aLastKeyboardData[ 256 ]; 

		std::string GetKeyName( int i );
		std::string GetButtonName( int i );

	public:
		DIInput( System* pSystem );
		virtual ~DIInput( void );
		virtual void SetInputEventHandler( IInputEventHandler* pHandler );
		virtual void Startup( void );
		virtual bool IsReady( void );
		virtual void Shutdown( void );
		virtual void Aquire( void );
		virtual bool IsAquired( void );
		virtual void UnAquire( void );
		virtual void Poll( void );

		void SetInstanceHandle( HINSTANCE hInstance );
		void SetWindowHandle( HWND hWindow );
	};
};
