#pragma once
#include <string>
#include <hash_map>
#include <sstream>
#include <set>
#include "IGraphics.h"
#include "System.h"
#include "dxstdafx.h"
#include "resource.h"

namespace ChaosEngine
{
	class D3DGraphics : public IGraphics
	{
	private:

		struct Material
		{
			D3DMATERIAL9 m_oMaterial;
			D3DMATERIAL9 m_oOldMaterial;
			std::set< std::string > m_oObjectSet;

			Material( float* pColor )
			{
				ZeroMemory( & m_oMaterial , sizeof( m_oMaterial ) );
				m_oMaterial.Diffuse.r = m_oMaterial.Ambient.r = pColor[ 0 ];
				m_oMaterial.Diffuse.g = m_oMaterial.Ambient.b = pColor[ 1 ];
				m_oMaterial.Diffuse.b = m_oMaterial.Ambient.g = pColor[ 2 ];
				m_oMaterial.Diffuse.a = m_oMaterial.Ambient.a = 1.0f;
			};

			void PreRender( IDirect3DDevice9* pd3dDevice )
			{
				pd3dDevice->GetMaterial( &m_oOldMaterial );
				pd3dDevice->SetMaterial( &m_oMaterial );
			};

			void PostRender( IDirect3DDevice9* pd3dDevice )
			{
				pd3dDevice->SetMaterial( &m_oOldMaterial );
			};
		};

		typedef stdext::hash_map< std::string , LPD3DXMESH > MeshHash;
		typedef stdext::hash_map< std::string , Material* > MaterialHash;


		struct ObjectDescription
		{
			// the mesh used to render this object
			std::string m_oMeshName;
			// the material
			std::string m_oMaterialName;
			D3DXVECTOR3 m_oPosition;
			D3DXQUATERNION m_oOrientation;
			D3DXVECTOR3 m_oScale;
		};

		typedef stdext::hash_map< std::string , ObjectDescription* > ObjectHash;

		// object container
		ObjectHash m_oObjects;

		// mesh container maps meshes by sring name to directx mesh pointers
		MeshHash m_oMeshes;

		// material container - index on objects by material
		MaterialHash m_oMaterials;

		CDXUTTextHelper* m_pTextHelper;
		ID3DXFont* m_pFont;
		ID3DXSprite* m_pTextSprite;

		D3DLIGHT9 m_oLight;

		D3DXVECTOR3 m_oEye;
		D3DXVECTOR3 m_oAt;
		D3DXVECTOR3 m_oUp;

		LPD3DXMATRIXSTACK m_pStack;

		System* m_pSystem;
	public:
		D3DGraphics( System* pSystem );
		virtual ~D3DGraphics( void );

		virtual void CreateSphere( const std::string& oName , const std::string& oMaterialName , float* pPosition , float* pOrientation , float fRadius );
		virtual void CreateBox( const std::string& oName , const std::string& oMaterialName , float* pPosition , float* pOrientation , float* pSideLengths );
		virtual void SetObjectPosition( const std::string& oName , float* pPosition );
		virtual void SetObjectOrientation( const std::string& oName , float* pOrientation );
		virtual void DestroyObject( const std::string& oName );

		virtual void CreateMaterial( const std::string& oMaterialName , float* pColor );
		virtual void DestroyMaterial( const std::string& oMaterialName );

		virtual void SetLight( float* pPosition , float* pDirection , float* pColor );
		virtual void SetCamera( float* pPosition , float* pOrientation );
		virtual void GetCameraDirection( float* pDirection , float* pUp );

		virtual void DrawString( float* pPosition , const std::string& oString );

		void Render( IDirect3DDevice9* pd3dDevice );
		void Update( float fDeltaTime );
		HRESULT OnCreateDevice( IDirect3DDevice9* pd3dDevice , const D3DSURFACE_DESC* pBackBufferSurfaceDesc );
		HRESULT OnResetDevice( IDirect3DDevice9* pd3dDevice , const D3DSURFACE_DESC* pBackBufferSurfaceDesc );
		void LoadMesh( const std::string& oName , const std::string& oFilename );
		void OnLostDevice( void );
		void OnDestroyDevice( void );
		void WindowActivate( void );
		void WindowDeactivate( void );
	};
};

namespace D3DStatics
{
	static ChaosEngine::D3DGraphics* g_pGraphics;
	void Startup( ChaosEngine::D3DGraphics* pGraphics );
	void Shutdown( void );
	bool CALLBACK IsDeviceAcceptable( D3DCAPS9* pCaps , D3DFORMAT AdapterFormat , D3DFORMAT BackBufferFormat , bool bWindowed , void* pUserContext );
	bool CALLBACK ModifyDeviceSettings( DXUTDeviceSettings* pDeviceSettings , const D3DCAPS9* pCaps , void* pUserContext );
	HRESULT CALLBACK OnCreateDevice( IDirect3DDevice9* pd3dDevice , const D3DSURFACE_DESC* pBackBufferSurfaceDesc , void* pUserContext );
	HRESULT CALLBACK OnResetDevice( IDirect3DDevice9* pd3dDevice , const D3DSURFACE_DESC* pBackBufferSurfaceDesc , void* pUserContext );
	void CALLBACK OnFrameMove( IDirect3DDevice9* pd3dDevice , double fTime , float fElapsedTime , void* pUserContext );
	void CALLBACK OnFrameRender( IDirect3DDevice9* pd3dDevice , double fTime , float fElapsedTime , void* pUserContext );
	LRESULT CALLBACK MsgProc( HWND hWnd , UINT uMsg , WPARAM wParam , LPARAM lParam , bool* pbNoFurtherProcessing , void* pUserContext );
	void CALLBACK OnLostDevice( void* pUserContext );
	void CALLBACK OnDestroyDevice( void* pUserContext );
};
