require 'digest/sha1'
class User < ActiveRecord::Base
# echo tcbpsalt|sha1sum
  @@salt = '13d0d3ab55cf4f9547472c1ce3f60ce9c73f58cc'
  cattr_accessor :salt
  
  def self.authenticate(login, pass)
    find_first(["login = ? AND password = ?", login, sha1(pass)])
  end
  
  def self.authenticate?(login, pass)
    user = self.authenticate(login, pass)
    return false if user.nil?
    return true if user.login == login
    false
  end
  protected

  def self.sha1(pass)
    Digest::SHA1.hexdigest("#{salt}--#{pass}--")
  end
  
  before_create :crypt_password

  def crypt_password
    write_attribute "password", self.class.sha1(password)
  end
 
  before_update :crypt_unless_empty

  def crypt_unless_empty
    if password.empty?      
      user = self.class.find(self.id)
      self.password = user.password
    else
      write_attribute "password", self.class.sha1(password)
    end        
  end  
  
  validates_uniqueness_of :login, :on => :create
  validates_confirmation_of :password
  validates_length_of :login, :within => 3..40
  validates_length_of :password, :within => 7..40
  validates_presence_of :login, :password, :password_confirmation
  


end
