class Ingredient < ActiveRecord::Base
    has_one :unit
    belongs_to :recipe_ingredients
    validates_presence_of :name,
                          :message => 'a name is required for an ingredient' 
    validates_uniqueness_of :name,
                            :message => 'that same ingredient name exists already'
    has_and_belongs_to_many :recipe
    end
