class RecipeController < ApplicationController
    layout "standard-layout"
    before_filter :login_required
    scaffold :recipe

    def list
        @recipes = Recipe.find(:all)
        @category = @params['category']
    end

    def edit
        @recipe = Recipe.find(@params["id"])
        @categories = Category.find_all
    end

    def new
        @recipe = Recipe.new
        @categories = Category.find_all
        @ingredients = Ingredient.find_all
        @units = Unit.find_all
    end
    def delete
        Recipe.find(@params['id']).destroy
            redirect_to :action => 'list'
    end

    def create
        @recipes = Recipe.find_all
        @category = @params['category']
    end
    
    def lookup
    @user = @params["id"]
    @lookup = Recipe.find_by_sql(["select r2.id,r2.title
from (select r.id as recipe_id
          from recipes r
               join recipe_ingredients ri on (ri.recipe_id=r.id)
               join ingredients i on (ri.ingredient_id=i.id)
               left join inventories iv
                 on (iv.user_id=?
                     and ri.ingredient_id=iv.ingredient_id
                     and ri.quantity<=iv.quantity)
        group by r.id
       having count(case when iv.id is null then 1 end) = 0) s
       join recipes r2 on (r2.id=s.recipe_id)", @user])
       end

def allrecipes
@allrecipes = Recipe.find_by_sql("Select r2.title, u2.login
  from (select r.id as recipe_id, u.id as user_id 
          from (recipes r
                join recipe_ingredients ri on (ri.recipe_id=r.id)
                join ingredients i on (ri.ingredient_id=i.id)
                cross join users u)
               left join inventories iv
                 on (u.id=iv.user_id
                     and ri.ingredient_id=iv.ingredient_id
                     and ri.quantity<=iv.quantity)
         group by r.id,u.id
         having count(case when iv.id is null then 1 end) = 0) s
        join users u2 on (u2.id=s.user_id)
        join recipes r2 on (r2.id=s.recipe_id)")
  end  
end
