class InventoriesController < ApplicationController
  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @inventory_pages, @inventories = paginate :inventories, :per_page => 10
  end

  def show
    @inventory = Inventory.find(params[:id])
  end

  def new
    @inventory = Inventory.new
  end

  def create
    @inventory = Inventory.new(params[:inventory])
    if @inventory.save
      flash[:notice] = 'Inventory was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
    @inventory = Inventory.find(params[:id])
  end

  def update
    @inventory = Inventory.find(params[:id])
    if @inventory.update_attributes(params[:inventory])
      flash[:notice] = 'Inventory was successfully updated.'
      redirect_to :action => 'show', :id => @inventory
    else
      render :action => 'edit'
    end
  end

  def destroy
    Inventory.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
