class IngredientsController < ApplicationController
  layout "standard-layout"
  before_filter :login_required
  def index
    list
    render :action => 'list'
  end

  def list
    @ingredient_pages, @ingredients = paginate :ingredients, :per_page => 10
  end

  def show
    @ingredient = Ingredient.find(params[:id])
  end

  def new
    @ingredient = Ingredient.new
    @unit = Unit.find(params[:id])
  end

  def create
    @ingredient = Ingredient.new(params[:ingredient])
    if @ingredient.save
      flash[:notice] = 'Ingredient was successfully created.'
      redirect_to :action => 'new'
    else
      render :action => 'new'
    end
  end

  def edit
    @ingredient = Ingredient.find(params[:id])
  end

  def update
    @ingredient = Ingredient.find(params[:id])
    if @ingredient.update_attributes(params[:ingredient])
      flash[:notice] = 'Ingredient was successfully updated.'
      redirect_to :action => 'show', :id => @ingredient
    else
      render :action => 'edit'
    end
  end

  def destroy
    Ingredient.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
