class AdminController < ApplicationController
layout "admin"

  def index
    list
    render :action => 'list'
  end

  def show_users
    @title = 'A Listing of All Users'
    @user_pages, @users = paginate :users, :per_page => 10
  end

  def list
    @ingredient_pages, @ingredients = paginate :ingredients, :per_page => 10
  end

  def show
    @ingredient = Ingredient.find(params[:id])
  end

  def new
    @ingredient = Ingredient.new
  end

  def create
    @ingredient = Ingredient.new(params[:ingredient])
    if @ingredient.save
      flash[:notice] = 'Ingredient was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
   @user = User.find(params[:id])
  end

  def update
    @ingredient = Ingredient.find(params[:id])
    if @ingredient.update_attributes(params[:ingredient])
      flash[:notice] = 'Ingredient was successfully updated.'
      redirect_to :action => 'show', :id => @ingredient
    else
      render :action => 'edit'
    end
  end

  def destroy_ingredient
    Ingredient.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
 
  def adduser
    @user = User.new(@params[:user])
    if @request.post? and @user.save
      @session[:user] = User.authenticate(@user.login, @params[:user][:password])
      flash['notice']  = "Signup successful"
      redirect_back_or_default :action => "account_created", :controller => "admin"
    end      
  end  
  
  def show_user
    @user = User.find(params[:id])
  end
  
  def update_user
    @user = User.find(@params['id'])
    @user.attributes = @params["user"]
    @user.save!
    if @request.post? and @user.save
      flash['notice'] = 'User was successfully updated.'
      redirect_to :action => 'show_users'
    end      
    @user.password = @user.password_confirmation =  ''
  end

# Method to remove a user from the system (should be admin only access)
# also delete all recipe ratings by the user
def destroy_user
    User.find(params[:id]).destroy
    redirect_to :action => 'show_users'
end
        
end
