// File: SplitBallPowerUp.cs
// Author: Sonhui Schweitzer
// Date: January 25th, 2005
// Project: CS470 Applied Software Developement Project
using System;
using System.Collections;
using Microsoft.DirectX;
using Direct3D=Microsoft.DirectX.Direct3D;
using DirectSound=Microsoft.DirectX.DirectSound;

namespace BreakOut
{
	class SplitBallPowerUp : PowerUp
	{
		public SplitBallPowerUp( Vector2 oLocation , System.Drawing.Color oColor , string oTextureName ) : base( oLocation )
		{
			m_oName = oTextureName;
			Color = oColor;
		}

		public override void ApplyPowerUp( Game oGame )
		{
			if ( oGame.GetBallCount() > 0 )
			{
				Ball oBall = oGame.GetBall( oGame.Random.Next( oGame.GetBallCount() ) );
				oGame.AddBall( new Ball( oGame , ( ( Circle )oBall.GetBounds() ).Location , -oBall.Velocity , Vector2.Empty ) );
			}
		}
	}
}
