// File: MachineGunPowerUp.cs
// Author: Sonhui Schweitzer
// Date: January 25th, 2005
// Project: CS470 Applied Software Developement Project
using System;
using Microsoft.DirectX;
using Direct3D=Microsoft.DirectX.Direct3D;
using DirectSound=Microsoft.DirectX.DirectSound;

namespace BreakOut
{
	public class MachineGunPowerUp : PowerUp
	{
		public MachineGunPowerUp( Vector2 oLocation , System.Drawing.Color oColor , string oTextureName ) : base( oLocation )
		{
			m_oName = oTextureName;
			Color = oColor;
		}

		public override void ApplyPowerUp( Game oGame )
		{
			for ( int i = 0 ; i < oGame.GetPaddleCount() ;  ++i )
			{
				oGame.GetPaddle( i ).GunType = Paddle.MachineGun;
			}
		}
	}

	public class ShotgunPowerUp : PowerUp
	{
		public ShotgunPowerUp( Vector2 oLocation , System.Drawing.Color oColor , string oTextureName ) : base( oLocation )
		{
			m_oName = oTextureName;
			Color = oColor;
		}

		public override void ApplyPowerUp( Game oGame )
		{
			for ( int i = 0 ; i < oGame.GetPaddleCount() ;  ++i )
			{
				oGame.GetPaddle( i ).GunType = Paddle.Shotgun;
			}
		}
	}

	public class RiflePowerUp : PowerUp
	{
		public RiflePowerUp( Vector2 oLocation , System.Drawing.Color oColor , string oTextureName ) : base( oLocation )
		{
			m_oName = oTextureName;
			Color = oColor;
		}

		public override void ApplyPowerUp( Game oGame )
		{
			for ( int i = 0 ; i < oGame.GetPaddleCount() ;  ++i )
			{
				oGame.GetPaddle( i ).GunType = Paddle.Rifle;
			}
		}
	}
}
