// File: Log.cs
// Author: Sonhui Schweitzer
// Date: January 25th, 2005
// Project: CS470 Applied Software Developement Project
using System;
using System.IO;

namespace BreakOut
{
	public class Log
	{
		private static Log m_oLog = null;
		private StreamWriter m_oWriter;

		private Log( string oFileName )
		{
			m_oWriter = new StreamWriter( oFileName , true );
 		}

		~Log()
		{
			m_oWriter.Close();
			m_oWriter = null;
			m_oLog = null;
		}

		public static void LogLine( string oLine )
		{
			if ( m_oLog == null )
			{
				m_oLog = new Log( "Log.txt" );
			}
			m_oLog.m_oWriter.WriteLine( oLine );
			m_oLog.m_oWriter.Flush();
		}
	}
}
