// File: Line.cs
// Author: Sonhui Schweitzer
// Date: January 25th, 2005
// Project: CS470 Applied Software Developement Project
using System;
using System.Drawing;
using System.Collections;
using Microsoft.DirectX;

namespace BreakOut
{
	public class Line : Bounds
	{
		private Vector2 m_oStartPoint;
		private Vector2 m_oEndPoint;
		private Vector2 m_oNormal;

		public Line ( Vector2 oStartPoint , Vector2 oEndPoint )
		{
			m_oStartPoint = oStartPoint;
			m_oEndPoint = oEndPoint;
			CalculateNormal();
		}

		private void CalculateNormal()
		{
			m_oNormal = Vector2.Subtract( m_oStartPoint , m_oEndPoint );
			m_oNormal = new Vector2( -m_oNormal.Y , m_oNormal.X );
			m_oNormal.Normalize();
		}

		public Vector2 StartPoint
		{
			get { return m_oStartPoint; }
			set { m_oStartPoint = value; CalculateNormal(); }
		}

		public Vector2 EndPoint
		{
			get { return m_oEndPoint; }
			set { m_oEndPoint = value; CalculateNormal(); }
		}

		public Vector2 Normal
		{
			get { return m_oNormal; }
		}

		public Vector2 Center
		{
			get { return StartPoint + ( ( EndPoint - StartPoint ) * 0.5f ); }
		}
	}
}
