// File: Entity.cs
// Author: Sonhui Schweitzer
// Date: January 25th, 2005
// Project: CS470 Applied Software Developement Project
using System;
using Direct3D=Microsoft.DirectX.Direct3D;

namespace BreakOut
{
	// base class for all game entities
	// all subclasses of the Entity class must implement
	public interface Entity
	{
		// apply changes over time
		float Update( Game oGame , float fDeltaTime );
		// react to collisions
		void Collide( Game oGame , CollideArgs oArgs );
		// render
		void Render( Direct3D.Device oDevice , Game oGame );
		// allow access to a bounds
		Bounds GetBounds();
	}
}
