// File: BallSpeedPowerUp.cs
// Author: Sonhui Schweitzer
// Date: January 25th, 2005
// Project: CS470 Applied Software Developement Project
using System;
using Microsoft.DirectX;
using Direct3D=Microsoft.DirectX.Direct3D;
using DirectSound=Microsoft.DirectX.DirectSound;

namespace BreakOut
{
	public class BallSpeedPowerUp : PowerUp
	{
		private float m_fSpeedMultiplier;

		public BallSpeedPowerUp( Vector2 oLocation , System.Drawing.Color oColor , float fSpeedMultiplier , string oTextureName ) : base( oLocation )
		{
			m_oName = oTextureName;
			Color = oColor;
			m_fSpeedMultiplier = fSpeedMultiplier;
		}

		public override void ApplyPowerUp( Game oGame )
		{
			for ( int i = 0 ; i < oGame.GetBallCount() ; ++i )
			{
				oGame.GetBall( i ).Speed *= m_fSpeedMultiplier;
			}
		}
	}
}
