#include "includes.h"
#include "source.cpp"
#include "finite_difference.cpp"

int main(int argc, char * argv[]) {

//  if(argc-3 != 3) {cout << "Usage: simulator filename time" << endl; exit(-1);}

  char outfilestring[30];
  int rank, size;
  int nodewidth, extracolumns;
  int m, n;

  MPI_Init(&argc, &argv);

  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  MPI_Comm_size(MPI_COMM_WORLD, &size);


//  int dividend = size;
//  while(dividend != 1) {
//    if(dividend%2 != 0) {cout << "You must use 2^k processors!" << endl; exit(-2);}
//    else dividend /= 2;
//  }

  ifstream infile(argv[1]);
  if(infile.is_open() == false) {cout << "Could not open file: " << argv[1] << endl; exit(0);}

  sprintf(outfilestring, "%s%d%s", "wavedata", rank, ".txt");

  ofstream outfile(outfilestring, ios::out);

  Matrix left, right, mydomain,
         temp, ghostsend, ghostrcv, // buffer matrices
         last, current, next; // displacement matrices at timesteps

  if(rank == 0) {

    Matrix base; // static density matrix read from file
    base.input_from_file(infile);

    int nodewidth = base.get_n()/size;
    int extracolumns = base.get_n()%size;

    for(int i = 0, currentcol = 1; i < size; i++) {

      if(extracolumns > 0) {
        temp = base.submatrix(1, currentcol, base.get_m(), currentcol+nodewidth);
        extracolumns--;
        currentcol += nodewidth+1;
      }

      else if(extracolumns == 0) {
        temp = base.submatrix(1, currentcol, base.get_m(), currentcol+nodewidth-1);
        currentcol += nodewidth;
      }

      if(i == 0) mydomain = temp;
      else temp.sendmatrix(i);

    }

  }

  else mydomain.rcvmatrix(0);

  mydomain.write_to_file(outfile);
  outfile << endl;

  Matrix zerocolumn(mydomain.get_m(), 1);
  zerocolumn.zero();
  mydomain.prependcolumn(zerocolumn);
  mydomain.appendcolumn(zerocolumn);

  Matrix zerorow(1, mydomain.get_n());
  zerorow.zero();
  mydomain.prependrow(zerorow);
  mydomain.appendrow(zerorow);

  current = mydomain - mydomain; // initial displacement is zero everywhere
  last = current; // medium is initally at rest, so no change in time

  if(rank == size/2) apply_source(current);

  for(int count = 0; count < atoi(argv[2]); count++) {

    if(rank != 0) {
      ghostsend = current.getcolumn(2);
      ghostsend.sendmatrix(rank-1);
    }

    if(rank != size-1) {
      ghostrcv.rcvmatrix(rank+1);
      current.replacecolumn(ghostrcv, current.get_n());
      ghostsend = current.getcolumn(current.get_n()-1);
      ghostsend.sendmatrix(rank+1);
    }

    if(rank != 0) {
      ghostrcv.rcvmatrix(rank-1);
      current.replacecolumn(ghostrcv, 1);
    }

    finite_difference(last, current, next, mydomain);

    temp = (mydomain + current).trim_ghost_nodes();

    temp.write_to_file(outfile);
    outfile << endl;

    last = current;
    current = next;

  }

  infile.close();
  outfile.close();

  MPI_Finalize();

  return 0;

}
